/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef DbPrj_included
#define DbPrj_included

#include "PicEl.h"
#include "PicGrp.h"
#include "PicObj.h"

#include <QWidget>
//#include <qpntarry.h>
//Added by qt3to4:
#include <QTextStream>

class QPainter;
class QColor;


class DbPrj : public PicGrp
{

struct DbLst {
  QString  FName;
  int      Ver;
  int      XOffs;
  int      YOffs;
  QString  PartLay;
  DbLst * Next;
};

public:

  DbPrj(Layers *L);
  virtual ~DbPrj();

  virtual int GetIden();

  void AddDb(QString name,int ver);

  QString GetDb();
  void GetDbR();

  int GetVer(QString name);
  void SetVer(QString name,int ver);
  int GetParam(QString name, int *x, int *y, QString* l);

  virtual void TextSave(QTextStream * S, bool sel=false);

protected:

  virtual bool  TLoadNext(QTextStream * S,QString* s);

private:

 DbLst * DL;
 DbLst * ADL;

};

#endif
