/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "Global.h"
#include "DbSch.h"
#include "Layers.h"
#include "Library.h"
#include "SComp.h"
#include "PComp.h"
#include "CnvAtr.h"
#include "ObjEdit.h"

#include <QPainter>
#include <QPen>
#include <QColor>
//#include <qpntarry.h>
//Added by qt3to4:
#include <QTextStream>

#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <unistd.h>

#include "Error.h"

extern Errors  gErr;


DbSch::DbSch(Layers *L)
 :PicGrp(L)
{
 Ver=0;
}


DbSch::~DbSch()
{
}

int DbSch::GetIden()
{
 return kDbSch;
}



void DbSch::SetType(QString Typ)
{
 GrpEl * T=Data;
// int i;
 Type=Typ;
 CnvAtr CA;
 CA.SetTyp(Typ);
 while(T){
  if(T->E->GetIden()==kSComp){
   ((SComp *)(T->E))->SetType(Typ,&CA);
  }
  T=T->Next;
 }
// SetOutl();
}

void DbSch::SetVer(int ver)
{
 GrpEl * T=Data;
// int i;
 Ver=ver;
 while(T){
  if(T->E->GetIden()==kSComp){
   ((SComp *)(T->E))->SetVer(Ver);
  }
  T=T->Next;
 }
// SetOutl();
}

int DbSch::GetVer()
{
 return Ver;
}

void DbSch::UpdateAtr()
{
 GrpEl * T=Data;
// int i;
 while(T){
  if(T->E->GetIden()==kSComp){
   ((SComp *)(T->E))->UpdateAtr();
  }
  T=T->Next;
 }
// LyChange();
}

void DbSch::SelXPartL()
{
 QString s;
 GrpEl * T=Data;
// int i;
 while(T){
  if(T->E->GetIden()==kSComp){
   s=(((SComp *)(T->E))->GetAtr(kAtrPartL));
   if(!s.isEmpty()){
     T->E->Select(T->E);
     Sel=2;
   }  
  }
  T=T->Next;
 }
// LyChange();
}

void DbSch::GetPart(Part * P)
{
 GrpEl * T=Data;
// int i;
 while(T){
  if(T->E->GetIden()==kSComp){
   if(!((SComp *)(T->E))->GetAtr(kAtrRef).isEmpty()){
    P->AddAtr(((SComp *)(T->E))->GetAtr());
   }
  }
  T=T->Next;
 }
}


bool DbSch::Select(QPoint p,int mode,int mir)
{
 if(PicGrp::Select(p,mode,mir)){
  GrpEl* T=Data;
//  GrpEl* T1;
  SComp * P;
  QString s;
  int i;
  QPoint p1;
  bool xx;
  int mod=mode & 255;
  int xmod=mode/0x10000;

  while(T && !xmod){
   if(T->E->GetIden()==kSComp && T->E->IsSelect()==1){
    if(mod!=kSelActOnly){
     P=(SComp*)T->E;
     xx=P->GetPin(&s,&p1,&i);
     while(xx){
      SelPoint(p1,2,mir);
      xx=P->GetNextPin(&s,&p1,&i);
     }
    }
   }
   T=T->Next;
  }
  return true;
 }
 return false;
}

void DbSch::ClrNets()
{
 int tol=4;
 unsigned long int L=Layer->GetWire();
 GrpEl * T=Data;
 GrpEl * T1=NULL;
 GrpEl * N;
// GrpEl * N1;
// GrpEl * N2;
// GrpEl * N3;
// PicNet * Ne;
// int i;
 QString s;


// while(!Layer->IsWir(L) && L>0) L=L*2;

 Layer->AddVis(L);
 UpdORect();

// printf("ClrNets: Start\n");
 // Prevede data z PicNet do DbSch
 N=Data;
 while(N){
  if (N->E->GetIden()==kPicNet){
   T1=((PicNet *)N->E)->GetData();
   ((PicNet *)N->E)->SetLock(1);
   if (T1){
    T=T1;
    while(T->Next){
     T=T->Next;
    }
    T->Next=Data;
    Data=T1;
   }
  }
  N=N->Next;
 }
// printf("ClrNets: ClrPicNet\n");

 // Smaze PicNet
 N=Data;
 while(N){
  if (N->E->GetIden()==kPicNet){
   if(N==Data){
    Data=N->Next;
    delete N->E;
    delete N;
    N=Data;
   }
   else {
    T1->Next=N->Next;
    delete N->E;
    delete N;
    N=T1->Next;
   }
  }
  else{
   T1=N;
   N=N->Next;
  }
 }

// printf("ClrNets: Clean\n");
 Clean(tol,L);
}

void DbSch::MkNets()
{
 int tol=4;
 unsigned long int L=Layer->GetWire();
 GrpEl * T=Data;
 GrpEl * T1=NULL;
 GrpEl * N;
 GrpEl * N1;
// GrpEl * N2;
// GrpEl * N3;
 PicNet * Ne;
 int i;
 QString s;


 ClrNets();

// printf("MkNets: MkPicNet\n");

 // Nove vytvori PicNet
 T=Data;
 T1=NULL;
 while(T){
  if((T->E->GetIden()==kPicLine ||
      T->E->GetIden()==kPicCir ||
      T->E->GetIden()==kPicText )&& (T->E->GetLayer() & L)){
   Ne=NULL;
   N1=NULL;
//   N2=NULL;
//   N3=NULL;
   N=Data;
   while(N){
    if (N->E->GetIden()==kPicNet && !N->E->IsLock()){
     if (((PicNet *)N->E)->IsConnect(T->E,tol)){
//      printf("IsConnect\n");
      if(Ne){
       Ne=(PicNet *)(N->E);
       Ne->AddItem(N1->E);
      }
      N1=N;
      Ne=(PicNet *)(N->E);
     }
    }
    N=N->Next;
   }
   if(!Ne){
//    printf("Create Net\n");
    Ne=new PicNet(Layer);
    if (T->E->GetIden()==kPicText) Ne->SetName(((PicText *)T->E)->GetText());
    else Ne->SetName("?");
    AddItem(Ne);
   }
   Ne->AddItem(T->E);
   if(!T1) T1=Data;
//   printf("Add Item\n");
   if (T==Data){
    Data=T->Next;
    delete T;
    T=Data;
   }
   else {
    T1->Next=T->Next;
    delete T;
    T=T1->Next;
   }
//   printf("Del Item\n");
  }
  else{
   T1=T;
   T=T->Next;
//   printf("Next Item\n");
  }
 }

// printf("MkNets: NumNet\n");

 i=0;
 N=Data;
 N1=NULL;
 while(N){
  if (N->E->GetIden()==kPicNet){
   if(N->E->IsLock()){
    if(N==Data){
     Data=N->Next;
     delete N->E;
     delete N;
     N=Data;
    }
    else{
     N1->Next=N->Next;
     delete N->E;
     delete N;
     N=N1->Next;
    }
   }
   else{
    s=((PicNet *)N->E)->GetName();
    if(s=="?"){
     s.setNum(i);
     s="NET"+s;
     ((PicNet *)N->E)->SetName(s);
     i++;
    }
    N1=N;
    N=N->Next;
   }
  }
  else{
   N1=N;
   N=N->Next;
  }
 }

// printf("MkNets: OK\n");
}

void DbSch::ListNet()
{
 GrpEl * T=Data;
 int i=0;
 while(T){
  if (T->E->GetIden()==kPicNet){
   printf("Net no.%d name %s\n",i,((PicNet *)(T->E))->GetName().toLatin1().data());
   ((PicNet *)(T->E))->ListItem();
  }
  T=T->Next;
  i++;
 }

 T=Data;
 QPoint p;
 QString s;
 int n;

 while(T){
  if (T->E->GetIden()==kSComp){
   s=(((SComp *)T->E)->GetAtr(0));
   if(((SComp *)T->E)->IsInGrp()) printf("Comp %s - InGrp\n",s.toLatin1().data());
   else printf("Comp %s\n",s.toLatin1().data());
   if(((SComp *)T->E)->GetPin(&s,&p,&n)){
    do{
     printf("  %d  %s\n",n,s.toLatin1().data());
    }while (((SComp *)T->E)->GetNextPin(&s,&p,&n));
   }
  }
  T=T->Next;
 }
}

void DbSch::Netlist()
{
 MkNets();
 UpdORect();

 GrpEl * T=Data;
 GrpEl * N=Data;
 QPoint p;
 QString s;
 int tol=4;
 int n;
 int xx;
// bool gr;

 while(T){
  if (T->E->GetIden()==kPicPower){
    N=Data;
    while(N){
     if (N->E->GetIden()==kPicNet && !N->E->IsLock()){
      p=T->E->Pos();
      s=((PicPower *)T->E)->GetText();
      if (((PicNet *)N->E)->IsConnect(p,tol)){
//       printf("Netlist: IsConnect\n");
//         ((SComp *)T->E)->SetActPinNet(((PicNet *)N->E)->GetName());
       if(!((PicNet *)N->E)->GetName().contains("NET")){
        gErr.Warn("Power "+((PicNet *)N->E)->GetName()+
                     " conected to power "+s);
       }
       ((PicNet *)N->E)->SetName(s);
       break;
      }
     }
     N=N->Next;
    }
  }
  T=T->Next;
 }

 T=Data;
 while(T){
  if (T->E->GetIden()==kSComp){
   if(((SComp *)T->E)->GetAtr(kAtrRef).isEmpty()){
    ((SComp *)T->E)->UpdatePins();
    xx=((SComp *)T->E)->GetPin(&s,&p,&n);
    while(xx){
     if(xx==1){
      N=Data;
      while(N){
       if (N->E->GetIden()==kPicNet && !N->E->IsLock()){
        if (((PicNet *)N->E)->IsConnect(p,tol)){
  //       printf("Netlist: IsConnect\n");
//         ((SComp *)T->E)->SetActPinNet(((PicNet *)N->E)->GetName());
         if(!((PicNet *)N->E)->GetName().contains("NET")){
          gErr.Err("Power "+((PicNet *)N->E)->GetName()+
                       " conected to power "+s);
         }
         ((PicNet *)N->E)->SetName(s);
         break;
        }
       }
       N=N->Next;
      }
     }
     xx=(((SComp *)T->E)->GetNextPin(&s,&p,&n));
    }
   }
  }
  T=T->Next;
 }


 T=Data;
 while(T){
  if (T->E->GetIden()==kSComp){
   if(!((SComp *)T->E)->GetAtr(kAtrRef).isEmpty()){
    ((SComp *)T->E)->UpdatePins();
    xx=((SComp *)T->E)->GetPin(&s,&p,&n);
    while(xx){
     if(xx==1){
      N=Data;
      while(N){
       if (N->E->GetIden()==kPicNet && !N->E->IsLock()){
        if (((PicNet *)N->E)->IsConnect(p,tol)){
  //       printf("Netlist: IsConnect\n");
         ((SComp *)T->E)->SetActPinNet(((PicNet *)N->E)->GetName());
         break;
        }
       }
       if (N->E->GetIden()==kPicPower){
        if (p==N->E->Pos()){
  //       printf("Netlist: IsConnect\n");
         ((SComp *)T->E)->SetActPinNet(((PicPower *)N->E)->GetText());
         break;
        }
       }
       N=N->Next;
      }
      if(!N) printf("Pin not connect at %d %d\n",p.x(),p.y());
     }
     xx=(((SComp *)T->E)->GetNextPin(&s,&p,&n));
    }
   }
  }
  T=T->Next;
 }

 ListNet();

}


void DbSch::ToPcb(DbPcb * D)
{
// Netlist();
 GrpEl * T=Data;
 PComp * C;
 QString s;
 int e=0;
 while(T){
  if (T->E->GetIden()==kSComp && 
     !(((SComp *)T->E)->GetAtr(kAtrRef)).isEmpty()){
   C=D->FindComp((((SComp *)T->E)->GetAtr(kAtrRef)));
   if (!C){
    C=new PComp(D->GetLayers());
    D->AddItem(C);
   }
   if(!((SComp *)T->E)->ToPcb(C)){
//    printf("Error in %s %s\n",((SComp *)T->E)->GetAtr(kAtrRef),
//                              ((SComp *)T->E)->GetAtr(kAtrPkg));
//    s.sprintf("Error in %s %s",((SComp *)T->E)->GetAtr(kAtrRef),
//                              ((SComp *)T->E)->GetAtr(kAtrPkg));
      s="Error in " + ((SComp *)T->E)->GetAtr(kAtrRef);
      s+= " " + ((SComp *)T->E)->GetAtr(kAtrPkg);
			      
    if(e<10) gErr.ToLst(s);
    e++;
   }
  }
  T=T->Next;
 }
 if(e){
  s.setNum(e);
  s="\n"+s+" ERRORs";
  gErr.ToLst(s);
  gErr.ShowLst();
 }
}

void DbSch::UpdCGrp()
{
 GrpEl * T=Data;
// GrpEl * TM=NULL;
 GrpEl * T1=Data;
// GrpEl * T1M=NULL;
 QString s;

 while(T){
  if(T->E->GetIden()==kSComp) ((SComp *)T->E)->SetInGrp(0);
  T=T->Next;
 }

 T=Data;
 while(T){
  if(T->E->GetIden()==kSComp){
   if(!((SComp *)T->E)->IsInGrp()){
    s=(((SComp *)T->E)->GetAtr(kAtrRef));
    if(!s.isEmpty()){
     T1=T->Next;
     while(T1){
      if(T1->E->GetIden()==kSComp){
       if(s==((SComp *)T1->E)->GetAtr(kAtrRef)){
//        printf("UpdCGrp : Add %s\n",(const char *)s);
        ((SComp *)T->E)->SetInGrp(1);
        ((SComp *)T1->E)->SetInGrp(1);
        ((SComp *)T1->E)->SetAtr(((SComp *)T->E)->GetAtr());
        ((SComp *)T1->E)->SetPL(((SComp *)T->E)->GetPL());
       }
      }
      T1=T1->Next;
     }
    }
   }
  }
  T=T->Next;
 }
 UpdateAtr();

// printf("UpdCGrp : OK\n");

/* while(T){
  T->a=0;
  T=T->Next;
 }
 T=Data;
 while(T && T->Next){
//  printf(" %x %x %x\n",(int)T,(int)Data,(int)TM);
  if(T->E->GetIden()==kSComp || T->E->GetIden()==kSCGrp){
   if (T->E->GetIden()==kSComp){
    s=((SComp *)T->E)->GetAtr(0);
//    printf("Comp :%s\n",((SComp *)T->E)->GetAtr(0));
     G=NULL;
   }
   else{
//    printf("Grp :%s\n",((SCGrp *)T->E)->GetAtr(0));
    s=((SCGrp *)T->E)->GetAtr(0);
    G=((SCGrp *)T->E);
   }
   T1=T->Next;
   while(T1){
    if(T1->E->GetIden()==kSComp && T1->a==0){
//     printf("  Comp :%s\n",((SComp *)T1->E)->GetAtr(0));
     if(s==((SComp *)T1->E)->GetAtr(0)){
      if(!G){
       G=new SCGrp(Layer);
       AddItem(G);
       G->AddItem(T->E);
       T->a=1;
      }
      G->AddItem(T1->E);
      T1->a=1;
     }
    }
    T1=T1->Next;
   }
   if(G)  G->UpdateAtr();
  }
  T=T->Next;
 }
// printf("UpdCGrp\n");
 T=Data;
 while(T){
  if(T->a==1){
   if(T==Data){
    Data=T->Next;
    delete T;
    T=Data;
   }
   else{
    TM->Next=T->Next;
    delete T;
    T=TM->Next;
   }
  }
  else {
   TM=T;
   T=T->Next;
  }
 }*/
// printf("UpdCGrp End\n");
}

bool DbSch::CheckRef()
{
 GrpEl * T=Data;
 GrpEl * T1=Data;
// GrpEl * T1M=NULL;

 bool Err=false;
 QString s;
 QString s1;

 int x;

 gErr.OpenLst();

 while(T){
  if(T->E->GetIden()==kSComp){
    s=(((SComp *)(T->E))->GetAtr(0));
   if(!s.isEmpty()){
     s1=(((SComp *)(T->E))->GetAtr(1));
    x=((SComp *)(T->E))->GetPSComp()->GetPiP();
    if(s.contains("?")){
     Err=true;
     gErr.ToLst("Ilegal reference "+s+" "+s1);
    }
    else{
      T1=T->Next;
     while(T1){
      if (T1->E->GetIden()==kSComp){
        if(s==((SComp *)(T1->E))->GetAtr(0) &&
          x==((SComp *)(T1->E))->GetPSComp()->GetPiP()){
//        gErr.ToLst("Duplicate reference "+s);
//        Err=true;
       }
      }
      T1=T1->Next;
     }
    }
   }
  }
  T=T->Next;
 }
 if (Err) gErr.ShowLst();
 return !Err;
}

#define MaxRefTyp 20

void DbSch::AddRef(int n)
{
 GrpEl * T=Data;
 QString s;
 QString s1;
 int m;
 int fl=0;

 while(T){
  if(T->E->GetIden()==kSComp){
   if((((SComp *)(T->E))->GetAtr()).GetRef(s)){
    m=(((SComp *)(T->E))->GetAtr()).GetRefNum();
    if((m+n)>=0) s1.setNum(m+n);
    else{
     s1="?";
     fl=1;
    } 
    (((SComp *)(T->E))->GetAtr()).SetAtr(0,s+s1,-2);
   }
  }
  T=T->Next;
 }
 if(fl) Annotate();
}

bool DbSch::Annotate()
{
 GrpEl * T=Data;
// GrpEl * T1=Data;
 Atrib  A;
 QString s;
 QString s1;
 QString ref[MaxRefTyp];
 int     max[MaxRefTyp];
 int     cnt[MaxRefTyp];
 char  * lst[MaxRefTyp];
 Atrib ** atr[MaxRefTyp];
 int rt=0;
 int i;
 int j;
 int m;
 bool Err=false;
 gErr.OpenLst();

 for(i=0;i<MaxRefTyp;i++) cnt[i]=0;
 while(T){
  if(T->E->GetIden()==kSComp){
   if((((SComp *)(T->E))->GetAtr()).GetRef(s)){
    m=(((SComp *)(T->E))->GetAtr()).GetRefNum();
 //   printf("%s : %d\n",(const char *)s,m);
    i=0;
    while(i<rt && ref[i]!=s) i++;
    if(i<rt){
     if(m>max[i]) max[i]=m;
     cnt[i]++;
    }
    else{
     rt=i+1;
     if(rt>MaxRefTyp){
      rt=MaxRefTyp;
      printf("Annotate : RefTyp>%d\n",MaxRefTyp);
     }
     else{
      ref[i]=s;
      max[i]=m;
      cnt[i]++;
     }
    }
   }
  }
  T=T->Next;
 }

 for(i=0;i<rt;i++){
  printf("%s : %d %d\n",ref[i].toLatin1().data(),max[i],cnt[i]);
  if(cnt[i]>max[i]) max[i]=cnt[i];
  lst[i]=new char[max[i]+2];
  atr[i]=new Atrib*[max[i]+1];
  for(j=0;j<max[i]+1;j++){
   lst[i][j]='0';
   atr[i][j]=NULL;
  }
  lst[i][j]=0;
 }

 T=Data;
 while(T){
  if(T->E->GetIden()==kSComp){
   if((((SComp *)(T->E))->GetAtr()).GetRef(s)){
    m=(((SComp *)(T->E))->GetAtr()).GetRefNum();
    j=(((SComp *)(T->E))->GetPSComp())->GetPPP();
 //   printf("%s : %d\n",(const char *)s,m);
    i=0;
    while(i<rt && ref[i]!=s) i++;
    if(i<rt){
     if(m>=0){
      if(lst[i][m]=='0'){
       lst[i][m]='A'+j-1;
       atr[i][m]=&(((SComp *)(T->E))->GetAtr());
      }
      else{
       lst[i][m]--;
      }
     }
    }
    else{
     printf("Annotate : BadRefTyp\n");
    }
   }
  }
  T=T->Next;
 }

 T=Data;
 while(T){
  if(T->E->GetIden()==kSComp){
   if((((SComp *)(T->E))->GetAtr()).GetRef(s)){
    m=(((SComp *)(T->E))->GetAtr()).GetRefNum();
    if(m<0){
     j=(((SComp *)(T->E))->GetPSComp())->GetPPP();
 //   printf("%s : %d\n",(const char *)s,m);
     i=0;
     while(i<rt && ref[i]!=s) i++;
     if(i<rt){
      for(m=1;m<=max[i];m++){
       if(lst[i][m]>'A' && *(atr[i][m])==(((SComp *)(T->E))->GetAtr())){
        s1.setNum(m);
        (((SComp *)(T->E))->GetAtr()).SetAtr(0,s+s1,-2);
        (((SComp *)(T->E))->GetPSComp())->SetPiP(j-(lst[i][m]-'A'));
        lst[i][m]--;
        m=0;
        break;
       }
      }
      if(m){
       for(m=1;m<=max[i];m++){
        if(lst[i][m]=='0'){
         s1.setNum(m);
         (((SComp *)(T->E))->GetAtr()).SetAtr(0,s+s1,-2);
         lst[i][m]='A'+j-1;
         atr[i][m]=&(((SComp *)(T->E))->GetAtr());
         break;
        }
       }
      }
     }
     else{
      printf("Annotate : BadRefTyp\n");
     }
    }
   }
  }
  T=T->Next;
 }


//        gErr.ToLst("Duplicate reference "+s);
//        Err=true;

 for(i=0;i<rt;i++){
  printf("%s : %s\n",ref[i].toLatin1().data(),lst[i]);
  for(j=0;j<max[i]+1;j++){
   if(lst[i][j]!='0'){
    if(lst[i][j]>'A'){
     gErr.ToLst("Warning : Unused parts in pkg "+*(atr[i][j]->GetAtr(kAtrRef))+
                 " "+*(atr[i][j]->GetAtr(kAtrVal)));
      Err=true;
    }
    if(lst[i][j]<'A'){
     gErr.ToLst("ERROR   : To many parts in pkg "+*(atr[i][j]->GetAtr(kAtrRef))+
                 " "+*(atr[i][j]->GetAtr(kAtrVal)));
      Err=true;
    }
   }
  }
  delete[] lst[i];
  delete[] atr[i];
 }

 if (Err) gErr.ShowLst();
 return !Err;
}

void DbSch::ResetSelRef()
{
 GrpEl * T=Data;

 while(T){
  if((T->E->GetIden()==kSComp) && T->E->IsSelect()){
    (((SComp *)(T->E))->GetAtr()).ClrRefNum();
  }
  T=T->Next;
 }
}


SComp * DbSch::GetFirstComp()
{
 AE=Data;
 while(AE && (AE->E->GetIden()!=kSComp)){
  AE=AE->Next;
 }
 if(!AE) return NULL;
 return (SComp *)(AE->E);
}

SComp * DbSch::GetNextComp()
{
 AE=AE->Next;
 while(AE && AE->E->GetIden()!=kSComp){
  AE=AE->Next;
 }
 if(!AE) return NULL;
 return (SComp *)(AE->E);
}

void DbSch::TextSave(QTextStream * S, bool sel)
{
// int i;
 PicEl::TextSave(S,sel);
 *S << "    {PkgType " << Type << " }\n";
 PicGrp::TextSaveNext(S,sel);
}

bool DbSch::TLoadNext(QTextStream * S,QString* s)
{
 if (s->contains("PkgType")){
  Type=TextLoadStr(S);
 }
 else  return PicGrp::TLoadNext(S,s);
 return true;
}



//--------------------------------------------------------------------

PicNet::PicNet(Layers *L)
 :PicGrp(L)
{
}


PicNet::~PicNet()
{
}

int PicNet::GetIden()
{
 return kPicNet;
}

void PicNet::AddTreeList(TreeListItem * LI)
{
 LI->setText( 1,Name);
 PicGrp::AddTreeList(LI);
}

void PicNet::HLSel(int fl)
{
// printf("PicNet::HLSel Sel= %d\n",Sel);
  if(fl){
    if(Sel) HL();
  }
  else{
    PicGrp::HLSel(fl);
  }  
}

void PicNet::GetSelORect(QRect* r)
{
// printf("PicNet::GetSelORect Sel=%d HiL=%d\n",Sel,HiL);
 if(HiL) GetORect(r);
 else PicGrp::GetSelORect(r);
}



void PicNet::AddItem(PicEl* E)
{
 if(E->GetIden()==kPicText) SetName(((PicText*)E)->GetText());
 if(E->GetIden()!=kPicNet) PicGrp::AddItem(E);
 else{
  GrpEl * T=((PicNet *)E)->GetData();
  GrpEl * T1=T;
  if(T){
   while(T1->Next){
    T1=T1->Next;
   }
   T1->Next=Data;
   Data=T;
   QString s=((PicNet *)E)->GetName();
   if (s!="?") SetName(s);
   ((PicNet *)E)->SetLock(1);
//   delete E;
  }
//  SetOutl();
  UpdORect();
 }
}

void PicNet::SetName(QString N)
{
 Name=N;
}

QString PicNet::GetName()
{
 return Name;
}

/*
PicGrp::GrpEl * PicNet::Unconnect(unsigned int L,int tol)
{
 GrpEl * T=Data;
 GrpEl * T1=NULL;
 GrpEl * X=NULL;
 bool x;
 while(T){
  if(!(T->E->GetLayer()&L))   x=false;
  else x=IsConnect(T->E,tol,T);
  if(!x){
   if(T==Data){
    Data=T->Next;
    T->Next=X;
    X=T;
    T=Data;
   }
   else{
    T1->Next=T->Next;
    T->Next=X;
    X=T;
    T=T1->Next;
   }
  }
  else{
   T1=T;
   T=T->Next;
  }
 }
 return X;
}
*/

bool PicNet::IsConnect(QPoint p,int tol)
{
 GrpEl * T=Data;
 while(T){
  if(T->E->GetIden()==kPicLine){
   if (((PicLine *)(T->E))->IsConnect(p,tol)) return true;
  }
//  else if(T->E->GetIden()==kPicCir){
//   QRect r1;
//   T->E->GetORect(&r1);
//   if (r.contains(p)) return true;
//  }
  T=T->Next;
 }
 return false;
}


//bool PicNet::IsConnect(PicEl * L,int tol,GrpEl * X)
bool PicNet::IsConnect(PicEl * L,int tol)
{
 GrpEl * T=Data;
 QRect r;
 L->GetORect(&r);
 if (!r.intersects(R) && L->GetIden()!=kPicText) return false;

 if (L->GetIden()==kPicLine){
  while(T){
//   if(T!=X){
    if(T->E->GetIden()==kPicLine){
     if (((PicLine *)(T->E))->IsConnect((PicLine *)L,tol)) return true;
    }
    else if(T->E->GetIden()==kPicText){
     QRect r;
     T->E->GetORect(&r);
     if (((PicLine *)L)->IsConnect(r,tol)) return true;
    }
    else if(T->E->GetIden()==kPicCir){
     QRect r1;
     T->E->GetORect(&r1);
     if (((PicLine *)L)->IsConnect(((PicCir *)T->E)->GetCenter(),tol+r1.width()/2)) return true;
    }
//   }
   T=T->Next;
  }
 }
 if (L->GetIden()==kPicCir){
  while(T){
//   if(T!=X){
    if(T->E->GetIden()==kPicLine){
     if (((PicLine *)(T->E))->IsConnect(((PicCir*)L)->GetCenter(),tol+r.width()/2)) return true;
    }
    if(T->E->GetIden()==kPicText){
     QRect r1;
     T->E->GetORect(&r1);
     if(r.intersects(r1)) return true;
    }
//   }
   T=T->Next;
  }
 }

 else if (L->GetIden()==kPicText){
  QRect r;
  L->GetORect(&r);
  QString s=((PicText *)L)->GetText();
  while(T){
//   if(T!=X){
    if(T->E->GetIden()==kPicLine){
     if (((PicLine *)(T->E))->IsConnect(r,tol)) return true;
    }
    else if(T->E->GetIden()==kPicCir){
     QRect r1;
     T->E->GetORect(&r1);
     if(r.intersects(r1)) return true;
    }
    else if(T->E->GetIden()==kPicText){
     if (s==((PicText *)(T->E))->GetText()) return true;
    }
//   }
   T=T->Next;
  }
 }
 // !!!!! Nevim jestli je to OK
 else if (L->GetIden()==kPicNet){
  while(T){
//   if(T!=X){
    if(T->E->GetIden()==kPicLine){
     if (((PicNet *)(L))->IsConnect(T->E,tol)) return true;
    }
//   }
   T=T->Next;
  }
 }
 return false;
}

bool PicNet::GetInfo(QString & i,QPoint p,int mode,int mir)
{
  if(PicGrp::GetInfo(i,p,mode,mir)){
    i+=" Net:";
    i+=Name;
    return true;
  }
  return false;
}

void PicNet::TextSave(QTextStream * S, bool sel)
{
// int i;
 PicEl::TextSave(S,sel);
 *S << "    {NetN " << Name << " }\n";
 PicGrp::TextSaveNext(S,sel);
}

bool  PicNet::TLoadNext(QTextStream * S,QString* s)
{
 if (s->contains("NetN")){
  Name=TextLoadStr(S);
 }
 else  return PicGrp::TLoadNext(S,s);
 return true;
}


