/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "Dlg.h"
#include "Atr.h"
//Added by qt3to4:
#include <QResizeEvent>
#include <QLabel>


StrDlg::StrDlg( QWidget *parent)
    : QDialog( parent )
{
    setMinimumSize( 300, 150 );
    setMaximumSize( 300, 150 );
    QPushButton *ok, *cancel;
    ok = new QPushButton( "Ok", this );
    ok->setFont( QFont( "Times", 18, QFont::Bold ) );
    ok->setGeometry( 200,110, 75,30 );
    connect( ok, SIGNAL(clicked()), SLOT(accept()) );
    cancel = new QPushButton( "Cancel", this );
    cancel->setFont( QFont( "Times", 18, QFont::Bold ) );
    cancel->setGeometry( 100,110, 75,30 );
    connect( cancel, SIGNAL(clicked()), SLOT(reject()) );
}

bool StrDlg::GetStr(QString * Str,QString & text)
{
 QLabel *L;
 L=new QLabel(text,this);
 L->setGeometry( 10,10, 280,45 );

 QLineEdit *LE;
 LE=new QLineEdit(this);
 LE->setText(*Str);
 LE->setGeometry( 20,60, 260,25 );
 connect( LE, SIGNAL(returnPressed()), SLOT(accept()) );
 LE->setFocus();
 if (exec()){
  *Str=LE->text();
  return true;
 }
 return false;
}


StrDlg::~StrDlg()
{

}

//--------------------------------------------------------------------------

//static const char *VerL[] = { "All","Actual","Ver.0","Ver.1","Ver.2","Ver.3"
//                              ,"Ver.4","Ver.5","Ver.6","Ver.7","Ver.8"
//                              ,"Ver.9", 0 };

SCompDlg::SCompDlg(SComp * C, QWidget *parent )
    : QDialog( parent )
{
 Co=C;
 QLabel *L;
 setMinimumSize( 195, 390 );
 setMaximumSize( 195, 390 );
 QPushButton *ok, *cancel;
 ok = new QPushButton( "Ok", this );
 ok->setFont( QFont( "Times", 18, QFont::Bold ) );
 ok->setGeometry( 105,390-40, 75,30 );
 connect( ok, SIGNAL(clicked()), SLOT(OK()) );
 cancel = new QPushButton( "Cancel", this );
 cancel->setFont( QFont( "Times", 18, QFont::Bold ) );
 cancel->setGeometry( 15,390-40, 75,30 );
 connect( cancel, SIGNAL(clicked()), SLOT(CA()) );
 int i;
 Ver=-1;
 Atrib  A;
 A=C->GetAtr();
 L=new QLabel("Ver",this);
 L->setGeometry( 10,10,40,20 );
 CBVer= new QComboBox(this);
// CBVer->insertItems(1,VerL);
 CBVer->insertItem(1,"All");
 CBVer->insertItem(2,"Actual");
 CBVer->insertItem(3,"Ver.0");
 CBVer->insertItem(4,"Ver.1");
 CBVer->insertItem(5,"Ver.2");
 CBVer->insertItem(5,"Ver.3");
 CBVer->setGeometry( 60,10,125,20 );
 CBVer->setCurrentIndex(Ver+2);
// CBVer->setFont(QFont( "Times", 10 ));
 int y;
 for(i=0;i<AtrN;i++){
  if(i<5) y=30*i+40;
  else y=30*i+70;
  L=new QLabel(A.GetName(i),this);
  L->setGeometry( 10,y,40,20 );
  LE[i]=new QLineEdit(this);
  LE[i]->setGeometry( 60,y,125,20 );
  if(A.GetAtr(i,Ver)) LE[i]->setText(*(A.GetAtr(i,Ver)));
  connect( LE[i], SIGNAL(returnPressed()), SLOT(OK()) );
 }
 i++;
 PicSComp * PC;
 PC=C->GetPSComp();
 y=PC->GetTNum();
 if(y>4) y=4;
 int j;
 for(j=0;j<y;j++){
   ok = new QPushButton( PC->GetTName(j), this );
   ok->setGeometry( j*45+5,190, 45,20 );
   switch (j) {
     case 0: connect(ok,SIGNAL(clicked()),SLOT(SetPkg0()));break;
     case 1: connect(ok,SIGNAL(clicked()),SLOT(SetPkg1()));break;
     case 2: connect(ok,SIGNAL(clicked()),SLOT(SetPkg2()));break;
     case 3: connect(ok,SIGNAL(clicked()),SLOT(SetPkg3()));break;
   }
 }
 L=new QLabel("Dev in Pkg",this);
 L->setGeometry( 10,30*i+40,70,20 );
 LEPiP=new QLineEdit(this);
 LEPiP->setGeometry( 90,30*i+40,85,20 );
 i++;
 QString s;
 s.setNum(PC->GetPiP());
 LEPiP->setText(s);
 CBPPV=new QCheckBox(this);
 CBPPV->setText("Vis power pin");
 CBPPV->setGeometry( 10,30*i+40,160,20 );
 CBPPV->setChecked(PC->GetPPV());
 LE[0]->setFocus();
 connect( CBVer, SIGNAL(activated(int)), SLOT(SetVer(int)) );
}

SCompDlg::~SCompDlg()
{

}

void SCompDlg::SetPkg(int n)
{
  printf("SetPkg %d\n",n);
  PicSComp * P;
  P=Co->GetPSComp();
  Atrib  A;
  A=Co->GetAtr();
  QString p=*(A.GetAtr(kAtrPkg));
  QString c=*(A.GetAtr(kAtrComm));
  QString t=P->GetTName(n);
  CnvAtr CA;
  CA.Convert(P->GetComm(t),P->GetPkg(t),A);
  LE[kAtrPkg]->setText(*(A.GetAtr(kAtrPkg)));
  LE[kAtrComm]->setText(*(A.GetAtr(kAtrComm)));
  A.SetAtr(kAtrPkg,p);
  A.SetAtr(kAtrComm,c);
}

void SCompDlg::SetPkg0()
{
  SetPkg(0);
}
void SCompDlg::SetPkg1()
{
  SetPkg(1);
}
void SCompDlg::SetPkg2()
{
  SetPkg(2);
}
void SCompDlg::SetPkg3()
{
  SetPkg(3);
}

void SCompDlg::SetVer(int v)
{
 int i;
 Atrib  A;
 A=Co->GetAtr();
 for(i=0;i<AtrN;i++){
  if(Ver==-2){
   if(A.GetAtr(i,0)){
    if(A.GetAtr(i,0) && LE[i]->text()!=*(A.GetAtr(i,0))){
     A.SetAtr(i,LE[i]->text(),Ver);
    }
   }
  }
  else A.SetAtr(i,LE[i]->text(),Ver);
 }
 Ver=v-2;
 for(i=0;i<AtrN;i++){
  if(A.GetAtr(i,Ver)) LE[i]->setText(*(A.GetAtr(i,Ver)));
 }
}

void SCompDlg::OK()
{
 int i;
 Atrib  A;
 A=Co->GetAtr();
 for(i=0;i<AtrN;i++){
  if(Ver==-2){
   if(A.GetAtr(i,0)){
    if(A.GetAtr(i,0) && LE[i]->text()!=*(A.GetAtr(i,0))){
     A.SetAtr(i,LE[i]->text(),Ver);
    }
   }
  }
  else A.SetAtr(i,LE[i]->text(),Ver);
 }
 PicSComp * PC;
 PC=Co->GetPSComp();
 QString s;
 s=LEPiP->text();
 PC->SetPiP(s.toInt());
 PC->SetPPV(CBPPV->isChecked());
 Change();
 accept();
 close();
}
void SCompDlg::CA()
{
 reject();
 close();
}



//--------------------------------------------------------------------------


PCompDlg::PCompDlg(PComp * C, QWidget *parent )
    : QDialog( parent )
{
 Co=C;
 QLabel *L;
 setMinimumSize( 195, 300 );
 setMaximumSize( 195, 300 );
 QPushButton *ok, *cancel;
 ok = new QPushButton( "Ok", this );
 ok->setFont( QFont( "Times", 18, QFont::Bold ) );
 ok->setGeometry( 105,260, 75,30 );
 connect( ok, SIGNAL(clicked()), SLOT(OK()) );
 cancel = new QPushButton( "Cancel", this );
 cancel->setFont( QFont( "Times", 18, QFont::Bold ) );
 cancel->setGeometry( 15,260, 75,30 );
 connect( cancel, SIGNAL(clicked()), SLOT(CA()) );
 int i;
 for(i=0;i<AtrN;i++){
  L=new QLabel(C->GetAtrNam(i),this);
  L->setGeometry( 10,30*i+10,40,20 );
  LE[i]=new QLineEdit(this);
  LE[i]->setGeometry( 60,30*i+10,125,20 );
  LE[i]->setText((C->GetAtr(i)));
  connect( LE[i], SIGNAL(returnPressed()), SLOT(OK()) );
 }
/* PicPComp * PC;
 PC=C->GetPPComp();
 L=new QLabel("Dev in Pkg",this);
 L->setGeometry( 10,30*i+10,70,20 );
 LEPiP=new QLineEdit(this);
 LEPiP->setGeometry( 90,30*i+10,85,20 );
 i++;
 QString s;
 s.setNum(PC->GetPiP());
 LEPiP->setText(s);
 CBPPV=new QCheckBox(this);
 CBPPV->setText("Vis power pin");
 CBPPV->setGeometry( 10,30*i+10,160,20 );
 CBPPV->setChecked(PC->GetPPV());*/
 LE[0]->setFocus();
}

PCompDlg::~PCompDlg()
{

}

void PCompDlg::OK()
{
 int i;
 for(i=0;i<AtrN;i++){
  Co->SetAtr(i,LE[i]->text().toLatin1().data());
 }
/* PicPComp * PC;
 PC=Co->GetPPComp();
 QString s;
 s=LEPiP->text();
 PC->SetPiP(s.toInt());
 PC->SetPPV(CBPPV->isChecked());*/
 Change();
 accept();
 delete this;
}
void PCompDlg::CA()
{
 reject();
 delete this;
}

//--------------------------------------------------------------------------


PSCompDlg::PSCompDlg(PicSComp * C, QWidget *parent )
    : QDialog( parent )
{
 QString str;
 QLabel *L;
 Co=C;
 setMinimumSize( 300, 400 );
 setMaximumSize( 300, 400 );
 QPushButton *ok, *cancel,*it;
 ok = new QPushButton( "Ok", this );
 ok->setFont( QFont( "Times", 18, QFont::Bold ) );
 ok->setGeometry( 215,360, 75,30 );
 connect( ok, SIGNAL(clicked()), SLOT(OK()) );
 cancel = new QPushButton( "Cancel", this );
 cancel->setFont( QFont( "Times", 18, QFont::Bold ) );
 cancel->setGeometry( 130,360, 75,30 );
 connect( cancel, SIGNAL(clicked()), SLOT(CA()) );
 it = new QPushButton( "New Type", this );
 it->setFont( QFont( "Times", 14 ) );
 it->setGeometry( 215,200, 75,30 );
 connect( it, SIGNAL(clicked()), SLOT(InsT()) );
 ppp=Co->GetPPP();
 Co->UpdatePinLst();
 MkPkgT();
 MkPinT();

 L=new QLabel("Parts per pkg :",this);
 L->setGeometry( 10,70, 130,20 );
 str.setNum(ppp);
 LEPPP=new QLineEdit(this);
 LEPPP->setGeometry( 150,70, 40,20 );
 LEPPP->setText(str);
 connect( LEPPP, SIGNAL(returnPressed()), SLOT(SetPPP()) );

 L=new QLabel("Value :",this);
 L->setGeometry( 10,10, 100,20 );
 str.setNum(ppp);
 LEVal=new QLineEdit(this);
 LEVal->setGeometry( 120,10, 100,20 );
 LEVal->setText(*(Co->GetVal()));

 L=new QLabel("Reference :",this);
 L->setGeometry( 10,40, 100,20 );
 str.setNum(ppp);
 LERef=new QLineEdit(this);
 LERef->setGeometry( 120,40, 100,20 );
 LERef->setText(*(Co->GetRef()));

}

PSCompDlg::~PSCompDlg()
{

}

void PSCompDlg::OK()
{
 int i;
 int j;
 int n;
 QString s;

 s=LEVal->text();
 Co->SetVal(&s);
 s=LERef->text();
 Co->SetRef(&s);
 Co->SetPPP(ppp);

 for(i=0;i<PinN;i++){
  s=PinT->cellContent(i,1);
  n=s.toInt();
  for(j=0;j<ppp;j++){
   s=PinT->cellContent(i,j+1);
   Co->SetPinNum(j,n,s.toInt());
  }
  Co->SetPinName(n,PinT->cellContent(i,0));
 }

 for(i=0;i<PkgN;i++){
  Co->SetPkg(PkgT->GetRHead(i),PkgT->cellContent(i,0));
  Co->SetComm(PkgT->GetRHead(i),PkgT->cellContent(i,1));
 }
 Co->UpdatePinLst();
 accept();
 delete this;
}

void PSCompDlg::CA()
{
 reject();
 delete this;
}

void PSCompDlg::InsT()
{
 QString Str;
 QString s="New type name";
 StrDlg * SD;
 SD=new StrDlg(this);
 if (SD->GetStr(&Str,s) && Str.length()>1){
  PkgN++;
  PkgT->SetSize(PkgN,2);
  PkgT->SetRHead(PkgN-1,Str);
 }
 delete SD;
}

void PSCompDlg::SetPPP()
{
 QString Str=LEPPP->text();
 int p=Str.toInt();
 if (p>0){
  ppp=p;
  PinT->SetSize(PinN,ppp+1);
 }
 int j;
 for(j=1;j<ppp+1;j++){
  Str.setNum(j);
  PinT->SetCHead(j,Str);
  PinT->SetCellWidth(j,30);
 }
 PinT->update();
}


void PSCompDlg::MkPkgT()
{
 PkgN=Co->GetTNum();

 PkgT=new Table(PkgN,2,this);
 PkgT->setGeometry( 10,110, 280,80 );
 int i;
 QString s;
 QString s1;
 for(i=0;i<PkgN;i++){
  s=Co->GetTName(i);
  PkgT->SetRHead(i,s);
  s1=Co->GetPkg(s);
  PkgT->setCellContent(i,0,s1);
  s1=Co->GetComm(s);
  PkgT->setCellContent(i,1,s1);
 }
 s1="TYPE";
 PkgT->SetCHead(-1,s1);
 s1="PKG";
 PkgT->SetCHead(0,s1);
 s1="COMM";
 PkgT->SetCHead(1,s1);
 PkgT->SetCellWidth(-1,60);
 PkgT->SetCellWidth(0,100);
 PkgT->SetCellWidth(1,100);
}

void PSCompDlg::MkPinT()
{
 PinN=Co->GetPinNum();

 PinT=new Table(PinN,ppp+1,this);
 PinT->setGeometry( 10,240, 280,110 );
 int i;
 int j;
 int n=0;
 QString s;
 QString s1;
 for(i=0;i<PinN;i++){
  while (Co->GetPinNum(0,n)<0) n++;
  s.setNum(n);
  PinT->SetRHead(i,s);
  for(j=1;j<ppp+1;j++){
   s.setNum(Co->GetPinNum(j-1,n));
   PinT->setCellContent(i,j,s);
  }
  s1=Co->GetPinName(n);
  PinT->setCellContent(i,0,s1);
  n++;
 }
 for(j=1;j<ppp+1;j++){
  s.setNum(j);
  PinT->SetCHead(j,s);
  PinT->SetCellWidth(j,30);
 }
 PinT->SetCellWidth(-1,40);
 PinT->SetCellWidth(-1,45);
 s1="NET";
 PinT->SetCHead(0,s1);
}

//--------------------------------------------------------------------------


//static const char *SelMode[] = { "Std", "Power", 0 };


PinDlg::PinDlg(PicPin * C, QWidget *parent )
    : QDialog( parent )
{
 QString str;
// QLabel *L;
 Co=C;
 setMinimumSize( 160, 80 );
 setMaximumSize( 160, 80 );

 QPushButton *ok, *cancel;
 ok = new QPushButton( "Ok", this );
 ok->setFont( QFont( "Times", 18, QFont::Bold ) );
 ok->setGeometry( 85,40, 65,30 );
 connect( ok, SIGNAL(clicked()), SLOT(OK()) );
 cancel = new QPushButton( "Cancel", this );
 cancel->setFont( QFont( "Times", 18, QFont::Bold ) );
 cancel->setGeometry( 10,40, 65,30 );
 connect( cancel, SIGNAL(clicked()), SLOT(CA()) );

 str.setNum(Co->GetNum());
 LENum=new QLineEdit(this);
 LENum->setGeometry( 10,10, 60,20 );
 LENum->setText(str);
 connect( LENum, SIGNAL(returnPressed()), SLOT(OK()) );

 CBTyp= new QComboBox(this);
// CBTyp->insertItems(1,SelMode);
 CBTyp->insertItem(1,"Std");
 CBTyp->insertItem(2,"Power");
 CBTyp->setGeometry( 80,10, 70,20 );
 CBTyp->setFont(QFont( "Times", 10 ));

 if(Co->GetSubIden()==kSIDPower) CBTyp->setCurrentIndex(1);

 LENum->setFocus();
}

PinDlg::~PinDlg()
{

}

void PinDlg::OK()
{
 QString s;

 s=LENum->text();
 Co->SetNum(s.toInt());
 if(CBTyp->currentIndex()==1) Co->SetSubIden(kSIDPower);
 Change();
 accept();
 delete this;
}

void PinDlg::CA()
{
 reject();
 delete this;
}

//--------------------------------------------------------------------------


PadSDlg::PadSDlg(PicPadS * C, QWidget *parent )
    : QDialog( parent )
{
 QString str;
 QLabel *L;
 Co=C;
 setMinimumSize( 160, 80 );
 setMaximumSize( 160, 80 );

 QPushButton *ok, *cancel;
 ok = new QPushButton( "Ok", this );
 ok->setFont( QFont( "Times", 18, QFont::Bold ) );
 ok->setGeometry( 85,40, 65,30 );
 connect( ok, SIGNAL(clicked()), SLOT(OK()) );
 cancel = new QPushButton( "Cancel", this );
 cancel->setFont( QFont( "Times", 18, QFont::Bold ) );
 cancel->setGeometry( 10,40, 65,30 );
 connect( cancel, SIGNAL(clicked()), SLOT(CA()) );


 L=new QLabel(Co->GetName(),this);
 L->setGeometry( 10,10, 60,20 );

 str.setNum(Co->GetPinNum());
 LENum=new QLineEdit(this);
 LENum->setGeometry( 80,10, 70,20 );
 LENum->setText(str);
 connect( LENum, SIGNAL(returnPressed()), SLOT(OK()) );

 LENum->setFocus();
}

PadSDlg::~PadSDlg()
{

}

void PadSDlg::OK()
{
 QString s;

 s=LENum->text();
 Co->SetPinNum(s.toInt());
 Change();
 accept();
 delete this;
}

void PadSDlg::CA()
{
 reject();
 delete this;
}

//--------------------------------------------------------------------------


SchDlg::SchDlg(DbSch * D, QWidget *parent )
    : QDialog( parent )
{
 QString str;
 Db=D;
 setMinimumSize( 700, 400 );
 setMaximumSize( 700, 1000 );

 ok = new QPushButton( "Ok", this );
 ok->setFont( QFont( "Times", 18, QFont::Bold ) );
 connect( ok, SIGNAL(clicked()), SLOT(OK()) );
 cancel = new QPushButton( "Cancel", this );
 cancel->setFont( QFont( "Times", 18, QFont::Bold ) );
 connect( cancel, SIGNAL(clicked()), SLOT(CA()) );

 L=new QLabel("Version :",this);

 str.setNum(D->GetVer());
 LEV=new QLineEdit(this);
 LEV->setText(str);

 AL=NULL;
 MkAL();
 MkTable();
 Arrange();
}

SchDlg::~SchDlg()
{
 AtrLst * L;
 while(AL){
  L=AL;
  AL=AL->Next;
  delete L;
 }
}

void SchDlg::Arrange()
{
 LEV->setGeometry( 80,height()-35, 30,20 );
 L->setGeometry( 10,height()-35, 60,20 );
 ok->setGeometry( 615,height()-40, 75,30 );
 cancel->setGeometry( 530,height()-40, 75,30 );
 T->setGeometry(10,10,680,height()-60);
}

void SchDlg::AddAtr(Atrib & A)
{
 AtrLst * L;
 L=AL;
 while(L){
  if(L->A.OneData(A)) return;
  L=L->Next;
 }

 L=new AtrLst;
 L->Next=AL;
 L->A=A;
 AL=L;
}

Atrib * SchDlg::FindAtr(QString Ref)
{
 AtrLst * L;
 L=AL;
 printf("FindAtr %s\n",Ref.toLatin1().data());
 while(L){
  if(Ref.compare(*(L->A.GetAtr(kAtrRef)))==0) return &(L->A);
  L=L->Next;
 }
 return NULL;
}


void SchDlg::MkAL()
{
 SComp * C;
 Atrib A;
 printf("MkAL : Start\n");
 AL=NULL;
 C=Db->GetFirstComp();
 while(C){
  if(!C->GetAtr(kAtrRef).isEmpty()) AddAtr(C->GetAtr());
  printf("MkAL : AdAtr %s\n",C->GetAtr(0).toLatin1().data());
  C=Db->GetNextComp();
 }
 Sort();
 printf("MkAL : OK\n");
}


void SchDlg::Sort()
{
 QString s1;
 QString s2;
 AtrLst * L;
 AtrLst * T;
 AtrLst * LM=NULL;
 bool ch=true;
 int x;
 while(ch){
  L=AL;
  ch=false;
  while(L && L->Next){
   L->A.GetRef(s1);
   L->Next->A.GetRef(s2);
   if(s1.compare(s2)==0) x=L->A.GetRefNum()>L->Next->A.GetRefNum();
   else x=s1.compare(s2)==1;
   if(x){
    ch=true;
    if(L==AL){
     AL=L->Next;
     LM=L->Next;
     T=L->Next;
     L->Next=L->Next->Next;
     T->Next=L;
    }
    else{
     LM->Next=L->Next;
     LM=L->Next;
     T=L->Next;
     L->Next=L->Next->Next;
     T->Next=L;
    }
   }
   else{
    LM=L;
    L=L->Next;
   }
  }
 }
}


void SchDlg::MkTable()
{
 int i=0;
 int j;
 int k;
 Atrib a;
 QString s;
 QString s1;

 AtrLst *L=AL;
 while(L){
  for(k=0;k<VerN;k++){
   if(L->A.GetAtr(kAtrRef,k)){
    i++;
   }
  }
  L=L->Next;
 }
 T=new Table(i,AtrN,this);
 Num=i;
 printf("MkTable : Create %d row\n",i);

 s1="Ver";
 T->SetCHead(0,s1);
 T->SetCellWidth(-1,60);
 T->SetCellWidth(0,30);
 for(i=1;i<AtrN;i++){
  s1=a.GetName(i);
  T->SetCHead(i,s1);
  T->SetCellWidth(i,80);
 }

 T->SetCellWidth(kAtrToPcb,60);
 T->SetCellWidth(kAtrPartL,60);
 T->SetCellWidth(kAtrComm,220);

 printf("MkTable : SetCHead \n");

 i=0;
 L=AL;
 while(L){
  for(k=0;k<VerN;k++){
   if(L->A.GetAtr(kAtrRef,k)){
    T->SetRHead(i,*(L->A.GetAtr(kAtrRef,k)));
    s.setNum(k);
    T->setCellContent(i,0,s);
    for(j=1;j<AtrN;j++){
     T->setCellContent(i,j,*(L->A.GetAtr(j,k)));
    }
    i++;
   }
  }
  L=L->Next;
 }
 printf("MkTable : OK\n");
}


void SchDlg::OK()
{
 QString s;
 int i;
 int j;
 int v;
 s=LEV->text();
 Db->SetVer(s.toInt());

 Atrib * A;
 for(i=0;i<Num;i++){
  A=FindAtr(T->GetRHeadS(i));
  if(A){
   s=T->cellContentS(i,0);
   v=s.toInt();
   for(j=1;j<AtrN;j++){
    A->SetAtr(j,T->cellContentS(i,j),v);
   }
  }
  else printf("No Atrib %s\n",T->GetRHead(i));
 }

 accept();
 close();
}

void SchDlg::CA()
{
 reject();
 close();
}

void SchDlg::resizeEvent ( QResizeEvent * /*e*/)
{
 Arrange();
}
