/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "DrcDlg.h"
#include <stdlib.h>
#include <QTextStream>
#include <QFileDialog>
#include <QFile>
#include <QPrinter>
#include <QPainter>

#include <QHBoxLayout>
#include <QVBoxLayout>

DrcDlg::DrcDlg(DRC * D, QWidget *parent )
        : QDialog( parent )
{
  QVBoxLayout * MLayout;
  QHBoxLayout * BLayout;


  MLayout = new QVBoxLayout(this);
  MLayout->setSpacing(6);
  MLayout->setMargin(11);

  Drc=D;

  QPushButton* Pb;
  QLabel* Lb;

  BLayout = new QHBoxLayout();
  BLayout->setSpacing(6);
  BLayout->setMargin(11);

  Lb=new QLabel("DRC SETTINGS",this);
  BLayout->addWidget( Lb );
  QSpacerItem * spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding , QSizePolicy::Minimum);
  BLayout->addItem( spacer );

  MLayout->addLayout( BLayout );

  BLayout = new QHBoxLayout();
  BLayout->setSpacing(10);
  BLayout->setMargin(4);


  Lb=new QLabel("Pad to Pad:",this);
  BLayout->addWidget( Lb );

  LePP=new QLineEdit(this);
  BLayout->addWidget( LePP );

  Lb=new QLabel("Wire to Wire:",this);
  BLayout->addWidget( Lb );

  LeWW=new QLineEdit(this);
  BLayout->addWidget( LeWW );

  MLayout->addLayout( BLayout );

  BLayout = new QHBoxLayout();
  BLayout->setSpacing(10);
  BLayout->setMargin(4);

  Lb=new QLabel("Pad to Wire:",this);
  BLayout->addWidget( Lb );

  LePW=new QLineEdit(this);
  BLayout->addWidget( LePW );

  Lb=new QLabel("Wire to Other:",this);
  BLayout->addWidget( Lb );

  LeWO=new QLineEdit(this);
  BLayout->addWidget( LeWO );

  MLayout->addLayout( BLayout );

  BLayout = new QHBoxLayout();
  BLayout->setSpacing(10);
  BLayout->setMargin(4);

  Lb=new QLabel("Pad to Other:",this);
  BLayout->addWidget( Lb );

  LePO=new QLineEdit(this);
  BLayout->addWidget( LePO );

  Lb=new QLabel("Other to Other:",this);
  BLayout->addWidget( Lb );

  LeOO=new QLineEdit(this);
  BLayout->addWidget( LeOO );

  MLayout->addLayout( BLayout );


  BLayout = new QHBoxLayout();
  BLayout->setSpacing(6);
  BLayout->setMargin(11);

  Pb = new QPushButton( "Load", this );
  connect( Pb, SIGNAL(clicked()),this, SLOT(Load()) );
  BLayout->addWidget( Pb );

  Pb = new QPushButton( "Save", this );
  connect( Pb, SIGNAL(clicked()),this, SLOT(Save()) );
  BLayout->addWidget( Pb );

  spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding , QSizePolicy::Minimum);
  BLayout->addItem( spacer );

  Pb = new QPushButton( "Cancel", this );
  connect( Pb, SIGNAL(clicked()),this, SLOT(Cancel()) );
  BLayout->addWidget( Pb );

  Pb = new QPushButton( "Revert", this );
  connect( Pb, SIGNAL(clicked()),this, SLOT(Revert()) );
  BLayout->addWidget( Pb );

  Pb = new QPushButton( "OK", this);
  connect( Pb, SIGNAL(clicked()),this, SLOT(OK()) );
  BLayout->addWidget( Pb );

  MLayout->addLayout( BLayout );
  Revert();
}

DrcDlg::~DrcDlg()
{
}

void  DrcDlg::Revert()
{
  double pp;
  double pw;
  double po;
  double ww;
  double wo;
  double oo;
  QString s;

  Drc->GetParam(pp,pw,po,ww,wo,oo);
  s.setNum(pp);
  LePP->setText(s);
  s.setNum(pw);
  LePW->setText(s);
  s.setNum(po);
  LePO->setText(s);
  s.setNum(ww);
  LeWW->setText(s);
  s.setNum(wo);
  LeWO->setText(s);
  s.setNum(oo);
  LeOO->setText(s);
}

void DrcDlg::Set()
{
  double pp;
  double pw;
  double po;
  double ww;
  double wo;
  double oo;

  pp=LePP->text().toDouble();
  pw=LePW->text().toDouble();
  po=LePO->text().toDouble();
  ww=LeWW->text().toDouble();
  wo=LeWO->text().toDouble();
  oo=LeOO->text().toDouble();

  Drc->SetParam(pp,pw,po,ww,wo,oo);
}

void DrcDlg::OK()
{
  Set();
  close();
}

void DrcDlg::Cancel()
{
  close();
}

void DrcDlg::Save()
{
  QString s;
  s = QFileDialog::getSaveFileName(this, tr("Save File"),0,tr("*"));
  if (s.isEmpty()) return;

  Set();
  QFile F(s);
  F.open(QIODevice::WriteOnly);
  QTextStream S;
  S.setDevice(&F);
  
  Drc->TextSave(&S);
  
  F.close();
}

void DrcDlg::Load()
{
  QString s;
  int i;
  
  s = QFileDialog::getOpenFileName(this, tr("Open File"),0,tr("*"));
  if (s.isEmpty()) return;

  QFile F(s);
  F.open(QIODevice::ReadOnly);
  QTextStream S;
  S.setDevice(&F);
  
  S >> s;
  while(!s.isEmpty()){
    if(s.contains("DrcSetting")){
      Drc->TextLoad(&S);
      break;
    }
    else{
      i=1;
      while(i){
        S >> s;
        if(s.contains("{")) i++;
        if(s.contains("}")) i--;
	if(s.isEmpty()) break;
      }
    }
    S >> s;
  }

  F.close();
  Revert();
}


