/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "Global.h"
#include "Edit.h"
#include "PicEl.h"
#include "PicObj.h"
#include "PicGrp.h"
#include "SComp.h"
#include "PComp.h"
#include "PicPin.h"
#include "Layers.h"
#include "LyEdit.h"
#include "ColSel.h"
#include "ActButt.h"
#include "Library.h"
#include "Dlg.h"
#include "ObjEdit.h"

#include <QApplication>
#include <QPainter>
#include <QPushButton>
#include <QFont>
#include <QEvent>
//#include <qtstream.h>
#include <QFile>
//#include <qiodev.h>
#include <QPalette>
//Added by qt3to4:
#include <QTextStream>
#include <QResizeEvent>
#include <QMouseEvent>
#include <QPaintEvent>
#include <QWheelEvent>
#include <QClipboard>
#include <QTime>
 
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "Error.h"

#define Update() repaint()

#define MWHEEL_Z1_M8 0
#define MWHEEL_ZOOM 1
#define MWHEEL_M_CTRLZ 2
#define MWHEEL_SHIFTM_CTRLZ 3

extern Errors  gErr;
extern Library gLib;


Edit::Edit(PicGrp * Db, QWidget *parent)
        : QWidget( parent)
{
    Info=NULL;
    setMouseTracking(true);
    G=Db;

    EWire=false;

    LE=new QLineEdit(this);
    LE->hide();
    LE->setGeometry(0,0,100,20);
    LEShow=false;
    connect(LE,SIGNAL(returnPressed()), this, SLOT(EndLE()) );

/*    if (gErr.YesNoErr(QString("Test Colors"))){
     ColSel* Dl= new ColSel();
     Dl->show();
    }


    if (gErr.YesNoErr(QString("Start Application")))
    gErr.Warn(QString("Starting ..."));
*/
//    unsigned long int t=1;
    int i=0;

    QPalette p(Qt::white);
    setPalette(p);

//    QFile F("tmp.dat");
//    F.open(IO_ReadOnly);
//    F.open(IO_WriteOnly);
//    QTextStream S;
//    S.setDevice(&F);

//    G->TextLoad(&S);
//    G->TextSave(&S);
//    F.close();

    scale=0.03;
    XPos=0;
    YPos=0;
    for(i=0;i<SizeZH;i++){
     ZHS[i]=0.03;
     ZHX[i]=0;
     ZHY[i]=0;
    }

    x1=0;
    y1=0;
    x2=0;
    y2=0;

    BlSel=false;
    Line=false;
    Circ=false;
    Act=-1;
    LAct=-1;
    MAct=-1;

    Tx=NULL;
    Pw=NULL;
    setFocusPolicy(Qt::WheelFocus);
    setFocus();
    
}

Edit::~Edit()
{
  if(!G)return;
/*  QFile F("tmp.dat");
  F.open(QIODevice::WriteOnly);
  QTextStream S;
  S.setDevice(&F);
  G->TextSave(&S);
  F.close(); */
}

void Edit::SetInfo(InfoBarr * I)
{
 Info=I;
}

void Edit::SetDb(PicGrp * Db)
{
 G=Db;
 if (!G)return;
// G->LyChange();
 QRect r;
 UpdatePM();
 G->UpdORect();
 G->GetORect(&r);
 Zoom(r);
 SettingsChanged();
}

void Edit::SettingsChanged()
{
  int t=2;
  MWheel=-1;
  while(MWheel<0) MWheel=gLib.GetMWheel(t--);
}


void Edit::LyVisChange()
{
 if (!G)return;
// G->LyChange();
 UpdatePM();
 G->UpdORect();
 update();
}

void Edit::LyChange()
{
 if (!G)return;
// QPainter paint( this );               // start painting widget
 UpdatePM();
 G->UpdORect();
 update();
}

int Edit::ConvActType(int type)
{
 if (type==kABMove){
  return(kIBSelM | kIBOri);
 }
 if (type==kABCopy || type==kABRot || type==kABMoveP || type==kABMir || type==kABEdit){
  return(kIBSelM);
 }
 if (type==kABDel || type==kABAddP){
  return(kIBSelM);
 }
 if (type==kABMoveBl || type==kABRotBl || Act==kABMirBl || type==kABDelBl || type==kABMirBl){
  return(kIBSelM | kIBSelBM);
 }
 else if (type==kABCopyBl){
  return(kIBSelM | kIBSelBM | kIBCopyM);
 }
 else if (type==kABZoomIn || type==kABZoomOut){
  return(kIBZoomT);
 }
 else if (type==kABVWin){
  return(kIBVWinT);
 }
 else if (type==kABText){
  return(kIBFont);
 }
 else if (type==kABPower){
  return(kIBFont | kIBPType | kIBWid | kIBOri);
 }
 else if (type==kABLine){
  return(kIBLineT | kIBLineM | kIBWid);
 }
 else if (type==kABPoly){
  return(kIBLineT | kIBWid | kIBPolyN);
 }
 else if (type==kABCir){
  return(kIBWid | kIBR | kIBCirM);
 }
 else if (type==kABRect){
  return(kIBWid);
 }
 else if (type==kABAtr){
  return(kIBSelM | kIBFont | kIBAtr | kIBOri);
 }
 else if (type==kABEnter){
  return(kIBCNam | kIBOri);
 }
 else{
  return(0);
 }
}

void Edit::LActSel(int type)
{
 if (!G)return;
 if (type==kABFitW){
  QRect r;
  G->GetORect(&r);
  Zoom(r);
  Escape();
  return;
 }
 if (type==kABLastW){
  RestoreZH();
  Update();
  Escape();
  return;
 }
 if(LAct!=type){
  LAct=type;
  if(button==Qt::LeftButton){
   button=Qt::NoButton;
   Bl.setRect(0,0,0,0);
   BlSel=false;
   Line=false;
   Circ=false;
  }
 }
 if (Info){
  Info->SetActL(ConvActType(type));
 }
}

void Edit::MActSel(int type)
{
 if (!G)return;
 if (type==kABFitW){
  QRect r;
  G->GetORect(&r);
  Zoom(r);
  Escape();
  return;
 }
 if (type==kABLastW){
  RestoreZH();
  Update();
  Escape();
  return;
 }
 if(MAct!=type){
  MAct=type;
  if(button==Qt::MidButton){
   button=Qt::NoButton;
   Bl.setRect(0,0,0,0);
   BlSel=false;
   Line=false;
   Circ=false;
  }
 }
 if (Info){
  Info->SetActM(ConvActType(type));
 }
}

void Edit::HLNet(QString s)
{
  if (!G)return;
  printf("Edit::HLNet %s\n",s.toLatin1().data());
  if(s.isEmpty()){
    G->HLOff();
    G->DeSelect();
  }
  else{
    G->SelNet(s);
    G->HLSel();
  }  
//  UpdatePM();
  Update();
}

void Edit::HLComp(QString s)
{
  if (!G)return;
  printf("Edit::HLComp %s\n",s.toLatin1().data());
  if(s.isEmpty()){
    G->HLOff();
    G->DeSelect();
    button=Qt::NoButton;
  }  
  else{
    G->SelComp(s);
    G->HLSel(1);
  }  
//  UpdatePM();
  Update();
}

void Edit::MoveComp(QString s)
{
  if (!G)return;
  printf("Edit::MoveComp %s\n",s.toLatin1().data());
  if(s.isEmpty()){
    G->HLOff();
    G->DeSelect();
  }
  else{
    G->SelComp(s);
    Act=kABMoveX;
    l1=G->SelPos();
    ClP=l1;
    Ori=G->SelRot();
    if (Info) Info->SetOri(button,Ori);
    button=Qt::LeftButton;
  }
//  UpdatePM();
  Update();
}

void Edit::Press(QPoint p,int but)
{
 DbToScr(&p);
 QMouseEvent e(QEvent::MouseButtonPress,p,(Qt::MouseButton)but,(Qt::MouseButtons)but,Qt::NoModifier);
 mouseMoveEvent(&e);
 mousePressEvent(&e);
 mouseReleaseEvent(&e);
}

void Edit::UpdatePM()
{
 LS=-1;
}

void Edit::UpdateAll()
{
 LS=-1;
 G->UpdORect();
 Update();
}


void Edit::paintEvent( QPaintEvent * e)
{
 if (!G)return;

 QPainter paint;
 unsigned int fl=0;
 int i;
 QTime T;
 
 if((G->GetIden()==kDbSch) || (G->GetIden()==kPicSComp)) fl=kDrawMirrorTxt;
  if(Info && (Info->IsOnFP())) fl|=kDrawFillPoly;
 
 QRect r;
 QPoint p0;
 if(LS!=G->IsSelect() || scale!=osc || XPos!=OXP || YPos!=OYP){
  printf("Edit:: Update PM %d=%d\n",LS,G->IsSelect());
  OXP=XPos;
  OYP=YPos;
  osc=scale;
  LS=G->IsSelect();
  PM.fill();
  paint.begin(&PM);
  paint.setPen(Qt::green);
  if(MWheel==MWHEEL_Z1_M8){
    for(i=0;i<PM.width();i+=10){
      paint.drawPoint(i,PM.height()/3);
      paint.drawPoint(i,PM.height()*2/3);
    }
    for(i=0;i<PM.height();i+=10){
      paint.drawPoint(PM.width()/3,i);
      paint.drawPoint(PM.width()*2/3,i);
    }
  }
  else if(MWheel==MWHEEL_M_CTRLZ){
    for(i=0;i<PM.height();i+=10){
      paint.drawPoint(PM.width()/10,i);
      paint.drawPoint(PM.width()*9/10,i);
    }
  }
  paint.scale(scale,scale);
  paint.setRenderHint(QPainter::Antialiasing);
  paint.setRenderHint(QPainter::HighQualityAntialiasing);

  if(G->GetIden()==kDbPcb) paint.setOpacity(0.85);

  r.setRect(0,0,PM.width(),PM.height());
  QRegion region = QRegion(r) * paint.combinedTransform().inverted();
  r = region.boundingRect();
  paint.setClipRect(r);
//  T.start();
//  G->ReDraw(&paint,&r,kDrawOth | fl | kDrawDummy,XPos,YPos);
//  G->ReDraw(&paint,&r,kDrawAct | fl | kDrawDummy,XPos,YPos);
//  printf("Draw dummy time %d\n",T.elapsed());
  T.start();
  G->ReDraw(&paint,&r,kDrawOth | fl | kDrawFast,XPos,YPos);
  G->ReDraw(&paint,&r,kDrawAct | fl | kDrawFast,XPos,YPos);
  printf("Draw time %d\n",T.elapsed());
  paint.end();
 }

 paint.begin(this);
 
 paint.setRenderHint(QPainter::Antialiasing);
 
 r=e->rect();

 p0.setX(r.left());
 p0.setY(r.top());
 paint.drawPixmap(p0,PM,r);

 paint.scale(scale,scale);

// r=paint.xFormDev(r);
  QRegion region1 = QRegion(r) * paint.combinedTransform().inverted();
  r = region1.boundingRect();

// paint.setClipRect(r);
 

 paint.setClipping(false);

 paint.setPen(Qt::black);

 if (Info){
  if (Info->IsVisGr()){
   float x=Info->GetGX();
   float y=Info->GetGY();
   if((x*scale)>10 && (y*scale)>10){
    int i;
    int j;
    paint.setPen(Qt::black);
    for(i=(((r.left()-XPos)/x)*x)+XPos;i<=r.right();i+=x){
     for(j=((r.top()-YPos)/y)*y+YPos;j<=r.bottom();j+=y){
      paint.drawPoint(i,j);
     }
    }
   }
   else if((x*scale)>5 && (y*scale)>5){
    int i;
    int j;
    x=x*2;y=y*2;
    paint.setPen(Qt::black);
    for(i=(((r.left()-XPos)/x)*x)+XPos;i<=r.right();i+=x){
     for(j=((r.top()-YPos)/y)*y+YPos;j<=r.bottom();j+=y){
      paint.drawPoint(i,j);
     }
    }
   }
  }
 }

 if(G->GetIden()==kDbPcb) paint.setOpacity(0.92);
 G->ReDraw(&paint,&r,kDrawSel | fl,XPos,YPos);


 if (Bl.isValid()){
  QRect r=Bl;
  QPen pen;
  if(scale<1) pen.setWidth(1/scale);
  else pen.setWidth(1);
  pen.setColor(Qt::black);
  paint.setPen(pen);
  paint.setBrush(Qt::NoBrush);
  r.translate(XPos,YPos);
  paint.drawRect(r);
 }

 if (Line){
  QPoint p1(XPos,YPos);
  QPen pen;
  if(scale<1) pen.setWidth(1/scale);
  else pen.setWidth(1);
  pen.setColor(Qt::black);
  paint.setPen(pen);
  paint.setBrush(Qt::NoBrush);
  paint.drawLine(l1+p1,PLineT(l1,l2)+p1);
  if(LineT){
   paint.setPen(Qt::DashLine);
   paint.drawLine(l2+p1,PLineT(l1,l2)+p1);
  }
/*  if(PL){
   PicPNet::PinLst * L;
   paint.setBrush(Qt::black);
   L=PL;
   while(L){
    paint.drawEllipse(L->x-20+p1.x(),L->y-20+p1.y(),40,40);
    L=L->Next;
   }
  } */
 }

 if (Circ && l1!=l2){
  QPoint p;
  p=l1-l2;
  int rr=(int)sqrt((double)p.x()*p.x()+(double)p.y()*p.y());
  QRect r1(l1.x()-rr,l1.y()-rr,2*rr,2*rr);
  QPen pen;
  if(scale<1) pen.setWidth(1/scale);
  else pen.setWidth(1);
  pen.setColor(Qt::black);
  paint.setPen(pen);
  paint.setBrush(Qt::NoBrush);
  r1.translate(XPos,YPos);
  paint.drawEllipse(r1);
 }

 paint.end();

 if(button==Qt::NoButton){
  paint.begin(this);
//  printf("Edit:: Clipping = %d\n", paint.hasClipping());
  paint.setPen(Qt::black);
  if(!IStr.isEmpty()){
    r.setRect(xP-10-4*IStr.length(),yP-21,20+8*IStr.length(),12);
    paint.setFont(QFont("Courier",10));
    paint.drawText(r,Qt::AlignCenter,IStr);
  }
  paint.drawLine(xP,yP-10,xP,yP+10);
  paint.drawLine(xP-10,yP,xP+10,yP);
  paint.end();
 }


}

void Edit::EndLE()
{
 LE->hide();
 LEShow=false;
 if (!G)return;
 if (Tx && TxNew) G->AddItem(Tx);
 if (Pw && PwNew) G->AddItem(Pw);
 QRect r;
 QRect r1;
 G->DeSelect();
// G->LyChange();
 if (Tx){
  G->Select(Tx);
  G->GetSelORect(&r);
  Tx->SetText(LE->text());
  Tx=NULL;
 } 
 if (Pw){
  G->Select(Pw);
  G->GetSelORect(&r);
  Pw->SetText(LE->text());
  Pw=NULL;
 }
 G->UpdSelORect();
 G->GetSelORect(&r1);
 r=r.unite(r1);
 DbToScr(&r);
 r.translate(-2,-2);
 r.setWidth(r.width()+4);
 r.setHeight(r.height()+4);
 repaint(r);
 G->DeSelect();
 button=Qt::NoButton;
}

void Edit::Zoom(QRect r)
{
 if (!G)return;
 if(r.isValid()){
  if ((float)width()/r.width()<(float)height()/r.height()){
   scale=(float)width()/r.width();
  } else {
   scale=(float)height()/r.height();
  }
  scale=scale*0.9;
  if(scale<0.0001) scale=0.0001;
  if(scale>32) scale=32;
  QPoint p=r.center();
  XPos=-p.x()+(int)((width()/2)/scale);
  YPos=-p.y()+(int)((height()/2)/scale);
  Update();
  SaveZH();
 }
}

void Edit::SaveZH()
{
 int i;
 for(i=SizeZH-2;i>=0;i--){
  ZHX[i+1]=ZHX[i];
  ZHY[i+1]=ZHY[i];
  ZHS[i+1]=ZHS[i];
//  printf("%2.3f ",ZHS[i+1]);
 }
 ZHX[0]=XPos;
 ZHY[0]=YPos;
 ZHS[0]=scale;
// printf("%2.3f\n",ZHS[i+1]);
}

void Edit::RestoreZH()
{
 int i;
 for(i=0;i<SizeZH-1;i++){
  ZHX[i]=ZHX[i+1];
  ZHY[i]=ZHY[i+1];
  ZHS[i]=ZHS[i+1];
//  printf("%2.3f ",ZHS[i]);
 }
 XPos=ZHX[0];
 YPos=ZHY[0];
 scale=ZHS[0];
 ZHS[i]=0.03;
 ZHX[i]=0;
 ZHY[i]=0;
// printf("%2.3f\n",ZHS[i]);
}

void Edit::wheelEvent ( QWheelEvent * e )
{
 printf("Wheel delta %d\n",e->delta());
// if (Mode==1) AdjustMark(e->delta());
  if(MWheel==MWHEEL_Z1_M8){
    if((e->x()>width()/3) && (e->x()<2*width()/3) && (e->y()>height()/3) && (e->y()<2*height()/3)){
     QPoint p=e->pos();
     ScrToDb(&p);

     if(e->delta()>1) scale=scale*(1+e->delta()/360.0);
     else if(e->delta()<-1) scale=scale/(1-e->delta()/360.0);


     if(scale>32) scale=32;
    // XPos=-p.x()+(int)((width()/2)/scale);
    // YPos=-p.y()+(int)((height()/2)/scale);
     XPos=-p.x()+(int)((e->pos().x())/scale);
     YPos=-p.y()+(int)((e->pos().y())/scale);
     Update();
   //  SaveZH();
   //  RestoreSt();
    }
    else{
     int dx;
     int dy;
     dx=((e->delta()*(int)(width()/8/scale)/120));
     dy=((e->delta()*(int)(height()/8/scale)/120));

     if(e->x()<width()/3)   dx=-dx;
     else if(e->x()<2*width()/3) dx=0;

     if (e->y()>2*height()/3) dx=-dx;
     else if (e->y()>height()/3) dy=0;

     XPos-=dx;
     YPos+=dy;

     Update();
    }
  }  
  else if(MWheel==MWHEEL_ZOOM){
    QPoint p=e->pos();
    ScrToDb(&p);

    if(e->delta()>1) scale=scale*(1+e->delta()/360.0);
    else if(e->delta()<-1) scale=scale/(1-e->delta()/360.0);


    if(scale>32) scale=32;
   // XPos=-p.x()+(int)((width()/2)/scale);
   // YPos=-p.y()+(int)((height()/2)/scale);
    XPos=-p.x()+(int)((e->pos().x())/scale);
    YPos=-p.y()+(int)((e->pos().y())/scale);
    Update();
  }
  else if(MWheel==MWHEEL_M_CTRLZ){
    if(e->modifiers()==Qt::ControlModifier){
      QPoint p=e->pos();
      ScrToDb(&p);

//      if(e->delta()>0) scale=scale*sqrt(2)*(e->delta()/120);
//      else scale=scale/(sqrt(2)*(-e->delta()/120));
      if(e->delta()>1) scale=scale*(1+e->delta()/360.0);
      else if(e->delta()<-1) scale=scale/(1-e->delta()/360.0);


      if(scale>32) scale=32;
     // XPos=-p.x()+(int)((width()/2)/scale);
     // YPos=-p.y()+(int)((height()/2)/scale);
      XPos=-p.x()+(int)((e->pos().x())/scale);
      YPos=-p.y()+(int)((e->pos().y())/scale);
      Update();
    }
    else{
      int dx;
      int dy;
      dx=((e->delta()*(int)(width()/8/scale)/120));
      dy=((e->delta()*(int)(height()/8/scale)/120));

      if(e->x()<width()/10){
        dx=-dx;
	dy=0;
      }	
      else if(e->x()<9*width()/10) dx=0;
      else dy=0;

      XPos-=dx;
      YPos+=dy;

      Update();
    }
  }
  else if(MWheel==MWHEEL_SHIFTM_CTRLZ){
    if(e->modifiers()==Qt::ControlModifier){
      QPoint p=e->pos();
      ScrToDb(&p);

      if(e->delta()>1) scale=scale*(1+e->delta()/360.0);
      else if(e->delta()<-1) scale=scale/(1-e->delta()/360.0);


      if(scale>32) scale=32;
      XPos=-p.x()+(int)((e->pos().x())/scale);
      YPos=-p.y()+(int)((e->pos().y())/scale);
      Update();
    }
    else{
      int dx;
      int dy;
      dx=((e->delta()*(int)(width()/8/scale)/120));
      dy=((e->delta()*(int)(height()/8/scale)/120));

      if(e->modifiers()==Qt::ShiftModifier){
        dx=-dx;
        dy=0;
      }
      else dx=0;

      XPos-=dx;
      YPos+=dy;

      Update();
    }
  }
}

void Edit::mousePressEvent ( QMouseEvent *e )
{
 if (!G)return;
 QPoint p=e->pos();
 ScrToDb(&p);

// printf("MouPr b:%d\n",e->button());

 if (Act<kABFitW) SaveSt();

 if (button!=Qt::NoButton){
  if (e->button()==Qt::RightButton){
   if (Line){
    Line=false;
    EWire=false;
    G->HLOff();
    G->DeSelect();
   }
   if (LEShow){
    LE->hide();
    LEShow=false;
    if (Tx && TxNew) delete Tx;
    if (Pw && PwNew) delete Pw;
    Tx=NULL;
    Pw=NULL;
   }
   if (Circ){
    Circ=false;
   }
   if (Bl.isValid()){
    Bl.setRect(0,0,0,0);
    BlSel=false;
    G->HLOff();
   }
   if(Act==kABMove || Act==kABMoveX){
//    QRect r;
//    QRect r1;
//    G->GetSelORect(&r);
    G->MoveSelBy(ClP.x()-p.x(),ClP.y()-p.y());
    if(Act==kABMoveX) CompHL("");
//    G->UpdORect();
//    l1=p;
//    G->MoveSelTo(p-Dif);
//    if(XOri!=Ori){
//     G->RotateSel((XOri-Ori) & 3,p.x(),p.y());
//     Ori=XOri;
//    }
//    G->GetSelORect(&r1);
//    r=r.unite(r1);

//    DbToScr(&r);
//    r.translate(-1,-1);
//    r.setWidth(r.width()+2);
//    r.setHeight(r.height()+2);
//    repaint(r);
   }
   if(Act==kABAddP){
     G->MovePointTo(ClP); 
   }
   if((Act==kABHiL) || (Act==kABXMove)) NetHL("");
   G->HLOff();
   G->DeSelect();
   Update();
   button=Qt::NoButton;
   return;
  }
  else {
   if (LEShow){
    EndLE();
    return;
   }
   if (button==e->button() || (e->button()==Qt::MidButton && MAct<kABFitW)
       || (e->button()==Qt::LeftButton && LAct<kABFitW)){
//    Release();
    return;
   }
  }
 }
 button=e->button();
 int SelM=0;
// int SelBM=0;
 int ZoomT=0;
 int Atr=0;
 int Wid=0;
 int CirR=0;
 int CopyM=0;

 OldP=e->pos();

 if (button==Qt::MidButton){
  Act=MAct;
  QRect r(xP-11-4*IStr.length(),yP-21,22+8*IStr.length(),32);
  repaint(r);
  if (Info){
   SelM=Info->GetSelMM();
//   SelBM=Info->GetSelBMM();
   ZoomT=Info->GetZoomTM();
/*   Atr=Info->GetAtrM();*/
   Ori=Info->GetOriM();
   CirR=Info->GetRM();
   Wid=Info->GetWidM();
   CopyM=Info->GetCopyMM();
   if((Act==kABLine) || (Act==kABPoly)) LineT=Info->GetLineTM();
  }
 }
 else if (button==Qt::LeftButton){
  Act=LAct;
  QRect r(xP-11-4*IStr.length(),yP-21,22+8*IStr.length(),32);
  repaint(r);
  if (Info){
   SelM=Info->GetSelML();
//   SelBM=Info->GetSelBML();
   ZoomT=Info->GetZoomTL();
/*   Atr=Info->GetAtrL();*/
   Ori=Info->GetOriL();
   CirR=Info->GetRL();
   Wid=Info->GetWidL();
   CopyM=Info->GetCopyML();
   if((Act==kABLine) || (Act==kABPoly)) LineT=Info->GetLineTL();
  }
 }

 ClP=p;

 if (button==Qt::RightButton){
  if(BlSel){
   QRect r=Bl;
   DbToScr(&r);

   BlSel=false;
   Bl.setRect(0,0,0,0);
   G->DeSelect();
   G->HLOff();

   r.translate(-2,-2);
   r.setWidth(r.width()+4);
   r.setHeight(r.height()+4);
   repaint(r);
   button=Qt::NoButton;
   return;
  }
  Escape();
  button=Qt::NoButton;
 }
 else {
  if(Act==kABZoomIn){
   scale=scale*sqrt(2);
   if(scale>32) scale=32;
   if(ZoomT!=1){
    XPos=-p.x()+(int)((e->pos().x())/scale);
    YPos=-p.y()+(int)((e->pos().y())/scale);
   }
   else {
    XPos=-p.x()+(int)((width()/2)/scale);
    YPos=-p.y()+(int)((height()/2)/scale);
   }
   Update();
   SaveZH();
   RestoreSt();
   return;
  }
  else if(Act==kABZoomOut){
   scale=scale/sqrt(2);
   if(scale<0.03) scale=0.03;
   if(ZoomT!=1){
    XPos=-p.x()+(int)((e->pos().x())/scale);
    YPos=-p.y()+(int)((e->pos().y())/scale);
   }
   else {
    XPos=-p.x()+(int)((width()/2)/scale);
    YPos=-p.y()+(int)((height()/2)/scale);
   }
   Update();
   SaveZH();
   RestoreSt();
   return;
  }
  else if(Act==kABLine){
   if(G->GetIden()==kDbPcb){
    if(((DbPcb *)G)->IsConnect(p,2)){
     QRect r;
     printf("Edit: Net Connect\n");
     EWire=true;
     ((DbPcb *)G)->ANetORect(r);
     DbToScr(&r);
     r.translate(-2,-2);
     r.setWidth(r.width()+4);
     r.setHeight(r.height()+4);
     repaint(r);
    }
   }
   Line=true;
   LineD=0;
   l1=p;
   l2=p;
  }
  else if(Act==kABPoly){
   Poly=new PicPoly(G->GetLayers());
   Poly->SetWidth(Wid);
   if (button==Qt::MidButton){
     Poly->SetNet(Info->GetPolyNM());
     Poly->SetClr(Info->GetPolyCM());
   }
   else{
     Poly->SetNet(Info->GetPolyNL());
     Poly->SetClr(Info->GetPolyCL());
   }
   G->AddItem(Poly);
   Poly->DeSelect();
   G->DeSelect();
   Poly->AddSelPoint();
   G->Select(Poly);
   G->MoveSelTo(p);
   Line=true;
   LineD=0;
   l1=p;
   l2=p;
  }
  else if((Act==kABHiL) || (Act==kABXMove)){
/*   if((G->GetIden()==kDbPcb) && (((DbPcb *)G)->IsConnect(p,2))){
    QRect r;
    printf("Edit - HiL: Net Connect\n");
    EWire=true;
    ((DbPcb *)G)->ANetORect(r);
    DbToScr(&r);
    r.translate(-2,-2);
    r.setWidth(r.width()+4);
    r.setHeight(r.height()+4);
    repaint(r);
   }
   else{*/
    if (G->Select(p,SelM)){
     G->HLSel(1);
     
     QString s=G->GetHLComp();
     if(!s.isEmpty()){
       if(Act==kABXMove){
         CompMove(s);
         printf("Move Comp %s\n",s.toLatin1().data());
       }	 
       else{
         CompHL(s);
         printf("HL Comp %s\n",s.toLatin1().data());
       }	 
     }  
     else{
       s=G->GetHLNet();
       if(!s.isEmpty()){
         NetHL(s);
         printf("HL NET %s\n",s.toLatin1().data());
       }
     }  

     QRect r;
     G->GetSelORect(&r);
     DbToScr(&r);
     r.translate(-2,-2);
     r.setWidth(r.width()+4);
     r.setHeight(r.height()+4);

     repaint(r);
    }
//   }
  }
  else if(Act==kABRect){
   l1=p;
   l2=p;
  }
  else if(Act==kABCir){
   if(CirR){
    QRect r;
    PicCir * C=NULL;
    C=new PicCir(G->GetLayers());
    C->Circle(0,0,CirR);
    C->SetWidth(Wid);
    G->AddItem(C);
    G->DeSelect();
    G->Select(C);
    G->MoveSelTo(p);
    G->UpdORect();
    G->GetSelORect(&r);
    G->DeSelect();
    UpdatePM();
    DbToScr(&r);
    r.translate(-2,-2);
    r.setWidth(r.width()+4);
    r.setHeight(r.height()+4);
    repaint(r);
    button=Qt::NoButton;
   }
   else{
    Circ=true;
    l1=p;
    l2=p;
   }
  }
  else if(Act==kABText){
   if(!LEShow){
    if (G->Select(p,0+0x10000*kPicText)){
     Tx=(PicText *)G->GetSel();
     TxNew=false;
    }
    else {
     TxNew=true;
     Tx=new PicText(G->GetLayers());
     Tx->MoveTo(p-G->Pos());
     if (Info){
      if (button==Qt::LeftButton) {
       Tx->SetFont(Info->GetFonL());
       Tx->SetAlig(Info->GetHAlL(),Info->GetVAlL());
      }
      else {
       Tx->SetFont(Info->GetFonM());
       Tx->SetAlig(Info->GetHAlM(),Info->GetVAlM());
      }
     }
    }
    G->DeSelect();
    LE->setText(Tx->GetText());
    LE->move(e->pos());
    LE->show();
    LE->activateWindow();
    LE->setFocus();
    LEShow=true;
    Pw=NULL;
   }
//   button=Qt::NoButton;
  }
  else if(Act==kABPower){
   if(!LEShow){
    if (G->Select(p,0+0x10000*kPicPower)){
     Pw=(PicPower *)G->GetSel();
     PwNew=false;
    }
    else {
     PwNew=true;
     Pw=new PicPower(G->GetLayers());
     Pw->MoveTo(p-G->Pos());
     if (Info){
      if (button==Qt::LeftButton) {
       Pw->SetFont(Info->GetFonL());
       Pw->SetType(Info->GetPTypeL());
       Pw->RotateTo(Info->GetOriL());
      }
      else {
       Pw->SetFont(Info->GetFonM());
       Pw->SetType(Info->GetPTypeM());
       Pw->RotateTo(Info->GetOriM());
      }
      Pw->SetWidth(Wid);
     }
    }
    G->DeSelect();
    LE->setText(Pw->GetText());
    LE->move(e->pos());
    LE->show();
    LE->activateWindow();
    LE->setFocus();
    LEShow=true;
    Tx=NULL;
   }
//   button=Qt::NoButton;
  }
  else if(Act==kABMView){
   m1=p;
  }
  else if(Act==kABVWin){
   l1=p;
  }
  else if(Act==kABMove){
   int x=5;
   int y=5;
   if(Info){
    x=Info->GetGX()/2;
    y=Info->GetGY()/2;
   }
   l1=p;
   if (G->SelPoint(p,x*x+y*y,SelM)<0){
    G->SelInfo();
    if (G->Select(p,SelM)){
     Ori=G->SelRot();
     G->SelInfo();
      if (Info) Info->SetOri(button,Ori);
    } else button=Qt::NoButton;
   }
  }
  else if(Act==kABAddP){
    l1=p;
    PicEl *E=NULL;
    if (G->Select(p,SelM)){
      E=G->GetSel();
      while(E && ((E->GetIden()!=kPicLine) || E->IsPointSel())) E=G->GetNextSel();
      if(E){
//        unsigned long l;
	QRect r;
	G->DeSelect();
	G->Select(E);
	E->SelThis(1,1);
	Wid=E->GetWidth();
//	l=E->GetLayer();
	l2=G->GetSelPoint();
	G->MovePointTo(l1);
	G->DeSelect();
	if(G->GetIden()==kDbPcb){
	 if(((DbPcb*)G)->IsConnect(l2,2)) ((DbPcb*)G)->AddWire(l1,l2,Wid,r,false);
	 else G->AddLine(l1,l2,Wid,r,false);
	}
	else{
	 G->AddLine(l1,l2,Wid,r,false);
	}
	//E=G->GetSel();
	//if(E) E->SetLayer(l);
	G->DeSelect();
	G->SelPoint(p,10,SelM);
	r.translate(-5,-5);
	r.setWidth(r.width()+10);
	r.setHeight(r.height()+10);
	repaint(r);
      }
      else{
	G->DeSelect();
      }
    }
    if((E==NULL) && G->SelPoint(p,10,SelM)>=0){
      printf("AddP Sel Point\n");
      G->SelInfo();
      E=G->GetSel();
      while(E && (E->GetIden()!=kPicPoly)) E=G->GetNextSel();
      if(E){
        printf("AddP Sel Poly\n");
        ((PicPoly *)E)->AddSelPoint(true);
	G->MovePointTo(l1);
      }
      else{
	G->DeSelect();
	button=Qt::NoButton;
      }
    }
    if(E==NULL) button=Qt::NoButton;
  }
  else if(Act==kABCopy){
    if (G->Select(p,SelM)){
      l1=p;
      CopySel();
      ReadCopy();
      G->UpdORect();
      UpdatePM();
      repaint();
      G->SelInfo();
    } else button=Qt::NoButton;
  }
  else if(Act==kABEdit){
   if (G->Select(p,SelM+0x10000*kPicSComp)){
    PicEl * E=G->GetSel();
    if(E->GetIden()==kSComp){
     SCompDlg *D=new SCompDlg((SComp *)E,NULL);
     connect( D, SIGNAL(Change()), SLOT(UpdatePM()) );
     D->show();
    }
   }
   else if (G->Select(p,SelM+0x10000*kPicPComp)){
    PicEl * E=G->GetSel();
    if(E->GetIden()==kPComp){
     PCompDlg *D=new PCompDlg((PComp *)E,NULL);
     connect( D, SIGNAL(Change()), SLOT(UpdatePM()) );
     D->show();
    }
   }
   else if (G->Select(p,SelM)){
    PicEl * E=G->GetSel();
    if(E->GetIden()==kPicPin){
     PinDlg *D=new PinDlg((PicPin *)E,this);
     connect( D, SIGNAL(Change()), SLOT(UpdatePM()) );
     D->show();
    }
    else if(E->GetIden()==kPicPadS){
     PadSDlg *D=new PadSDlg((PicPadS *)E,this);
     connect( D, SIGNAL(Change()), SLOT(UpdatePM()) );
     D->show();
    }
    else{
     EditDlg *D=new EditDlg(E,NULL);
     connect( D, SIGNAL(Change()), SLOT(UpdateAll()) );
     D->show();
    }
   }
   else {
    if (G->GetIden()==kPicSComp){
     PSCompDlg *D=new PSCompDlg((PicSComp *)G,NULL);
//     connect( D, SIGNAL(Change()), SLOT(UpdatePM()) );
     D->show();
     UpdatePM();
    }
    else if (G->GetIden()==kDbSch){
     SchDlg *D=new SchDlg((DbSch *)G,NULL);
//     connect( D, SIGNAL(Change()), SLOT(UpdatePM()) );
     D->show();
     UpdatePM();
    }
   }
   G->DeSelect();
   Update();
   button=Qt::NoButton;
  }
  else if(Act==kABEnter){
    Dif.setX(0);
    Dif.setY(0);
   l1=p;
//   PicEl * E=NULL;
   if(G->GetIden()==kDbSch && Info){
    SComp * SC=new SComp(G->GetLayers());
    if (SC->LibPart(Info->GetCNam(button))){
     SC->RotateTo(Ori);
     G->AddItem(SC);
     G->UpdORect();
     if (!G->Select(SC)) printf("Spatny Select\n");
     SC->SetLock(2);
     G->MoveSelTo(p-Dif);
     QRect r;
     G->GetSelORect(&r);
     DbToScr(&r);
     r.translate(-2,-2);
     r.setWidth(r.width()+4);
     r.setHeight(r.height()+4);
     repaint(r);
    }
    else{
     delete SC;
     button=Qt::NoButton;
     QString s;
/*     s="Component ";
     s+=Info->GetCNam(button);
     s+=" not found ";
     gErr.Err(s);*/
     button=Qt::NoButton;
    }
   }
   else if(G->GetIden()==kDbPcb && Info){
    PComp * PC=new PComp(G->GetLayers());
    PicPadS * PP=new PicPadS(G->GetLayers());
    DbPcb * DP=new DbPcb(G->GetLayers());
    if (PP->LibPart(Info->GetCNam(button))){
     delete PC;
     delete DP;
     PP->RotateTo(Ori);
     G->AddItem(PP);
     G->UpdORect();
     if (!G->Select(PP)) printf("Spatny Select\n");
     G->MoveSelTo(p-Dif);
     QRect r;
     G->GetSelORect(&r);
     DbToScr(&r);
     r.translate(-2,-2);
     r.setWidth(r.width()+4);
     r.setHeight(r.height()+4);
     repaint(r);
    }
    else if (PC->LibPart(Info->GetCNam(button))){
     delete PP;
     delete DP;
     PC->UpdateAtr();
     PC->RotateTo(Ori);
     G->AddItem(PC);
     G->UpdORect();
     if (!G->Select(PC)) printf("Spatny Select\n");
     PC->SetLock(2);
     G->MoveSelTo(p-Dif);
     QRect r;
     G->GetSelORect(&r);
     DbToScr(&r);
     r.translate(-2,-2);
     r.setWidth(r.width()+4);
     r.setHeight(r.height()+4);
     repaint(r);
    }
    else if (DP->LibPart(Info->GetCNam(button))){
     delete PC;
     delete PP;
     DP->RotateTo(Ori);
     G->AddItem(DP);
     G->UpdORect();
     if (!G->Select(DP)) printf("Spatny Select\n");
     G->MoveSelTo(p-Dif);
     QRect r;
     G->GetSelORect(&r);
     DbToScr(&r);
     r.translate(-2,-2);
     r.setWidth(r.width()+4);
     r.setHeight(r.height()+4);
     repaint(r);
    }
    else{
     delete PC;
     delete PP;
     delete DP;
     QString s;
/*     s="Component ";
     s+=Info->GetCNam(button);
     s+=" not found ";
     gErr.Err(s);*/
     button=Qt::NoButton;
    }
   }
   else if(G->GetIden()==kPicSComp && Info){
    PicPin * PP=new PicPin(G->GetLayers());
    if (PP->LibPart(Info->GetCNam(button))){
     PP->RotateTo(Ori);
     G->AddItem(PP);
     G->UpdORect();
     if (!G->Select(PP)) printf("Spatny Select\n");
     G->MoveSelTo(p-Dif);
     QRect r;
     G->GetSelORect(&r);
     DbToScr(&r);
     r.translate(-2,-2);
     r.setWidth(r.width()+4);
     r.setHeight(r.height()+4);
     repaint(r);
    }
    else{
     delete PP;
     QString s;
/*     s="Pin ";
     s+=Info->GetCNam(button);
     s+=" not found ";
     gErr.Err(s);*/
     button=Qt::NoButton;
    }
   }
   else if(G->GetIden()==kPicPComp && Info){
    PicPadS * PP=new PicPadS(G->GetLayers());
    if (PP->LibPart(Info->GetCNam(button))){
     PP->RotateTo(Ori);
     G->AddItem(PP);
     G->UpdORect();
     if (!G->Select(PP)) printf("Spatny Select\n");
     G->MoveSelTo(p-Dif);
     QRect r;
     G->GetSelORect(&r);
     DbToScr(&r);
     r.translate(-2,-2);
     r.setWidth(r.width()+4);
     r.setHeight(r.height()+4);
     repaint(r);
    }
    else{
     delete PP;
     QString s;
/*     s="Pad ";
     s+=Info->GetCNam(button);
     s+=" not found ";
     gErr.Err(s);*/
     button=Qt::NoButton;
    }
   }
   else button=Qt::NoButton;
  }
  else if(Act==kABAtr){
   QRect r;
   if (G->Select(p,SelM+0x10000*kPicSComp)){
     Dif.setX(0);
     Dif.setY(0);
    l1=p;
    SComp * E=(SComp *)G->GetSel();
    Atr=G->GetLayers()->GetActType()-3;
    if(Atr<0) Atr=0;
    PicText * T=E->AddAtr(Atr);
    G->DeSelect();
    G->Select(T);
    G->GetSelORect(&r);
    if (Info){
     if (button==Qt::LeftButton) {
      T->SetFont(Info->GetFonL());
      T->SetAlig(Info->GetHAlL(),Info->GetVAlL());
     }
     else {
      T->SetFont(Info->GetFonM());
      T->SetAlig(Info->GetHAlM(),Info->GetVAlM());
     }
    }
    T->RotateTo(0);
    T->SetLayer(G->GetLayers()->GetAct());
    T->RotateTo((Ori-G->SelRot())& 3);
   }
   else if (G->Select(p,SelM+0x10000*kPicPComp)){
     Dif.setX(0);
     Dif.setY(0);
    l1=p;
    PComp * E=(PComp *)G->GetSel();
    Atr=G->GetLayers()->GetActType()-3;
    if(Atr<0) Atr=0;
    PicText * T=E->AddAtr(Atr);
    G->DeSelect();
    G->Select(T);
    G->GetSelORect(&r);
    if (Info){
     if (button==Qt::LeftButton) {
      T->SetFont(Info->GetFonL());
      T->SetAlig(Info->GetHAlL(),Info->GetVAlL());
     }
     else {
      T->SetFont(Info->GetFonM());
      T->SetAlig(Info->GetHAlM(),Info->GetVAlM());
     }
    }
    T->RotateTo(0);
    if((G->GetMirror()+E->GetMirror())&1)
       T->SetLayer(G->GetLayers()->MirLy(G->GetLayers()->GetAct()));
    else T->SetLayer(G->GetLayers()->GetAct());
    T->RotateTo((Ori-G->SelRot())& 3);
   } else button=Qt::NoButton;

   G->MoveSelTo(p-Dif);
   DbToScr(&r);
   r.translate(-2,-2);
   r.setWidth(r.width()+4);
   r.setHeight(r.height()+4);
   repaint(r);
  }
  else if(Act==kABRot){
   if (G->Select(p,SelM)){
    QRect r;
    QRect r1;
    G->GetSelORect(&r);
    G->RotateSel(1,p.x(),p.y());
    G->UpdORect();
    G->GetSelORect(&r1);
    G->DeSelect();

    r=r.unite(r1);
    DbToScr(&r);
    r.translate(-2,-2);
    r.setWidth(r.width()+4);
    r.setHeight(r.height()+4);
    UpdatePM();
    repaint(r);
   }
   G->DeSelect();
   button=Qt::NoButton;
  }
  else if(Act==kABMir){
   if (G->Select(p,SelM)){
    QRect r;
    QRect r1;
    G->GetSelORect(&r);
    G->MirrorSel(p.x(),p.y());
    G->GetSelORect(&r1);
    G->DeSelect();

    r=r.unite(r1);
    DbToScr(&r);
    r.translate(-2,-2);
    r.setWidth(r.width()+4);
    r.setHeight(r.height()+4);
    UpdatePM();
    repaint(r);
   }
   G->DeSelect();
   button=Qt::NoButton;
  }
  else if(Act==kABDel){
   if (G->Select(p,SelM)){
    QRect r;
    G->GetSelORect(&r);
    G->HLSel();
//    G->DeleteSel();

    DbToScr(&r);
    r.translate(-2,-2);
    r.setWidth(r.width()+4);
    r.setHeight(r.height()+4);
    repaint(r);
   }
   else{
    G->DeSelect();
    button=Qt::NoButton;
   }
  }
  else if(Act==kABMoveP){
   if (G->SelPoint(p,30*30,SelM)<0) button=Qt::NoButton;
  }
  else if (BlSel){
   if(Act==kABCopyBl || Act==kABMoveBl){
//    if (G->Select(Bl,SelM+256*SelBM)){
     l1=p;
/*    }
    else {
     QRect r=Bl;
     DbToScr(&r);

     button=Qt::NoButton;
     BlSel=false;
      Bl.setRect(0,0,0,0);

     r.translate(-1,-1);
     r.setWidth(r.width()+2);
     r.setHeight(r.height()+2);
     repaint(r);
    } */
   }
   else if(Act==kABRotBl){
    QRect r;
//    if (G->Select(Bl,SelM+256*SelBM)){
     QRect r1;
     G->GetSelORect(&r);
     G->RotateSel(1,p.x(),p.y());
     G->GetSelORect(&r1);
//     G->DeSelect();
//     G->HLOff();

     r=r.unite(r1);
//    }
    button=Qt::NoButton;
//    BlSel=false;
    r=r.unite(Bl);
//     Bl.setRect(0,0,0,0);
    DbToScr(&r);
    r.translate(-2,-2);
    r.setWidth(r.width()+4);
    r.setHeight(r.height()+4);
    repaint(r);
   }
   else if(Act==kABMirBl){
    QRect r;
//    if (G->Select(Bl,SelM+256*SelBM)){
     QRect r1;
     G->GetSelORect(&r);
     G->MirrorSel(p.x(),p.y());
     G->GetSelORect(&r1);
//     G->DeSelect();
//     G->HLOff();

     r=r.unite(r1);
//    }
    button=Qt::NoButton;
//    BlSel=false;
    r=r.unite(Bl);
//     Bl.setRect(0,0,0,0);
    DbToScr(&r);
    r.translate(-2,-2);
    r.setWidth(r.width()+4);
    r.setHeight(r.height()+4);
    repaint(r);
   }
   else if(Act==kABDelBl){
    QRect r;
//    if (G->Select(Bl,SelM+256*SelBM)){
     G->GetSelORect(&r);
     G->DeleteSel();
     G->HLOff();
//    }
    button=Qt::NoButton;
    BlSel=false;
    r=r.unite(Bl);
     Bl.setRect(0,0,0,0);
    DbToScr(&r);
    r.translate(-2,-2);
    r.setWidth(r.width()+4);
    r.setHeight(r.height()+4);
    G->DeSelect();
    repaint(r);
   }
  }
  else{
   if(Act==kABCopyBl || Act==kABMoveBl || Act==kABRotBl || Act==kABMirBl || Act==kABDelBl){
    l1=p;
    if((Act==kABCopyBl) && (CopyM==2)){
      CopyStr=QApplication::clipboard()->text();
      ReadCopy();
      G->UpdSelORect();
      G->GetSelORect(&Bl);
      G->MoveSelBy((p-Bl.center()).x(),(p-Bl.center()).y());
      G->UpdORect();
      UpdatePM();
      G->GetSelORect(&Bl);
      BlSel=true;
      repaint();
    }
   }
  }
 }
}

void Edit::mouseReleaseEvent ( QMouseEvent *e )
{
 if (!G)return;
 if(e->pos()!=OldP && button!=Qt::NoButton){
  Release();
  G->UpdORect();
 }
}


void Edit::Release ()
{
 int butt=Qt::NoButton;
 int VWinT=0;
 int Wid=0;
 int CirM=1;
 int LineM=0;
 int SelM=0;
 int SelBM=0;
 int CopyM=0;

 printf("Edit::Release act=%d\n",Act);

 if (Info){
  if (button==Qt::MidButton){
   SelM=Info->GetSelMM();
   SelBM=Info->GetSelBMM();
   VWinT=Info->GetVWinTM();
   Wid=Info->GetWidM();
   LineM=Info->GetLineMM();
   CirM=Info->GetCirMM();
   CopyM=Info->GetCopyMM();
  }
  else if (button==Qt::LeftButton){
   SelM=Info->GetSelML();
   SelBM=Info->GetSelBML();
   VWinT=Info->GetVWinTL();
   Wid=Info->GetWidL();
   LineM=Info->GetLineML();
   CirM=Info->GetCirML();
   CopyM=Info->GetCopyML();
  }
 }
 if((Act==kABHiL) || (Act==kABXMove)){
  if(G->GetIden()==kDbPcb){
   QRect r;
   ((DbPcb *)G)->ANetORect(r);
   DbToScr(&r);

   G->HLOff();
   NetHL("");
   G->DeSelect();

   r.translate(-2,-2);
   r.setWidth(r.width()+4);
   r.setHeight(r.height()+4);
   repaint(r);
  }
  else {
   QRect r;
   G->GetSelORect(&r);
   DbToScr(&r);
   r.translate(-2,-2);
   r.setWidth(r.width()+4);
   r.setHeight(r.height()+4);

   G->HLOff();
   NetHL("");
   G->DeSelect();

   repaint(r);
  }
 }
 if(Act==kABLine){
  QRect r;
  if (l1!=l2){
   if(G->GetIden()==kDbPcb && EWire){
    ((DbPcb*)G)->AddWire(l1,PLineT(l1,l2),Wid,r);
   }
   else{
    G->AddLine(l1,PLineT(l1,l2),Wid,r);
   }
  }

  if (LineM){
   l1=PLineT(l1,l2);
   LineD=0;
   butt=button;
  }
  else{
   EWire=false;
   Line=false;
   G->HLOff();
   G->DeSelect();
  }

  if(LineT && !LineM){
   QRect r1;
   r1.setCoords(l1.x(),l1.y(),l2.x(),l2.y());
   r1=r1.normalized();
   r=r.unite(r1);
  }

  G->UpdORect();

  DbToScr(&r);
  r.translate(-2,-2);
  r.setWidth(r.width()+4);
  r.setHeight(r.height()+4);
  if(!LineM || (G->GetIden()!=kDbPcb) || !EWire) UpdatePM();
  repaint();



/*  QRect r;
  if (LineM){
   if (G->Select(PLineT(l1,l2),kSelActOnly+0x10000*kPicLine)){
//    printf("Sel\n");
    PicEl * LL=G->GetSel();
    G->DeSelect();
    if(G->SelPoint(l1,4,kSelActOnly)>=0){
//     printf("SelPoint\n");
     if(LL==G->GetSel()){
//      printf("SelPoint=Sel\n");
      G->GetSelORect(&r);
      G->MovePointTo(PLineT(l1,l2));
      if(((PicLine *)LL)->GetBegin()==((PicLine *)LL)->GetEnd()){
//       printf("Delete\n");
       G->DeleteSel();
      }
      l1=PLineT(l1,l2);

      DbToScr(&r);
      r.translate(-1,-1);
      r.setWidth(r.width()+2);
      r.setHeight(r.height()+2);
      repaint(r);
      return;
     }
    }
   }
  }
  PicLine * L=NULL;
  if (l1!=l2){
   L=new PicLine(G->GetLayers());
   L->Begin(l1-G->Pos());
   L->End(PLineT(l1,l2)-G->Pos());
   L->SetWidth(Wid);
   G->AddItem(L);
  }
  if (LineM){
   l1=PLineT(l1,l2);
   LineD=0;
   butt=button;
  }
  else Line=false;

  G->Select(L);
  G->GetSelORect(&r);
  G->DeSelect();
  if(LineT && !LineM){
   QRect r1;
   r1.setCoords(l1.x(),l1.y(),l2.x(),l2.y());
   r1=r1.normalized();
   r=r.unite(r1);
  }
  DbToScr(&r);
  r.translate(-1,-1);
  r.setWidth(r.width()+2);
  r.setHeight(r.height()+2);
  repaint(r);*/
 }
 else if(Act==kABPoly){
   QRect r;
   Poly->AddSelPoint();
   l1=PLineT(l1,l2);
   G->MovePointTo(l1);
   G->UpdORect();
   G->GetSelORect(&r);
   LineD=0;
   butt=button;
   DbToScr(&r);
   r.translate(-2,-2);
   r.setWidth(r.width()+4);
   r.setHeight(r.height()+4);
   repaint();
 }
 else if((Act==kABText) || (Act==kABPower)){
   butt=button;
 }
 else if(Act==kABCir){
  QRect r;
  PicCir * C=NULL;
  if (l1!=l2){
   QPoint p1;
   p1=l1-l2;
   int rr=(int)sqrt((double)p1.x()*p1.x()+(double)p1.y()*p1.y());
   C=new PicCir(G->GetLayers());
   C->Circle(0,0,rr);
   C->SetWidth(Wid);
   G->AddItem(C);
   G->Select(C);
   G->MoveSelTo(l1);
   G->UpdORect();
   if(CirM){
    C->SelPBeg();
    G->MovePointTo(l2);
    C->SelPEnd();
    Act=kABMoveP;
    G->GetSelORect(&r);
    butt=button;
   }
   else{
    G->GetSelORect(&r);
    G->DeSelect();
   }
  }
  Circ=false;
  DbToScr(&r);
  r.translate(-2,-2);
  r.setWidth(r.width()+4);
  r.setHeight(r.height()+4);
  UpdatePM();
  repaint(r);
 }
 else if(Act==kABRect){
  QRect r;
  PicRect * R=NULL;
  if (Bl.isValid()){
   R=new PicRect(G->GetLayers());
   Bl.translate(-G->Pos().x(),-G->Pos().y());
   R->Rect(Bl);
   R->SetWidth(Wid);
   G->AddItem(R);
   G->UpdORect();
   R->GetORect(&r);
  }
  Bl.setRect(0,0,0,0);
  r.translate(G->Pos().x(),G->Pos().y());
  DbToScr(&r);
  r.translate(-2,-2);
  r.setWidth(r.width()+4);
  r.setHeight(r.height()+4);
  UpdatePM();
  repaint(r);
 }
 else if(Act==kABMove || Act==kABMoveX || Act==kABCopy || Act==kABMoveP || 
         Act==kABAddP || Act==kABAtr || Act==kABEnter){
  QRect r;
  G->GetSelORect(&r);
  DbToScr(&r);
  r.translate(-2,-2);
  r.setWidth(r.width()+4);
  r.setHeight(r.height()+4);

  if(Act==kABMoveX) CompHL("");
  G->DeSelect();
  G->HLOff();

  repaint(r);
 }
 else if(Act==kABDel){
  printf("Release Delete\n");
  QRect r;
  G->GetSelORect(&r);
  DbToScr(&r);
  r.translate(-2,-2);
  r.setWidth(r.width()+4);
  r.setHeight(r.height()+4);

  G->DeleteSel();
  G->DeSelect();
  G->HLOff();

  repaint(r);
 }
 else if(Act==kABVWin){
  if(Bl.isValid()){
   if ((float)width()/Bl.width()<(float)height()/Bl.height()){
    scale=(float)width()/Bl.width();
   } else {
    scale=(float)height()/Bl.height();
   }
   if(VWinT==1) scale=scale/2;
   if(scale<0.03) scale=0.03;
   if(scale>32) scale=32;
   QPoint p=Bl.center();
   XPos=-p.x()+(int)((width()/2)/scale);
   YPos=-p.y()+(int)((height()/2)/scale);
   Bl.setRect(0,0,0,0);
  }
  Update();
  SaveZH();
  RestoreSt();
  return;
 }
 else if(Act==kABCopyBl || Act==kABMoveBl || Act==kABRotBl || Act==kABMirBl || Act==kABDelBl){
  if(BlSel){
   QRect r=Bl;
   DbToScr(&r);

   BlSel=false;
   Bl.setRect(0,0,0,0);
   G->DeSelect();
   G->HLOff();

   r.translate(-3,-3);
   r.setWidth(r.width()+6);
   r.setHeight(r.height()+6);
   repaint(r);
  }
  else{
   if(Bl.isValid()){
    if (G->Select(Bl,SelM+256*SelBM)){
     if(Act==kABCopyBl){
      if(CopyM==0){
       CopySel();
       ReadCopy();
       G->UpdORect();
       UpdatePM();
       G->HLSel();
       BlSel=true;
      }	
      else if(CopyM==1){
       CopySel();
       QApplication::clipboard()->setText(CopyStr);
       QRect r=Bl;
       DbToScr(&r);

       BlSel=false;
       Bl.setRect(0,0,0,0);
       G->DeSelect();

       r.translate(-3,-3);
       r.setWidth(r.width()+6);
       r.setHeight(r.height()+6);
       repaint(r);
      }
     }
     else{
      G->HLSel();
      BlSel=true;
     }
    }
    else{
     QRect r=Bl;
     DbToScr(&r);

     BlSel=false;
     Bl.setRect(0,0,0,0);
     G->DeSelect();

     r.translate(-3,-3);
     r.setWidth(r.width()+6);
     r.setHeight(r.height()+6);
     repaint(r);
    }
   }
   Update();
  }
 }
 else if(Act==kABMView){
   RestoreSt();
   return;
 }
 else if(Act==kABZoomOut || Act==kABZoomIn){
   return;
 }
 button=butt;
}


void Edit::mouseMoveEvent( QMouseEvent *e )
{
 QPoint p;
 p=e->pos();
 ScrToDb(&p);

 if (p!=Old){

  Old=p;

  if(!LEShow) setFocus();

  if(Info){
   Info->SetXY(p.x(),p.y());
  }

  if (!G)return;

  if((button==Qt::NoButton) && Info){
   QRect r;
   QRect r1;
   r.setRect(xP-11-4*IStr.length(),yP-21,22+8*IStr.length(),32);
   if(Info->IsOnInfo() && G->GetInfo(IStr,p)){
//     printf("Info : %s\n",IStr.toLatin1().data());
     
     DbToScr(&p);
     xP=p.x();
     yP=p.y();
     r1.setRect(xP-10-4*IStr.length(),yP-21,20+8*IStr.length(),32);
   }
   else{
     IStr="";
     DbToScr(&p);
     xP=p.x();
     yP=p.y();
     r1.setRect(xP-11,yP-11,22,22);
   }
   r|=r1;
   repaint(r);
  }

  if(button==Qt::LeftButton || button==Qt::MidButton){
   if(Act==kABMView){
    QPoint p2=m1-p;
    XPos-=p2.x();
    YPos-=p2.y();
    Update();
   }
   else if((Act==kABLine) || (Act==kABPoly)){
    QRect r(l1,l2);
    r=r.normalized();
    DbToScr(&r);
    r.translate(-2,-2);
    r.setWidth(r.width()+4);
    r.setHeight(r.height()+4);
    l2=p;
    if (l1.x()==l2.x() || l1.y()==l2.y()) LineD=0;
    QRect r1(p.x(),p.y(),1,1);
    r|=r1;
    repaint(r);
   }
   else if(Act==kABCir){
    QPoint p1;
    p1=l1-l2;
    int rr=2+(int)sqrt((double)p1.x()*p1.x()+(double)p1.y()*p1.y());
    QRect r(l1.x()-rr,l1.y()-rr,2*rr,2*rr);
    r=r.normalized();

    p1=l1-p;
    rr=2+(int)sqrt((double)p1.x()*p1.x()+(double)p1.y()*p1.y());
    QRect r1(l1.x()-rr,l1.y()-rr,2*rr,2*rr);
    r1=r1.normalized();

    r|=r1;

    r.translate(-2,-2);
    r.setWidth(r.width()+4);
    r.setHeight(r.height()+4);
    DbToScr(&r);

    l2=p;

    repaint(r);
   }
   else if(Act==kABAddP || Act==kABMove || Act==kABMoveX || Act==kABAtr  || Act==kABEnter){
    int XOri=Ori;
    if (Info){
     if(button==Qt::LeftButton){
      XOri=Info->GetOriL();
     }
     else{
      XOri=Info->GetOriM();
     }
    }
    QRect r;
    QRect r1;
    G->GetSelORect(&r);
    G->MoveSelBy(p.x()-l1.x(),p.y()-l1.y());
    G->UpdORect();
    l1=p;
//    G->MoveSelTo(p-Dif);
    if(XOri!=Ori){
     G->RotateSel((XOri-Ori) & 3,p.x(),p.y());
     Ori=XOri;
    }
    G->GetSelORect(&r1);
    r=r.unite(r1);

    DbToScr(&r);
    r.translate(-2,-2);
    r.setWidth(r.width()+4);
    r.setHeight(r.height()+4);
    repaint(r);
   }
   else if(Act==kABCopy){
    QRect r;
    QRect r1;
    G->GetSelORect(&r);
    G->MoveSelBy(p.x()-l1.x(),p.y()-l1.y());
    G->UpdORect();
    l1=p;
//    G->MoveSelTo(p-Dif);
    G->GetSelORect(&r1);
    r=r.unite(r1);

    DbToScr(&r);
    r.translate(-2,-2);
    r.setWidth(r.width()+4);
    r.setHeight(r.height()+4);
    repaint(r);
   }
   else if(Act==kABMoveP){
    QRect r;
    G->GetSelORect(&r);
    G->MovePointTo(p);
    G->UpdORect();

    DbToScr(&r);
    r.translate(-2,-2);
    r.setWidth(r.width()+4);
    r.setHeight(r.height()+4);
    repaint(r);
   }
   else if(Act==kABVWin || Act==kABRect || 
          ((Act==kABCopyBl || Act==kABMoveBl || Act==kABRotBl || Act==kABMirBl || Act==kABDelBl) && !BlSel)){
    QRect r=Bl;
    DbToScr(&r);
    int h,w;
    w=l1.x()-p.x();
    h=l1.y()-p.y();
    if(w>0) {
     Bl.setLeft(p.x());
     Bl.setWidth(w);
    }
    else {
     Bl.setLeft(l1.x());
     Bl.setWidth(-w);
    }
    if(h>0) {
     Bl.setTop(p.y());
     Bl.setHeight(h);
    }
    else {
     Bl.setTop(l1.y());
     Bl.setHeight(-h);
    }
    QRect r1=Bl;
    DbToScr(&r1);
    r|=r1;

    r.translate(-3,-3);
    r.setWidth(r.width()+6);
    r.setHeight(r.height()+6);
    repaint(r);
   }
   else if((Act==kABMoveBl || Act==kABCopyBl) && BlSel){
    QRect r;
    G->GetSelORect(&r);
    r=r.unite(Bl);

    G->MoveSelBy(p.x()-l1.x(),p.y()-l1.y());
    G->UpdORect();
    Bl.translate(p.x()-l1.x(),p.y()-l1.y());
    l1=p;

    QRect r1;
    G->GetSelORect(&r1);
    r1|=Bl;
    r|=r1;

    DbToScr(&r);
    r.translate(-3,-3);
    r.setWidth(r.width()+6);
    r.setHeight(r.height()+6);
    repaint(r);
   }
  }
 }
}


void Edit::RestoreSt()
{
 button=OB;
 Act=OA;
 Ori=OO;
 l1=Ol1;
 l2=Ol2;
 Bl=OBl;
// printf("Restore  B:%d A:%d\n",button,Act);
}

void Edit::SaveSt()
{
// printf("Save  B:%d A:%d\n",button,Act);
 OB=button;
 OA=Act;
 OO=Ori;
 Ol1=l1;
 Ol2=l2;
 OBl=Bl;
}


void Edit::resizeEvent ( QResizeEvent * /*e*/)
{
// PM.resize(width(),height());
// PM=PM.copy(0, 0, width(),height());
 PM=QPixmap(width(),height());
 OXP=XPos-1;
//    Update();
}


void Edit::ScrToDb(QPoint * p,bool g)
{
  QPoint p1;
  p->setX((p->x()/scale)-XPos);
  p->setY((p->y()/scale)-YPos);
  if (Info){
    float x=Info->GetGX();
    float y=Info->GetGY();
    if(G && Info->IsOnSnaP()){
      if(G->GetNearestPin(*p,p1,(x+y)*(x+y))){
	*p=p1;
	return;
      }
    }
    if (g && Info->IsOnGr()){
      if (x>0 && y>0){
/*	if (p->x()>0) p->setX(((p->x()+x/2)/x)*x);
	else p->setX(((p->x()-x/2)/x)*x);
	if (p->y()>0) p->setY(((p->y()+y/2)/y)*y);
	else p->setY(((p->y()-y/2)/y)*y); */
	p->setX(roundf(p->x()/x)*x);
	p->setY(roundf(p->y()/y)*y);
      }	
    }
  }
}

void Edit::DbToScr(QPoint * p)
{
// QPainter paint;
// paint.begin(this);
// paint.scale(scale,scale);
 p->setX((p->x()+XPos)*scale);
 p->setY((p->y()+YPos)*scale);
// *p=paint.xForm(*p);
// paint.end();
}

void Edit::DbToScr(QRect * r)
{
// QPainter paint;
// paint.begin(this);
// paint.scale(scale,scale);
 r->translate(XPos,YPos);
 r->setRect(r->x()*scale,r->y()*scale,r->width()*scale,r->height()*scale);
// *r=paint.xForm(*r);
// paint.end();
}

QPoint Edit::PLineT(QPoint p1,QPoint p2)
{
 QPoint p=p2;
 if (Info){
  if (button==Qt::MidButton){
    LineT=Info->GetLineTM();
  }
  else if (button==Qt::LeftButton){
    LineT=Info->GetLineTL();
  }
 }

 if(LineT==1){
  if(!LineD){
   if (abs(p1.x()-p2.x())<abs(p1.y()-p2.y())) LineD=1;
   else LineD=2;
  }
  if (LineD==1){
   p.setX(p1.x());
  }
  else{
   p.setY(p1.y());
  }
 }
 else if(LineT==2){
  if(abs(p1.x()-p2.x())!=0 && abs(p1.y()-p2.y())!=0){
   if(abs(p1.x()-p2.x())<abs(p1.y()-p2.y())){
    p.setX(p2.x());
    if (p1.y()<p2.y()) p.setY(p1.y()+abs(p1.x()-p2.x()));
    else p.setY(p1.y()-abs(p1.x()-p2.x()));
   }
   else{
    p.setY(p2.y());
    if (p1.x()<p2.x()) p.setX(p1.x()+abs(p1.y()-p2.y()));
    else p.setX(p1.x()-abs(p1.y()-p2.y()));
   }
  }
 }
 else if(LineT==3){
  if(abs(p1.x()-p2.x())!=abs(p1.y()-p2.y())){
   if(abs(p1.x()-p2.x())<abs(p1.y()-p2.y())){
    p.setX(p1.x());
    if (p1.y()<p2.y()) p.setY(p2.y()-abs(p1.x()-p2.x()));
    else p.setY(p2.y()+abs(p1.x()-p2.x()));
   }
   else{
    p.setY(p1.y());
    if (p1.x()<p2.x()) p.setX(p2.x()-abs(p1.y()-p2.y()));
    else p.setX(p2.x()+abs(p1.y()-p2.y()));
   }
  }
 }
 else if(LineT==4){
  if(2*abs(p1.x()-p2.x())<abs(p1.y()-p2.y())){
   p.setX(p1.x());
   if (p1.y()<p2.y()) p.setY(p2.y()-abs(p1.x()-p2.x()));
   else p.setY(p2.y()+abs(p1.x()-p2.x()));
  }
  else if(abs(p1.x()-p2.x())>2*abs(p1.y()-p2.y())){
   p.setY(p1.y());
   if (p1.x()<p2.x()) p.setX(p2.x()-abs(p1.y()-p2.y()));
   else p.setX(p2.x()+abs(p1.y()-p2.y()));
  }
  else if(abs(p1.x()-p2.x())<abs(p1.y()-p2.y())){
   p.setX(p2.x());
   if (p1.y()<p2.y()) p.setY(p1.y()+abs(p1.x()-p2.x()));
   else p.setY(p1.y()-abs(p1.x()-p2.x()));
  }
  else{
   p.setY(p2.y());
   if (p1.x()<p2.x()) p.setX(p1.x()+abs(p1.y()-p2.y()));
   else p.setX(p1.x()-abs(p1.y()-p2.y()));
  }
 }
 return p;
}

extern const char *sPic[];


void Edit::CopySel()
{
  QTextStream S(&CopyStr,QIODevice::WriteOnly);

  S<<"{"<< sPic[G->GetIden()] <<"\n";
  G->TextSave(&S,true);
  G->DeSelect();

  printf("CopySel::\n%s\n",CopyStr.toAscii().data());
}


void Edit::ReadCopy()
{
  QString s;
  
  QTextStream S(&CopyStr,QIODevice::ReadOnly);

  S >> s;
  if (s.contains(sPic[G->GetIden()])){
    G->TextLoad(&S);
    if(G->GetIden()==kDbSch){
      ((DbSch *)G)->UpdateAtr();
      ((DbSch *)G)->ResetSelRef();
    }
    if(G->GetIden()==kDbPcb){
      ((DbPcb *)G)->UpdateAtr();
    }
  }
  
  printf("ReadCopy::\n%s\n",CopyStr.toAscii().data());
  CopyStr.clear();
}

void Edit::keyPressEvent ( QKeyEvent * e )
{
  printf("Edit key %d\n",e->key());
  KeyPress(e->key());
}
