/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "Error.h"

#include <QFile>
//#include <qiodev.h>
#include <QTextStream>
#include <QMessageBox>
 
Errors::Errors()
{
 F.setFileName("Err.log");
 F.open(QIODevice::WriteOnly);
 S.setDevice(&F);
 log=true;
}

Errors::~Errors()
{
 F.close();
}

void Errors::Err(QString msg)
{
 if(log) S << "Error  : " << msg << "\n";
 QMessageBox M;
 M.critical(NULL,"Error",msg);
}

void Errors::Warn(QString msg)
{
 if(log) S << "Warning: " << msg << "\n";
 QMessageBox M;
 M.warning(NULL,"Warning",msg);

}

void Errors::Msg(QString msg)
{
 if(log) S << "Message: " << msg << "\n";
 QMessageBox M;
 M.information(NULL,"Message",msg);
}

bool Errors::YesNo(QString msg)
{
 if(log) S << "Message: " << msg << "\n";
 QMessageBox M;
 return !(M.critical(NULL,"Message",msg,"Yes","No"));
}

bool Errors::YesNoErr(QString msg)
{
 if(log) S << "Error  : " << msg << "\n";
 QMessageBox M;
 return !(M.critical(NULL,"Error",msg,"Yes","No"));

}

bool Errors::YesNoWarn(QString msg)
{
 if(log) S << "Warning : " << msg << "\n";
 QMessageBox M;
 return !(M.critical(NULL,"Warning",msg,"Yes","No"));
}

void Errors::OpenLst()
{
 Lst="";
}

void Errors::ToLst(QString msg)
{
 Lst+=msg;
 Lst+="\n";
}

void Errors::ShowLst()
{
 if(Lst.isEmpty()) return;
 if(log) S << Lst;
 QMessageBox M;
 M.critical(NULL,"Message",Lst);
}
