/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "ImpPComp.h"

#include "PicObj.h"
#include "PicPadS.h"

#include <QFont>
#include <QFile>
#include <QTextStream>

#include <math.h>

#define PINTOP "PINTOP"
#define PINBOT "PINBOT"
#define PININT "PININT"
#define SLKTOP "SLKTOP"
#define MSKTOP "MSKTOP"
#define MSKBOT "MSKBOT"
#define DRILL  "DRILL"
#define BARALL "BARALL"
#define PSTTOP "PSTTOP"

#define MUL 10


extern const char *sPic[];


ImpPComp::ImpPComp()
{
}

ImpPComp::~ImpPComp()
{
}

void ImpPComp::SetDirName(QString n)
{
  DirName=n;
  printf("ImpPComp::SetDirName %s\n",n.toAscii().data());
}

QString ImpPComp::GetParam(QString & p,char sep)
{
  QString s;
  int i;
  i=p.indexOf(sep);
  if(i<0){
    s=p;
    p="";
    return s;
  }
  s=p.left(i);
  p.remove(0,i+1);
  return s;
}

void ImpPComp::Rotate(int &x,int &y,int angle)
{
  double a=angle*3.141592/(16*180);
  int x1=x;
  int y1=y;
  x=x1*cos(a)+y1*sin(a);
  y=y1*cos(a)-x1*sin(a);
}

void ImpPComp::Rotate(int &x,int &y,int x1,int y1,int angle)
{
  double a=angle*3.141592/(16*180);
  x=x1*cos(a)+y1*sin(a);
  y=y1*cos(a)-x1*sin(a);
}

void ImpPComp::Save(PicGrp *P,Layers & Ly,QString name)
{
  QFile F(DirName+name);
  if(F.open(QIODevice::WriteOnly)){
   QTextStream S1;
   S1.setDevice(&F);
   Ly.TextSave(&S1);
   S1<<"{"<< sPic[P->GetIden()] <<"\n";
   P->TextSave(&S1);
   F.close();
  }
  else printf("Error open file %s\n",name.toLatin1().data());
}

void ImpPComp::CreatePad(Layers & Ly,QString name,int angle)
{
  int w,h,x,y;
  int x1,y1;
  int d=0;
  QString s;
  QString s1=name;
  unsigned long int t;
  PicPadS * P=NULL;
  
  s1.remove(0,1);
  s1.remove(".pad");
  if(name.at(0)=='R'){
    s=GetParam(s1,'x');
    w=s.toFloat()*MUL;
    if(w<=0) return;
    s=GetParam(s1,'h');
    h=s.toFloat()*MUL;
    if(h<=0) return;
    s=GetParam(s1,'v');
    x=s.toFloat()*MUL;
    if(s1.contains('d')){
      s=GetParam(s1,'d');
      y=s.toFloat()*MUL;
      s=GetParam(s1,' ');
      d=s.toFloat()*MUL;
    }
    else{
      s=GetParam(s1,' ');
      y=s.toFloat()*MUL;
    }
    s=PINTOP;
    t=Ly.GetLy(&s);
    if(d){
      s=PININT;
      t|=Ly.GetLy(&s);
      s=PINBOT;
      t|=Ly.GetLy(&s);
    }
    Ly.SetVis(t);
    Ly.SetAct(t);
    P=new PicPadS(&Ly);
    if(angle){
      PicPoly * T=new PicPoly(&Ly);
      T->SetWidth(0);
      T->SetClr(0);
      Rotate(x1,y1,-x,-y,angle);
      T->AddPoint(x1,y1);
      Rotate(x1,y1,-x,-y+h,angle);
      T->AddPoint(x1,y1);
      Rotate(x1,y1,-x+w,-y+h,angle);
      T->AddPoint(x1,y1);
      Rotate(x1,y1,-x+w,-y,angle);
      T->AddPoint(x1,y1);
      P->AddItem(T);
    }
    else{
      PicRect * T=new PicRect(&Ly);
      T->Rect(-x,-y,w,h);
      T->SetWidth(2000);
      P->AddItem(T);
    }
    s=MSKTOP;
    t=Ly.GetLy(&s);
    if(d){
      s=MSKBOT;
      t|=Ly.GetLy(&s);
    }
    Ly.SetVis(t);
    Ly.SetAct(t);
    if(angle){
      PicPoly * T=new PicPoly(&Ly);
      T->SetWidth(0);
      T->SetClr(0);
      Rotate(x1,y1,-x-10,-y-10,angle);
      T->AddPoint(x1,y1);
      Rotate(x1,y1,-x-10,-y-10+h+20,angle);
      T->AddPoint(x1,y1);
      Rotate(x1,y1,-x-10+w+20,-y-10+h+20,angle);
      T->AddPoint(x1,y1);
      Rotate(x1,y1,-x-10+w+20,-y-10,angle);
      T->AddPoint(x1,y1);
      P->AddItem(T);
    }
    else{
      PicRect * T=new PicRect(&Ly);
      T->Rect(-x-10,-y-10,w+20,h+20);
      T->SetWidth(2000);
      P->AddItem(T);
    }  
    if(!d){
      s=PSTTOP;
      t=Ly.GetLy(&s);
      Ly.SetVis(t);
      Ly.SetAct(t);
      if(angle){
	PicPoly * T=new PicPoly(&Ly);
	T->SetWidth(0);
	T->SetClr(0);
	Rotate(x1,y1,-x+10,-y+10,angle);
	T->AddPoint(x1,y1);
	Rotate(x1,y1,-x+10,-y+10+h-20,angle);
	T->AddPoint(x1,y1);
	Rotate(x1,y1,-x+10+w-20,-y+10+h-20,angle);
	T->AddPoint(x1,y1);
	Rotate(x1,y1,-x+10+w-20,-y+10,angle);
	T->AddPoint(x1,y1);
	P->AddItem(T);
      }
      else{
	PicRect * T=new PicRect(&Ly);
	T->Rect(-x+10,-y+10,w-20,h-20);
	T->SetWidth(2000);
	P->AddItem(T);
      }
    }

    if(d){
      s=DRILL;
      t=Ly.GetLy(&s);
      Ly.SetVis(t);
      Ly.SetAct(t);
      PicCir * T1=new PicCir(&Ly);
      T1->SetR(d/2);
      T1->SetWidth(0);
      P->AddItem(T1);
    }
  }
  if(name.at(0)=='O'){
    s=GetParam(s1,'x');
    w=s.toFloat()*MUL;
    if(w<=0) return;
    if(s1.contains('d')){
      s=GetParam(s1,'d');
      h=s.toFloat()*MUL;
      s=GetParam(s1,' ');
      d=s.toFloat()*MUL;
    }
    else{
      s=GetParam(s1,' ');
      h=s.toFloat()*MUL;
    }
    s=PINTOP;
    t=Ly.GetLy(&s);
    if(d){
      s=PININT;
      t|=Ly.GetLy(&s);
      s=PINBOT;
      t|=Ly.GetLy(&s);
    }
    Ly.SetVis(t);
    Ly.SetAct(t);
    P=new PicPadS(&Ly);
    if(angle){
      PicLine * L=new PicLine(&Ly);
      Rotate(x1,y1,-(w-h)/2,0,angle);
      L->MoveTo(x1,y1);
      L->Begin(x1,y1);
      Rotate(x1,y1,(w-h)/2,0,angle);
      L->End(x1,y1);
      L->SetWidth(h);
      P->AddItem(L);
    }
    else{
      PicLine * L=new PicLine(&Ly);
      L->MoveTo(-(w-h)/2,0);
      L->Begin(-(w-h)/2,0);
      L->End((w-h)/2,0);
      L->SetWidth(h);
      P->AddItem(L);
    }
    s=MSKTOP;
    t=Ly.GetLy(&s);
    if(d){
      s=MSKBOT;
      t|=Ly.GetLy(&s);
    }
    Ly.SetVis(t);
    Ly.SetAct(t);
    if(angle){
      PicLine * L=new PicLine(&Ly);
      Rotate(x1,y1,-(w-h)/2-10,0,angle);
      L->MoveTo(x1,y1);
      L->Begin(x1,y1);
      Rotate(x1,y1,(w-h)/2+10,0,angle);
      L->End(x1,y1);
      L->SetWidth(h+20);
      P->AddItem(L);
    }
    else{
      PicLine * L=new PicLine(&Ly);
      L->MoveTo(-(w-h)/2-10,0);
      L->Begin(-(w-h)/2-10,0);
      L->End((w-h)/2+10,0);
      L->SetWidth(h+20);
      P->AddItem(L);
    }
    if(!d){
      s=PSTTOP;
      t=Ly.GetLy(&s);
      Ly.SetVis(t);
      Ly.SetAct(t);
      if(angle){
	PicLine * L=new PicLine(&Ly);
	Rotate(x1,y1,-(w-h)/2+10,0,angle);
	L->MoveTo(x1,y1);
	L->Begin(x1,y1);
	Rotate(x1,y1,(w-h)/2-10,0,angle);
	L->End(x1,y1);
	L->SetWidth(h-20);
	P->AddItem(L);
      }
      else{
	PicLine * L=new PicLine(&Ly);
	L->MoveTo(-(w-h)/2+10,0);
	L->Begin(-(w-h)/2+10,0);
	L->End((w-h)/2-10,0);
	L->SetWidth(h-20);
	P->AddItem(L);
      }
    }

    if(d){
      s=DRILL;
      t=Ly.GetLy(&s);
      Ly.SetVis(t);
      Ly.SetAct(t);
      PicCir * T1=new PicCir(&Ly);
      T1->SetR(d/2);
      T1->SetWidth(0);
      P->AddItem(T1);
    }
  }
  if(name.at(0)=='C'){
    if(s1.contains('d')){
      s=GetParam(s1,'d');
      y=s.toFloat()*MUL;
      s=GetParam(s1,' ');
      d=s.toFloat()*MUL;
    }
    else{
      s=GetParam(s1,' ');
      y=s.toFloat()*MUL;
    }

    s=PINTOP;
    t=Ly.GetLy(&s);
    if(d){
      s=PININT;
      t|=Ly.GetLy(&s);
      s=PINBOT;
      t|=Ly.GetLy(&s);
    }
    Ly.SetVis(t);
    Ly.SetAct(t);
    P=new PicPadS(&Ly);
    PicCir * T=new PicCir(&Ly);
    T->SetR(y/2);
    T->SetWidth(2000);
    P->AddItem(T);

    s=MSKTOP;
    t=Ly.GetLy(&s);
    if(d){
      s=MSKBOT;
      t|=Ly.GetLy(&s);
    }
    Ly.SetVis(t);
    Ly.SetAct(t);
    T=new PicCir(&Ly);
    T->SetR(y/2+10);
    T->SetWidth(2000);
    P->AddItem(T);

    if(!d){
      s=PSTTOP;
      t=Ly.GetLy(&s);
      Ly.SetVis(t);
      Ly.SetAct(t);
      T=new PicCir(&Ly);
      T->SetR(y/2-10);
      T->SetWidth(2000);
      P->AddItem(T);
    }

    if(d){
      s=DRILL;
      t=Ly.GetLy(&s);
      Ly.SetVis(t);
      Ly.SetAct(t);
      T=new PicCir(&Ly);
      T->SetR(d/2);
      T->SetWidth(0);
      P->AddItem(T);
    }
  }
  if(P){
    if(angle){
      name.remove(".pad");
      s.setNum(angle);
      name+='a'+s+".pad";
    }
    Save(P,Ly,name);
    delete P;
  }  
}

void ImpPComp::AddPad(PicPComp * C,Layers & Ly,int n,int x,int y,int r,QString name,int angle)
{
  QString n1=name;
  QString s;
  PicPadS * P=new PicPadS(&Ly);
  P->SetPinNum(n);
  if(angle){
    s.setNum(angle);
    n1+='a'+s;
  }
  if(!P->LibPart(n1)){
    CreatePad(Ly,name+".pad",angle);
    if(!P->LibPart(n1)){
      delete P;
      printf("PAD %s not found\n",n1.toLatin1().data());
      return;
    }
  }
  if(angle) Rotate(x,y,angle);
  P->MoveTo(x,y);
  P->RotateTo(r);
  C->AddItem(P);
}

void ImpPComp::Pad(PicPComp * P,Layers & Ly,QString s,int angle)
{
  int n,x,y,r;
  QString s1;
  s1=GetParam(s,' ');
  n=s1.toInt();
  s1=GetParam(s,' ');
  x=s1.toFloat()*MUL;
  s1=GetParam(s,' ');
  y=s1.toFloat()*MUL;
  s1=GetParam(s,' ');
  r=s1.toInt();
  s1=GetParam(s,' ');
  AddPad(P,Ly,n,x,y,r,s1,angle);
}

void ImpPComp::Pads(PicPComp * P,Layers & Ly,QString s,int angle)
{
  int n,m,x,y,r;
  int d=1;
  int i;
  int dx;
  int dy;
  QString s1;
  QString s2;
  s1=GetParam(s,' ');
  s2=GetParam(s1,':');
  n=s2.toInt();
  s2=GetParam(s1,':');
  m=s2.toInt();
  s2=GetParam(s1,':');
  if(!s2.isEmpty()) d=s2.toInt();
  
  s1=GetParam(s,' ');
  x=s1.toFloat()*MUL;
  s1=GetParam(s,' ');
  y=s1.toFloat()*MUL;
  s1=GetParam(s,' ');
  r=s1.toInt();

  s1=GetParam(s,' ');
  dx=s1.toFloat()*MUL;
  s1=GetParam(s,' ');
  dy=s1.toFloat()*MUL;
  
  s1=GetParam(s,' ');
  
  if(m<n){
    for(i=n;i>=m;i-=d){
      AddPad(P,Ly,i,x,y,r,s1,angle);
      x+=dx;
      y+=dy;
    }
  }
  else{
    for(i=n;i<=m;i+=d){
      AddPad(P,Ly,i,x,y,r,s1,angle);
      x+=dx;
      y+=dy;
    }
  }
}

const char BGA_Chars[]="ABCDEFGHJKLMNPRTUVWXYZ";

void ImpPComp::Bga1(PicPComp * P,Layers & Ly,QString s,int angle)
{
  int n,m,x,y;
  int i,j;
  int dx;
  int dy;
  QString s1;
  QString s2;
  s1=GetParam(s,' ');
  s2=GetParam(s1,':');
  n=s2.toInt();
  s2=GetParam(s1,':');
  m=s2.toInt();
  
  s1=GetParam(s,' ');
  dx=s1.toFloat()*MUL;
  s1=GetParam(s,' ');
  dy=s1.toFloat()*MUL;
  
  s1=GetParam(s,' ');
  x=0;
  y=0;
  for(j=1;j<=m;j++){
    for(i=1;i<=n;i++){
      AddPad(P,Ly,(BGA_Chars[j-1]-'A'+1)*65536+i,x,y,0,s1,angle);
      x+=dx;
    }
    y+=dy;
    x=0;
  }
}

void ImpPComp::Bga2(PicPComp * P,Layers & Ly,QString s,int angle)
{
  int n,m,o,x,y;
  int i,j;
  int dx;
  int dy;
  QString s1;
  QString s2;
  s1=GetParam(s,' ');
  s2=GetParam(s1,':');
  n=s2.toInt();
  s2=GetParam(s1,':');
  m=s2.toInt();
  s2=GetParam(s1,':');
  o=s2.toInt();
  
  s1=GetParam(s,' ');
  dx=s1.toFloat()*MUL;
  s1=GetParam(s,' ');
  dy=s1.toFloat()*MUL;
  
  s1=GetParam(s,' ');
  x=0;
  y=0;
  for(j=1;j<=m;j++){
    for(i=1;i<=n;i++){
      if((i<=((n-o)/2)) || (i>(n-(n-o)/2)))
        AddPad(P,Ly,(BGA_Chars[j-1]-'A'+1)*65536+i,x,y,0,s1,angle);
      x+=dx;
    }
    y+=dy;
    x=0;
  }
}

void ImpPComp::BodyR(PicPComp * P,Layers & Ly,QString s,int angle)
{
  int w,h,x,y;
  int x1,y1;
  QString m;
  QString s1;
  QRect r;
  QPoint p;
  unsigned long int l;
  int ds;
  PicLine * L;

  s1=GetParam(s,' ');
  w=s1.toFloat()*MUL;
  s1=GetParam(s,' ');
  h=s1.toFloat()*MUL;
  s1=GetParam(s,' ');
  x=s1.toFloat()*MUL;
  s1=GetParam(s,' ');
  y=s1.toFloat()*MUL;
  m=GetParam(s,' ');
  
  Ly.SetVis(AllLy);
  P->UpdORect();
  P->GetORect(&r);
  p=r.center();
//  x+=p.x();
//  y+=p.y();

  s=SLKTOP;
  l=Ly.GetLy(&s);
  Ly.SetVis(l);
  Ly.SetAct(l);
  
  ds=200;
  if(w<1800) ds=100;
  if(w<800) ds=60;
  if(m=="S"){
    L=new PicLine(&Ly);
    Rotate(x1,y1,x-w/2,y-h/2+ds,angle);
    L->MoveTo(x1+p.x(),y1+p.y());
    L->Begin(x1+p.x(),y1+p.y());
    Rotate(x1,y1,x-w/2+ds,y-h/2,angle);
    L->End(x1+p.x(),y1+p.y());
    L->SetWidth(30);
    P->AddItem(L);

    L=new PicLine(&Ly);
    Rotate(x1,y1,x-w/2,y-h/2+ds,angle);
    L->MoveTo(x1+p.x(),y1+p.y());
    L->Begin(x1+p.x(),y1+p.y());
    Rotate(x1,y1,x-w/2,y+h/2,angle);
    L->End(x1+p.x(),y1+p.y());
    L->SetWidth(30);
    P->AddItem(L);

    L=new PicLine(&Ly);
    Rotate(x1,y1,x-w/2,y+h/2,angle);
    L->MoveTo(x1+p.x(),y1+p.y());
    L->Begin(x1+p.x(),y1+p.y());
    Rotate(x1,y1,x+w/2,y+h/2,angle);
    L->End(x1+p.x(),y1+p.y());
    L->SetWidth(30);
    P->AddItem(L);

    L=new PicLine(&Ly);
    Rotate(x1,y1,x+w/2,y+h/2,angle);
    L->MoveTo(x1+p.x(),y1+p.y());
    L->Begin(x1+p.x(),y1+p.y());
    Rotate(x1,y1,x+w/2,y-h/2,angle);
    L->End(x1+p.x(),y1+p.y());
    L->SetWidth(30);
    P->AddItem(L);

    L=new PicLine(&Ly);
    Rotate(x1,y1,x+w/2,y-h/2,angle);
    L->MoveTo(x1+p.x(),y1+p.y());
    L->Begin(x1+p.x(),y1+p.y());
    Rotate(x1,y1,x-w/2+ds,y-h/2,angle);
    L->End(x1+p.x(),y1+p.y());
    L->SetWidth(30);
    P->AddItem(L);

    L=new PicLine(&Ly);
    Rotate(x1,y1,x-w/2+ds,y-h/2,angle);
    L->MoveTo(x1+p.x(),y1+p.y());
    L->Begin(x1+p.x(),y1+p.y());
    Rotate(x1,y1,x-w/2+ds,y+h/2,angle);
    L->End(x1+p.x(),y1+p.y());
    L->SetWidth(30);
    P->AddItem(L);
  }
  else{
    if(angle){
      L=new PicLine(&Ly);
      Rotate(x1,y1,x-w/2,y-h/2,angle);
      L->MoveTo(x1+p.x(),y1+p.y());
      L->Begin(x1+p.x(),y1+p.y());
      Rotate(x1,y1,x+w/2,y-h/2,angle);
      L->End(x1+p.x(),y1+p.y());
      L->SetWidth(30);
      P->AddItem(L);

      L=new PicLine(&Ly);
      Rotate(x1,y1,x+w/2,y-h/2,angle);
      L->MoveTo(x1+p.x(),y1+p.y());
      L->Begin(x1+p.x(),y1+p.y());
      Rotate(x1,y1,x+w/2,y+h/2,angle);
      L->End(x1+p.x(),y1+p.y());
      L->SetWidth(30);
      P->AddItem(L);

      L=new PicLine(&Ly);
      Rotate(x1,y1,x+w/2,y+h/2,angle);
      L->MoveTo(x1+p.x(),y1+p.y());
      L->Begin(x1+p.x(),y1+p.y());
      Rotate(x1,y1,x-w/2,y+h/2,angle);
      L->End(x1+p.x(),y1+p.y());
      L->SetWidth(30);
      P->AddItem(L);

      L=new PicLine(&Ly);
      Rotate(x1,y1,x-w/2,y+h/2,angle);
      L->MoveTo(x1+p.x(),y1+p.y());
      L->Begin(x1+p.x(),y1+p.y());
      Rotate(x1,y1,x-w/2,y-h/2,angle);
      L->End(x1+p.x(),y1+p.y());
      L->SetWidth(30);
      P->AddItem(L);

      if(m=="C"){
	PicCir * C=new PicCir(&Ly);
	C->SetR(ds);
	C->SetWidth(2000);
	if(w<200) Rotate(x1,y1,x-w/2+ds,y-h/2+ds,angle);
	else Rotate(x1,y1,x-w/2+2*ds,y-h/2+2*ds,angle);
	C->MoveTo(x1+p.x(),y1+p.y());
	P->AddItem(C);
      }
      if(m=="B"){
	PicPoly * T=new PicPoly(&Ly);
	T->SetWidth(0);
	T->SetWidth(0);
	Rotate(x1,y1,x-w/2+ds,y-h/2,angle);
	T->AddPoint(x1+p.x(),y1+p.y());
	Rotate(x1,y1,x-w/2+ds,y+h/2,angle);
	T->AddPoint(x1+p.x(),y1+p.y());
	Rotate(x1,y1,x-w/2+2*ds,y+h/2,angle);
	T->AddPoint(x1+p.x(),y1+p.y());
	Rotate(x1,y1,x-w/2+2*ds,y-h/2,angle);
	T->AddPoint(x1+p.x(),y1+p.y());
	P->AddItem(T);
      }
    }
    else{
      PicRect * T=new PicRect(&Ly);
      T->Rect(x-w/2+p.x(),y-h/2+p.y(),w,h);
      T->SetWidth(30);
      P->AddItem(T);
      if(m=="C"){
	PicCir * C=new PicCir(&Ly);
	C->SetR(ds);
	C->SetWidth(2000);
	if(w<200) C->MoveTo(x-w/2+ds+p.x(),y-h/2+ds+p.y());
	else C->MoveTo(x-w/2+2*ds+p.x(),y-h/2+2*ds+p.y());
	P->AddItem(C);
      }
      if(m=="B"){
	T=new PicRect(&Ly);
	T->Rect(x-w/2+ds+p.x(),y-h/2+p.y(),ds,h);
	T->SetWidth(2000);
	P->AddItem(T);
      }
    }
  }
}

void ImpPComp::BodyC(PicPComp * P,Layers & Ly,QString s,int angle)
{
  int rr,x,y;
  QString m;
  QString s1;
  QRect r;
  QPoint p;
  unsigned long int l;

  s1=GetParam(s,' ');
  rr=s1.toFloat()*MUL;
  s1=GetParam(s,' ');
  x=s1.toFloat()*MUL;
  s1=GetParam(s,' ');
  y=s1.toFloat()*MUL;

  Ly.SetVis(AllLy);
  P->UpdORect();
  P->GetORect(&r);
  p=r.center();
//  x+=p.x();
//  y+=p.y();

  s=SLKTOP;
  l=Ly.GetLy(&s);
  Ly.SetVis(l);
  Ly.SetAct(l);

  PicCir * C=new PicCir(&Ly);
  C->SetR(rr);
  C->SetWidth(30);
  if(angle) Rotate(x,y,angle);
  C->MoveTo(x+p.x(),y+p.y());
  P->AddItem(C);
}

void ImpPComp::BodyL(PicPComp * P,Layers & Ly,QString s,int angle)
{
  int x,y;
  int x1,y1;
  int x2,y2;
  QString s1;
  unsigned long int l;
  PicLine * L;

  s1=SLKTOP;
  l=Ly.GetLy(&s1);
  Ly.SetVis(l);
  Ly.SetAct(l);

  s1=GetParam(s,' ');
  x=s1.toFloat()*MUL;
  s1=GetParam(s,' ');
  y=s1.toFloat()*MUL;

  s1=GetParam(s,' ');
  x1=s1.toFloat()*MUL;
  s1=GetParam(s,' ');
  y1=s1.toFloat()*MUL;
  while(!s1.isEmpty()){
    L=new PicLine(&Ly);
    Rotate(x2,y2,x,y,angle);
    L->MoveTo(x2,y2);
    L->Begin(x2,y2);
    Rotate(x2,y2,x1,y1,angle);
    L->End(x2,y2);
    L->SetWidth(30);
    P->AddItem(L);
    x=x1;
    y=y1;
    s1=GetParam(s,' ');
    x1=s1.toFloat()*MUL;
    s1=GetParam(s,' ');
    y1=s1.toFloat()*MUL;
  }   
}

void ImpPComp::Body(PicPComp * P,Layers & Ly,QString s,int angle)
{
  QString t;

  t=GetParam(s,' ');
  if(t=="R") BodyR(P,Ly,s,angle);
  else if(t=="L") BodyL(P,Ly,s,angle);
  else if(t=="C") BodyC(P,Ly,s,angle);
}

void ImpPComp::Drill(PicPComp * P,Layers & Ly,QString s,int angle)
{
  int x,y;
  int r;
  QString s1;
  unsigned long int l;
  PicCir * C;

  s1=GetParam(s,' ');
  x=s1.toFloat()*MUL;
  s1=GetParam(s,' ');
  y=s1.toFloat()*MUL;
  s1=GetParam(s,' ');
  r=s1.toFloat()*MUL;

  s1=DRILL;
  l=Ly.GetLy(&s1);
  Ly.SetVis(l);
  Ly.SetAct(l);
  
  C=new PicCir(&Ly);
  C->SetR(r/2);
  C->SetWidth(30);
  Rotate(x,y,angle);
  C->MoveTo(x,y);
  P->AddItem(C);

  s1=BARALL;
  l=Ly.GetLy(&s1);
  Ly.SetVis(l);
  Ly.SetAct(l);
  
  C=new PicCir(&Ly);
  C->SetR(r/2+50);
  C->SetWidth(100);
  C->MoveTo(x,y);
  P->AddItem(C);
}

void ImpPComp::Circ(PicPComp * P,Layers & Ly,QString s,int angle)
{
  int x,y;
  int r,w;
  QString s1;
  unsigned long int l;
  PicCir * C;

  s1=GetParam(s,' ');
  x=s1.toFloat()*MUL;
  s1=GetParam(s,' ');
  y=s1.toFloat()*MUL;
  s1=GetParam(s,' ');
  r=s1.toFloat()*MUL;
  s1=GetParam(s,' ');
  w=s1.toFloat()*MUL;

  l=0;
  
  s1=GetParam(s,' ');
  while(!s1.isEmpty()){
    l|=Ly.GetLy(&s1);
    s1=GetParam(s,' ');
  }    
  Ly.SetVis(l);
  Ly.SetAct(l);
  
  C=new PicCir(&Ly);
  C->SetR(r/2);
  C->SetWidth(w);
  Rotate(x,y,angle);
  C->MoveTo(x,y);
  P->AddItem(C);
}

void ImpPComp::Rect(PicPComp * P,Layers & Ly,QString s,int angle)
{
  int x,y;
  int w,h,wd;
  QString s1;
  unsigned long int l;
  PicRect * C;

  s1=GetParam(s,' ');
  x=s1.toFloat()*MUL;
  s1=GetParam(s,' ');
  y=s1.toFloat()*MUL;
  s1=GetParam(s,' ');
  w=s1.toFloat()*MUL;
  s1=GetParam(s,' ');
  h=s1.toFloat()*MUL;
  s1=GetParam(s,' ');
  wd=s1.toFloat()*MUL;

  l=0;
  
  s1=GetParam(s,' ');
  while(!s1.isEmpty()){
    l|=Ly.GetLy(&s1);
    s1=GetParam(s,' ');
  }
  Ly.SetVis(l);
  Ly.SetAct(l);
  if(angle){
    int x1,y1;
    PicLine * L=new PicLine(&Ly);
    Rotate(x1,y1,x,y,angle);
    L->MoveTo(x1,y1);
    L->Begin(x1,y1);
    Rotate(x1,y1,x+w,y,angle);
    L->End(x1,y1);
    L->SetWidth(wd);
    P->AddItem(L);

    L=new PicLine(&Ly);
    Rotate(x1,y1,x+w,y,angle);
    L->MoveTo(x1,y1);
    L->Begin(x1,y1);
    Rotate(x1,y1,x+w,y+h,angle);
    L->End(x1,y1);
    L->SetWidth(wd);
    P->AddItem(L);

    L=new PicLine(&Ly);
    Rotate(x1,y1,x+w,y+h,angle);
    L->MoveTo(x1,y1);
    L->Begin(x1,y1);
    Rotate(x1,y1,x,y+h,angle);
    L->End(x1,y1);
    L->SetWidth(wd);
    P->AddItem(L);

    L=new PicLine(&Ly);
    Rotate(x1,y1,x,y+h,angle);
    L->MoveTo(x1,y1);
    L->Begin(x1,y1);
    Rotate(x1,y1,x,y,angle);
    L->End(x1,y1);
    L->SetWidth(wd);
    P->AddItem(L);
  }
  else{
    C=new PicRect(&Ly);
    C->Rect(x,y,w,h);
    C->SetWidth(wd);
    P->AddItem(C);
  }  
}

void ImpPComp::Line(PicPComp * P,Layers & Ly,QString s,int angle)
{
  int x,y;
  int x2,y2,wd;
  QString s1;
  unsigned long int l;

  s1=GetParam(s,' ');
  x=s1.toFloat()*MUL;
  s1=GetParam(s,' ');
  y=s1.toFloat()*MUL;
  s1=GetParam(s,' ');
  x2=s1.toFloat()*MUL;
  s1=GetParam(s,' ');
  y2=s1.toFloat()*MUL;
  s1=GetParam(s,' ');
  wd=s1.toFloat()*MUL;

  l=0;
  
  s1=GetParam(s,' ');
  while(!s1.isEmpty()){
    l|=Ly.GetLy(&s1);
    s1=GetParam(s,' ');
  }
  Ly.SetVis(l);
  Ly.SetAct(l);
  if(angle){
    int x1,y1;
    PicLine * L=new PicLine(&Ly);
    Rotate(x1,y1,x,y,angle);
    L->MoveTo(x1,y1);
    L->Begin(x1,y1);
    Rotate(x1,y1,x2,y2,angle);
    L->End(x1,y1);
    L->SetWidth(wd);
    P->AddItem(L);
  }
  else{
    PicLine * L=new PicLine(&Ly);
    L->MoveTo(x,y);
    L->Begin(x,y);
    L->End(x2,y2);
    L->SetWidth(wd);
    P->AddItem(L);
  }
}

void ImpPComp::Arc(PicPComp * P,Layers & Ly,QString s,int angle)
{
  int x,y;
  int r,w;
  int b,e;
  QString s1;
  unsigned long int l;
  PicCir * C;

  s1=GetParam(s,' ');
  x=s1.toFloat()*MUL;
  s1=GetParam(s,' ');
  y=s1.toFloat()*MUL;
  s1=GetParam(s,' ');
  r=s1.toFloat()*MUL;
  s1=GetParam(s,' ');
  b=s1.toFloat()*16;
  s1=GetParam(s,' ');
  e=s1.toFloat()*16;
  s1=GetParam(s,' ');
  w=s1.toFloat()*MUL;

  l=0;
  
  s1=GetParam(s,' ');
  while(!s1.isEmpty()){
    l|=Ly.GetLy(&s1);
    s1=GetParam(s,' ');
  }    
  Ly.SetVis(l);
  Ly.SetAct(l);
  
  C=new PicCir(&Ly);
  C->SetR(r);
  C->SetWidth(w);
  Rotate(x,y,angle);
  C->MoveTo(x,y);
  if(b<e) C->SetArc(b-angle,e-b);
  else C->SetArc(b-angle,e-b+16*360);
  P->AddItem(C);
}

void ImpPComp::ProcCmd(QString & cmd,PicPComp * P,Layers & Ly,QString s,int angle)
{
  if(!P) return;
  else if(cmd=="Pad"){
    Pad(P,Ly,s,angle);
  }
  else if(cmd=="Pads"){
    Pads(P,Ly,s,angle);
  }
  else if(cmd=="Bga1"){
    Bga1(P,Ly,s,angle);
  }
  else if(cmd=="Bga2"){
    Bga2(P,Ly,s,angle);
  }
  else if(cmd=="Body"){
    Body(P,Ly,s,angle);
  }
  else if(cmd=="Drill"){
    Drill(P,Ly,s,angle);
  }
  else if(cmd=="Circ"){
    Circ(P,Ly,s,angle);
  }
  else if(cmd=="Rect"){
    Rect(P,Ly,s,angle);
  }
  else if(cmd=="Line"){
    Line(P,Ly,s,angle);
  }
  else if(cmd=="Arc"){
    Arc(P,Ly,s,angle);
  }
}


PicPComp * ImpPComp::ImportOne(QTextStream * S,QString & name,Layers & Ly,int fl)
{
  PicPComp *P=NULL;
  QString s;
  QString s1;
  QString cmd;
  
  int angle=0;

  while(!S->atEnd()){
    s=S->readLine();
    RmComm(s);
    if(!s.isEmpty()){
      cmd=GetParam(s,' ');
      if(cmd=="Name"){
        if(P) break;
	P=new PicPComp(&Ly);
	name=GetParam(s,' ');
      }
      if(cmd=="Rotate"){
	s1=GetParam(s,' ');
	angle=s1.toFloat()*16;
      }
      else ProcCmd(cmd,P,Ly,s,angle);
    }
  }
  if(P && fl){
    Save(P,Ly,name+".pco");
  }
  return P;
}

int ImpPComp::Import(QTextStream * S)
{
  QString s;
  QString s1;
  QString cmd;
  QString name;

  int angle=0;
  
  int num=0;
  
  Layers Ly;
  
  PicPComp * P=NULL;
  
  while(!S->atEnd()){
    s=S->readLine();
    RmComm(s);
    if(!s.isEmpty()){
      cmd=GetParam(s,' ');
      if(cmd=="Name"){
        if(P){
	  Save(P,Ly,name+".pco");
	  delete P;
	  Ly.DelDef(AllLy);
	  num ++;
	}
	angle=0;
	P=new PicPComp(&Ly);
	name=GetParam(s,' ');
      }
      if(cmd=="Rotate"){
	s1=GetParam(s,' ');
	angle=s1.toFloat()*16;
      }
      else ProcCmd(cmd,P,Ly,s,angle);
    }
  }
  if(P){
    Save(P,Ly,name+".pco");
    delete P;
    Ly.DelDef(AllLy);
    num ++;
  }
  return num;
}


void  ImpPComp::RmComm(QString & s)
{
  if(s.contains('#')){
    s=s.left(s.indexOf('#'));
  }
  s=s.simplified();
}
