/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef InfoBarr_included
#define InfoBarr_included

#define kIBSelM 1
#define kIBZoomT 2
#define kIBVWinT 4
#define kIBSelBM 8
#define kIBLineM 0x10
#define kIBWid   0x20
#define kIBFont  0x40
#define kIBAtr   0x80
#define kIBCNam  0x100
#define kIBOri   0x200
#define kIBR     0x400
#define kIBCirM  0x800
#define kIBCopyM 0x1000
#define kIBPType 0x2000
#define kIBLineT 0x4000
#define kIBPolyN 0x8000


#include <QObject>
#include <QPushButton>
#include <QEvent>
#include <QPixmap>
#include <QLineEdit>
#include <QCheckBox>
#include <QComboBox>
#include <QLabel>
#include <QString>
//Added by qt3to4:
#include <QPaintEvent>
#include <QResizeEvent>

#include "ActButt.h"

class InfoBarr : public QWidget
{
 Q_OBJECT
public:

  InfoBarr( QWidget *parent=0);
  virtual ~InfoBarr();

  void SetActL(int a);
  void SetActM(int a);

  void SetXY(int x,int y);
  float GetGX();
  float GetGY();
  bool IsVisGr();
  bool IsOnGr();
  bool IsOnFP();
  bool IsOnSnaP();
  bool IsOnInfo();
  int GetSelML();
  int GetSelMM();
  int GetSelBML();
  int GetSelBMM();
  int GetZoomTL();
  int GetZoomTM();
  int GetVWinTL();
  int GetVWinTM();
  int GetLineML();
  int GetLineMM();
  int GetLineTL();
  int GetLineTM();
  int GetWidL();
  int GetWidM();
  QFont GetFonM();
  QFont GetFonL();
  int GetHAlL();
  int GetHAlM();
  int GetVAlL();
  int GetVAlM();
  int GetAtrL();
  int GetAtrM();
  QString GetCNam(int Butt);
  int GetOriL();
  int GetOriM();
  int GetRL();
  int GetRM();
  int GetCirML();
  int GetCirMM();
  int GetCopyML();
  int GetCopyMM();
  int GetPTypeL();
  int GetPTypeM();

  QString GetPolyNL();
  QString GetPolyNM();
  int GetPolyCL();
  int GetPolyCM();

  void SetOri(int Butt,int O);
  
  void SetMulF(int f);
  int GetMulF();

  QComboBox *  GetCBAtrL();
  QComboBox *  GetCBAtrM();


public slots:
  void PresL();
  void PresM();
//  void SetGX(const char * s);
  void SetGX(const QString& s);
  void SetGX2(const QString& s);
//  void SetGY(const char * s);
  void SetGY(const QString& s);
  void SetGY2(const QString& s);
  void SetGr(bool on);
  void SetGV(bool on);
  void SetSelML(int m);
  void SetSelMM(int m);
  void SetSelBML(int m);
  void SetSelBMM(int m);
  void SetZoomTL(int m);
  void SetZoomTM(int m);
  void SetVWinTL(int m);
  void SetVWinTM(int m);
  void SetLineML(int m);
  void SetLineMM(int m);

  void ChangeSettings();
  
  void Set(int fn,QString p);
  void SetCName(QString n);
  
signals :
  void Press(QPoint p,int but);
  void Change();

protected:

//  void resizeEvent ( QResizeEvent * e);
  void paintEvent( QPaintEvent * e);
  void resizeEvent ( QResizeEvent * e);

  QString GetParam(QString & p);

private:

 void Arrange();

 int MulF;

 int ActL;
 int ActM;

 QLineEdit * LEX;
 QLineEdit * LEY;
 int X;
 int Y;

 QPushButton * BL;
 QPushButton * BM;



 QLineEdit * LEGX;
 QLineEdit * LEGY;
 float GX;
 float GY;

 QLineEdit * LEGX2;
 QLineEdit * LEGY2;
 float GX2;
 float GY2;

 QCheckBox * BG;
 QCheckBox * BGV;
 bool GrV;
 bool Gr;

 QCheckBox * BFP;
 QCheckBox * BSnaP;
 QCheckBox * BInfo;

 QComboBox * CBSelML;
 QComboBox * CBSelMM;
 int SelML;
 int SelMM;

 QComboBox * CBSelBML;
 QComboBox * CBSelBMM;
 int SelBML;
 int SelBMM;


 QComboBox * CBZoomTL;
 QComboBox * CBZoomTM;
 int ZoomTL;
 int ZoomTM;

 QComboBox * CBVWinTL;
 QComboBox * CBVWinTM;
 int VWinTL;
 int VWinTM;

 QComboBox * CBLineML;
 QComboBox * CBLineMM;
 int LineML;
 int LineMM;
 QComboBox * CBLineTL;
 QComboBox * CBLineTM;

 QComboBox * CBWidL;
 QComboBox * CBWidM;


 QLabel     * Lb1L;
 QLabel     * Lb1M;

 QLabel     * Lb2L;
 QLabel     * Lb2M;

 QLabel     * Lb3L;
 QLabel     * Lb3M;

 QCheckBox * BBolL;
 QCheckBox * BBolM;
 QCheckBox * BItL;
 QCheckBox * BItM;
 QComboBox * CBFonL;
 QComboBox * CBFonM;
 QComboBox * CBFSizL;
 QComboBox * CBFSizM;

 QComboBox * CBHAlL;
 QComboBox * CBHAlM;
 QComboBox * CBVAlL;
 QComboBox * CBVAlM;

 QComboBox * CBAtrL;
 QComboBox * CBAtrM;

 QComboBox * CBCNamL;
 QComboBox * CBCNamM;

 QComboBox * CBOriL;
 QComboBox * CBOriM;

 QComboBox * CBRL;
 QComboBox * CBRM;

 QComboBox * CBCirML;
 QComboBox * CBCirMM;

 QComboBox * CBCopyML;
 QComboBox * CBCopyMM;

 QComboBox * CBPTypeL;
 QComboBox * CBPTypeM;

 QComboBox * CBPolyNL;
 QComboBox * CBPolyNM;

 QComboBox * CBPolyCL;
 QComboBox * CBPolyCM;

 QCheckBox * Metric;
 QCheckBox * Metric2;

 QCheckBox * AltGr;
};

#endif
