/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <QTextStream>
#include <QDialog>
#include <QLineEdit>
#include <QComboBox>
#include <QCheckBox>
#include <QPushButton>
#include <QLabel>
#include <QPaintEvent>

#include "Global.h"
#include "Layers.h"
#include "PicEl.h"
#include "PicGrp.h"

#ifndef KeyMap_included
#define KeyMap_included

#define KMNUM 30
#define FUNCNUM 6

#define fnActLayer  1
#define fnActNextLy 2
#define fnActPrevLy 3
#define fnSelFnL    4
#define fnSelFnM    5
#define fnEsc       6
#define fnSetWd     7
#define fnSetRadius 8
#define fnSetFont   9
#define fnSetOrient 10
#define fnSetLineType 11
#define fnSetLineMode 12
#define fnSetPwrType  13
#define fnSetCopyMode 14
#define fnSetSelMode  15
#define fnSetBlSelMode 16
#define fnAltGrid   17
#define fnLoad      18
#define fnSave      19



class KeyMap : public QObject
{
 Q_OBJECT
public:

struct KeyDef{
  int Num;
  const char * Name;
};

  KeyMap();
  virtual ~KeyMap();

  void SetKeyMapType(int n);
  int GetKeyMapType();
  
  int StrToKey(QString s);
  QString KeyToStr(int k);
  
  void SetKey(int n,QString s);
  QString GetKey(int n);
  
  void SetFn(int n,int m,int f,QString p);
  void GetFn(int n,int m,int & f,QString & p);

  void TextSave(QTextStream * S);
  void TextLoad(QTextStream * S);

signals:
  void SetAct(QString s,int b);
  void SetLy(const QString & s);
  void SetNextLy(int d);
  void SetInfo(int fn,QString p);

public slots:
  void ProcKey(int k);

private:
  int Type;
  int Key[KMNUM];
  QString Param[KMNUM][FUNCNUM];
  int FnId[KMNUM][FUNCNUM];
};


class KeyMapDlg : public QDialog
{
 Q_OBJECT
public:
    KeyMapDlg(KeyMap * km, QWidget *parent=0 );
    virtual ~KeyMapDlg();

public slots:
    void Set();
    void OK();
    void Cancel();
    void Revert();
    void Save();
    void Load();

protected:

/*
    void paintEvent( QPaintEvent * e);
    void mousePressEvent ( QMouseEvent *e );
*/


private:
    KeyMap * KM;
    
    QLineEdit * Key[KMNUM];
    QLineEdit * Par[KMNUM][FUNCNUM];
    QComboBox * Fn[KMNUM][FUNCNUM];
};

#endif
