/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef Layers_included
#define Layers_included

#include <QColor>
#include <QObject>
#include <QString>
#include <QTextStream>

#define LyLEN 6
#define AllLy 0xffffffff

class QString;

class Layers : public QObject
{
 Q_OBJECT
public:

  Layers();
  virtual ~Layers();

  unsigned long int Add(int r,int g, int b,char N[LyLEN]);

  void SetVis(unsigned long int L);
  void SetEn(unsigned long int L);
  void SetAct(unsigned long int L);
//  void SetAct(const char * name);
  void SetVis(const char * name);

  void AddVis(const char * name);
  void AddVis(unsigned long int L);
  void AddAct(unsigned long int L);
  void AddEn(unsigned long int L);
  void AddDef(unsigned long int L);

  void DelVis(unsigned long int L);
  void DelAct(unsigned long int L);
  void DelEn(unsigned long int L);
  void DelDef(unsigned long int L);

  bool IsAct(unsigned long int L);
  bool IsEn(unsigned long int L);
  bool IsVis(unsigned long int L);
  bool IsDef(unsigned long int L);
  bool IsWir(unsigned long int L);
  bool IsRts(unsigned long int L);

  bool IsDef(QString * name);

  unsigned long int GetAct();
  unsigned long int GetDef();
  unsigned long int GetLy(QString * name);

  unsigned long int GetRts();

  void SetAlpha(int a);
  
  bool GetColor(QColor** col,unsigned long int L,int Mir=0);
  void SetColor(unsigned long int L,int r,int g,int b);

  bool GetHLColor(QColor** col,unsigned long int L,int Mir=0);
  void SetHLColor(unsigned long int L,int r,int g,int b);

  bool GetVisColor(QColor** col,unsigned long int L,int Mir=0);
  bool GetActColor(QColor** col,unsigned long int L,int Mir=0);
  const char* GetName(unsigned long int L);
  void SetName(unsigned long int L,char N[LyLEN]);

  void TextSave(QTextStream * S,bool Pcb=false);
  void TextLoad(QTextStream * S);

  int GetActType();
  int GetType(unsigned long int L);
  void SetType(unsigned long int L,int t);
  unsigned long int GetWire();
  unsigned long int GetPrint();
  unsigned long int GetAtrLy();

  QString GetLevels(unsigned long int L);
  unsigned long int GetLyLevel(int t);
  void SetLevel(unsigned long int L,int t);
  void AddLevel(unsigned long int L,int t);
  bool IsConnect(unsigned long int L,unsigned long int L1);

  void SetPair(QString na,QString pna);
  void SetPair(int n,int p);
  const char* GetPairN(unsigned long int t);

//  void SetMir(int M);
//  void Mirror();

  unsigned long int MirLy(unsigned long int L);
  unsigned long int PairLy(unsigned long int L);

  void Store();
  void ReStore();

signals:

  void Change();
  void VisChange();

public slots:

  void SetAct(const char * name);
  void SetAct(const QString & name);
  void SetActNext(int d);

protected:


private:
  bool CmpName(char N[LyLEN],unsigned long int L);

  QColor* Colors[32];
  QColor* HLCol[32];
  char Name[32][LyLEN+1];
  unsigned long int Exist;
  unsigned long int Vis;
  unsigned long int En;
  unsigned long int Act;
  unsigned long int Wir;
  unsigned long int Rts;

  unsigned long int Ref;
  unsigned long int Val;
  unsigned long int SVal;
  unsigned long int Comm;
  unsigned long int Print;

  unsigned long int Level[32];
  unsigned long int Pair[32];

  int Mir;

  unsigned long int SD[8];
  int SC[32][3];
  int SCH[32][3];
  char SName[32][LyLEN+1];
  unsigned long int SPair[32];

};


#endif
