/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "LibBrowser.h"
#include "Library.h"
#include "Error.h"
#include "PicPComp.h"
#include "PicSComp.h"
#include "ImpPComp.h"
#include "ImpExp.h"
#include "ActButt.h"

#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QPushButton>
#include <QTextStream>
#include <QTextStream>
#include <QFile>

extern Library gLib;
extern Errors  gErr;
extern const char *sPic[];

LibBrowser::LibBrowser(QWidget *parent )
 :QWidget(parent)
{

  QVBoxLayout * Layout;
  Layout = new QVBoxLayout(this);
  Layout->setSpacing(2);
  Layout->setMargin(1);

  Tree=new QTreeWidget();
  Tree->setColumnCount(1);
//  for (int i = 0; i < 10; ++i)
//     Tree->addTopLevelItem(new QTreeWidgetItem((QTreeWidget*)0, QStringList(QString("item: %1").arg(i))));

  Layout->addWidget(Tree);
  connect( Tree, SIGNAL(itemActivated(QTreeWidgetItem* ,int)),
           this,SLOT(Select(QTreeWidgetItem* ,int)));
  connect( this, SIGNAL(RunEdit()),Tree,SLOT (hide()) );
  connect( this, SIGNAL(EndEdit()),Tree,SLOT (show()) );

  TextEd=new QTextEdit();
  Layout->addWidget(TextEd);
  TextEd->setAcceptRichText(false);
  TextEd->setWordWrapMode(QTextOption::NoWrap);
  TextEd->setLineWrapMode(QTextEdit::NoWrap);
  TextEd->hide();
  connect( this, SIGNAL(EndEdit()),TextEd,SLOT (hide()) );
  connect( this, SIGNAL(RunEdit()),TextEd,SLOT (show()) );


  QHBoxLayout * BLayout;
  BLayout = new QHBoxLayout();
  BLayout->setSpacing(2);
  BLayout->setMargin(2);

  QPushButton * BT = new QPushButton( this );
  BT->setText("Use");
  BT->setMinimumSize( QSize( 60, 20 ) );
  BLayout->addWidget( BT );
  connect( BT, SIGNAL(clicked ()),SLOT (Use()) );
  connect( this, SIGNAL(RunEdit()),BT,SLOT (hide()) );
  connect( this, SIGNAL(EndEdit()),BT,SLOT (show()) );

  BT = new QPushButton( this );
  BT->setText("Edit");
  BT->setMinimumSize( QSize( 60, 20 ) );
  BLayout->addWidget( BT );
  connect( BT, SIGNAL(clicked ()),SLOT (EditC()) );
  connect( this, SIGNAL(RunEdit()),BT,SLOT (hide()) );
  connect( this, SIGNAL(EndEdit()),BT,SLOT (show()) );

  BT = new QPushButton( this );
  BT->setText("Show");
  BT->setMinimumSize( QSize( 60, 20 ) );
  BLayout->addWidget( BT );
  BT->hide();
  connect( BT, SIGNAL(clicked ()),SLOT (Show()) );
  connect( this, SIGNAL(EndEdit()),BT,SLOT (hide()) );
  connect( this, SIGNAL(RunEdit()),BT,SLOT (show()) );

  BT = new QPushButton( this );
  BT->setText("Save");
  BT->setMinimumSize( QSize( 60, 20 ) );
  BLayout->addWidget( BT );
  BT->hide();
  connect( BT, SIGNAL(clicked ()),SLOT (Save()) );
  connect( this, SIGNAL(EndEdit()),BT,SLOT (hide()) );
  connect( this, SIGNAL(RunEdit()),BT,SLOT (show()) );

  BT = new QPushButton( this );
  BT->setText("Save New");
  BT->setMinimumSize( QSize( 60, 20 ) );
  BLayout->addWidget( BT );
  BT->hide();
  connect( BT, SIGNAL(clicked ()),SLOT (SaveNew()) );
  connect( this, SIGNAL(EndEdit()),BT,SLOT (hide()) );
  connect( this, SIGNAL(RunEdit()),BT,SLOT (show()) );

  BT = new QPushButton( this );
  BT->setText("Cancel");
  BT->setMinimumSize( QSize( 60, 20 ) );
  BLayout->addWidget( BT );
  BT->hide();
  connect( BT, SIGNAL(clicked ()),SLOT (Cancel()) );
  connect( this, SIGNAL(EndEdit()),BT,SLOT (hide()) );
  connect( this, SIGNAL(RunEdit()),BT,SLOT (show()) );

  BT = new QPushButton( this );
  BT->setText("Delete");
  BT->setMinimumSize( QSize( 60, 20 ) );
  BLayout->addWidget( BT );
  connect( BT, SIGNAL(clicked ()),SLOT (Delete()) );
  connect( this, SIGNAL(RunEdit()),BT,SLOT (hide()) );
  connect( this, SIGNAL(EndEdit()),BT,SLOT (show()) );

  BT = new QPushButton( this );
  BT->setText("Close");
  BT->setMinimumSize( QSize( 60, 20 ) );
  BLayout->addWidget( BT );
  connect( BT, SIGNAL(clicked ()),SLOT (close()) );
  connect( this, SIGNAL(RunEdit()),BT,SLOT (hide()) );
  connect( this, SIGNAL(EndEdit()),BT,SLOT (show()) );

  Layout->addLayout(BLayout);

  Db=NULL;
  Ed=new Edit(Db,this);
  Ed->setMinimumSize(250,250);
  Layout->addWidget(Ed);

  setMinimumSize(280,600);
}

LibBrowser::~LibBrowser()
{

}

void LibBrowser::SetType(int t)
{
  Type=t;
  gLib.FillTree(Tree,t);
}

void LibBrowser::Select(QTreeWidgetItem* I,int /*c*/)
{
  QString fname;
  QString s;
  int i=1;

  printf("Select %s %s\n",I->text(0).toAscii().data(),I->text(1).toAscii().data());
  fname=I->text(1);
  
  if(fname.isEmpty()) return;
  
  QFile F(fname);
  if(!F.open(QIODevice::ReadOnly)){
    gErr.Err("File not found "+fname);
    return;
  }
  QTextStream S;
  S.setDevice(&F);

  Ed->SetDb(NULL);
  if(Db) delete Db;
  Db=NULL;
  gLib.Clear(&Layer);
  Layer.DelDef(AllLy);

  S >> s;
  while(!S.atEnd()){
    if (s.contains("Layer")){
      Layer.TextLoad(&S);
    }
    else if (s.contains(sPic[kPicPComp])){
      Db= new PicPComp(&Layer);
      Db->TextLoad(&S);
    }
    else if (s.contains(sPic[kPicSComp])){
      Db= new PicSComp(&Layer);
      Db->TextLoad(&S);
    }
    else{
      do{
       S >> s;
       i+=s.count('{');
       i-=s.count('}');
      } while (i>0);
    }
    S >> s;
  }
  F.close();
  if(Db){
    Layer.SetVis(AllLy);
    Layer.DelAct(AllLy);
    s="SIZEB";
    Layer.DelVis(Layer.GetLy(&s));
    Db->DeSelect();
    Db->SetLock(false);
    Ed->SetDb(Db);
    QRect r;
    Db->GetORect(&r);
    Ed->Zoom(r);
  }
}

QString LibBrowser::ReadSCompDef(QFile &F,QString n)
{
  QString s;
  QString r;
  do{
    while(!F.atEnd()){
      EdSrcStart=F.pos();
      s=F.readLine();
      if(s.startsWith("'")) break;
    }
    r=s;
    while(!F.atEnd() && s.startsWith("'") && !s.contains(n)){
      s=F.readLine();
      r+=s;
    }
  }while(!F.atEnd() && !s.contains(n));
  
  if(F.atEnd()) return r;
  while(!F.atEnd()){
    s=F.readLine();
    r+=s;
    if(s.isEmpty() || s.startsWith(" ") || s.startsWith("\n"))break;
  }
  EdSrcEnd=F.pos();
  while(!F.atEnd()){
    EdSrcEnd=F.pos();
    s=F.readLine();
    if(s.startsWith("'")) break;
    r+=s;
  }
  return r;
}

QString LibBrowser::ReadPCompDef(QFile &F,QString n)
{
  QString s;
  QString r;
  while(!F.atEnd()){
    EdSrcStart=F.pos();
    s=F.readLine();
    if(s.startsWith("Name")){
      QString s1=s;
      s1.remove(0,5);
      s1.remove("\n");
      s1.remove(" ");
      if(s1==n) break;
    }
  }
  if(F.atEnd()) return r;
  r=s;
  while(!F.atEnd()){
    EdSrcEnd=F.pos();
    s=F.readLine();
    if(s.startsWith("Name")) break;
    r+=s;
  }
  return r;
}

void LibBrowser::EditC()
{
  QString s;
  QTreeWidgetItem* I;
  I=Tree->currentItem();
  if(!I) return;
  if(I->text(2).isEmpty()) return;
  printf("Edit %s %s\n",I->text(0).toAscii().data(),I->text(2).toAscii().data());
  
  QFile F(I->text(2));
  if(!F.open(QIODevice::ReadOnly)){
    gErr.Err("File not found "+I->text(2));
    return;
  }
  
  if(Type==kPicSComp) s=ReadSCompDef(F,I->text(0));
  else s=ReadPCompDef(F,I->text(0));

  F.close();

  if(s.isEmpty()){
    gErr.Err("Source not available for"+I->text(0));
    return;
  }  
  TextEd->clear();
  TextEd->setPlainText(s);
  printf("Edit %lld %lld\n",EdSrcStart,EdSrcEnd);
  Select(I,0);
  RunEdit();
}

void LibBrowser::Save()
{
  QString s;
  QTreeWidgetItem* I;
  I=Tree->currentItem();
  if(!I) return;
  if(I->text(2).isEmpty()) return;
  
  QFile F(I->text(2)+".bak");
  if(F.remove()) printf("Remove OK\n");
  F.setFileName(I->text(2));
  F.open(QIODevice::ReadOnly);
  F.rename(I->text(2)+".bak");
  F.setFileName(I->text(2)+".bak");
  if(!F.open(QIODevice::ReadOnly)){
    gErr.Err("File not found "+I->text(2)+".bak");
    return;
  }
  QFile G(I->text(2));
  if(!G.open(QIODevice::WriteOnly)){
    gErr.Err("File not found "+I->text(2));
    return;
  }
  QByteArray Data;
  Data=F.read(EdSrcStart);
  G.write(Data);
  G.write(TextEd->toPlainText().toAscii());
  F.seek(EdSrcEnd);
  Data=F.readAll();
  G.write(Data);
  
  F.close();
  G.close();
  EndEdit();
  if(EdSrcEnd==EdSrcStart) Show(2);
  else Show(1);
}

void LibBrowser::SaveNew()
{
  EdSrcStart=EdSrcEnd;
  Save();
}

void LibBrowser::Cancel()
{
  EndEdit();
}

void LibBrowser::Show(int fl)
{
  QTreeWidgetItem* I;
  I=Tree->currentItem();
  if(!I) return;
  QString s;
  if(Type==kPicPComp){
    ImpPComp Import;
    QFileInfo FI(I->text(1));
    Import.SetDirName(FI.absolutePath()+"/");

    s=TextEd->toPlainText();
    QTextStream S;
    S.setString(&s);

    Ed->SetDb(NULL);
    if(Db) delete Db;
    Db=NULL;
    gLib.Clear(&Layer);
    Layer.DelDef(AllLy);
    if(fl==1){
      QFile F;
      F.setFileName(I->text(1));
      F.remove();
    }
    Db=Import.ImportOne(&S,Name,Layer,fl);
    if(fl==1){
      I->setText(1,FI.absolutePath()+"/"+Name+".pco");
      I->setText(0,Name);
    }  
    if(fl==2){
      QTreeWidgetItem* P=I->parent();
      QTreeWidgetItem* J=new QTreeWidgetItem((QTreeWidget*)0,QStringList(Name));
      J->setText(1,FI.absolutePath()+"/"+Name+".pco");
      J->setText(2,I->text(2));
      P->insertChild(P->indexOfChild(I),J);
    }
  }
  else if(Type==kPicSComp){
    OrcImpExp Import;
    QFileInfo FI(I->text(1));
    Import.SetDirName(FI.absolutePath()+"/");

    s=TextEd->toPlainText();
    QTextStream S(&s,QIODevice::ReadOnly);

    Ed->SetDb(NULL);
    if(Db) delete Db;
    Db=NULL;
    gLib.Clear(&Layer);
    Layer.DelDef(AllLy);

    Import.ImportLib(&S,fl,&Db,&Layer);
    
  }
  if(Db){
    Layer.SetVis(AllLy);
    Layer.DelAct(AllLy);
    s="SIZEB";
    Layer.DelVis(Layer.GetLy(&s));
    Db->DeSelect();
    Db->SetLock(false);
    Ed->SetDb(Db);
    QRect r;
    Db->GetORect(&r);
    Ed->Zoom(r);
  }
}

void LibBrowser::Delete()
{
  QString s;
  QTreeWidgetItem* I;
  I=Tree->currentItem();
  if(!I) return;
  if(I->text(1).isEmpty()) return;
  if(!gErr.YesNo("Delete component "+I->text(0)+" ?")) return;

  printf("Delete %s %s\n",I->text(0).toAscii().data(),I->text(2).toAscii().data());

  I->parent()->removeChild(I);

  QFile F(I->text(1));
  if(F.remove()) printf("Remove OK\n");

  if(I->text(2).isEmpty()) return;
  
  F.setFileName(I->text(2));
  if(F.open(QIODevice::ReadOnly)){
  
    if(Type==kPicSComp) s=ReadSCompDef(F,I->text(0));
    else s=ReadPCompDef(F,I->text(0));

    F.close();

    QFile F(I->text(2)+".bak");
    if(F.remove()) printf("Remove OK\n");
    F.setFileName(I->text(2));
    F.open(QIODevice::ReadOnly);
    F.rename(I->text(2)+".bak");
    F.setFileName(I->text(2)+".bak");
    if(!F.open(QIODevice::ReadOnly)){
      gErr.Err("File not found "+I->text(2)+".bak");
      return;
    }
    QFile G(I->text(2));
    if(!G.open(QIODevice::WriteOnly)){
      gErr.Err("File not found "+I->text(2));
      return;
    }
    QByteArray Data;
    Data=F.read(EdSrcStart);
    G.write(Data);
    F.seek(EdSrcEnd);
    Data=F.readAll();
    G.write(Data);

    F.close();
    G.close();
  }
  delete I;  
}

void LibBrowser::Use()
{
  QTreeWidgetItem* I;
  I=Tree->currentItem();
  if(!I) return;
  printf("Use %s\n",I->text(0).toAscii().data());
  ActSel(kABEnter);
  SetCName(I->text(0).toAscii().data());
}
