/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef LibBrowser_included
#define LibBrowser_included


#include "Global.h"
#include "Edit.h"
#include "Layers.h"

#include <QWidget>
#include <QTreeWidget>
#include <QTextEdit>
#include <QFile>

class LibBrowser : public QWidget
{
 Q_OBJECT
public:
    LibBrowser(QWidget *parent=0 );

    virtual ~LibBrowser();

    void SetType(int t);

signals:
    void SetCName(QString n);
    void ActSel(int a);
    void RunEdit();
    void EndEdit();

public slots:
    void Select(QTreeWidgetItem* I,int c);
    void Use();
    void EditC();
    void Save();
    void SaveNew();
    void Cancel();
    void Delete();
    void Show(int fl=0);

private:

    QString ReadSCompDef(QFile &F,QString n);
    QString ReadPCompDef(QFile &F,QString n);

protected:

  int Type;
  QTreeWidget * Tree;
  QTextEdit * TextEd;
  
  Edit* Ed;
  PicGrp * Db;
  Layers Layer;

  qint64 EdSrcStart;
  qint64 EdSrcEnd;
  
  QString Name;
};

#endif
