/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef Library_included
#define Library_included

#include "Global.h"
#include "PicEl.h"
#include "PicGrp.h"

#include <QWidget>
//#include <qpntarry.h>
#include <QDir>
#include <QFileInfo>
//Added by qt3to4:
#include <QTextStream>
#include <QTreeWidget>

class Library
{

struct DirList {
  QString Dir;
  DirList * Next;
};

struct PCompList {
  PicGrp * C;
  QString FullName;
  QString Name;
  PCompList * Next;
};

public:

  Library();
  virtual ~Library();

  void AddDir(const char * Dir);
  void Clear();
  void Clear(Layers * Ly);
  
  QString GetDirs(int t);
  void SetDirs(int t,QString d);

  int GetMWheel(int t);
  void SetMWheel(int t,int d);

  int GetThPat(int t);
  void SetThPat(int t,int d);

  int GetEmbedLib(int t);
  void SetEmbedLib(int t,int d);

  PicGrp * GetPComp(QString name,Layers * L);

  PicGrp * GetComp(QString name,Layers * L,int typ,int fl=0);

  bool SetFName(QFile * F,QString name);

  void FillTree(QTreeWidget * Tree,int type);

  void LoadSetting();
  void SaveSetting();
  void LoadSetting(QTextStream *S,int t=2);
  void SaveSetting(QTextStream *S,int t=2);

  void SaveLib(QTextStream *S,int typ);
  void LoadLib(QTextStream *S,Layers * L,Layers * Lp);
  void SaveParts(QString dir);

private:

  QString Suff(int typ);
  void TextLoadSkip(QTextStream * S);
  
  void Dirs2DL();

private:

  DirList * DL;
  PCompList * CL;
  
  QString Dirs[3];

  int MWheel[3];
  int ThermalPattern[3];
  int EmbedLib[3];

};

#endif
