/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "Layers.h"

#include <QObject>
#include <QWidget>
#include <QEvent>
#include <QDialog>
#include <QLineEdit>
#include <QComboBox>
#include <QCheckBox>
#include <QPushButton>
#include <QLabel>
//Added by qt3to4:
#include <QMouseEvent>
#include <QPaintEvent>

class LySelWdg : public QWidget
{
 Q_OBJECT
public:
    LySelWdg(Layers *L, QWidget *parent=0 );

public slots:

    void LyChange();

protected:
    void paintEvent( QPaintEvent * e);
    void mouseMoveEvent( QMouseEvent *e );
    void mousePressEvent ( QMouseEvent *e );
    void mouseReleaseEvent ( QMouseEvent * e);
 //   void resizeEvent ( QResizeEvent * e);


private:

  int XOfs;
  int wid;
  int Px;
  int button;
  bool Move;
  Layers *Layer;
};

class LyInterf: public QObject
{
 Q_OBJECT

public:
    LyInterf();
    LyInterf(Layers *L,unsigned long int t);
    virtual ~LyInterf();

    void SetLy(unsigned long int L);
    void SetLayers(Layers* L);

public slots:

    virtual void SetName(const char * Na);
    virtual void SetCol(int r, int g,int b);
    virtual void Act (bool on);
    virtual void Vis (bool on);
    virtual void Co (bool on);
    virtual void On (bool on);
    virtual void Type (int t);

signals:

    void NoLy(int n);

protected:


private:
    unsigned long int Ly;
    Layers* Lay;
    int    No;
};



class LyDlg : public QDialog
{
 Q_OBJECT
public:
    LyDlg( QWidget *parent=0 );
    LyDlg( Layers *L,QWidget *parent=0 );
    virtual ~LyDlg();

public slots:
    void SetNo(int * n);
    void LyChange();
    void End();

protected:

    void paintEvent( QPaintEvent * e);
    void mousePressEvent ( QMouseEvent *e );


private:

    Layers * Ly;
    LyInterf * LyIn[32];
    QLineEdit * Le[32];
    QCheckBox * CbEx[32];
    QCheckBox * CbVis[32];
    QCheckBox * CbAct[32];
    QComboBox * CBTyp[32];

};


class LyDlgM : public QDialog
{
 Q_OBJECT
public:
//    LyDlgM( QWidget *parent=0 );
    LyDlgM( Layers *L,QWidget *parent=0 );
    virtual ~LyDlgM();

public slots:
//    void SetNo(int * n);
//    void LyChange();
    void End();
    void Cancel();
    void New();
    void Del();

protected:

    void paintEvent( QPaintEvent * e);
    void mousePressEvent ( QMouseEvent *e );

    void Arrange();


private:

    Layers * Ly;
//    LyInterf * LyIn[32];

    QPushButton* Ok;
    QPushButton* BCancel;
    QPushButton* BNew;
    QPushButton* BDel;

    QLabel    * La[32];
    QLineEdit * Le[32];
    QLineEdit * Pa[32];
    QLineEdit * Lev[32];
    QCheckBox * CbEx[32];
    QCheckBox * CbVis[32];
    QCheckBox * CbAct[32];
    QComboBox * CBTyp[32];

    int N;

};

