/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "ObjEdit.h"
#include "Global.h"
#include "PicEl.h"
#include "PicGrp.h"
#include "Layers.h"

#include <QFontDialog>
//#include <QLayout.h>
#include <QPushButton>
//Added by qt3to4:
#include <QHBoxLayout>
#include <QGridLayout>
#include <QLabel>
#include <QVBoxLayout>


extern const char *ObjName[];


ObjEdit::ObjEdit(PicEl * Obj, QWidget *parent )
 :QWidget(parent)
{
  int i;
  
  QLabel * TL;
  QPushButton * BT;
  QGridLayout * Layout;
  QVBoxLayout * MLayout;
  QHBoxLayout * BLayout;

  EObj=Obj;

  MLayout = new QVBoxLayout(this);
  MLayout->setSpacing(6);
  MLayout->setMargin(11);

  Layout = new QGridLayout();
  Layout->setSpacing(6);
  Layout->setMargin(11);

  BLayout = new QHBoxLayout();
  BLayout->setSpacing(6);
  BLayout->setMargin(11);


//  printf("ObjEdit::ObjEdit create %s\n",ObjName[Obj->GetIden()]);

//Row 0

  TL = new QLabel( this );
  TL->setText(ObjName[Obj->GetIden()]);
  Layout->addWidget( TL,0,0,1,2 );

  CBSID = new QComboBox(this);
//  CBSID->insertStrList(sSID);
  i=0;
  while(Obj->GetsSID(i)){
    CBSID->insertItem(1000,Obj->GetsSID(i));
    i++;
  }  
  Layout->addWidget( CBSID,0,3,1,2 );

  if(Obj->GetIden()>=kPicGrp){
   CBLock = new QComboBox(this);
   CBLock->insertItem(1,"No Lock");
   CBLock->insertItem(2,"Lock");
   CBLock->insertItem(3,"Lock 2");
   CBLock->insertItem(4,"Lock 3");
   CBLock->insertItem(5,"Lock 4");
   Layout->addWidget( CBLock,0,6,1,2 );
  }

//Row 1
  TL = new QLabel( this );
  TL->setText("X:");
  Layout->addWidget( TL,1,0 );

  LEX = new QLineEdit( this );
  Layout->addWidget( LEX,1,1 );

  TL = new QLabel( this );
  TL->setText("Y:");
  Layout->addWidget( TL,1,3 );

  LEY = new QLineEdit( this );
  Layout->addWidget( LEY,1,4 );

  TL = new QLabel( this );
  TL->setText("Width:");
  Layout->addWidget( TL,1,6 );

  LEWid = new QLineEdit( this );
  Layout->addWidget( LEWid,1,7 );

//Row2
  TL = new QLabel( this );
  TL->setText("Rotate:");
  Layout->addWidget( TL,2,0 );

  CBRot = new QComboBox(this);
  CBRot->insertItem(1,"0");
  CBRot->insertItem(2,"90");
  CBRot->insertItem(3,"180");
  CBRot->insertItem(4,"270");
  Layout->addWidget( CBRot,2,1 );

  TL = new QLabel( this );
  TL->setText("Miror:");
  Layout->addWidget( TL,2,3 );

  CBMir = new QComboBox(this);
  CBMir->insertItem(1,"No");
  CBMir->insertItem(2,"Yes");
  Layout->addWidget( CBMir,2,4 );

  TL = new QLabel( this );
  TL->setText("Layers:");
  Layout->addWidget( TL,2,6 );

  LELy = new QLineEdit( this );
  Layout->addWidget( LELy,2,7 );

//Row3

  if(Obj->GetIden()==kPicLine || Obj->GetIden()==kPicRect){
   TL = new QLabel( this );
   TL->setText("X1:");
   Layout->addWidget( TL,3,0 );

   LEX1 = new QLineEdit( this );
   Layout->addWidget( LEX1,3,1 );

   TL = new QLabel( this );
   TL->setText("Y1:");
   Layout->addWidget( TL,3,3 );

   LEY1 = new QLineEdit( this );
   Layout->addWidget( LEY1,3,4 );

  //Row4
   TL = new QLabel( this );
   if(Obj->GetIden()==kPicLine) TL->setText("X2:");
   else TL->setText("Width:");
   Layout->addWidget( TL,4,0 );

   LEX2 = new QLineEdit( this );
   Layout->addWidget( LEX2,4,1 );

   TL = new QLabel( this );
   if(Obj->GetIden()==kPicLine) TL->setText("Y2:");
   else TL->setText("Height:");
   Layout->addWidget( TL,4,3 );

   LEY2 = new QLineEdit( this );
   Layout->addWidget( LEY2,4,4 );

  }

  if(Obj->GetIden()==kPicCir){
   TL = new QLabel( this );
   TL->setText("Radius:");
   Layout->addWidget( TL,3,0 );

   LEX1 = new QLineEdit( this );
   Layout->addWidget( LEX1,3,1 );
  }

  if((Obj->GetIden()==kPicText)||(Obj->GetIden()==kPicPower)){
   TL = new QLabel( this );
   TL->setText("Text:");
   Layout->addWidget( TL,3,0 );

   LEText = new QLineEdit( this );
   Layout->addWidget( LEText,3,1,1,5 );

   if(Obj->GetIden()==kPicText){
   //Row4
    TL = new QLabel( this );
    TL->setText("Horiz:");
    Layout->addWidget( TL,4,0 );

    CBHorAl = new QComboBox(this);
    CBHorAl->insertItem(1,"Left");
    CBHorAl->insertItem(2,"Center");
    CBHorAl->insertItem(3,"Right");

    Layout->addWidget( CBHorAl,4,1 );

    TL = new QLabel( this );
    TL->setText("Vert:");
    Layout->addWidget( TL,4,3 );

    CBVerAl = new QComboBox(this);
    CBVerAl->insertItem(1,"Top");
    CBVerAl->insertItem(2,"Center");
    CBVerAl->insertItem(3,"Bottom");
    Layout->addWidget( CBVerAl,4,4 );
   }

   if(Obj->GetIden()==kPicPower){
    TL = new QLabel( this );
    TL->setText("Type:");
    Layout->addWidget( TL,4,0 );
    CBPwrTyp = new QComboBox(this);
    CBPwrTyp->insertItem(1,"Circle");
    CBPwrTyp->insertItem(2,"Arrow");
    CBPwrTyp->insertItem(3,"Bar");
    CBPwrTyp->insertItem(4,"Wave");
    Layout->addWidget( CBPwrTyp,4,1 );
   }

   BT = new QPushButton( this );
   BT->setText("Font");
   Layout->addWidget( BT,4,7 );
   connect( BT, SIGNAL(clicked ()),SLOT (FontEdit()) );
  }

  if(Obj->GetIden()==kPicPoly){
   TL = new QLabel( this );
   TL->setText("Net:");
   Layout->addWidget( TL,3,0 );

   LEText = new QLineEdit( this );
   Layout->addWidget( LEText,3,1,1,2 );

   TL = new QLabel( this );
   TL->setText("Clr:");
   Layout->addWidget( TL,3,4 );

   LEX1 = new QLineEdit( this );
   Layout->addWidget( LEX1,3,5,1,2 );
  } 

  QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
  Layout->addItem( spacer, 6, 0 );

//Buttons

  spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding , QSizePolicy::Minimum);
  BLayout->addItem( spacer );

  BT = new QPushButton( this );
  BT->setText("OK");
  BT->setMinimumSize( QSize( 80, 20 ) );
  BLayout->addWidget( BT );
  connect( BT, SIGNAL(clicked ()),SLOT (OK()) );

  spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding , QSizePolicy::Minimum);
  BLayout->addItem( spacer );

  BT = new QPushButton( this );
  BT->setText("Apply");
  BT->setMinimumSize( QSize( 80, 20) );
  BLayout->addWidget( BT );
  connect( BT, SIGNAL(clicked ()),SLOT (Apply ()) );

  spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding , QSizePolicy::Minimum);
  BLayout->addItem( spacer );

  BT = new QPushButton( this );
  BT->setText("Revert");
  BT->setMinimumSize( QSize( 80, 20) );
  BLayout->addWidget( BT );
  connect( BT, SIGNAL(clicked ()),SLOT (Revert ()) );

  spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding , QSizePolicy::Minimum);
  BLayout->addItem( spacer );

  BT = new QPushButton( this );
  BT->setText("Cancel");
  BT->setMinimumSize( QSize( 80, 20) );
  BLayout->addWidget( BT );
  connect( BT, SIGNAL(clicked ()),SLOT (Cancel ()) );

  spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding , QSizePolicy::Minimum);
  BLayout->addItem( spacer );


  MLayout->addLayout( Layout );
  MLayout->addLayout( BLayout );

  Revert();
}


ObjEdit::~ObjEdit()
{

 Apply();
}




void ObjEdit::Apply()
{
 bool x;

 EObj->MoveTo(LEX->text().toInt(),LEY->text().toInt());
 EObj->SetWidth(LEWid->text().toInt());

 EObj->RotateTo(CBRot->currentIndex());
 EObj->SetMirror(CBMir->currentIndex());
 EObj->SetLayer(LELy->text().toInt(&x,16));

 if(EObj->GetIden()<kPicGrp) EObj->SetSubIden(CBSID->currentIndex());


 if(EObj->GetIden()>=kPicGrp){
  ((PicGrp *)EObj)->SetLock(CBLock->currentIndex());
 }

 if(EObj->GetIden()==kPicLine){
   ((PicLine *)EObj)->Begin(LEX1->text().toInt(),LEY1->text().toInt());
   ((PicLine *)EObj)->End(LEX2->text().toInt(),LEY2->text().toInt());
 }

 if(EObj->GetIden()==kPicCir){
   ((PicCir *)EObj)->SetR(LEX1->text().toInt());
 }

 if(EObj->GetIden()==kPicRect){

  ((PicRect *)EObj)->Rect(LEX1->text().toInt(),LEY1->text().toInt(),
                       LEX2->text().toInt(),LEY2->text().toInt());
 }

 if(EObj->GetIden()==kPicText){
  ((PicText*)EObj)->SetText(LEText->text());

  ((PicText*)EObj)->SetAlig(CBHorAl->currentIndex(),CBVerAl->currentIndex());
  ((PicText*)EObj)->SetFont(Font);
 }
 if(EObj->GetIden()==kPicPower){
  ((PicPower*)EObj)->SetText(LEText->text());

  ((PicPower*)EObj)->SetType(CBPwrTyp->currentIndex());
  ((PicPower*)EObj)->SetFont(Font);
 }
 if(EObj->GetIden()==kPicPoly){
  ((PicPoly*)EObj)->SetNet(LEText->text());
  ((PicPoly*)EObj)->SetClr(LEX1->text().toInt());
 }
 Change();
}

void ObjEdit::Cancel()
{
 Revert();
 Done();
}

void ObjEdit::Revert()
{
 QString s;

// printf (" ObjEdit::Cancel start\n");

 if(EObj->GetIden()>=kPicGrp){
   CBLock->setCurrentIndex(((PicGrp *)EObj)->IsLock(0));
 }

 CBSID->setCurrentIndex(EObj->GetSubIden());

 s.setNum(EObj->X());
 LEX->setText(s);

 s.setNum(EObj->Y());
 LEY->setText(s);

 s.setNum(EObj->GetWidth());
 LEWid->setText(s);

 CBRot->setCurrentIndex(EObj->GetRotate() & 3);
 CBMir->setCurrentIndex(EObj->GetMirror() & 1);

 s.setNum(EObj->GetLayer(),16);
 LELy->setText(s);

 if(EObj->GetIden()==kPicLine){
  s.setNum(((PicLine*)EObj)->GetBegin().x());
  LEX1->setText(s);

  s.setNum(((PicLine*)EObj)->GetBegin().y());
  LEY1->setText(s);

  s.setNum(((PicLine*)EObj)->GetEnd().x());
  LEX2->setText(s);

  s.setNum(((PicLine*)EObj)->GetEnd().y());
  LEY2->setText(s);
 }

 if(EObj->GetIden()==kPicCir){
  s.setNum(((PicCir*)EObj)->GetR());
  LEX1->setText(s);
 }

 if(EObj->GetIden()==kPicRect){
  int x,y,w,h;
  ((PicRect*)EObj)->GetRect(&x,&y,&w,&h);

  s.setNum(x);
  LEX1->setText(s);

  s.setNum(y);
  LEY1->setText(s);

  s.setNum(w);
  LEX2->setText(s);

  s.setNum(h);
  LEY2->setText(s);
 }

 if(EObj->GetIden()==kPicText){
  int v,h;

//  printf (" ObjEdit::Cancel GetText\n");

//  printf (" ObjEdit::Cancel Text : %s\n",(const char *)((PicText*)EObj)->GetText());

  LEText->setText(((PicText*)EObj)->GetText());


  ((PicText*)EObj)->GetAlig(&h,&v);

//  printf (" ObjEdit::Cancel Alig : %d %d\n",h,v);


  CBHorAl->setCurrentIndex(h);
  CBVerAl->setCurrentIndex(v);
  
  Font=((PicText*)EObj)->GetFont();
 }

 if(EObj->GetIden()==kPicPower){
   LEText->setText(((PicPower*)EObj)->GetText());
   Font=((PicPower*)EObj)->GetFont();
   CBPwrTyp->setCurrentIndex(((PicPower*)EObj)->GetType());
 }

 if(EObj->GetIden()==kPicPoly){
   LEText->setText(((PicPoly*)EObj)->GetNet());
   s.setNum(((PicPoly*)EObj)->GetClr());
   LEX1->setText(s);
 }
}


void ObjEdit::OK()
{
  Apply();
  Done();
}

void ObjEdit::FontEdit()
{
  Font = QFontDialog::getFont(NULL, Font, this );
}
//----------------------------------------------------------------

TreeList::TreeList(PicGrp *db,  QWidget *parent )
    : QDialog( parent )
{

  setFixedSize(710,500);
  LV=new QTreeWidget(this);
  LV->setGeometry(0,0,250,500);
  LV->setColumnCount(2);
  QStringList l;
  l << "Type" << "Name";
  LV->setHeaderLabels(l);
//  LV->addColumn( "Type" );
//  LV->addColumn( "Name" );

  TreeListItem * item = new TreeListItem(db,LV);
  item->setText( 0,ObjName[db->GetIden()]);
  db->AddTreeList(item);


  connect( LV, SIGNAL(itemClicked ( QTreeWidgetItem *,int )),
              SLOT(Select ( QTreeWidgetItem * )) );

  OE= new ObjEdit(db,this);
  OE->setGeometry(260,0,450,500);
  connect( OE, SIGNAL(Done ()),SLOT (OK ()) );

}

TreeList::~TreeList()
{
}

void TreeList::AddDb( PicGrp *db)
{
  TreeListItem * item = new TreeListItem(db,LV);
  item->setText( 0,ObjName[db->GetIden()]);
  db->AddTreeList(item);
}


void TreeList::Select( QTreeWidgetItem * item)
{
 if (item){
  delete OE;
  OE= new ObjEdit(((TreeListItem *)item)->GetObj(),this);
  OE->setGeometry(260,0,450,500);
  OE->show();
  update();
  connect( OE, SIGNAL(Done ()),SLOT (OK ()) );
 }
}

void TreeList::OK()
{
 accept();
 delete this;
}



//----------------------------------------------------------------

EditDlg::EditDlg(PicEl *db,  QWidget *parent)
    : QDialog( parent )
{

  setFixedSize(500,500);

  OE= new ObjEdit(db,this);
  OE->setGeometry(0,0,500,500);
  connect( OE, SIGNAL(Done ()),SLOT (OK ()) );
  connect( OE, SIGNAL(Change ()),SLOT (Apply ()) );
}

EditDlg::~EditDlg()
{
}



void EditDlg::OK()
{
 accept();
 delete this;
}

void EditDlg::Apply()
{
 Change();
}

//----------------------------------------------------------------


TreeListItem::TreeListItem(PicEl *E, QTreeWidget *parent )
:QTreeWidgetItem(parent)
{
 Obj=E;
}

TreeListItem::TreeListItem(PicEl *E, QTreeWidgetItem *parent )
:QTreeWidgetItem(parent)
{
 Obj=E;
}

TreeListItem::~TreeListItem()
{
}

PicEl * TreeListItem::GetObj()
{
 return Obj;
}

