/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef ObjEdit_included
#define ObjEdit_included


#include "Global.h"
#include "PicEl.h"
#include "PicObj.h"
#include "PicGrp.h"
#include "DbPcb.h"
#include "InfoBarr.h"

#include <QLineEdit>
#include <QPainter>
#include <QComboBox>
#include <QDialog>
#include <QTreeWidget>
#include <QTreeWidgetItem>
#include <QEvent>

class ObjEdit : public QWidget
{
 Q_OBJECT
public:
    ObjEdit(PicEl * Obj, QWidget *parent=0);
    virtual ~ObjEdit();


signals:

  void Done();
  void Change();

public slots:
  void Apply();
  void Cancel();
  void Revert();
  void OK();
  
  void FontEdit();

private:




protected:

 PicEl * EObj;

 QLineEdit * LEX;
 QLineEdit * LEY;
 QLineEdit * LEWid;

 QComboBox * CBRot;
 QComboBox * CBMir;

 QComboBox * CBSID;
 QComboBox * CBLock;

 QLineEdit * LELy;

 QLineEdit * LEX1;
 QLineEdit * LEX2;
 QLineEdit * LEY1;
 QLineEdit * LEY2;

 QLineEdit * LEBegA;
 QLineEdit * LELenA;

 QLineEdit * LEText;

 QComboBox * CBHorAl;
 QComboBox * CBVerAl;
 
 QFont   Font;

 QComboBox * CBPwrTyp;

};

//-----------------------------------------------------------

class TreeList : public QDialog
{
    Q_OBJECT
public:
    TreeList(PicGrp *db, QWidget *parent);
    virtual ~TreeList();


   void AddDb( PicGrp *db);



protected:

public slots:


    void OK();
    void Select( QTreeWidgetItem * item);


private:

 QTreeWidget * LV;
 ObjEdit   * OE;


};

//-----------------------------------------------------------

class EditDlg : public QDialog
{
    Q_OBJECT
public:
    EditDlg(PicEl *db, QWidget *parent);
    virtual ~EditDlg();

signals:

  void Change();

protected:

public slots:

    void OK();
    void Apply();


private:

 ObjEdit   * OE;


};

//-----------------------------------------------------------

class TreeListItem : public QTreeWidgetItem
{
public:
    TreeListItem(PicEl *E, QTreeWidget * parent);
    TreeListItem(PicEl *E, QTreeWidgetItem * parent);
    virtual ~TreeListItem();

 PicEl * GetObj();

protected:



private:

 PicEl * Obj;

};



#endif
