/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "Global.h"
#include "PicEl.h"
#include "Layers.h"

#include <QPainter>
#include <QPen>
#include <QColor>
//#include <qpntarry.h>
//#include <qtstream.h>
//Added by qt3to4:
#include <QTextStream>
#include <QPainterPath>

#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <unistd.h>

const char *sPic[] = {
 "PEl",
 "PLine",
 "PPoly",
 "PRect",
 "PCir",
 "PPower",
 "PText",
 "PGrp",
 "PPadS",
 "PPin",
 "PPComp",
 "PSComp",
 "DPComp",
 "DSComp",
// "SCGrp",
 "DbSch",
 "DbPcb",
 "PSNet",
 "PPNet",
 "DbPrj",
 0
};

static const char *sSID[] = {
 "None",
 "PinN",
 "Ref",
 "Val",
 "SubV",
 "Comm",
 "Pkg",
 "Power",
 "Date",
 "FName",
 "Ver",
 0
};


extern Layers *Layer;
extern unsigned long long gID;


PicEl::PicEl(Layers *L)
{
 Layer=L;
 Ref.setX(0);
 Ref.setY(0);
 R.setCoords(0,0,0,0);
 Rot=0;
 Ly=Layer->GetAct();
 wid=1;
 Sel=0;
 SelP=0;
 SID=0;
 Mir=0;
 HiL=false;
 ID=gID++;
}

PicEl::~PicEl()
{
// printf("PicEl: delete %s\n",sPic[GetIden()]);
}

int PicEl::GetIden()
{
 return(kPicEl);
}

int PicEl::GetSubIden()
{
 return SID;
}

const char * PicEl::GetsSID(int i)
{
  return sSID[i];
}

void PicEl::SetSubIden(int i)
{
 SID=i;
}


void PicEl::Draw(QPainter* P,int flag)
{
 DrawTo(P,0,0,0,flag);
}

void PicEl::DrawTo(QPainter* P,int x,int y,int rot,int flag)
{
 ReDraw(P,NULL,flag,x,y,rot);
}

void PicEl::ReDraw(QPainter* P,QRect* Rec,int flag,
                   int x,int y,int rot,int mir,bool HL)
{
// if ((!(flag & kDrawSel)) || (Sel)){
  int xr=Ref.x();
  int yr=Ref.y();
//  int rp=rot;
  QRect r=R;

  if (HiL) HL=true;

  CompRot(rot,&xr,&yr,mir);

//  if (Mir && rot&1) rot=(rot+2)&3;

//  if (mir && rot&1) rot=(rot+2)&3;
  if(mir) rot=(rot-Rot)&3;
  else rot=(rot+Rot)&3;

  r=CompRot(rot,r,(Mir+mir)&1);
  r.translate(x+xr,y+yr);
  QColor* col=NULL;

//  printf("%s (x:%d y:%d r:%d m:%d)+(x:%d y:%d r:%d m:%d)=(x:%d y:%d r:%d m:%d)\n",
//                                  sPic[GetIden()],x,y,rp,mir,
//                                  Ref.x(),Ref.y(),Rot,Mir,
//                                  x+xr,yr+y,(rot+Rot)&3,(Mir+mir)&1);

//  printf("%s flag=%x sel=%d\n",sPic[GetIden()],flag,Sel);
  
  if (Sel && (flag & kDrawSel)){
   if (Layer->GetColor(&col,Ly,(Mir+mir)&1)){
//    QColor* col1=NULL;
//    col1 = new QColor(0,0,0);
    if(HL){
     col=NULL;
     Layer->GetHLColor(&col,Ly,(Mir+mir)&1);
//     printf("Draw : HiL %s\n",sPic[GetIden()]);
    }
    Paint(P,Rec,flag,col,x+xr,yr+y,rot,(Mir+mir)&1,HL);
    return;
   }
  }
  if (Rec==NULL || Rec->intersects(r)){
   if ((flag & kDrawAct) && (Sel!=1)){
     if (Layer->GetActColor(&col,Ly,(Mir+mir)&1)){
     if(HL){
      col=NULL;
      Layer->GetHLColor(&col,Ly,(Mir+mir)&1);
//      printf("Draw : HiL %s\n",sPic[GetIden()]);
     }
     Paint(P,Rec,flag,col,x+xr,yr+y,rot,(Mir+mir)&1,HL);
     return;
    }
   }
   if ((flag & kDrawOth) && (Sel!=1)){
    if (Layer->GetVisColor(&col,Ly,(Mir+mir)&1)){
     if(HL){
      col=NULL;
      Layer->GetHLColor(&col,Ly,(Mir+mir)&1);
//      printf("Draw : HiL %s\n",sPic[GetIden()]);
     }
     Paint(P,Rec,flag,col,x+xr,yr+y,rot,(Mir+mir)&1,HL);
    }
   }
  }
// }
}



void PicEl::MoveTo(int x, int y)
{
 Ref.setX(x);
 Ref.setY(y);
}

void PicEl::MoveBy(int x, int y)
{
 Ref.setX(Ref.x()+x);
 Ref.setY(Ref.y()+y);
}

void PicEl::MoveTo(QPoint p)
{
 Ref=p;
}

void PicEl::Rotate(int rot)
{
 Rot+=rot;
 Rot=Rot & 3;
}

void PicEl::RotateTo(int rot)
{
 Rot=rot;
 Rot=Rot & 3;
}


bool PicEl::Select(int x,int y,int mode,int mir)
{
 QPoint p(x,y);
 return Select(p,mode,mir);
}

bool PicEl::Select(PicEl * E)
{
 if (E==this) {
  Sel=1;
  return true;
 }
 else return false;
}

bool PicEl::GetInfo(QString & i,QPoint p,int mode,int mir)
{
  if ((mode != kSelActOnly) || Layer->IsAct(GetLayer(mir))){
    p=p-Ref;
    p=CompRot((4-Rot),p,Mir+256);
    if (R.contains(p) && Layer->IsVis(GetLayer(mir))){
      i=sPic[GetIden()];
      return true;
    }
    else{
      return false;
    }
  }
  return false;
}

bool PicEl::Select(QPoint p,int mode,int mir)
{
 if ((mode != kSelActOnly) || Layer->IsAct(GetLayer(mir))){
  p=p-Ref;
  p=CompRot((4-Rot),p,Mir+256);
  if (R.contains(p) && Layer->IsVis(GetLayer(mir))){
   Sel=1;
   return true;
  }
  else {
   Sel=0;
   return false;
  }
 }
 return false;
}

bool PicEl::Select(QRect r,int mode,int mir)
{
 int xmod=mode/256;
 mode=mode & 255;
 if (((mode != kSelActOnly) || Layer->IsAct(GetLayer(mir))) &&
        Layer->IsVis(GetLayer(mir))){
  r.translate(-Ref.x(),-Ref.y());
  r=CompRot(4-Rot,r,Mir+256);
  if (((xmod!=kSelBPart && r.contains(R)) ||
      (xmod==kSelBPart && r.intersects(R)))){
   Sel=1;
   return true;
  }
  else {
   Sel=0;
  }
  if (xmod==kSelBPoint && r.intersects(R)){
   return(SelPoint(r,mode,mir));
  }
 }
 return false;
}


void PicEl::DeSelect()
{
 Sel=0;
 SelP=0;
}

void PicEl::SelInfo(int l)
{
 if(Sel){
  int i;
  unsigned long int t;
  for(i=0;i<l;i++) printf(" ");
  printf("%s:S=%d,SP=%d,Ly=",sPic[GetIden()],Sel,SelP);
  t=1;
  for(i=0;i<32;i++){
   if(Ly & t) printf("%d",i%8);
   else printf("-");
   t=t*2;
  }
  printf("\n");
 }
}


void PicEl::SelThis(int s, int sp)
{
 Sel=s;
 SelP=sp;
}

void PicEl::HL()
{
 HiL=true;
}

bool PicEl::IsHL()
{
  return HiL;
}

void PicEl::HLSel(int /*fl*/)
{
 if(Sel==1) HiL=true;
}

void PicEl::HLOff()
{
 HiL=false;
}


int PicEl::SelPoint(int x,int y,int tol,int mode,int mir)
{
 QPoint p(x,y);
 return SelPoint(p,tol,mode,mir);
}
int PicEl::SelPoint(QPoint /*p*/,int /*tol*/,int /*mode*/,int /*mir*/)
{
 return -1;
}

bool PicEl::SelPoint(QRect /*r*/,int /*mode*/,int /*mir*/)
{
 return false;
}


void PicEl::MovePointTo(int x, int y)
{
 QPoint p(x,y);
 MovePointTo(p);
}

void PicEl::MovePointTo(QPoint /*p*/)
{
}

void PicEl::MovePointBy(int /*x*/, int /*y*/)
{
}

int PicEl::IsSelect()
{
 return Sel;
}

bool PicEl::IsPointSel()
{
 if(SelP)return true;
 return false;
}

QPoint PicEl::GetSelPoint()
{
 QPoint p;
 return p;
}


int PicEl::GetRotate()
{
 return Rot;
}

int PicEl::GetMirror()
{
 return Mir;
}
void PicEl::SetMirror(int m)
{
 Mir=m&1;
}
void PicEl::Mirror()
{
 Mir=1-Mir;
}


int PicEl::X()
{
 return Ref.x();
}

int PicEl::Y()
{
 return Ref.y();
}

QPoint PicEl::Pos()
{
 return Ref;
}

unsigned long int PicEl::GetLayer()
{
// printf("GetLayer mir=%d Ly=%x\n",Mir,Ly);
 if(Mir) return Layer->MirLy(Ly);
 return Ly;
}

unsigned long int PicEl::GetLayer(int m)
{
 if((Mir+m) & 1) return Layer->MirLy(Ly);
 return Ly;
}

void PicEl::SetLayer(unsigned long int L)
{
 if(Mir) Ly=Layer->MirLy(L);
 else Ly=L;
}

void PicEl::SetWidth(int w)
{
 wid=w;
 SetOutl();
}

int PicEl::GetWidth()
{
 return wid;
}

void PicEl::SetORect()
{
 SetOutl();
}


void PicEl::SetOutl()
{
}


void PicEl::CompRot(int rot,int* x,int* y,int mir)
{
 int t;
 int ro;
 ro=rot & 3;
 mir=mir &0x101;
 if (mir==0x001) *x=-(*x);
 if (ro==1){
  t=*x;
  *x=-*y;
  *y=t;
 }
 else if (ro==2){
  *x=-*x;
  *y=-*y;
 }
 else if (ro==3){
  t=*x;
  *x=*y;
  *y=-t;
 }
 if (mir==0x101) *x=-(*x);
}

QPoint PicEl::CompRot(int rot,const QPoint &p,int mir)
{
 int x1;
 int y1;
 x1=p.x();
 y1=p.y();
 CompRot(rot,&x1,&y1,mir);
 QPoint p1(x1,y1);
 return p1;
}

QRect PicEl::CompRot(int rot,const QRect & r,int mir)
{
 int x1;
 int y1;
 int x2;
 int y2;
 int t;
 QRect r1;

 r.getRect(&x1,&y1,&x2,&y2);
 x2=x2+x1;
 y2=y2+y1;

 CompRot(rot,&x1,&y1,mir);
 CompRot(rot,&x2,&y2,mir);

 if (x1>x2){
  t=x1;
  x1=x2;
  x2=t;
 }

 if (y1>y2){
  t=y1;
  y1=y2;
  y2=t;
 }

 x2=x2-x1;
 y2=y2-y1;

 r1.setRect(x1,y1,x2,y2);
 return r1;
}

void PicEl::TransPoly(QPainterPath & Po, int fl)
{
  int i;
  QPoint p;
  QPointF p1;
  if(fl){
    for(i=0;i<Po.elementCount();i++){
      p1=Po.elementAt(i);
      p=p1.toPoint();
      p-=Ref;
      CompRot(4-Rot,p,Mir+256);
      Po.setElementPositionAt(i, p.x(), p.y());
    }
  }
  else{
    for(i=0;i<Po.elementCount();i++){
      p1=Po.elementAt(i);
      p=p1.toPoint();
      p=CompRot(Rot,p,Mir);
      p+=Ref;
      Po.setElementPositionAt(i, p.x(), p.y());
    }
  }
}


void PicEl::GetORect(QRect* r)
{
 *r=R;
 *r=CompRot(Rot,*r,Mir);
 r->translate(Ref.x(),Ref.y());
}
/*
void PicEl::GetORect(int rot,QRect* r)
{
 *r=R;
 *r=CompRot(rot,*r,Mir);
 r->moveBy(Ref.x(),Ref.y());
}
*/
bool PicEl::IsLock(int /*l*/)
{
 return true;
}

Layers * PicEl::GetLayers()
{
 return Layer;
}

PicEl * PicEl::GetEl(int &iden,QPoint &p1,QPoint &p2,int &W,int &r,
                     int &/*Lo*/,QString &/*N*/,QPainterPath &/*Po*/,
		     unsigned long int L,bool &/*pad*/)
{
 unsigned long int L1=L;
 if(Mir) L1=Layer->MirLy(L);
 if((Ly & L1)==0) return NULL;
 p1.setX(R.left());
 p1.setY(R.top());
 p2.setX(R.right());
 p2.setY(R.bottom());
 p1=CompRot(Rot,p1,Mir);
 p1=p1+Ref;
 p2=CompRot(Rot,p2,Mir);
 p2=p2+Ref;
 W=wid;
 r=0;
 iden=GetIden();
 return this;
}

PicEl * PicEl::GetNextEl(int &/*iden*/,QPoint &/*p1*/,QPoint &/*p2*/,int &/*W*/,
                         int &/*r*/,int &/*Lo*/,QString &/*N*/,QPainterPath &/*Po*/,
			 unsigned long int /*L*/,bool &/*pad*/)
{
 return NULL;
}



void PicEl::Paint(QPainter* P,QRect* /*Rec*/,int /*flag*/,QColor* col,
                  int x,int y,int rot,int /*mir*/,bool /*HL*/)
{
 QPen pen;

 pen.setColor(*col);
 pen.setWidth(5);
 pen.setStyle(Qt::SolidLine);

 P->setPen(pen);
 P->drawLine(x,y,x-rot,y);
 P->setPen(Qt::red);
 P->drawLine(0,0,20,20);
}


void PicEl::TextSave(QTextStream * S, bool )
{
  *S << " : " << sSID[SID] << "\n";
//  *S << "    {ORect " << R.left()<< " " << R.top();
//  *S << " " << R.width() << " " << R.height() << " }\n";
  *S << "    {Pos " << Ref.x() << " " << Ref.y() << " }\n";
//  S->setf(QTextStream::showbase|QTextStream::hex);
  *S << "    {Ly ";
  unsigned long int t=1;
  do {
   if (t & Ly) {
    *S << " " << Layer->GetName(t);
   }
   t=t*2;
  } while(t>1);
  *S << " }\n";

//  S->unsetf(QTextStream::showbase|QTextStream::hex);
  *S << "    {Rot " << Rot << " }\n" ;
  *S << "    {Mir " << Mir << " }\n" ;
  *S << "    {Wd " << wid << " }\n" ;
}

void PicEl::TextLoad(QTextStream * S)
{
  QString s;
  QTextStream O(stdout,QIODevice::WriteOnly);
//  O << "Start Load\n";
  Sel=1;
  *S >> s;
  while (!s.contains('}') && !S->atEnd()){
//   O << " " << s << "\n";
   if (s.contains(":")){
    int i;
    QString s1;
    *S >> s1;
    for(i=0;i<kSIDEnd;i++){
     if (s1.contains(sSID[i])){
      SID=i;
      break;
     }
    }
   }
   else if (s.contains("Pos")){
    int x;
    *S >> x;
    Ref.setX(x);
    *S >> x;
    Ref.setY(x);
    TextLoadSkip(S);
   }
   else if (s.contains("Ly")){
    QString s1;
    *S >> s1;
    Ly=0;
    while(!s1.contains('}')){
      Ly=Ly|Layer->GetLy(&s1);
      *S >> s1;
    }
   }
   else if (s.contains("Rot")){
    *S >> Rot;
    TextLoadSkip(S);
   }
   else if (s.contains("Mir")){
    *S >> Mir;
    TextLoadSkip(S);
   }
   else if (s.contains("Wd")){
    *S >> wid;
    TextLoadSkip(S);
   }
   else if (s.contains("ORect")){
    TextLoadSkip(S);
   }
   else if (TLoadNext(S,&s));
   else if (s.contains("{") && s.length()==1){
    TextLoadSkip(S);
   }
   else {
    O << "Unknown section " << s << "\n";
    TextLoadSkip(S);
   }
   *S >> s;
  }
//  O << "End Load\n";
//  SetOutl();
}

void PicEl::TextLoadSkip(QTextStream * S)
{
  QString s;
  int i=1;
  do{
   *S >> s;
   i+=s.count('{');
   i-=s.count('}');
  } while (i>0);
}

QString PicEl::TextLoadStr(QTextStream * S)
{
  QString s,s1;
//  int i=1;
  *S >> s;
  while (!s.contains('}')) {
   s1+=s;
   s1+=" ";
   *S >> s;
  }
  return (s1.trimmed());
}

bool  PicEl::TLoadNext(QTextStream * /*S*/,QString* /*s*/)
{
 return false;
}

