/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef PicGrp_included
#define PicGrp_included

#include <QWidget>
//#include <qpntarry.h>
//Added by qt3to4:
#include <QTextStream>

class TreeListItem;

class QPainter;
class QPainterPath;
class QColor;




class PicGrp : public PicEl
{

public:

struct GrpEl {
  PicEl* E;
  int a;
  GrpEl* Next;
};


  PicGrp(Layers *L);
  virtual ~PicGrp();

  virtual int GetIden();

  void AddItem(PicEl* E);
  void AddItem(GrpEl* T);
  void DelItem(uint n);
  void SetItem(uint n,PicEl* E);
  PicEl* GetItem(uint n);
  void ListItem();

  virtual void AddTreeList(TreeListItem * LI);

  void AddLine(QPoint l1,QPoint l2,int Wid,QRect & r,bool cln=true);

  void Clean(int tol=1,unsigned long int L=AllLy);


  void MoveSelTo(int x, int y);
  void MoveSelBy(int x, int y);
  void MoveSelTo(QPoint p);
  void RotateSel(int rot, int x=0 ,int y=0);
  void MirrorSel(int x=0 ,int y=0);

  virtual void DeleteSel();

  virtual bool Select(QPoint p,int mode=0,int mir=0);

  virtual bool Select(QRect r,int mode=0,int mir=0);

  virtual bool Select(PicEl * E);

  virtual void DeSelect();
  virtual void SelInfo(int l=0);

  virtual void HLSel(int fl=0);
  virtual void HLOff();
  QString GetHLNet();
  QString GetHLComp();
  void SelNet(QString s);
  void SelComp(QString s);

  virtual int SelPoint(QPoint p,int tol=0,int mode=0,int mir=0);

  virtual void MovePointTo(QPoint p);
  virtual void MovePointBy(int x, int y);

  bool GetNearestPin(QPoint p,QPoint & p1,int tol,int mir=0);

  virtual bool GetInfo(QString & i,QPoint p,int mode=0,int mir=0);
  
  virtual QPoint GetSelPoint();

  virtual void GetSelORect(QRect* r);
  QPoint SelPos();
  int SelRot();
  PicEl * GetSel();
  PicEl * GetNextSel();

  void Sort();

  virtual void SubtractPoly(int &iden,QPoint &p1,QPoint &p2,int &W,int &r,
                       bool pad,QString &N,unsigned long int L);
  virtual void AddThermal(int &iden,QPoint &p1,QPoint &p2,int &W,int &r,
                       bool pad,QString &N,unsigned long int L);
  void ClearPoly();
  void RmClearPoly();
  void RmUnconnectPoly();

  virtual void TextSave(QTextStream * S, bool sel=false);
  void TextSaveNext(QTextStream * S, bool sel=false);

//  void LyChange();
  virtual void UpdORect(int mir=0);
  virtual void UpdSelORect(int mir=0);

  virtual bool IsLock(int l=0);
  void    SetLock(int L);

  GrpEl * GetData();
  void SetData(GrpEl * D);

  void SetDate(QString * Date,QString * FName,QString * Ver);

  virtual PicEl * GetEl(int &iden,QPoint &p1,QPoint &p2,int &W,int &r,
                        int &Lo,QString &N,QPainterPath &Po,unsigned long int L,bool &pad);
  virtual PicEl * GetNextEl(int &iden,QPoint &p1,QPoint &p2,int &W,int &r,
                            int &Lo,QString &N,QPainterPath &Po,unsigned long int L,bool &pad);

protected:

  virtual void Paint(QPainter* P,QRect* Rec,int flag,QColor* col,
                     int x,int y,int rot,int mir,bool HL);
  virtual void SetOutl();
  virtual bool  TLoadNext(QTextStream * S,QString* s);

private:

  uint   N;
  GrpEl * NS;

protected:

  GrpEl* Data;
  int Lock;

  GrpEl* AEl;

};

#endif
