/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "Global.h"
#include "PicEl.h"
#include "PicObj.h"
#include "Layers.h"
#include "Library.h"

#include <QPainter>
#include <QPen>
#include <QColor>
#include <QPolygonF>
#include <QList>

//#include <qpntarry.h>
//#include <qtstream.h>
//Added by qt3to4:
#include <QTextStream>

#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <unistd.h>
#include <math.h>
//#include <qfontmet.h>
#include <QFont>
#include <QFontInfo>

#define PI 3.141592

//extern Layers *Layer;
extern unsigned int gFlag;
extern Library gLib;

//-----------------------------------------------------------------------
/*
PicPolyLine::PicPolyLine(Layers *L)
 :PicEl(L)
{
}

PicPolyLine::~PicPolyLine()
{
}

int PicPolyLine::GetIden()
{
 return kPicPolyLine;
}


uint PicPolyLine::AddPoint(QPoint p)
{
 PA.resize(PA.size()+1);
 PA.setPoint(PA.size()-1,p);
 SetOutl();
 return(PA.size());
}

uint PicPolyLine::AddPoint(int x,int y)
{
 PA.resize(PA.size()+1);
 PA.setPoint(PA.size()-1,x,y);
 SetOutl();
 return(PA.size());
}

void PicPolyLine::SetPoint(QPoint p,uint n)
{
 if (n<PA.size()) PA.setPoint(n,p);
}

void PicPolyLine::SetPoint(int x,int y,uint n)
{
 if (n<PA.size()) PA.setPoint(n,x,y);
}

void PicPolyLine::DelPoint(uint n)
{
 uint i;
 if (n<PA.size()){
  for(i=n+1;i<PA.size();i++) PA.setPoint(i-1,PA.point(i));
  PA.resize(PA.size()-1);
 }
}

QPoint PicPolyLine::GetPoint(uint i) const
{
 return PA.point(i);
}

void PicPolyLine::SetOutl()
{
 R=PA.boundingRect();
 R.setWidth(R.width()+wid+1);
 R.setHeight(R.height()+wid+1);
 R.moveBy((-wid/2-1),(-wid/2-1));
}

void PicPolyLine::Paint(QPainter* P,QRect* Rec,int flag,QColor* col,int x,int y,int rot)
{
 QPen pen;
 QPoint nul(0,0);
 QPoint p(wid,1000);
 QPointArray a(PA);
 uint i;

 p=P->xForm(p);
 p-=P->xForm(nul);

 pen.setColor(*col);
 pen.setStyle(SolidLine);

 pen.setWidth(p.x());
 P->setBrush(NoBrush);
 P->setPen(pen);

 p.setX(x);
 p.setY(y);

 for(i=1;i<a.size();i++){
  P->drawLine(CompRot(rot,a.point(i-1))+p,CompRot(rot,a.point(i))+p);
 }

 QRect r(0,0,wid,wid);

 if(wid>1){
  P->setBrush(*col);
  P->setPen(*col);

  p.rx()--;
  p.ry()--;

  for(i=0;i<a.size();i++){
   r.moveCenter(CompRot(rot,a.point(i))+p);
   P->drawEllipse(r);
  }
 }

#ifdef ORectDEBUG
 r=R;
 r=CompRot(rot,r);
 r.moveBy(x,y);
 P->setBrush(NoBrush);
 P->setPen(black);
 P->drawRect(r);
#endif
}

void PicPolyLine::TextSave(QTextStream * S)
{
  PicEl::TextSave(S);
  uint i;
  *S << "    {XY \n";
  for(i=0;i<PA.size();i++){
    *S << " " << PA.point(i).x() << " " << PA.point(i).y() << "\n";
  }
  *S << "    }\n";
  *S << "   }\n";

}


bool  PicPolyLine::TLoadNext(QTextStream * S,QString* s)
{
 int x;
 int y;
 QString s1;

   if (s->contains("XY")){
   *S >> s1;
   while(!s1.contains('}')){
    x=s1.toInt();
    *S >> y;
    AddPoint(x,y);
    *S >> s1;
   }
  } else  return false;
 return true;
}
*/
//-----------------------------------------------------------------------

PicLine::PicLine(Layers *L)
 :PicEl(L)
{
}

PicLine::~PicLine()
{
}

int PicLine::GetIden()
{
 return kPicLine;
}

QPoint PicLine::GetBegin()
{
 QPoint p=Beg;
 p=CompRot(Rot,p,Mir);
 p+=Ref;
 return p;
}

QPoint PicLine::GetEnd()
{
 QPoint p=En;
 p=CompRot(Rot,p,Mir);
 p+=Ref;
 return p;
}

void PicLine::Begin(QPoint p)
{
 p-=Ref;
 Beg=CompRot(4-Rot,p,Mir+256);
// Beg=p;
// SetOutl();
}

void PicLine::Begin(int x,int y)
{
 QPoint p;
 p.setX(x);
 p.setY(y);
 Begin(p);
}

void PicLine::End(QPoint p)
{
 p-=Ref;
 En=CompRot(4-Rot,p,Mir+256);
// En=p;
// SetOutl();
}

void PicLine::End(int x,int y)
{
 QPoint p;
 p.setX(x);
 p.setY(y);
 End(p);
}

bool PicLine::IsX(QPoint A,QPoint B)
{
 return(IsX(A.x(),A.y(),B.x(),B.y()));
}

bool PicLine::IsX(int Ax,int Ay,int Bx,int By)
{
 Ax-=Ref.x();
 Ay-=Ref.y();
 Bx-=Ref.x();
 By-=Ref.y();
 CompRot(4-Rot,&Ax,&Ay,Mir+256);
 CompRot(4-Rot,&Bx,&By,Mir+256);

 double x;
 double y;

 int Cx=Beg.x();
 int Cy=Beg.y();
 int Dx=En.x();
 int Dy=En.y();

 if((Ax==Cx && Ay==Cy) || (Bx==Cx && By==Cy) ||
    (Ax==Dx && Ay==Dy) || (Bx==Dx && By==Dy)) return true;

 x=Ax-Cx;
 y=Ay-Cy;
 if((x*x+y*y)<=(double)wid*wid/4) return true;
 x=Ax-Dx;
 y=Ay-Dy;
 if((x*x+y*y)<=(double)wid*wid/4) return true;
 x=Bx-Cx;
 y=By-Cy;
 if((x*x+y*y)<=(double)wid*wid/4) return true;
 x=Bx-Dx;
 y=By-Dy;
 if((x*x+y*y)<=(double)wid*wid/4) return true;

 double t;
 double t1=((double)(Cy-Ay)*(double)(Bx-Ax)+(double)(Ax-Cx)*(double)(By-Ay))/
              ((double)(Dx-Cx)*(double)(By-Ay)-(double)(Dy-Cy)*(double)(Bx-Ax));
 if (Bx-Ax) t=(double)(Cx-Ax+t1*(Dx-Cx))/(double)(Bx-Ax);
 else t=(double)(Cy-Ay+t1*(Dy-Cy))/(double)(By-Ay);

 if (t1>=-0.0001 && t1<=1.0001 && t>=-0.0001 && t<=1.0001) return true;
 return false;
}

QPoint PicLine::XPoint(QPoint A,QPoint B)
{
 return(XPoint(A.x(),A.y(),B.x(),B.y()));
}

QPoint PicLine::XPoint(int /*Ax*/,int /*Ay*/,int /*Bx*/,int /*By*/)
{
 QPoint p(0,0);
 return p;
}

bool PicLine::IsConnect(PicLine *L,int tol)
{
 QPoint p;
 QPoint B=L->GetBegin();
 QPoint E=L->GetEnd();
 B-=Ref;
 E-=Ref;
 B=CompRot(4-Rot,B,Mir+256);
 E=CompRot(4-Rot,E,Mir+256);

 p=B-Beg;
 if(((double)p.x()*p.x()+p.y()*p.y())<=(double)tol) return true;
 p=B-En;
 if(((double)p.x()*p.x()+p.y()*p.y())<=(double)tol) return true;
 p=E-Beg;
 if(((double)p.x()*p.x()+p.y()*p.y())<=(double)tol) return true;
 p=E-En;
 if(((double)p.x()*p.x()+p.y()*p.y())<=(double)tol) return true;

 return false;
}


bool PicLine::IsConnect(QPoint p,int tol)
{
 QRect r;
 p=p-Ref;
 p=CompRot((4-Rot),p,Mir+256);
 r.setRect(p.x()-tol,p.y()-tol,tol*2,tol*2);
 if (R.intersects(r)){
  double k;
  QPoint s;
  QPoint p1;
  s=En-Beg;
  p1=p-Beg;
  k=((double)p1.x()*(double)s.x()+(double)p1.y()*(double)s.y())/
    ((double)s.x()*(double)s.x()+(double)s.y()*(double)s.y());
  p1=Beg-p+(s*k);
  if ((double)(p1.x()*p1.x()+p1.y()*p1.y())<(double)tol+(double)wid*wid/4) return true;
 }
 return false;
}

bool PicLine::IsConnect(QRect r,int /*tol*/)
{
 QRect r1(r);
 r1.translate(-Ref.x(),-Ref.y());
 r1=CompRot(4-Rot,r1,Mir+256);
 if(r1.contains(R)) return true;
 if(IsX(r.left(),r.top(),r.right(),r.top()) ||
    IsX(r.left(),r.top(),r.left(),r.bottom()) ||
    IsX(r.right(),r.top(),r.right(),r.bottom()) ||
    IsX(r.left(),r.bottom(),r.right(),r.bottom())) return true;
 return false;
}

int PicLine::GetLen()
{
  QPoint s;
  s=En-Beg;
  return sqrt((long long)s.x()*s.x()+(long long)s.y()*s.y());  
}

bool PicLine::GetInfo(QString & i,QPoint p,int mode,int mir)
{
  if ((mode != kSelActOnly) || Layer->IsAct(GetLayer(mir))){
   p=p-Ref;
   p=CompRot((4-Rot),p,Mir+256);
   if (R.contains(p) && Layer->IsVis(GetLayer(mir))){
    double k;
    QPoint s;
    QPoint p1;
    s=En-Beg;
    p1=p-Beg;
    k=((double)p1.x()*(double)s.x()+(double)p1.y()*(double)s.y())/
      ((double)s.x()*(double)s.x()+(double)s.y()*(double)s.y());
    p1=Beg-p+(s*k);
    if (((double)p1.x()*p1.x()+p1.y()*p1.y())<(((double)wid+2)*(wid+2)/4)){
     i.sprintf("Line len=%3.0f angle=%3.1f",
          sqrt((long long)s.x()*s.x()+(long long)s.y()*s.y()),
          180*atan2(abs(s.y()),abs(s.x()))/3.141592);
     return true;
    }
   }
  }
  return false;
}

bool PicLine::Select(QPoint p,int mode,int mir)
{
 if ((mode != kSelActOnly) || Layer->IsAct(GetLayer(mir))){
  p=p-Ref;
  p=CompRot((4-Rot),p,Mir+256);
  if (R.contains(p) && Layer->IsVis(GetLayer(mir))){
   double k;
   QPoint s;
   QPoint p1;
   s=En-Beg;
   p1=p-Beg;
   k=((double)p1.x()*(double)s.x()+(double)p1.y()*(double)s.y())/
     ((double)s.x()*(double)s.x()+(double)s.y()*(double)s.y());
   p1=Beg-p+(s*k);
   if ((double)(p1.x()*p1.x()+p1.y()*p1.y())<(((double)wid+2)*(wid+2)/4)){
    Sel=1;
    return true;
   }
  }
 }
 Sel=0;
 return false;
}

bool PicLine::Select(QRect r,int mode,int mir)
{
 bool xx=PicEl::Select(r,mode,mir);
 if (xx && (mode/256)==kSelBPart){
  QRect r1(r);
  r1.translate(-Ref.x(),-Ref.y());
  r1=CompRot(4-Rot,r1,Mir+256);
  if(r1.contains(R)) return true;
  if(IsX(r.left(),r.top(),r.right(),r.top()) ||
     IsX(r.left(),r.top(),r.left(),r.bottom()) ||
     IsX(r.right(),r.top(),r.right(),r.bottom()) ||
     IsX(r.left(),r.bottom(),r.right(),r.bottom())) return true;
  Sel=0;
  return false;
 }
 else return xx;
}

int PicLine::SelPoint(QPoint p,int tol,int mode,int mir)
{
 if(Sel && !SelP) return -1;
 if(Layer->IsVis(GetLayer(mir)) && 
    (mode!=kSelActOnly || Layer->IsAct(GetLayer(mir)))){
  p=p-Ref;
  p=CompRot((4-Rot),p,Mir+256);
  QPoint p1;
  long long int xb;
  long long int xe;
  p1=p-Beg;
  xb=(long long)p1.x()*p1.x()+(long long)p1.y()*p1.y();
  p1=p-En;
  xe=(long long)p1.x()*p1.x()+(long long)p1.y()*p1.y();
  if (xb<tol || xe<tol){
//    printf("Line %d %d\n",xb,xe);
   if (xb<xe){
    Sel=1;
    if (SelP==2) SelP=0;
    else SelP=1;
    return xb;
   } else {
    Sel=1;
    if (SelP==1) SelP=0;
    else SelP=2;
    return xe;
   }
  }
 }
 return -1;
}

bool PicLine::SelPoint(QRect r,int mode,int mir)
{
 if(Layer->IsVis(GetLayer(mir)) 
     && (mode!=kSelActOnly || Layer->IsAct(GetLayer(mir)))){
/*  if(r.contains(Beg) && r.contains(En)){
   Sel=1;
   SelP=0;
   return true;
  }  */
  if(r.contains(Beg)){
   Sel=1;
   if(!r.contains(En)) SelP=1;
   else SelP=0;
   return true;
  }
  if(r.contains(En)){
   Sel=1;
   SelP=2;
   return true;
  }
 }
 return false;
}

void PicLine::SelPBeg()
{
 SelP=1;
}
void PicLine::SelPEnd()
{
 SelP=2;
}


QPoint PicLine::GetSelPoint()
{
 if(SelP==1) return CompRot(Rot,Beg,Mir)+Ref;
 else return CompRot(Rot,En,Mir)+Ref;
}


void PicLine::MovePointTo(QPoint p)
{
 if(Sel && SelP){
  p=p-Ref;
  p=CompRot((4-Rot),p,Mir+256);
  if (SelP==1){
   Beg=p;
  } else {
   En=p;
  }
//  SetOutl();
 }
}

void PicLine::MovePointBy(int x, int y)
{
 CompRot(4-Rot,&x,&y,Mir+256);
 QPoint p(x,y);

 if(Sel && SelP){
  if (SelP==1){
   Beg+=p;
  } else {
   En+=p;
  }
//  SetOutl();
 }
}


PicEl* PicLine::GetEl(int &iden,QPoint &p1,QPoint &p2,int &W,int &r,
                    int &/*Lo*/,QString &/*N*/,QPainterPath &/*Po*/,unsigned long int L,
		    bool &/*pad*/)
{
 if(Mir) L=Layer->MirLy(L);
 if((Ly & L)==0) return NULL;
 p1=Beg;
 p2=En;
 p1=CompRot(Rot,p1,Mir);
 p1=p1+Ref;
 p2=CompRot(Rot,p2,Mir);
 p2=p2+Ref;
 W=wid;
 r=0;
 iden=GetIden();
 return this;
}


void PicLine::SetOutl()
{
 R.setCoords(Beg.x(),Beg.y(),En.x(),En.y());
 R=R.normalized();
 R.setWidth(R.width()+wid+1);
 R.setHeight(R.height()+wid+1);
 R.translate((-wid/2-1),(-wid/2-1));
}

void PicLine::Paint(QPainter* P,QRect* /*Rec*/,int flag,QColor* col,
                    int x,int y,int rot,int mir,bool /*HL*/)
{
 QPen pen;
// QPoint nul(0,0);
 QPoint p(x,y);
// uint i;

// p=P->xForm(p);
// p-=P->xForm(nul);

 pen.setColor(*col);
 pen.setStyle(Qt::SolidLine);
 pen.setCapStyle(Qt::RoundCap);
 if(wid==0) pen.setWidth(1);
 else pen.setWidth(wid);
// i=p.x();
// if(i<1) pen.setWidth(1);
 P->setBrush(Qt::NoBrush);
 P->setPen(pen);
// p.setX(x);
// p.setY(y);

  if(!(flag & kDrawDummy)) P->drawLine(CompRot(rot,Beg,mir)+p,CompRot(rot,En,mir)+p);

  if(Sel && SelP && (P->deviceMatrix().m11()>0.05)){
    int dx=Beg.x()-En.x();
    int dy=Beg.y()-En.y();
    if(dx<0) dx=-dx;
    if(dy<0) dy=-dy;
    if((((dx-dy)<3)&&((dx-dy)>-3)) || ((dx>-3)&&(dx<3)) || ((dy>-3)&&(dy<3))){
      P->setPen(Qt::black);
      pen.setWidth(0);
      P->drawLine(CompRot(rot,Beg,mir)+p,CompRot(rot,En,mir)+p);
    }  
  }
/* QRect r(0,0,wid,wid);

 if(i>4){
  P->setBrush(*col);
  P->setPen(*col);

  p.rx()--;
  p.ry()--;

  r.moveCenter(CompRot(rot,Beg,mir)+p);
  P->drawEllipse(r);
  r.moveCenter(CompRot(rot,En,mir)+p);
  P->drawEllipse(r);
 }
*/

#ifdef ORectDEBUG
 QRect r;
 r=R;
 r=CompRot(rot,r,mir);
 r.translate(x,y);
 P->setBrush(Qt::NoBrush);
 P->setPen(Qt::black);
 P->drawRect(r);
#endif
}

void PicLine::TextSave(QTextStream * S, bool sel)
{
  PicEl::TextSave(S,sel);
  *S << "    {XY ";
   *S << " " << Beg.x() << " " << Beg.y();
   *S << " " << En.x() << " " << En.y();
  *S << " }\n";
  *S << "   }\n";

}


bool  PicLine::TLoadNext(QTextStream * S,QString* s)
{
 int x;
 int y;
 QString s1;

   if (s->contains("XY")){
   *S >> x;
   *S >> y;
   Beg.setX(x);
   Beg.setY(y);
   *S >> x;
   *S >> y;
   En.setX(x);
   En.setY(y);
   TextLoadSkip(S);
  } else  return false;
 return true;
}


//-----------------------------------------------------------------------

PicRect::PicRect(Layers *L)
 :PicEl(L)
{
}

PicRect::~PicRect()
{
}

int PicRect::GetIden()
{
 return kPicRect;
}

void PicRect::Rect(int x,int y,int wd,int hg)
{
 Re.setRect(x,y,wd,hg);
 Re=Re.normalized();
// SetOutl();
}

void PicRect::Rect(QRect re)
{
 Re=re;
// SetOutl();
}

void PicRect::GetRect(int *x,int *y,int *wd,int *hg)
{
 Re.getRect(x,y,wd,hg);
}


void PicRect::SetOutl()
{
 if(wid>1000){
  R.setRect(-1+Re.left(),
           -1+Re.top(),Re.width()+2,Re.height()+2);
 } else {
  R.setRect(-wid/2-1+Re.left(),
           -wid/2-1+Re.top(),Re.width()+wid+2,Re.height()+wid+2);
 }
}

bool PicRect::GetInfo(QString & i,QPoint p,int mode,int mir)
{
  if(wid>=1000){
    if(PicEl::GetInfo(i,p,mode,mir)){
      i="Rect";
      return true;
    }
    return false;
  }
  if ((mode != kSelActOnly) || Layer->IsAct(GetLayer(mir))){
    p=p-Ref;
    p=CompRot((4-Rot),p,Mir+256);
    if (Layer->IsVis(GetLayer(mir))){
      if(((p.x()==Re.left()) || (p.x()==Re.right()+1)) && ((p.y()>Re.top()) && (p.y()<Re.bottom()))){
        i="Rect";
	return true;
      }
      if(((p.y()==Re.top()) || (p.y()==Re.bottom()+1)) && ((p.x()>Re.left()) && (p.x()<Re.right()))){
        i="Rect";
	return true;
      }
    }
  }
  return false;
}

bool PicRect::Select(QPoint p,int mode,int mir)
{
 if(wid>=1000) return PicEl::Select(p,mode,mir);
 
 if ((mode != kSelActOnly) || Layer->IsAct(GetLayer(mir))){
  p=p-Ref;
  p=CompRot((4-Rot),p,Mir+256);
  if (Layer->IsVis(GetLayer(mir))){
//   printf("SelRect x=%d y=%d  t=%d b=%d l=%d r=%d\n",
//           p.x(),p.y(),Re.top(),Re.bottom(),Re.left(),Re.right());
   if(((p.x()==Re.left()) || (p.x()==Re.right()+1)) && ((p.y()>Re.top()) && (p.y()<Re.bottom()))){
    Sel=1;
    return true;
   }
   if(((p.y()==Re.top()) || (p.y()==Re.bottom()+1)) && ((p.x()>Re.left()) && (p.x()<Re.right()))){
    Sel=1;
    return true;
   } 
  }
  Sel=0;
  return false;
 }
 return false;
}

int PicRect::SelPoint(QPoint p,int tol,int mode,int mir)
{
 if(Layer->IsVis(GetLayer(mir)) 
    && (mode!=kSelActOnly || Layer->IsAct(GetLayer(mir)))){
  long long int x1;
  long long int x2;
  long long int x3;
  long long int x4;
  p=p-Ref;
  p=CompRot((4-Rot),p,Mir+256);
  x1=((long long)p.x()-Re.left())*(p.x()-Re.left())+((long long)p.y()-Re.top())*(p.y()-Re.top());
  x2=((long long)p.x()-Re.right())*(p.x()-Re.right())+((long long)p.y()-Re.top())*(p.y()-Re.top());
  x3=((long long)p.x()-Re.left())*(p.x()-Re.left())+((long long)p.y()-Re.bottom())*(p.y()-Re.bottom());
  x4=((long long)p.x()-Re.right())*(p.x()-Re.right())+((long long)p.y()-Re.bottom())*(p.y()-Re.bottom());
  if (x1<tol || x2<tol || x3<tol || x4<tol){
   printf("Rect SelP L=%d R=%d T=%d B=%d X=%d Y=%d x1=%lld x2=%lld x3=%lld x4=%lld\n",
          Re.left(),Re.right(),Re.top(),Re.bottom(),p.x(),p.y(),x1,x2,x3,x4);
//    printf("Rect %d %d %d %d\n",x1,x2,x3,x4);
   if (x1<x2 && x1<x3 && x1<x4){
    Sel=1;
    SelP=1;
    return x1;
   }
   else if (x2<x1 && x2<x3 && x2<x4){
    Sel=1;
    SelP=2;
    return x2;
   }
   else if (x3<x1 && x3<x2 && x3<x4){
    Sel=1;
    SelP=3;
    return x3;
   }
   else {
    Sel=1;
    SelP=4;
    return x4;
   }
  }
 }
 return -1;
}

void PicRect::MovePointTo(QPoint p)
{
 if(Sel && SelP){
  p=p-Ref;
  p=CompRot((4-Rot),p,Mir+256);
  if (SelP==1){
   Re.setLeft(p.x());
   Re.setTop(p.y());
  }
  else if (SelP==2){
   Re.setRight(p.x());
   Re.setTop(p.y());
  }
  else if (SelP==3){
   Re.setLeft(p.x());
   Re.setBottom(p.y());
  }
  else if (SelP==4){
   Re.setRight(p.x());
   Re.setBottom(p.y());
  }
  if(Re.top()>Re.bottom()){
   SelP=SelP+2;
   if(SelP>4) SelP=SelP-4;
  }
  if(Re.left()>Re.right()){
   SelP=((SelP-1) ^ 1)+1;
  }
  Re=Re.normalized();
//  SetOutl();
 }
}

void PicRect::MovePointBy(int x, int y)
{
 CompRot(4-Rot,&x,&y,Mir+256);
 QPoint p1(x,y);
 if(Sel && SelP){
  if (SelP==1){
   Re.setLeft(Re.left()+p1.x());
   Re.setTop(Re.top()+p1.y());
  }
  else if (SelP==2){
   Re.setRight(Re.right()+p1.x());
   Re.setTop(Re.top()+p1.y());
  }
  else if (SelP==3){
   Re.setLeft(Re.left()+p1.x());
   Re.setBottom(Re.bottom()+p1.y());
  }
  else if (SelP==4){
   Re.setRight(Re.right()+p1.x());
   Re.setBottom(Re.bottom()+p1.y());
  }
//  SetOutl();
 }
}


PicEl * PicRect::GetEl(int &iden,QPoint &p1,QPoint &p2,int &W,int &r,
                       int &/*Lo*/,QString &/*N*/,QPainterPath &/*Po*/,
		       unsigned long int L,bool &/*pad*/)
{
 if(Mir) L=Layer->MirLy(L);
 if((Ly & L)==0) return NULL;
 p1.setX(Re.left());
 p1.setY(Re.top());
 p2.setX(Re.right());
 p2.setY(Re.bottom());
 p1=CompRot(Rot,p1,Mir);
 p1=p1+Ref;
 p2=CompRot(Rot,p2,Mir);
 p2=p2+Ref;
 W=wid;
 r=0;
 iden=GetIden();
 return this;
}


void PicRect::Paint(QPainter* P,QRect* /*Rec*/,int flag,QColor* col,
                    int x,int y,int rot,int mir,bool /*HL*/)
{
 QPen pen;
// QPoint nul(0,0);
// QPoint p(wid,1000);
 QRect r(Re);

// p=P->xForm(p);
// p-=P->xForm(nul);

 pen.setColor(*col);
 pen.setStyle(Qt::SolidLine);

 if(wid<=1000){
  if(wid==0) pen.setWidth(1);
  else pen.setWidth(wid);
  P->setBrush(Qt::NoBrush);
 } else {
  P->setBrush(*col);
  pen.setWidth(0);
 }
 P->setPen(pen);
 r=CompRot(rot,r,mir);
 r.translate(x,y);
 if(!(flag & kDrawDummy)) P->drawRect(r);
#ifdef ORectDEBUG
 r=R;
 r=CompRot(rot,r,mir);
 r.translate(x,y);
 P->setPen(Qt::black);
 P->setBrush(Qt::NoBrush);
 P->drawRect(r);
#endif
}

void PicRect::TextSave(QTextStream * S, bool sel)
{
  PicEl::TextSave(S,sel);
  *S << "    {Rect " << Re.left()<< " " << Re.top();
  *S << " " << Re.width() << " " << Re.height() << " }\n";
  *S << "   }\n";
}


bool  PicRect::TLoadNext(QTextStream * S,QString* s)
{
 if (s->contains("Rect")){
  int x;
  int y;
  int w;
  int h;
  *S >> x;
  *S >> y;
  *S >> w;
  *S >> h;
  Re.setRect(x,y,w,h);
  TextLoadSkip(S);
 } else  return false;
 return true;
}


//-----------------------------------------------------------------------

PicCir::PicCir(Layers *L)
 :PicEl(L)
{
 BegA=0;
 LenA=0;
 ActA=0;
 StpA=0;

}

PicCir::~PicCir()
{
}

int PicCir::GetIden()
{
 return kPicCir;
}

void PicCir::Rect(int x,int y,int wd,int hg)
{
 Re.setRect(x,y,wd,hg);
// SetOutl();
}

void PicCir::Rect(QRect re)
{
 Re=re;
// SetOutl();
}

void PicCir::SetR(int r)
{
 int x=((Re.left()+Re.right())/2-r);
 int y=((Re.top()+Re.bottom())/2-r);
 Re.setRect(x,y,r*2,r*2);
}

void PicCir::Center(int x,int y)
{
 QPoint p(x,y);
 Re.moveCenter(p);
}

void PicCir::Center(QPoint p)
{
 p-=Ref;
 p=CompRot(4-Rot,p,Mir+256);
 Re.moveCenter(p);
}

int PicCir::GetR()
{
 return Re.width()/2;
}


QPoint PicCir::GetCenter()
{
 QPoint p((Re.left()+Re.right())/2,(Re.top()+Re.bottom())/2);
 p=CompRot(Rot,p,Mir);
 p+=Ref;
 return p;
}


void PicCir::Circle(QPoint p,int r)
{
 p-=Ref;
 p=CompRot(4-Rot,p,Mir+256);
 Re.setRect(p.x()-r,p.y()-r,r*2,r*2);
}
void PicCir::Circle(int x,int y,int r)
{
 QPoint p(x,y);
 Circle (p,r);
}

void PicCir::SetBegA(int a)
{
 BegA=a;
}

void PicCir::SetLenA(int a)
{
 LenA=a;
}

void PicCir::SetArc(int a,int l)
{
 BegA=a;
 LenA=l;
}

void PicCir::SelPBeg()
{
 SelP=2;
}
void PicCir::SelPEnd()
{
 SelP=3;
}
void PicCir::SelPR()
{
 SelP=1;
}


bool PicCir::GetInfo(QString & i,QPoint p,int mode,int mir)
{
  if(PicEl::GetInfo(i,p,mode,mir)){
    p=p-Ref;
    p=CompRot((4-Rot),p,Mir+256);
    double r=(Re.right()-Re.left())/2;
    double d;
    QPoint p1((Re.left()+Re.right())/2,(Re.top()+Re.bottom())/2);
    p1=p-p1;
    d=sqrt((double)p1.x()*p1.x()+(double)p1.y()*p1.y());
    if((d>(r-wid/2)) && (d<(r+wid/2))){
      if(LenA==0){
	i.sprintf("Circle r=%3.1f",r);
	return true;
      }	
      else{
         int a=(int)(2880*atan2(p1.y(),p1.x())/PI);
//         printf("SelRect a=%d BegA=%d LenA=%d EndA=%d\n",
//           a,BegA,LenA,BegA+LenA);
         if((a>BegA) && (a<(BegA+LenA))){
	   i.sprintf("Arc r=%3.1f",r);
	   return true;
	 }
	 a+=360*16;
         if((a>BegA) && (a<(BegA+LenA))){
	   i.sprintf("Arc r=%3.1f",r);
	   return true;
	 }
      }
    }
  }
  return false;
}

void PicCir::SetOutl()
{
 if(wid>1000){
  R.setRect(-1+Re.left(),
           -1+Re.top(),Re.width()+2,Re.height()+2);
 } else {
   if(LenA==0){
     R.setRect(-wid/2-1+Re.left(),
           -wid/2-1+Re.top(),Re.width()+wid+1,Re.height()+wid+1);
   }
   else{
     double r=(Re.right()-Re.left())/2;
     QPoint p1((Re.left()+Re.right())/2,(Re.top()+Re.bottom())/2);
     int x,y;
     int xmin,xmax,ymin,ymax;
     int i;
     xmin=(int)(p1.x()+cos((double)BegA*3.141592/2880)*r);
     ymin=(int)(p1.y()+sin((double)BegA*3.141592/2880)*r);
     xmax=xmin;
     ymax=ymin;
     x=(int)(p1.x()+cos((double)(BegA+LenA)*3.141592/2880)*r);
     y=(int)(p1.y()+sin((double)(BegA+LenA)*3.141592/2880)*r);
     if(x<xmin) xmin=x;
     if(y<ymin) ymin=y;
     if(x>xmax) xmax=x;
     if(y>ymax) ymax=y;
     for(i=0;i<8*90*16;i+=90*16){
       if((i>BegA)&&(i<(BegA+LenA))){
	 x=(int)(p1.x()+cos((double)i*3.141592/2880)*r);
	 y=(int)(p1.y()+sin((double)i*3.141592/2880)*r);
	 if(x<xmin) xmin=x;
	 if(y<ymin) ymin=y;
	 if(x>xmax) xmax=x;
	 if(y>ymax) ymax=y;
       }
     }
     R.setRect(-wid/2-1+xmin,
           -wid/2-1+ymin,(xmax-xmin)+wid+1,(ymax-ymin)+wid+1);
   }
 }
}


bool PicCir::Select(QPoint p,int mode,int mir)
{
 if(wid>=1000){
   return PicEl::Select(p,mode,mir);
 }
 
 if ((mode != kSelActOnly) || Layer->IsAct(GetLayer(mir))){
  p=p-Ref;
  p=CompRot((4-Rot),p,Mir+256);
  if (Layer->IsVis(GetLayer(mir))){
//   printf("SelRect x=%d y=%d  t=%d b=%d l=%d r=%d\n",
//           p.x(),p.y(),Re.top(),Re.bottom(),Re.left(),Re.right());
    double r=(Re.right()-Re.left())/2;
    double d;
    QPoint p1((Re.left()+Re.right())/2,(Re.top()+Re.bottom())/2);
    p1=p-p1;
    d=sqrt((double)p1.x()*p1.x()+(double)p1.y()*p1.y());
    if((d>(r-wid/2)) && (d<(r+wid/2))){
      if(LenA==0){
        Sel=1;
        return true;
      }	
      else{
         int a=(int)(2880*atan2(p1.y(),p1.x())/PI);
         printf("SelRect a=%d BegA=%d LenA=%d EndA=%d\n",
           a,BegA,LenA,BegA+LenA);
         if((a>BegA) && (a<(BegA+LenA))){
           Sel=1;
           return true;
	 }
	 a+=360*16;
         if((a>BegA) && (a<(BegA+LenA))){
           Sel=1;
           return true;
	 }
      }
    }
  }
  Sel=0;
  return false;
 }
 return false;
}


int PicCir::SelPoint(QPoint p,int tol,int mode,int mir)
{
 if(Layer->IsVis(GetLayer(mir)) && 
    (mode!=kSelActOnly || Layer->IsAct(GetLayer(mir)))){
  QPoint p1((Re.left()+Re.right())/2,(Re.top()+Re.bottom())/2);
  long long int xb;
//  long long int xe;
//  double rp;
  p=p-Ref;
  p=CompRot((4-Rot),p,Mir+256);
  if(LenA){
   QPoint b;
   QPoint e;
   double r=(Re.right()-Re.left())/2;
   b.setX((int)(p1.x()+cos((double)BegA*3.141592/2880)*r));
   b.setY((int)(p1.y()+sin((double)BegA*3.141592/2880)*r));
   e.setX((int)(p1.x()+cos((double)(BegA+LenA)*3.141592/2880)*r));
   e.setY((int)(p1.y()+sin((double)(BegA+LenA)*3.141592/2880)*r));
   e=e-p;
   b=b-p;
   xb=(long long)b.x()*b.x()+(long long)b.y()*b.y();
   if(xb<tol) {
    PS=p;
    SelP=2;
    Sel=1;
    return xb;
   }
   xb=(long long)e.x()*e.x()+(long long)e.y()*e.y();
   if(xb<tol) {
    PS=p;
    SelP=3;
    Sel=1;
    return xb;
   }
  }
/*  p1=p-p1;
  xb=(long long)p1.x()*p1.x()+(long long)p1.y()*p1.y();
  rp=sqrt(xb)/(Re.width()/2);
  xe=(long long int)sqrt(xb);
  xb=(long long)(Re.width()/2-xe)*(Re.width()/2-xe);
  QPoint pc((Re.left()+Re.right())/2,(Re.top()+Re.bottom())/2);
  p1=p-pc;
  xe=(long long)p1.x()*p1.x()+(long long)p1.y()*p1.y();
  if (xb<tol || xe<tol){
   Sel=1;
   if (xb<xe) {
//    PS=p;
//    printf("PicCir : %d %d \n",PS.x(),PS.y());

    PS.setX((int)(p1.x()/rp)+pc.x());
    PS.setY((int)(p1.y()/rp)+pc.y());
    SelP=1;
    return xb;
   }
   SelP=4;
   printf("Cir SelP4 x1=%d x2=%d tol=%d xe=%lld\n",p.x(),pc.x(),tol,xe);
   return xe;
  } */
 }
 return -1;
}

QPoint PicCir::GetSelPoint()
{
 if(Sel && SelP==4){
  return GetCenter();
 }
 QPoint p(PS);
 p=CompRot(Rot,p,Mir);
 p+=Ref;
 return p;
}


void PicCir::MovePointTo(QPoint p)
{
 if(Sel && SelP){
  if(SelP<4){
   QPoint p1((Re.left()+Re.right())/2,(Re.top()+Re.bottom())/2);
   long long xb;
   long long xe;
   p=p-Ref;
   p=CompRot((4-Rot),p,Mir+256);
   if (SelP==1){
    p1=p-p1;
    xb=(long long)p1.x()*p1.x()+(long long)p1.y()*p1.y();
    xe=(int)sqrt(xb);
    SetR(xe);
//    SetOutl();
   }
   else if(SelP==2){
    p1=p-p1;
    BegA=(int)(2880*atan2(p1.y(),p1.x())/PI);
   }
   else if(SelP==3){
    p1=p-p1;
    int fi=(int)(2880*atan2(p1.y(),p1.x())/PI);
    LenA=fi-BegA;
    if (LenA<0) LenA+=5760;
   }
  }
  else{
   p=p-Ref;
   p=CompRot((4-Rot),p,Mir+256);
   MoveTo(p);
  }
 }
}

void PicCir::MovePointBy(int x, int y)
{
 if(SelP==4){
  MoveBy(x,y);
 }
 else{
  QPoint p(x,y);
  PS=PS+p;
  p=PS;
  p=CompRot(Rot,p,Mir);
  p+=Ref;
  MovePointTo(p);
 }
}

PicEl * PicCir::GetEl(int &iden,QPoint &p1,QPoint &p2,int &W,int &r,
                      int &/*Lo*/,QString &/*N*/,QPainterPath &/*Po*/,unsigned long int L,
		      bool &/*pad*/)
{
 if(Mir) L=Layer->MirLy(L);
 if((Ly & L)==0) return NULL;
 if(LenA){
   QPoint b;
   QPoint e;
   double r1=(Re.right()-Re.left())/2;
   QPoint p((Re.left()+Re.right())/2,(Re.top()+Re.bottom())/2);
   ActA=BegA;
   StpA=160;
   if(r1<1000) StpA=480;
   if(r1>10000) StpA=40;
   b.setX((int)(cos((double)ActA*3.141592/2880)*r1));
   b.setY((int)(sin((double)ActA*3.141592/2880)*r1));
   ActA+=StpA;
   if(ActA>(BegA+LenA)){
     ActA=BegA+LenA;
     StpA=0;
   }
   e.setX((int)(cos((double)ActA*3.141592/2880)*r1));
   e.setY((int)(sin((double)ActA*3.141592/2880)*r1));
   p1=p+b;
   p2=p+e;
   p1=CompRot(Rot,p1,Mir);
   p1=p1+Ref;
   p2=CompRot(Rot,p2,Mir);
   p2=p2+Ref;
   W=wid;
   r=0;
   iden=kPicLine;
   return this;   
 }
 else{
   StpA=0;
   p1=GetCenter();
   W=wid;
   r=Re.width()/2;
   iden=GetIden();
   return this;
 }  
}

PicEl * PicCir::GetNextEl(int &iden,QPoint &p1,QPoint &p2,int &W,int &r,
                      int &/*Lo*/,QString &/*N*/,QPainterPath &/*Po*/,unsigned long int L,
		      bool &/*pad*/)
{
 if(StpA==0) return NULL;
 if(Mir) L=Layer->MirLy(L);
 if((Ly & L)==0) return NULL;

 QPoint b;
 QPoint e;
 double r1=(Re.right()-Re.left())/2;
 QPoint p((Re.left()+Re.right())/2,(Re.top()+Re.bottom())/2);
 b.setX((int)(cos((double)ActA*3.141592/2880)*r1));
 b.setY((int)(sin((double)ActA*3.141592/2880)*r1));
 ActA+=StpA;
 if(ActA>(BegA+LenA)){
   ActA=BegA+LenA;
   StpA=0;
 }
 e.setX((int)(cos((double)ActA*3.141592/2880)*r1));
 e.setY((int)(sin((double)ActA*3.141592/2880)*r1));
 p1=p+b;
 p2=p+e;
 p1=CompRot(Rot,p1,Mir);
 p1=p1+Ref;
 p2=CompRot(Rot,p2,Mir);
 p2=p2+Ref;
 W=wid;
 r=0;
 iden=kPicLine;
 return this;   
}


void PicCir::Paint(QPainter* P,QRect* /*Rec*/,int flag,QColor* col,
                   int x,int y,int rot,int mir,bool /*HL*/)
{
 QPen pen;
// QPoint nul(0,0);
// QPoint p(wid,1000);
 QRect r(Re);

// p=P->xForm(p);
// p-=P->xForm(nul);

 pen.setColor(*col);
 pen.setStyle(Qt::SolidLine);

 if(wid<=1000){
  if(wid==0) pen.setWidth(1);
  else pen.setWidth(wid);
  P->setBrush(Qt::NoBrush);
 } else {
  P->setBrush(*col);
  pen.setWidth(0);
 }
 P->setPen(pen);
 r=CompRot(rot,r,mir);
 r.translate(x,y);

 if(LenA){
  int b;
  int e;
  if (mir){
   b=180*16+BegA-rot*90*16;
   e=LenA;
  }
  else{
   b=-BegA-rot*90*16;
   e=-LenA;
  }
  if(!(flag & kDrawDummy)){
    if (wid>=2000)   P->drawPie(r,b,e);
    else if (wid>=1000)   P->drawChord(r,b,e);
    else P->drawArc(r,b,e);
  }  
 }
 else   if(!(flag & kDrawDummy)) P->drawEllipse(r);
#ifdef ORectDEBUG
 r=R;
 r=CompRot(rot,r,mir);
 r.translate(x,y);
 P->setPen(Qt::black);
 P->setBrush(Qt::NoBrush);
 P->drawRect(r);
#endif
}

void PicCir::TextSave(QTextStream * S, bool sel)
{
  PicEl::TextSave(S,sel);
  *S << "    {Circ " << Re.left()<< " " << Re.top();
  *S << " " << Re.width() << " " << Re.height() << " }\n";
  if(LenA) *S << "    {Angle " << BegA << " " << LenA << " }\n";
  *S << "   }\n";
}

bool  PicCir::TLoadNext(QTextStream * S,QString* s)
{
 if (s->contains("Angle")){
  *S >> BegA;
  *S >> LenA;
  TextLoadSkip(S);
 }
 else if (s->contains("Circ")){
  int x;
  int y;
  int w;
  int h;
  *S >> x;
  *S >> y;
  *S >> w;
  *S >> h;
  Re.setRect(x,y,w,h);
  TextLoadSkip(S);
 } else  return false;
 return true;
}

//----------------------------------------------------------------------------

PicText::PicText(Layers *L)
 :PicEl(L)
{
 HorAl=1;
 VerAl=1;
 Text=NULL;
 TxO=NULL;
 Font.setRawMode(false);
}

PicText::~PicText()
{
 if(Text && X) delete Text;
 if(TxO && X) delete TxO;
}

int PicText::GetIden()
{
 return kPicText;
}

void PicText::SetText(QString s)
{
 if (Text==NULL){
  Text=new QString(s);
  X=true;
 }
 else *Text=s;
// SetOutl();
}

void PicText::SetText(QString * s)
{
 if (X && Text!=NULL) delete Text;
 Text=s;
 X=false;
// SetOutl();
}

void PicText::SText(QString * s)
{
 if(s){
  if(TxO) delete TxO;
  TxO=Text;
  Text=s;
  X=false;
 }
 else{
  if (TxO){
   Text=TxO;
   TxO=NULL;
   X=true;
  }
 }
// SetOutl();
}


QString PicText::GetText()
{
 if (Text){
  return *Text;
 }
 else {
  QString s="";
  return s;
 }
}

void PicText::SetFont(QFont F)
{
 Font=F;
// Font.setCharSet(QFont::AnyCharSet);
// SetOutl();
}


QFont PicText::GetFont()
{
 return Font;
}

void PicText::SetAlig(int h,int v)
{
 VerAl=v;
 HorAl=h;
// SetOutl();
}

void PicText::GetAlig(int *h,int *v)
{
 *v=VerAl;
 *h=HorAl;
}

PicEl* PicText::GetEl(int &iden,QPoint &p1,QPoint &p2,int &W,int &r,
                    int &Lo,QString &N,QPainterPath &Po,unsigned long int L,bool &pad)
{
  PicEl * E=PicEl::GetEl(iden,p1,p2,W,r,Lo,N,Po,L,pad);
  if(E){
    N=*Text;
    p1.setX(R.left());
    p1.setY(R.top()*3/4);
    p2.setX(R.right());
    p2.setY(R.bottom()*3/4);
    p1=CompRot(Rot,p1,Mir);
    p1=p1+Ref;
    p2=CompRot(Rot,p2,Mir);
    p2=p2+Ref;

    W=Font.pointSize();
  }  
//  W=0;
//  printf("PicText::GetEl\n");
  return E;
}

bool PicText::GetInfo(QString & i,QPoint p,int mode,int mir)
{
  if(PicEl::GetInfo(i,p,mode,mir)){
    i="Txt:";
    i+=Text;
    return true;
  }
  return false;
}

void PicText::SetOutl()
{
 if (Text){
  QFontMetrics FM(Font);
  if (Text->contains(0x5c)){
//   printf("SetOutl:  %s contains \\ \n",(const char *)*Text);
   QString s1=*Text;
   s1.remove('\\');
   R=FM.boundingRect(s1);
  }
  else{
   R=FM.boundingRect(*Text);
  }
  R.setHeight(Font.pointSize()+12);
  int x;
  int y;
  if (HorAl==AligLeft){
   x=R.left();
  }
  else if (HorAl==AligCenter){
   x=(R.left()+R.right())/2;
  }
  else{
   x=R.right();
  }
  if (VerAl==AligTop){
   y=R.top();
  }
  else if (VerAl==AligCenter){
   y=(R.top()+R.bottom())/2;
  }
  else{
   y=R.bottom();
  }
  R.translate(-x,-y);
  R.setRect(R.left()-2-Font.pointSize()/10,2+R.top(),R.width()+4+Font.pointSize()/5,R.height()+4);
 }
}




void PicText::TextSave(QTextStream * S, bool sel)
{
  PicEl::TextSave(S,sel);
  *S << "    {Text " << *Text << " }\n";
  *S << "    {Font \042" << Font.family() << "\042 " << Font.pointSize() << " ";
  *S << Font.bold() << " " << Font.italic() << " ";
//  *S << Font.charSet() << " }\n";
  *S << "ISO" << " }\n";
  *S << "    {Alig " << HorAl << " " << VerAl << " }\n";
  *S << "   }\n";
}

bool  PicText::TLoadNext(QTextStream * S,QString* s)
{
// char s1[20];
 if (s->contains("Text")){
  if(Text==NULL) Text=new QString();
  *Text=TextLoadStr(S);
  X=true;
 }
 else if (s->contains("Font")){
  char s1[50];
  char s2[50];
  int x;
  int x1;
  *S >> s1;
  if(s1[0]=='"'){
   x=1;
   x1=0;
   do{
    while(s1[x] && s1[x]!='"'){
     s2[x1]=s1[x];
     x++;
     x1++;
    }
    if(!s1[x]){
     s2[x1]=' ';
     x1++;
     *S >> s1;
     x=0;
    }
   }while (s1[x]!='"');
   s2[x1]=0;
   Font.setFamily(s2);
  }
  else{
   Font.setFamily(s1);
  }
  *S >> x;
  Font.setPointSize(x);
  *S >> x;
  Font.setBold(x);
  *S >> x;
  Font.setItalic(x);
//  Font.setCharSet(QFont::AnyCharSet);

  TextLoadSkip(S);
//  QFontInfo FI(Font);
//  printf("SetFont %s",FI.family());
//  printf(" size %d \n",FI.pointSize());
//  printf("IsRaw %d \n",Font.rawMode());

 }
 else if (s->contains("Alig")){
  *S >> HorAl;
  *S >> VerAl;

  TextLoadSkip(S);
 }
 else  return false;
 return true;
}

void PicText::Paint(QPainter* P,QRect* /*Rec*/,int flag,QColor* col,
                    int x,int y,int rot,int mir,bool /*HL*/)
{
 if (Text){
  QPen pen;
//  QPoint nul(0,0);
  QPoint p(x,y);
  QRect r(R);

  int t;
  float sc=P->deviceMatrix().m11();
  t=Font.pointSize();
  if(t<=0) t=Font.pixelSize();
  if((sc*t<4) && (flag & kDrawFast)) return;

/*  QPoint p1(2,1000);

  p1=P->xForm(p1);
*/
  pen.setColor(*col);
  pen.setStyle(Qt::SolidLine);

  pen.setWidth(2);
  P->setBrush(Qt::NoBrush);
  P->setPen(pen);

  P->setFont(Font);
  if(flag & kDrawMirrorTxt){
   if(mir){
    t=r.left();
    r.setLeft(-r.right());
    r.setRight(-t);
   }

  // r=CompRot(rot,r);
   if(rot==1 || rot==2){
    t=r.left();
    r.setLeft(-r.right());
    r.setRight(-t);
    t=r.top();
    r.setTop(-r.bottom());
    r.setBottom(-t);
    rot=(rot+2)&3;
   }

   p=CompRot(4-rot,p,0);
   r.translate(p.x(),p.y());

   P->save();
   P->rotate(rot*90);
  }
  else{

   P->save();

   P->translate(x,y);
   P->rotate(rot*90);
   if(mir) P->scale(-1,1);
  }

  if (Text->contains(0x5c)){
//   printf("  %s contains \\ \n",(const char *)*Text);
   int i;
   QString s1="";
   int b,e;
   b=-1;
   e=-1;
   for(i=0;i<Text->length();i++){
    if((*Text)[i].toLatin1()=='\\'){
     if(b==-1){
      b=s1.length()-1;
     }
     e=s1.length();
    }
    else{
     s1+=(*Text)[i];
    }
   }
   if(!(flag & kDrawDummy)) P->drawText(r,Qt::AlignCenter,s1);
   i=r.width()/s1.length();
   if(!(flag & kDrawDummy)) P->drawLine(r.left()+b*i,r.top()+3,r.left()+e*i,r.top()+3);
  }
  else   if(!(flag & kDrawDummy)) P->drawText(r,Qt::AlignCenter,*Text);

  if (Text->length()<1){
   P->setPen(Qt::black);
   P->setBrush(Qt::NoBrush);
   P->drawRect(r);
  }

 #ifdef ORectDEBUG
  P->setPen(Qt::black);
  P->setBrush(Qt::NoBrush);
  P->drawRect(r);
 #endif

  P->restore();

// r=R;
// r=CompRot(rot,r,mir);
// r.moveBy(x,y);
// P->setPen(red);
// P->setBrush(NoBrush);
// P->drawRect(r);


 }
}

//----------------------------------------------------------------------------

PicPower::PicPower(Layers *L)
 :PicEl(L)
{
 Text="";
 Font.setRawMode(false);
 Type=0;
}

PicPower::~PicPower()
{
}

int PicPower::GetIden()
{
 return kPicPower;
}

void PicPower::SetText(QString s)
{
 Text=s;
// SetOutl();
}

QString PicPower::GetText()
{
  return Text;
}

void PicPower::SetFont(QFont F)
{
 Font=F;
// Font.setCharSet(QFont::AnyCharSet);
// SetOutl();
}

void PicPower::SetType(int t)
{
  Type=t;
}

int PicPower::GetType()
{
  return Type;
}


QFont PicPower::GetFont()
{
 return Font;
}

bool PicPower::GetInfo(QString & i,QPoint p,int mode,int mir)
{
  if(PicEl::GetInfo(i,p,mode,mir)){
    i="Pwr:";
    i+=Text;
    return true;
  }
  return false;
}

void PicPower::SetOutl()
{
  QFontMetrics FM(Font);
  int x;
  int y;

  R=FM.boundingRect(Text);
  if(Rot & 1){
   x=R.height();
   R.setHeight(R.width()+25*wid/2);
   R.setWidth(x);

   if(R.width()<20*wid/2) R.setWidth(20*wid/2);
  }
  else {
   R.setHeight(R.height()+25*wid/2);
   if(R.width()<40*wid/2) R.setWidth(40*wid/2);
  }
  x=(R.left()+R.right())/2;
  y=R.top();
  R.translate(-x,-y);
  R.setRect(-3+R.left(),-2+R.top(),R.width()+6,R.height()+4);
}


void PicPower::TextSave(QTextStream * S, bool sel)
{
  PicEl::TextSave(S,sel);
  *S << "    {Text " << Text << " }\n";
  *S << "    {Font \042" << Font.family() << "\042 " << Font.pointSize() << " ";
  *S << Font.bold() << " " << Font.italic() << " }\n";
  *S << "    {Type " << Type << " }\n";
  *S << "   }\n";
}

bool  PicPower::TLoadNext(QTextStream * S,QString* s)
{
 if (s->contains("Text")){
  Text=TextLoadStr(S);
 }
 else if (s->contains("Type")){
  int x;
  *S >> x;
  Type=x;
  TextLoadSkip(S);
 }
 else if (s->contains("Font")){
  char s1[50];
  char s2[50];
  int x;
  int x1;
  *S >> s1;
  if(s1[0]=='"'){
   x=1;
   x1=0;
   do{
    while(s1[x] && s1[x]!='"'){
     s2[x1]=s1[x];
     x++;
     x1++;
    }
    if(!s1[x]){
     s2[x1]=' ';
     x1++;
     *S >> s1;
     x=0;
    }
   }while (s1[x]!='"');
   s2[x1]=0;
   Font.setFamily(s2);
  }
  else{
   Font.setFamily(s1);
  }
  *S >> x;
  Font.setPointSize(x);
  *S >> x;
  Font.setBold(x);
  *S >> x;
  Font.setItalic(x);
//  Font.setCharSet(QFont::AnyCharSet);

  TextLoadSkip(S);
//  QFontInfo FI(Font);
//  printf("SetFont %s",FI.family());
//  printf(" size %d \n",FI.pointSize());
//  printf("IsRaw %d \n",Font.rawMode());

 }
 else  return false;
 return true;
}

void PicPower::Paint(QPainter* P,QRect* /*Rec*/,int flag,QColor* col,
                    int x,int y,int rot,int mir,bool /*HL*/)
{
  QPen pen;
//  QPoint nul(0,0);
  QPoint p(x,y);
  QRect r(R);
  int x1,y1,y2;
//  int rot1=rot;

  int t;

//  QPoint p1(wid,1000);

//  p1=P->xForm(p1);

  pen.setColor(*col);
  pen.setStyle(Qt::SolidLine);

  if(wid==0) pen.setWidth(1);
  else pen.setWidth(wid);
  P->setBrush(Qt::NoBrush);
  P->setPen(pen);

  P->setFont(Font);

  if(mir){
   t=r.left();
   r.setLeft(-r.right());
   r.setRight(-t);
  }
  r.setTop(r.top()+23*wid/2);

 // r=CompRot(rot,r);
  if(rot==1){
   t=r.left();
   r.setLeft(-r.bottom());
   r.setBottom(r.right());
   r.setRight(-r.top());
   r.setTop(t);
  }
  else if(rot==2){
   t=r.left();
   r.setLeft(-r.right());
   r.setRight(-t);
   t=r.top();
   r.setTop(-r.bottom());
   r.setBottom(-t);
//   rot1=(rot+2)&3;
  }
  else if(rot==3){
   t=r.left();
   r.setLeft(r.top());
   r.setTop(-r.right());
   r.setRight(r.bottom());
   r.setBottom(-t);
  }

//  p=CompRot(4-rot1,p,0);
  r.translate(p.x(),p.y());

  P->save();

  x1=p.x();
  y1=p.y();

  if(!(flag & kDrawDummy)){
    if(Type==PwrTypeBar){
     if(rot==0){
      y2=p.y()+20*wid/2;
      P->drawLine(x1,y1,x1,y2);
      P->drawLine(x1-20*wid/2,y2,x1+20*wid/2,y2);
     }
     else if(rot==1){
      P->drawLine(x1,y1,x1-20*wid/2,y1);
      P->drawLine(x1-20*wid/2,y1-10*wid/2,x1-20*wid/2,y1+10*wid/2);
     }
     else if(rot==2){
      y2=p.y()-20*wid/2;
      P->drawLine(x1,y1,x1,y2);
      P->drawLine(x1-20*wid/2,y2,x1+20*wid/2,y2);
     }
     else {
      P->drawLine(x1,y1,x1+20*wid/2,y1);
      P->drawLine(x1+20*wid/2,y1-10*wid/2,x1+20*wid/2,y1+10*wid/2);
     }
    }
    if(Type==PwrTypeArrow){
     if(rot==0){
      y2=p.y()+20*wid/2;
      P->drawLine(x1,y1,x1,y2);
      P->drawLine(x1-5*wid,y2-5*wid,x1,y2);
      P->drawLine(x1+5*wid,y2-5*wid,x1,y2);
     }
     else if(rot==1){
      P->drawLine(x1,y1,x1-10*wid,y1);
      P->drawLine(x1-5*wid,y1-5*wid,x1-10*wid,y1);
      P->drawLine(x1-5*wid,y1+5*wid,x1-10*wid,y1);
     }
     else if(rot==2){
      y2=p.y()-20*wid/2;
      P->drawLine(x1,y1,x1,y2);
      P->drawLine(x1-5*wid,y2+5*wid,x1,y2);
      P->drawLine(x1+5*wid,y2+5*wid,x1,y2);
     }
     else {
      P->drawLine(x1,y1,x1+10*wid,y1);
      P->drawLine(x1+5*wid,y1-5*wid,x1+10*wid,y1);
      P->drawLine(x1+5*wid,y1+5*wid,x1+10*wid,y1);
     }
    }
    else if(Type==PwrTypeCircle){
     if(rot==0){
      y2=p.y()+10*wid/2;
      P->drawLine(x1,y1,x1,y2);
      P->drawEllipse(x1-5*wid/2,y2,10*wid/2,10*wid/2);
     }
     else if(rot==1){
      P->drawLine(x1,y1,x1-10*wid/2,y1);
      P->drawEllipse(x1-20*wid/2,y1-5*wid/2,10*wid/2,10*wid/2);
     }
     else if(rot==2){
      y2=p.y()-10*wid/2;
      P->drawLine(x1,y1,x1,y2);
      P->drawEllipse(x1-5*wid/2,y2-10*wid/2,10*wid/2,10*wid/2);
     }
     else {
      P->drawLine(x1,y1,x1+10*wid/2,y1);
      P->drawEllipse(x1+10*wid/2,y1-5*wid/2,10*wid/2,10*wid/2);
     }
    }
    else {
     if(rot==0){
      y2=p.y()+20*wid/2;
      P->drawLine(x1,y1,x1,y2);
     }
     else if(rot==1){
      P->drawLine(x1,y1,x1-20*wid/2,y1);
     }
     else if(rot==2){
      y2=p.y()-20*wid/2;
      P->drawLine(x1,y1,x1,y2);
     }
     else {
      P->drawLine(x1,y1,x1+20*wid/2,y1);
     }
    }

  //  P->rotate(rot1*90);


    P->drawText(r,Qt::AlignCenter,Text);
  }  

  if (Text.length()<1){
   P->setPen(Qt::black);
   P->setBrush(Qt::NoBrush);
   P->drawRect(r);
  }

//  P->setPen(Qt::black);
//  P->setBrush(Qt::NoBrush);
//  P->drawRect(r);

  P->restore();

 #ifdef ORectDEBUG
  r=R;
  r=CompRot(rot,r,mir);
  r.translate(x,y);
  P->setBrush(Qt::NoBrush);
  P->setPen(Qt::black);
  P->drawRect(r);
 #endif



}

//----------------------------------------------------------------------------

PicPoly::PicPoly(Layers *L)
 :PicEl(L)
{
  PolySIdx=0;
  PolyClr=NULL;
  PolyAct=NULL;
}

PicPoly::~PicPoly()
{
  PolyLst * PL;
  while(PolyClr){
    PL=PolyClr->Next;
    delete PolyClr;
    PolyClr=PL;
  }
}

int PicPoly::GetIden()
{
 return kPicPoly;
}

void PicPoly::SetNet(QString net)
{
  Net=net;
}

void PicPoly::SetClr(int clr)
{
  Clr=clr;
}

QString PicPoly::GetNet()
{
  return Net;
}

int PicPoly::GetClr()
{
  return Clr;
}

bool PicPoly::GetInfo(QString & info,QPoint p,int mode,int mir)
{
  if ((mode != kSelActOnly) || Layer->IsAct(GetLayer(mir))){
    p=p-Ref;
    p=CompRot((4-Rot),p,Mir+256);
    if (R.contains(p) && Layer->IsVis(GetLayer(mir))){
      double k;
      QPointF s;
      QPointF p1;
      int i;
      for(i=0;i<Poly.elementCount()-1;i++){
        if(Poly.elementAt(i+1).isLineTo()){
	  s=Poly.elementAt(i+1)-Poly.elementAt(i);
	  p1=p-Poly.elementAt(i);
	  k=((double)p1.x()*(double)s.x()+(double)p1.y()*(double)s.y())/
	    ((double)s.x()*(double)s.x()+(double)s.y()*(double)s.y());
	  p1=Poly.elementAt(i)-p+(s*k);
	  if((((long long)p1.x()*p1.x()+(long long)p1.y()*p1.y())<((wid+2)*(wid+2)/4)) &&
	     (k>=0) && (k<=1)){
	   info="Poly";
	   if(PolyClr) info+=" clr";
	   return true;
	  }
	}
      }
    }
  }
  return false;
}

bool PicPoly::Select(QPoint p,int mode,int mir)
{
  if ((mode != kSelActOnly) || Layer->IsAct(GetLayer(mir))){
    p=p-Ref;
    p=CompRot((4-Rot),p,Mir+256);
    if (R.contains(p) && Layer->IsVis(GetLayer(mir))){
//      if(Poly.containsPoint(p,Qt::OddEvenFill)){
//        Sel=1;
//        return true;
//      }
      double k;
      QPointF s;
      QPointF p1;
      int i;
      for(i=0;i<Poly.elementCount()-1;i++){
        if(Poly.elementAt(i+1).isLineTo()){
	  s=Poly.elementAt(i+1)-Poly.elementAt(i);
	  p1=p-Poly.elementAt(i);
	  k=((double)p1.x()*(double)s.x()+(double)p1.y()*(double)s.y())/
	    ((double)s.x()*(double)s.x()+(double)s.y()*(double)s.y());
	  p1=Poly.elementAt(i)-p+(s*k);
	  if((((long long)p1.x()*p1.x()+(long long)p1.y()*p1.y())<((wid+2)*(wid+2)/4)) &&
	     (k>=0) && (k<=1)){
	   Sel=1;
	   return true;
	  }
	}  
      }
    }
    Sel=0;
    return false;
  }
  return false;
}

int PicPoly::IsConnect(QPoint p,int tol)
{
  p=p-Ref;
  p=CompRot((4-Rot),p,Mir+256);
  if(PolyClr){
    PolyLst * PL=PolyClr;
    while(PL){
      if(PL->P.contains(p)){
        if(PL->CN){
	  PL->C=true;
	  return PL->CN;
	}  
	else return 1;
      }
      PL=PL->Next;
    }
  }
  else{
    if((tol>3) && Poly.contains(p)) return 1;
    return 0;
  }
  return 0;
}

int PicPoly::IsConnect(QPainterPath Po,int /* tol */)
{
  QPainterPath P1;
  TransPoly(Po,1);
  if(PolyClr){
    PolyLst * PL=PolyClr;
    while(PL){
      P1=PL->P.intersected(Po);
      if(!P1.isEmpty()){
        if(PL->CN){
	  PL->C=true;
	  return PL->CN;
	}  
	else return 1;
      }
      PL=PL->Next;
    }
  }  
/*  else{
    P1=Poly.intersected(Po);  
    return !P1.isEmpty();
  }*/
  return 0;
}

int PicPoly::SetCN(int start)
{
  PolyLst * PL=PolyClr;
  int i=start;
  while(PL){
    PL->CN=i;
    PL->C=false;
    i++;
    PL=PL->Next;
  }
  return i;
}

void PicPoly::ChangeCN(int from,int to)
{
  PolyLst * PL=PolyClr;
  while(PL){
    if(PL->CN==from) PL->CN=to;
    PL=PL->Next;
  }
}

void PicPoly::RmUnconnect()
{
  PolyLst * PL=PolyClr;
  PolyLst * PL1=NULL;
  
  while(PL){
    if(!PL->C){
      if(PL1) PL1->Next=PL->Next;
      else PolyClr=PL->Next;
      delete PL;
      if(PL1) PL=PL1->Next;
      else PL=PolyClr;
    }
    else{
      PL1=PL;
      PL=PL->Next;
    }
  }
  PolyAct=NULL;
}

int PicPoly::SelPoint(QPoint p,int tol,int mode,int mir)
{
  if(Sel && !SelP) return -1;
  if(Layer->IsVis(GetLayer(mir)) && 
     (mode!=kSelActOnly || Layer->IsAct(GetLayer(mir)))){
    p=p-Ref;
    p=CompRot((4-Rot),p,Mir+256);
    QPointF p1;
    long long xb;
    int i;

    for(i=0;i<Poly.elementCount();i++){
      p1=p-Poly.elementAt(i);
      xb=(long long)p1.x()*p1.x()+(long long)p1.y()*p1.y();
      if (xb<tol){
	Sel=1;
	SelP=i+1;
	return xb;
      }
    }
  }
  return -1;
}

void PicPoly::MovePointTo(QPoint p)
{
  if(Sel && SelP){
    p=p-Ref;
    p=CompRot((4-Rot),p,Mir+256);
    Poly.setElementPositionAt(SelP-1, p.x(), p.y());
  }
}

void PicPoly::MovePointBy(int x, int y)
{
  CompRot(4-Rot,&x,&y,Mir+256);
  QPointF p(x,y);

  if(Sel && SelP){
    p+=Poly.elementAt(SelP-1);
    Poly.setElementPositionAt(SelP-1, p.x(), p.y());
  }
}

void PicPoly::AddSelPoint(bool ins)
{
  printf("AddSelPoint c=%d ins=%d",Poly.elementCount(),ins);
  if(Sel && SelP && ins){
//    Poly.insert(SelP-1,QPoint(0,0));  !!!!!!!!!!!!
  }
  else{
    Sel=1;
    if(Poly.elementCount()==0) Poly.moveTo(QPoint(0,0));
    Poly.lineTo(QPoint(1,1));
    SelP=Poly.elementCount();
  }
  printf(" e=%d SelP=%d\n",Poly.elementCount(),SelP);
}

void PicPoly::AddPoint(int x, int y)
{
  if(Poly.elementCount()>0) Poly.lineTo(QPoint(x,y));
  else Poly.moveTo(QPoint(x,y));
}

bool PicPoly::CleanSplited()
{
  return true;
}

void PicPoly::RmClear()
{
  PolyLst * PL;
  while(PolyClr){
    PL=PolyClr->Next;
    delete PolyClr;
    PolyClr=PL;
  }
  PolyClr=NULL;
  PolyAct=NULL;
}


bool PicPoly::Clean()
{
  int i;
  QPointF p;
//  int x=0;
  QPainterPath Po;
  
  if(PolyClr) return CleanSplited();

  if(!PolyS[0].isEmpty()){
    for(i=0;i<NumPolyS;i++){
      if(!PolyS[i].isEmpty()){
	printf("Clean Poly subtract %d\n",i);
	if(Po.isEmpty()) Po=Poly.subtracted(PolyS[i]);
	else Po=Po.subtracted(PolyS[i]);
	printf("Clean Poly subtract OK\n");
	QPainterPath Em;
	PolyS[i]=Em;
      }
    }
    PolySIdx=0;
    int s=Clr*Clr*2;
    if(s>(wid*wid*2)) s=wid*wid*2;

//    i=0;
//    while(FindSubPoly(Po,i,j)){
//      if(!CleanSubPoly(Po,i,j,s)) i++;
//    }

    Po=Po.simplified();

//    i=0;
//    while(FindSubPoly(Po,i,j)){
//      if(!CleanSubPoly(Po,i,j,s)) i++;
//    }

    SplitSubPoly(Po);

    printf("Poly size %d\n",Po.elementCount());
  }

  Poly=Poly.simplified();

  if(Poly.elementCount()<3) return false;
  return true;
}

void PicPoly::SetOutl()
{
  R=Poly.boundingRect().toRect();

  R.setWidth(R.width()+4+wid);
  R.setHeight(R.height()+4+wid);
  R.translate(-2-wid/2,-2-wid/2);
}


QPainterPath PicPoly::GetPoly()
{
  QPainterPath Po;
  QPointF p;
  int i;
  if(PolyClr){
    if(PolyAct) PolyAct=PolyAct->Next;
    else PolyAct=PolyClr;
    if(PolyAct){
      for(i=0;i<PolyAct->P.elementCount();i++){
	p=PolyAct->P.elementAt(i);
	p=CompRot(Rot,p.toPoint(),Mir);
	p+=Ref;
	if(PolyAct->P.elementAt(i).isLineTo()) Po.lineTo(p);
	else Po.moveTo(p);
      }
    }
  }
  else{
    for(i=0;i<Poly.elementCount();i++){
      p=Poly.elementAt(i);
      p=CompRot(Rot,p.toPoint(),Mir);
      p+=Ref;
      if(Poly.elementAt(i).isLineTo()) Po.lineTo(p);
      else Po.moveTo(p);
    }
  }
  return Po;
}

int PicPoly::ContainsPoint(QPoint p)
{
  int i=0;
  PolyLst * PL=PolyClr;
  while(PL){
    if(PL->P.contains(p)){
      return i;
    }
    i++;
    PL=PL->Next;
  }
  return -1;
}

void PicPoly::AddThermal(int n,QPainterPath & Po)
{
  if(n<NumPolyS){
    PolyS[n]=PolyS[n].united(Po);
  }
  else{
    int i=0;
    PolyLst * PL=PolyClr;
    while(PL){
      if(i==n){
        PL->P=PL->P.united(Po);
	return;
      }
      PL=PL->Next;
      i++;
    }
  }
}
  
int Sin[]={267,731,1000,1000,731,267,
          -267,-731,-1000,-1000,-731,-267,
           267,731,1000,1000,731,267};

int Sin24[]={132,386,614,800,932,1000,
             1000,932,800,614,386,132,
	     -132,-386,-614,-800,-932,-1000,
	     -1000,-932,-800,-614,-386,-132,
	     132,386,614,800,932,1000,
	     1000,932,800,614,386,132};

int Sin4[]={0,1000,0,-1000,0,1000,0,-1000};

void PicPoly::AddThermal(int &iden,QPoint &p1o,QPoint &p2o,int &W,int &r,
                       bool pad,QString &N,unsigned long int Lo)
{
  int x1,x2,x3;
  int y1,y2,y3;
  int i=0;
  int clr=Clr+wid/2;
  int wd=4;
  
  int n;

  QPoint p1;
  QPoint p2;
  unsigned long int L=Lo;

//  printf("Add Thermal Pad=0\n");

  
  if(!pad){
    PolyLst * PL=PolyClr;
    for(i=0;i<NumPolyS;i++){
      if(!PolyS[i].isEmpty() && PL){
	printf("AddThermal %d %d\n",i,PolyS[i].elementCount());
	PL->P=PL->P.united(PolyS[i]);
	QPainterPath Em;
	PolyS[i]=Em;
      }
      if(PL) PL=PL->Next;
    }
    PolySIdx=0;
    PL=PolyClr;
    while(PL){
//      MinPoly(PL->P);
      PL=PL->Next;
    }
    return;
  }

  if(gLib.GetThPat(-1)==0) return;
 
//  printf("Add Thermal 1 Net=%s\n",N.ascii());

  if(Mir) L=Layer->MirLy(L);
  if((Ly & L)==0) return;

  p1=p1o-Ref;
  p1=CompRot((4-Rot),p1,Mir+256);
  p2=p2o-Ref;
  p2=CompRot((4-Rot),p2,Mir+256);

  if(iden==kPicCir){
    i+=r;
    p2=p1;
  }
  if(W<1000) i+=W/2+1;

  Poly.boundingRect().toRect().normalized().getCoords(&x1,&y1,&x2,&y2);
  if((p1.x()<(x1-i)) && (p2.x()<(x1-i))) return;
  if((p1.x()>(x2+i)) && (p2.x()>(x2+i))) return;
  if((p1.y()<(y1-i)) && (p2.y()<(y1-i))) return;
  if((p1.y()>(y2+i)) && (p2.y()>(y2+i))) return;

/*  if(PolyS[PolySIdx].elementCount()>700){
    printf("Poly::subtract I=%d size=%d pad=%d\n",PolySIdx,PolyS[PolySIdx].elementCount(),pad);
    PolySIdx++;
  }  
  if(PolySIdx==NumPolyS) PolySIdx=0;
*/
  if(iden==kPicRect){
    if(p1.x()<p2.x()){
      x1=p1.x();
      x2=p2.x();
    }
    else{
      x1=p2.x();
      x2=p1.x();
    }  
    if(p1.y()<p2.y()){
      y1=p1.y();
      y2=p2.y();
    }
    else{
      y1=p2.y();
      y2=p1.y();
    }
    if(W<1000){
      x1-=W/2;
      y1-=W/2;
      x2+=W/2;
      y2+=W/2;
    } 
    x1-=clr;
    y1-=clr;
    x2+=clr;
    y2+=clr;
    if(N==Net){
//      printf("Add Thermal 2 %d %d %d %d\n",x1,y1,x2,y2);

      n=ContainsPoint(QPoint(x1-2,(y1+y2)/2));
      if(n>=0){
        QPainterPath Po;
        Po.moveTo(x1,(y1+y2+wd)/2);
        Po.lineTo(x1,(y1+y2-wd)/2);
        Po.lineTo((x1+x2+wd)/2,(y1+y2-wd)/2);
        Po.lineTo((x1+x2+wd)/2,(y1+y2+wd)/2);
        Po.lineTo(x1,(y1+y2+wd)/2);
	AddThermal(n,Po);
      }
      n=ContainsPoint(QPoint(x2+2,(y1+y2)/2));
      if(n>=0){
        QPainterPath Po;
        Po.moveTo(x2,(y1+y2+wd)/2);
        Po.lineTo(x2,(y1+y2-wd)/2);
        Po.lineTo((x1+x2-wd)/2,(y1+y2-wd)/2);
        Po.lineTo((x1+x2-wd)/2,(y1+y2+wd)/2);
        Po.lineTo(x2,(y1+y2+wd)/2);
	AddThermal(n,Po);
      }

      n=ContainsPoint(QPoint((x1+x2)/2,y1-2));
      if(n>=0){
        QPainterPath Po;
        Po.moveTo((x1+x2+wd)/2,y1);
        Po.lineTo((x1+x2-wd)/2,y1);
        Po.lineTo((x1+x2-wd)/2,(y1+y2+wd)/2);
        Po.lineTo((x1+x2+wd)/2,(y1+y2+wd)/2);
        Po.lineTo((x1+x2+wd)/2,y1);
	AddThermal(n,Po);
      }
      n=ContainsPoint(QPoint((x1+x2)/2,y2+2));
      if(n>=0){
        QPainterPath Po;
        Po.moveTo((x1+x2+wd)/2,y2);
        Po.lineTo((x1+x2-wd)/2,y2);
        Po.lineTo((x1+x2-wd)/2,(y1+y2-wd)/2);
        Po.lineTo((x1+x2+wd)/2,(y1+y2-wd)/2);
        Po.lineTo((x1+x2+wd)/2,y2);
	AddThermal(n,Po);
      }
    }
  }
  else if(iden==kPicLine){
    if(N==Net){
      int l=sqrt(((p1.x()-p2.x())*(p1.x()-p2.x()))+(p1.y()-p2.y())*(p1.y()-p2.y()));
      x2=(wd)*(p1.x()-p2.x())/l;
      y2=(wd)*(p1.y()-p2.y())/l;
      x3=(p1.x()+p2.x())/2;
      y3=(p1.y()+p2.y())/2;
      x1=(W/2+2+clr+l/2)*(p1.x()-p2.x())/l;
      y1=(W/2+2+clr+l/2)*(p1.y()-p2.y())/l;

      n=ContainsPoint(QPoint(x3+x1,y3+y1));
      if(n>=0){
        QPainterPath Po;
        Po.moveTo(x3+y2,y3-x2);
        Po.lineTo(x3+x1+y2,y3+y1-x2);
        Po.lineTo(x3+x1-y2,y3+y1+x2);
        Po.lineTo(x3-y2,y3+x2);
        Po.lineTo(x3+y2,y3-x2);
	AddThermal(n,Po);
      }
      n=ContainsPoint(QPoint(x3-x1,y3-y1));
      if(n>=0){
        QPainterPath Po;
        Po.moveTo(x3+y2,y3-x2);
        Po.lineTo(x3-x1+y2,y3-y1-x2);
        Po.lineTo(x3-x1-y2,y3-y1+x2);
        Po.lineTo(x3-y2,y3+x2);
        Po.lineTo(x3+y2,y3-x2);
	AddThermal(n,Po);
      }

      x1=(W/2+6+clr)*(p1.x()-p2.x())/l;
      y1=(W/2+6+clr)*(p1.y()-p2.y())/l;

      n=ContainsPoint(QPoint(x3+y1,y3-x1));
      if(n>=0){
        QPainterPath Po;
        Po.moveTo(x3+x2,y3+y2);
        Po.lineTo(x3+y1+x2,y3-x1+y2);
        Po.lineTo(x3+y1-x2,y3-x1-y2);
        Po.lineTo(x3-x2,y3-y2);
        Po.lineTo(x3+x2,y3+y2);
	AddThermal(n,Po);
      }
      n=ContainsPoint(QPoint(x3-y1,y3+x1));
      if(n>=0){
        QPainterPath Po;
        Po.moveTo(x3+x2,y3+y2);
        Po.lineTo(x3-y1+x2,y3+x1+y2);
        Po.lineTo(x3-y1-x2,y3+x1-y2);
        Po.lineTo(x3-x2,y3-y2);
        Po.lineTo(x3+x2,y3+y2);
	AddThermal(n,Po);
      }
    }
  }
  else if(iden==kPicCir){
    if((r>2) && (N==Net)){
      x1=p1.x();
      y1=p1.y();
      x2=r;
      if(W<1000){
	x2+=W/2;
      }  
      x2+=clr;
      for(i=0;i<4;i++){
	n=ContainsPoint(QPoint(x1+(x2+2)*Sin4[i]/1000,y1+(x2+2)*Sin4[i+1]/1000));
	if(n>=0){
          QPainterPath Po;
	  Po.moveTo(x1+wd*Sin4[i+3]/2000-wd*Sin4[i]/2000,
	                y1+wd*Sin4[i]/2000-wd*Sin4[i+1]/2000);
	  Po.lineTo(x1+x2*Sin4[i]/1000+wd*Sin4[i+3]/2000,
	                y1+x2*Sin4[i+1]/1000+wd*Sin4[i]/2000);
	  Po.lineTo(x1+x2*Sin4[i]/1000+wd*Sin4[i+1]/2000,
	                y1+x2*Sin4[i+1]/1000+wd*Sin4[i+2]/2000);
	  Po.lineTo(x1+wd*Sin4[i+1]/2000-wd*Sin4[i]/2000,
	                y1+wd*Sin4[i+2]/2000-wd*Sin4[i+1]/2000);
	  Po.lineTo(x1+wd*Sin4[i+3]/2000-wd*Sin4[i]/2000,
	                y1+wd*Sin4[i]/2000-wd*Sin4[i+1]/2000);
//          Poly=Poly.subtracted(Po);
	  AddThermal(n,Po);
	}
      }
    }
  }
}

void PicPoly::Subtract(int &iden,QPoint &p1o,QPoint &p2o,int &W,int &r,
                       bool pad,QString &N,unsigned long int Lo)
{
  QPainterPath Po;
  int x1,x2;
  int y1,y2;
  int clr=Clr+wid/2;
  int i=clr;

  QPoint p1;
  QPoint p2;
  unsigned long int L=Lo;
  
  if(Mir) L=Layer->MirLy(L);
  if((Ly & L)==0) return;

  if((N==Net) && (gLib.GetThPat(-1)==0)) return;

  p1=p1o-Ref;
  p1=CompRot((4-Rot),p1,Mir+256);
  p2=p2o-Ref;
  p2=CompRot((4-Rot),p2,Mir+256);

  if(iden==kPicCir){
    i+=r;
    p2=p1;
  }
  if(W<1000) i+=W/2+1;
  i+=wid/2;

  Poly.boundingRect().toRect().normalized().getCoords(&x1,&y1,&x2,&y2);
  if((p1.x()<(x1-i)) && (p2.x()<(x1-i))) return;
  if((p1.x()>(x2+i)) && (p2.x()>(x2+i))) return;
  if((p1.y()<(y1-i)) && (p2.y()<(y1-i))) return;
  if((p1.y()>(y2+i)) && (p2.y()>(y2+i))) return;

  if(PolyS[PolySIdx].elementCount()>400){
    printf("Poly::subtract I=%d size=%d pad=%d\n",PolySIdx,PolyS[PolySIdx].elementCount(),pad);
    PolySIdx++;
  }  
  if(PolySIdx==NumPolyS) PolySIdx=0;

  
  if((iden==kPicRect) || (iden==kPicText)){
    if(p1.x()<p2.x()){
      x1=p1.x();
      x2=p2.x();
    }
    else{
      x1=p2.x();
      x2=p1.x();
    }  
    if(p1.y()<p2.y()){
      y1=p1.y();
      y2=p2.y();
    }
    else{
      y1=p2.y();
      y2=p1.y();
    }
    if((iden==kPicRect) && (W<1000)){
      x1-=W/2;
      y1-=W/2;
      x2+=W/2;
      y2+=W/2;
    }
    x1-=clr;
    y1-=clr;
    x2+=clr;
    y2+=clr;
    if((N!=Net) || pad){
      Po.moveTo(QPoint(x1,y1));
      Po.lineTo(QPoint(x1,y2));
      Po.lineTo(QPoint(x2,y2));
      Po.lineTo(QPoint(x2,y1));
      Po.lineTo(QPoint(x1,y1));
      if((iden==kPicRect) && (W<1000)){
	Po.moveTo(QPoint(x2-W-2*clr,y1+W+2*clr));
	Po.lineTo(QPoint(x1+W+2*clr,y1+W+2*clr));
	Po.lineTo(QPoint(x1+W+2*clr,y2-W-2*clr));
	Po.lineTo(QPoint(x2-W-2*clr,y2-W-2*clr));
	Po.lineTo(QPoint(x2-W-2*clr,y1+W+2*clr));
      }
      PolyS[PolySIdx]=PolyS[PolySIdx].united(Po);
    } 
  }
  else if(iden==kPicCir){
    if(r>2){
      x1=p1.x();
      y1=p1.y();
      x2=r;
      if(W<1000){
	x2+=W/2;
      }  
      x2+=clr;
      if((N!=Net) || pad){
        if(x2<1000){
          Po.moveTo(QPoint(x1+x2*Sin[11]/1000,y1+x2*Sin[11+3]/1000));
	  for(i=0;i<12;i++){
            Po.lineTo(QPoint(x1+x2*Sin[i]/1000,y1+x2*Sin[i+3]/1000));
	  }
	}
	else{
          Po.moveTo(QPoint(x1+x2*Sin24[23]/1000,y1+x2*Sin24[23+6]/1000));
	  for(i=0;i<24;i++){
            Po.lineTo(QPoint(x1+x2*Sin24[i]/1000,y1+x2*Sin24[i+6]/1000));
	  }
	}
  //      Poly=Poly.subtracted(Po);
        PolyS[PolySIdx]=PolyS[PolySIdx].united(Po);
      }
    }
  }
  else if(iden==kPicLine){
    if((N!=Net) || pad){
      x1=p1.x();
      x2=p2.x();
      y1=p1.y();
      y2=p2.y();
      int dx=x1-x2;
      int dy=y1-y2;
      int k=W/2+clr;
      if(dx==0){
        if(dy<1) dy=-1;
	else dy=1;
        Po.moveTo(QPoint(x1-k,y1+k*414*dy/1000));
        Po.lineTo(QPoint(x1-k*414/1000,y1+k*dy));
        Po.lineTo(QPoint(x1+k*414/1000,y1+k*dy));
        Po.lineTo(QPoint(x1+k,y1+k*414*dy/1000));
        Po.lineTo(QPoint(x2+k,y2-k*414*dy/1000));
        Po.lineTo(QPoint(x2+k*414/1000,y2-k*dy));
        Po.lineTo(QPoint(x2-k*414/1000,y2-k*dy));
        Po.lineTo(QPoint(x2-k,y2-k*414*dy/1000));
        Po.lineTo(QPoint(x1-k,y1+k*414*dy/1000));
//        Poly=Poly.subtracted(Po);
          PolyS[PolySIdx]=PolyS[PolySIdx].united(Po);
      }
      else if(dy==0){
        if(dx<1) dx=-1;
	else dx=1;
        Po.moveTo(QPoint(x1+k*414*dx/1000,y1-k));
        Po.lineTo(QPoint(x1+k*dx,y1-k*414/1000));
        Po.lineTo(QPoint(x1+k*dx,y1+k*414/1000));
        Po.lineTo(QPoint(x1+k*414*dx/1000,y1+k));
        Po.lineTo(QPoint(x2-k*414*dx/1000,y2+k));
        Po.lineTo(QPoint(x2-k*dx,y2+k*414/1000));
        Po.lineTo(QPoint(x2-k*dx,y2-k*414/1000));
        Po.lineTo(QPoint(x2-k*414*dx/1000,y2-k));
        Po.lineTo(QPoint(x1+k*414*dx/1000,y1-k));
//        Poly=Poly.subtracted(Po);
          PolyS[PolySIdx]=PolyS[PolySIdx].united(Po);
      }
      else{
        int l=(int)(1000.0*sqrt((long long)dx*dx+(long long)dy*dy));
	if(l>3000){
	  l=l/10;
	  dx=dx/10;
	  dy=dy/10;
	}
	printf("Poly::subtract line len=%d dx=%d dy=%d W=%d k-%d\n",l,dx,dy,W,k);
        Po.moveTo(QPoint(x1+(k*414*dx-k*1000*dy)/l,y1+(k*414*dy+k*1000*dx)/l));
        Po.lineTo(QPoint(x1+(k*1000*dx-k*414*dy)/l,y1+(k*1000*dy+k*414*dx)/l));
        Po.lineTo(QPoint(x1+(k*1000*dx+k*414*dy)/l,y1+(k*1000*dy-k*414*dx)/l));
        Po.lineTo(QPoint(x1+(k*414*dx+k*1000*dy)/l,y1+(k*414*dy-k*1000*dx)/l));

        Po.lineTo(QPoint(x2+(-k*414*dx+k*1000*dy)/l,y2+(-k*414*dy-k*1000*dx)/l));
        Po.lineTo(QPoint(x2+(-k*1000*dx+k*414*dy)/l,y2+(-k*1000*dy-k*414*dx)/l));
        Po.lineTo(QPoint(x2+(-k*1000*dx-k*414*dy)/l,y2+(-k*1000*dy+k*414*dx)/l));
        Po.lineTo(QPoint(x2+(-k*414*dx-k*1000*dy)/l,y2+(-k*414*dy+k*1000*dx)/l));

        Po.lineTo(QPoint(x1+(k*414*dx-k*1000*dy)/l,y1+(k*414*dy+k*1000*dx)/l));
//        Poly=Poly.subtracted(Po);
          PolyS[PolySIdx]=PolyS[PolySIdx].united(Po);
      }
    }
  }
  else return;
}

/*
bool PicPoly::CleanSubPoly(QPainterPath &Po,int &start, int end,int s)
{
 !!!!!!!!!!!!!!!!!!!
  int i;
  int d;
  
  i=start+1;
  d=0;
  while(i<end){
    d+=(Po.elementAt(i).x()-Po.elementAt(i+1).x())*(Po.elementAt(i).y()+Po.elementAt(i+1).y())/2;
    i++;
  }
  if(d<0) d=-d;

  if(d>s) return false;

  printf("CleanSubPoly area %d min %d\n",d,s);
  printf("CleanSubPoly remove from %d to %d\n",start,end);
  Po.remove(start,end-start+1);

  return true;
  
  return false;
}
*/


bool PicPoly::SplitSubPoly(QPainterPath &Po)
{
  PolyLst * PL=0;
  PolyLst * PL1;
  PolyLst * PL2=0;
  PolyLst * PL3;
  int i;

/*
  PL=new PolyLst;
  PL->Next=PolyClr;
  PL->CN=0;
  PolyClr=PL;
  PL->P=Po.simplified();
*/


  for (i=0;i<Po.elementCount();i++){
    if(Po.elementAt(i).isMoveTo()){
      PL=new PolyLst;
      PL->Next=PolyClr;
      PL->CN=0;
      PL->C=false;
      PolyClr=PL;
      PL->P.moveTo(Po.elementAt(i));
    }
    else{
      if(PL){
        PL->P.lineTo(Po.elementAt(i));
      }
    }
  }
/*
  PL=PolyClr;
  while(PL){
    PL1=PolyClr;
    while(PL1){
      if((PL1!=PL)&&(PL1->P.contains(PL->P.elementAt(0)))) break; 
      PL1=PL1->Next;
    }
    if(PL1){
      PL1->P.addPath(PL->P);
      if(PL2){
        PL2->Next=PL->Next;
	delete PL;
	PL=PL2->Next;
      }
      else{
        PolyClr=PL->Next;
	delete PL;
	PL=PolyClr;
      }
    }
    else{
      PL2=PL;
      PL=PL->Next;
    }
  }
*/

  PL=PolyClr;
  while(PL){
    PL->CN=0;
    PL1=PolyClr;
    while(PL1){
      if(PL!=PL1){
        if(PL1->P.contains(PL->P.elementAt(0))){
	  PL->CN+=1;
	}
      }
      PL1=PL1->Next;
    }
    printf("SplitSubPoly level=%d\n",PL->CN);
    PL=PL->Next;
  }

  PL=PolyClr;
  PL2=NULL;
  while(PL){
    if(PL->CN&1){
      PL1=PolyClr;
      PL3=NULL;
      while(PL1){
	if((PL!=PL1) && (PL1->CN==(PL->CN-1))){
          if(PL1->P.contains(PL->P.elementAt(0))){
	    if(PL3) printf("SplitSubPoly Find more parents !\n");
	    PL3=PL1;
	  }
	}
	PL1=PL1->Next;
      }
      if(PL3){
        PL3->P.addPath(PL->P);
	if(PL2)	PL2->Next=PL->Next;
	else PolyClr=PL->Next;
	delete PL;
	PL=NULL;
      }
      else{
        printf("SplitSubPoly parent not found!\n");
      }
    }
    if(PL){
      PL2=PL;
      PL=PL->Next;
    }
    else{
      if(PL2) PL=PL2->Next;
      else PL=PolyClr;
    }
  }

  return true;
}


void PicPoly::TextSave(QTextStream * S, bool sel)
{
  int i;
  int x,y;
  PolyLst *PL=PolyClr;
  QPointF p;
  PicEl::TextSave(S,sel);
  *S << "    {Net " << Net <<" }\n";
  *S << "    {Clr " << Clr <<" }\n";
  if(PolyClr){
    *S << "    {ClrElements\n" ;
    while(PL){
      *S << "     {" ;
      for(i=0;i<PL->P.elementCount();i++){
	if((i%4)==3) *S << "\n      " ;
	p=PL->P.elementAt(i);
	x=p.x();
	y=p.y();
	if(PL->P.elementAt(i).isLineTo()) *S  << " L ";
	else *S  << " M ";
	*S  << x << " " << y ;
      }
      *S << "     }\n" ;
      PL=PL->Next;
    }
    *S << "    }\n" ;
  }
  *S << "    {Elements" ;
  for(i=0;i<Poly.elementCount();i++){
    if((i%4)==3) *S << "\n        " ;
    p=Poly.elementAt(i);
    x=p.x();
    y=p.y();
    if(Poly.elementAt(i).isLineTo()) *S  << " L ";
    else *S  << " M ";
    *S  << x << " " << y ;
  }
  *S << " }\n   }\n" ;
}

bool  PicPoly::TLoadNext(QTextStream * S,QString* s)
{
 QString s1;
 QString s2;
 int x,y;
 PolyLst *PL;
 PolyLst *PL1=NULL;

 if (s->contains("ClrPoints")){
   *S >> s1;
   while(!s1.contains('}')){
     if(s1.contains('{')){
       PL=new PolyLst;
       PL->CN=0;
       if(PL1) PL1->Next=PL;
       else PolyClr=PL;
       PL1=PL;
       PL->Next=NULL;
       *S >> s1;
       while(!s1.contains('}')){
	 x=s1.toInt();
	 *S >> s1;
	 y=s1.toInt();
	 if(PL->P.elementCount()==0) PL->P.moveTo(QPointF(x,y));
	 else PL->P.lineTo(QPointF(x,y));
	 *S >> s1;
       }
       PL->P.closeSubpath();
       PL->P=PL->P.simplified();
     }
     *S >> s1;
   }
 }
 else if (s->contains("ClrElements")){
   *S >> s1;
   while(!s1.contains('}')){
     if(s1.contains('{')){
       PL=new PolyLst;
       PL->CN=0;
       PL->C=false;
       if(PL1) PL1->Next=PL;
       else PolyClr=PL;
       PL1=PL;
       PL->Next=NULL;
       *S >> s1;
       while(!s1.contains('}')){
       
	 *S >> s2;
	 x=s2.toInt();
	 *S >> s2;
	 y=s2.toInt();
	 if(s1.contains("M")) PL->P.moveTo(QPointF(x,y));
	 else PL->P.lineTo(QPointF(x,y));
	 *S >> s1;
       }
       PL->P.closeSubpath();
       PL->P=PL->P.simplified();
     }
     *S >> s1;
   }
 }
 else if (s->contains("Points")){
   *S >> s1;
   while(!s1.contains('}')){
     x=s1.toInt();
     *S >> s1;
     y=s1.toInt();
     if(Poly.elementCount()==0) Poly.moveTo(QPointF(x,y));
     else Poly.lineTo(QPointF(x,y));
     *S >> s1;
   }
   Poly.closeSubpath();
   Poly=Poly.simplified();
 }
 else if (s->contains("Elements")){
   *S >> s1;
   while(!s1.contains('}')){
     *S >> s2;
     x=s2.toInt();
     *S >> s2;
     y=s2.toInt();
     if(s1.contains("M")) Poly.moveTo(QPointF(x,y));
     else Poly.lineTo(QPointF(x,y));
     *S >> s1;
   }
   Poly.closeSubpath();
   Poly=Poly.simplified();
 }
 else if (s->contains("Net")){
  *S >> Net;
  if(Net.contains('}')){
    Net="";
  }
  else TextLoadSkip(S);
 }
 else if (s->contains("Clr")){
  *S >> Clr;
  TextLoadSkip(S);
 }
 else  return false;
 return true;
}


PicEl* PicPoly::GetEl(int &iden,QPoint &p1,QPoint &p2,int &W,int &r,
                    int &Lo,QString &N,QPainterPath &Po,unsigned long int L,bool &pad)
{
  if(!PolyClr && Net.isEmpty()){
    if(Mir) L=Layer->MirLy(L);
    if((Ly & L)==0) return NULL;
    Po=GetPoly();
    if(Po.isEmpty()) return NULL;
    W=wid;
    r=0;
    iden=GetIden();
    return this;
  }
  if(!PolyClr) return NULL;
  PolyAct=NULL;
  return GetNextEl(iden,p1,p2,W,r,Lo,N,Po,L,pad);
}

PicEl* PicPoly::GetNextEl(int &iden,QPoint &/*p1*/,QPoint &/*p2*/,int &W,int &r,
                    int &/*Lo*/,QString &/*N*/,QPainterPath &Po,unsigned long int L,
		    bool &/*pad*/)
{
  if(!PolyClr) return NULL;
  if(Mir) L=Layer->MirLy(L);
  if((Ly & L)==0) return NULL;
  Po=GetPoly();
  if(Po.isEmpty()) return NULL;
  W=wid;
  r=0;
  iden=GetIden();
  return this;
}

void PicPoly::Paint(QPainter* P,QRect* /*Rec*/,int flag,QColor* col,
                    int x,int y,int rot,int mir,bool /*HL*/)
{
  QPen pen;
  QPoint p;

  pen.setColor(*col);
  P->setBrush(*col);

  P->save();

  P->translate(x,y);
  P->rotate(rot*90);
  if(mir) P->scale(-1,1);

//  printf("Poly::Paint size=%d %ld\n",Poly.elementCount(),PolyClr);
  if(PolyClr && (flag & kDrawFillPoly)){
    PolyLst * PL=PolyClr;
    while(PL){
      if(!(flag & kDrawDummy)){
        if(flag & kDrawFillPoly){

  	  pen.setStyle(Qt::SolidLine);
	  pen.setWidth(wid);
          pen.setCapStyle(Qt::RoundCap);

//	  pen.setStyle(Qt::NoPen);
//	  pen.setWidth(0);
	  P->setPen(pen);
	  P->drawPath(PL->P);
	}
//	p=PL->P.elementAt(PL->P.elementCount()-1);
//	for(i=0;i<PL->P.elementCount();i++){
//	  if(Rec==NULL || Rec->contains(p) || Rec->contains(PL->P.elementAt(i)))
//	    P->drawLine(PL->P.elementAt(i),p);
//	  p=PL->P.elementAt(i);
//	}
//	  P->drawPolyline(PL->P);
//	  P->drawLine(PL->P.elementAt(0),PL->P.elementAt(PL->P.elementCount()-1));
      }
      PL=PL->Next;
    }
  }
  else{
//    pen.setStyle(Qt::DashLine);
    if((flag & kDrawFillPoly) || (wid==0)){
      pen.setStyle(Qt::NoPen);
      pen.setWidth(0);
      P->setPen(pen);
      if(!(flag & kDrawDummy)) P->drawPath(Poly);
    }
    if(wid){
      P->setBrush(Qt::NoBrush);
      pen.setStyle(Qt::SolidLine);
      pen.setWidth(wid);
      P->setPen(pen);
      if(!(flag & kDrawDummy)) P->drawPath(Poly);
//      if(!(flag & kDrawDummy)) P->drawLine(Poly.elementAt(0),Poly.elementAt(Poly.elementCount()-1));
    }  
  }

  P->restore();

 #ifdef ORectDEBUG
  QRect r(R);
  r=CompRot(rot,r,mir);
  r.translate(x,y);
  P->setBrush(Qt::NoBrush);
  P->setPen(Qt::black);
  P->drawRect(r);
 #endif
}

