/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef PicObj_included
#define PicObj_included

#define NumPolyS 50

#include "PicEl.h"
//Added by qt3to4:
#include <QTextStream>
#include <QPainterPath>

//--------------------------------------------------------------------
/*
class PicPolyLine : public PicEl
{

public:

  PicPolyLine(Layers *L);
  virtual ~PicPolyLine();

  virtual int GetIden();

  uint AddPoint(QPoint p);
  uint AddPoint(int x,int y);

  void SetPoint(QPoint p,uint n);
  void SetPoint(int x,int y,uint n);

  void DelPoint(uint n);

  QPoint GetPoint(uint i) const;

  virtual void TextSave(QTextStream * S);

protected:

  virtual void  Paint(QPainter* P,QRect* Rec,int flag,QColor* col,int x,int y,int rot);
  virtual  void  SetOutl();
  virtual bool  TLoadNext(QTextStream * S,QString* s);

private:

  QPointArray  PA;

};
*/
//----------------------------------------------------------------------

class PicLine : public PicEl
{

public:

  PicLine(Layers *L);
  virtual ~PicLine();

  virtual int GetIden();

  void Begin(QPoint p);
  void Begin(int x,int y);

  void End(QPoint p);
  void End(int x,int y);

  QPoint GetBegin();
  QPoint GetEnd();

  int GetLen();

  bool IsX(QPoint A,QPoint B);
  bool IsX(int Ax,int Ay,int Bx,int By);

  QPoint XPoint(QPoint A,QPoint B);
  QPoint XPoint(int Ax,int Ay,int Bx,int By);

  bool IsConnect(PicLine *L,int tol);
  bool IsConnect(QPoint p,int tol);
  bool IsConnect(QRect r,int tol);

  virtual bool GetInfo(QString & i,QPoint p,int mode=0,int mir=0);

  virtual bool Select(QPoint p,int mode=0,int mir=0);
  virtual bool Select(QRect r,int mode=0,int mir=0);

  virtual int SelPoint(QPoint p,int tol=0,int mode=0,int mir=0);
  virtual bool SelPoint(QRect r,int mode=0,int mir=0);

  void SelPBeg();
  void SelPEnd();

  virtual QPoint GetSelPoint();

  virtual void MovePointTo(QPoint p);
  virtual void MovePointBy(int x, int y);

  virtual void TextSave(QTextStream * S, bool sel=false);

  virtual PicEl * GetEl(int &iden,QPoint &p1,QPoint &p2,int &W,int &r,
                        int &Lo,QString &N,QPainterPath &Po,unsigned long int L,bool &pad);

protected:

  virtual void  Paint(QPainter* P,QRect* Rec,int flag,QColor* col,
                      int x,int y,int rot,int mir,bool HL);
  virtual  void  SetOutl();
  virtual bool  TLoadNext(QTextStream * S,QString* s);

private:

  QPoint Beg;
  QPoint En;

};

//----------------------------------------------------------------------

class PicRect : public PicEl
{

public:

  PicRect(Layers *L);
  virtual ~PicRect();

  virtual int GetIden();

  void Rect(int x,int y,int wd,int hg);
  void Rect(QRect re);
  void GetRect(int *x,int *y,int *wd,int *hg);

  virtual bool GetInfo(QString & i,QPoint p,int mode=0,int mir=0);

  virtual bool Select(QPoint p,int mode=0,int mir=0);
  virtual int SelPoint(QPoint p,int tol=0,int mode=0,int mir=0);

  virtual void MovePointTo(QPoint p);
  virtual void MovePointBy(int x, int y);

  virtual void TextSave(QTextStream * S, bool sel=false);

  virtual PicEl * GetEl(int &iden,QPoint &p1,QPoint &p2,int &W,int &r,
                        int &Lo,QString &N,QPainterPath &Po,unsigned long int L,bool &pad);

protected:

  virtual void  Paint(QPainter* P,QRect* Rec,int flag,QColor* col,
                      int x,int y,int rot,int mir,bool HL);
  virtual  void  SetOutl();
  virtual bool  TLoadNext(QTextStream * S,QString* s);

private:

  QRect    Re;
//  PenStyle LS;

};

//----------------------------------------------------------------------

class PicCir : public PicEl
{

public:

  PicCir(Layers *L);
  virtual ~PicCir();

  virtual int GetIden();

  void Rect(int x,int y,int wd,int hg);
  void Rect(QRect re);
  void SetR(int r);
  void Center(int x,int y);
  void Center(QPoint p);
  void Circle(QPoint p,int r);
  void Circle(int x,int y,int r);

  QPoint GetCenter();
  int GetR();

  void SetBegA(int a);

  void SetLenA(int a);

  void SetArc(int a,int l);

  void SelPBeg();
  void SelPEnd();
  void SelPR();

  virtual bool GetInfo(QString & i,QPoint p,int mode=0,int mir=0);

  virtual bool Select(QPoint p,int mode=0,int mir=0);
  virtual int SelPoint(QPoint p,int tol=0,int mode=0,int mir=0);

  virtual QPoint GetSelPoint();

  virtual void MovePointTo(QPoint p);
  virtual void MovePointBy(int x, int y);

  virtual void TextSave(QTextStream * S, bool sel=false);

  virtual PicEl * GetEl(int &iden,QPoint &p1,QPoint &p2,int &W,int &r,
                        int &Lo,QString &N,QPainterPath &Po,unsigned long int L,bool &pad);

  virtual PicEl * GetNextEl(int &iden,QPoint &p1,QPoint &p2,int &W,int &r,
                        int &Lo,QString &N,QPainterPath &Po,unsigned long int L,bool &pad);

protected:

  virtual void  Paint(QPainter* P,QRect* Rec,int flag,QColor* col,
                      int x,int y,int rot,int mir,bool HL);
  virtual  void  SetOutl();
  virtual bool  TLoadNext(QTextStream * S,QString* s);

private:

  QRect    Re;
  int     BegA;
  int     LenA;
  int     ActA;
  int     StpA;
  QPoint   PS;
//  PenStyle LS;

};

//----------------------------------------------------------------------

class PicText : public PicEl
{

public:

#define AligLeft 0
#define AligTop 0
#define AligCenter 1
#define AligRight 2
#define AligBottom 2

  PicText(Layers *L);
  virtual ~PicText();

  virtual int GetIden();

  void SetText(QString s);
  QString GetText();

  void SetText(QString * s);
  void SText(QString * s);

  void SetFont(QFont F);
  QFont GetFont();

  void SetAlig(int h,int v);
  void GetAlig(int *h,int *v);

  virtual bool GetInfo(QString & i,QPoint p,int mode=0,int mir=0);

  virtual PicEl * GetEl(int &iden,QPoint &p1,QPoint &p2,int &W,int &r,
                        int &Lo,QString &N,QPainterPath &Po,unsigned long int L,bool &pad);

  virtual void TextSave(QTextStream * S, bool sel=false);

protected:

  virtual void  Paint(QPainter* P,QRect* Rec,int flag,QColor* col,
                      int x,int y,int rot,int mir,bool HL);
  virtual  void  SetOutl();
  virtual bool  TLoadNext(QTextStream * S,QString* s);

private:

  int   HorAl;
  int   VerAl;
  QString * Text;
  QString * TxO;
  QFont  Font;
  bool X;

};


//----------------------------------------------------------------------

class PicPower : public PicEl
{

public:

#define PwrTypeCircle 0
#define PwrTypeArrow 1
#define PwrTypeBar   2
#define PwrTypeWave  3

  PicPower(Layers *L);
  virtual ~PicPower();

  virtual int GetIden();

  void SetText(QString s);
  QString GetText();

  void SetType(int t);
  int GetType();

  void SetFont(QFont F);
  QFont GetFont();

  virtual bool GetInfo(QString & i,QPoint p,int mode=0,int mir=0);

  virtual void TextSave(QTextStream * S, bool sel=false);

protected:

  virtual void  Paint(QPainter* P,QRect* Rec,int flag,QColor* col,
                      int x,int y,int rot,int mir,bool HL);
  virtual  void  SetOutl();
  virtual bool  TLoadNext(QTextStream * S,QString* s);

private:

  QString Text;
  QFont  Font;
  int Type;

};



//----------------------------------------------------------------------

class PicPoly : public PicEl
{

struct PolyLst {
  QPainterPath P;
  int CN;
  bool C;
  PolyLst* Next;
};


public:

  PicPoly(Layers *L);
  virtual ~PicPoly();

  virtual int GetIden();

  void SetNet(QString net);
  void SetClr(int clr);
  
  QString GetNet();
  int GetClr();
  
  bool Clean();
  bool CleanSplited();

  virtual bool GetInfo(QString & i,QPoint p,int mode=0,int mir=0);

  virtual bool Select(QPoint p,int mode=0,int mir=0);
  virtual int SelPoint(QPoint p,int tol=0,int mode=0,int mir=0);

  virtual void MovePointTo(QPoint p);
  virtual void MovePointBy(int x, int y);

  void AddSelPoint(bool ins=false);
  void AddPoint(int x, int y);
  
  int IsConnect(QPoint p,int tol);
  int IsConnect(QPainterPath Po,int tol);
  int SetCN(int start);
  void ChangeCN(int from,int to);
  void RmUnconnect();

  int ContainsPoint(QPoint p);

  QPainterPath GetPoly();
/*
  bool XPoint(QPoint p1, QPoint p2, QPoint p3, QPoint p4, QPoint &x);
  int MovePointOut(QPainterPath &Po, QPoint & p1, QPoint & p2, QPoint & p3);
  void Expand(int w, QPainterPath & Po);
*/
  void Subtract(int &iden,QPoint &p1,QPoint &p2,int &W,int &r,
                   bool pad,QString &N,unsigned long int L);
  void AddThermal(int &iden,QPoint &p1,QPoint &p2,int &W,int &r,
                   bool pad,QString &N,unsigned long int L);
  void RmClear();
  
  virtual void TextSave(QTextStream * S, bool sel=false);
  
  virtual PicEl * GetEl(int &iden,QPoint &p1,QPoint &p2,int &W,int &r,
                        int &Lo,QString &N,QPainterPath &Po,unsigned long int L,bool &pad);
  virtual PicEl * GetNextEl(int &iden,QPoint &p1,QPoint &p2,int &W,int &r,
                        int &Lo,QString &N,QPainterPath &Po,unsigned long int L,bool &pad);
protected:

  void AddThermal(int n,QPainterPath & Po);
//  bool FindSubPoly(QPainterPath &Po,int &i,int &j);
//  bool MinPoly(QPainterPath &Po,int &start, int end);
//  bool MinPoly(QPainterPath &Po);
//  bool CleanSubPoly(QPainterPath &Po,int &start, int end,int s);
//  bool FindNarrow(QPainterPath Po,int min);
//  bool SplitSubPoly(QPainterPath &Po,int &start, int end);
  bool SplitSubPoly(QPainterPath &Po);


  virtual void  Paint(QPainter* P,QRect* Rec,int flag,QColor* col,
                      int x,int y,int rot,int mir,bool HL);
  virtual  void  SetOutl();
  virtual bool  TLoadNext(QTextStream * S,QString* s);

private:

  QPainterPath Poly;
  PolyLst * PolyClr;
  PolyLst * PolyAct;
  QPainterPath PolyS[NumPolyS];
  int PolySIdx;
  
  QString Net;
  int Clr;

};


#endif
