/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "Global.h"
#include "PicEl.h"
#include "PicPComp.h"
#include "Layers.h"
#include "PicGrp.h"
#include "PicPadS.h"
#include "Library.h"
#include "ObjEdit.h"

#include <QPainter>
#include <QPen>
#include <QColor>
//#include <qpntarry.h>
//Added by qt3to4:
#include <QTextStream>

#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <unistd.h>

extern Library gLib;


PicPComp::PicPComp(Layers *L)
 :PicGrp(L)
{
 AEl=NULL;
}

PicPComp::~PicPComp()
{

}

int PicPComp::GetIden()
{
 return kPicPComp;
}

void PicPComp::AddTreeList(TreeListItem * LI)
{
 LI->setText( 1,Name);
 PicGrp::AddTreeList(LI);
}


void PicPComp::SetName(QString n)
{
 Name=n;
}
QString PicPComp::GetName()
{
 return Name;
}


bool PicPComp::LibPart(QString name)
{
 Name=name;
 PicPComp * E=(PicPComp *)gLib.GetComp(name,Layer,kPicPComp);
 if (E){
  Data=E->GetData();
  Lock=true;
//  SetOutl();
  return true;
 }
 return false;
}


int PicPComp::GetMaxPN()
{
 GrpEl * T=Data;
 int max=0;
 int i;
 while(T){
  if(T->E->GetIden()==kPicPadS){
   i=((PicPadS *)T->E)->GetPinNum();
   if (i>max) max=i;
  }
  T=T->Next;
 }
 return max;
}

void PicPComp::GetPinPosRes()
{
 AEl=Data;
}

bool PicPComp::GetPinPos(QPoint & p,int & num)
{
 while(AEl){
  if(AEl->E->GetIden()==kPicPadS){
   num=((PicPadS *)AEl->E)->GetPinNum();
   p=AEl->E->Pos();
   p=CompRot(Rot,p,Mir);
   p+=Ref;
   AEl=AEl->Next;
   return true;
  }
  AEl=AEl->Next;
 }
 return false;
}

bool PicPComp::GetPinP(QPoint * p,int num)
{
 GrpEl * T=Data;
 int i;
 while(T){
  if(T->E->GetIden()==kPicPadS){
   i=((PicPadS *)T->E)->GetPinNum();
   if (i==num){
    *p=T->E->Pos();
    *p=CompRot(Rot,*p,Mir);
    *p+=Ref;
    return true;
   }
  }
  T=T->Next;
 }
 return false;
}

unsigned long int PicPComp::GetPinL(int num)
{
 GrpEl * T=Data;
// int i;
 while(T){
  if(T->E->GetIden()==kPicPadS){
   if(((PicPadS *)T->E)->GetPinNum()==num){
    if(Mir) return Layer->MirLy(T->E->GetLayer());
    else return T->E->GetLayer();
   }
  }
  T=T->Next;
 }
 return 0;
}

bool PicPComp::GetInfo(QString & i,QPoint p,int mode,int mir)
{
  p=p-Ref;
  p=CompRot(4-Rot,p,Mir+256);
  if(Data!=NULL && R.contains(p) && Layer->IsVis(GetLayer(mir))){
    GrpEl* T=Data;
    while(T!=NULL){
      if (T->E->GetInfo(i,p,mode,mir+Mir)){
	if(T->E->GetIden()==kPicPadS){
	  QString s;
	  int n=((PicPadS *)T->E)->GetPinNum();
	  if(n>65535) s.sprintf(" N:%c%d",'A'-1+n/65536,n&0xFFFF);
	  else s.sprintf(" N:%d",n);
	  i+=s;
	}  
	i+=" Comp:";
	i+=Name;
        return true;
      }
      T=T->Next;
    }
    i="Comp:";
    i+=Name;
    return true;
  }
  return false;
}

void PicPComp::TextSave(QTextStream * S, bool sel)
{
 if (Lock){
  PicEl::TextSave(S,sel);
  *S << "    {Lock " << Lock << " }\n";
  *S << "    {Name " << Name << " }\n";
  *S << "   }\n";
 }
 else{
//  *S << " " << Name << " ";
  PicGrp::TextSave(S,sel);
 }
}

bool  PicPComp::TLoadNext(QTextStream * S,QString* s)
{
 if (s->contains("Name")){
  QString s1;
  *S >> s1;
  TextLoadSkip(S);
  Name=s1;
  PicGrp * E=gLib.GetPComp(s1,Layer);
  if (E) Data=E->GetData();
 }
 else  return PicGrp::TLoadNext(S,s);
 return true;
}

