/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "Global.h"
#include "PinLst.h"

#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <unistd.h>
//Added by qt3to4:
#include <QTextStream>


PinList::PinList()
{
 PL=new PinLst *;
 *PL=NULL;
 Poc=new int;
 *Poc=1;
}

PinList::~PinList()
{
 (*Poc)--;
 if(!*Poc){
  PinLst *P;
  while(*PL){
   P=(*PL)->Next;
   delete *PL;
   *PL=P;
  }
  delete PL;
  delete Poc;
 }
}


PinList  &PinList::operator=(PinList &P)
{
 (*Poc)--;
 if(!(*Poc)){
  PinLst *P;
  while(*PL){
   P=(*PL)->Next;
   delete *PL;
   *PL=P;
  }
  delete PL;
  delete Poc;
 }

 PL=P.GetPL();
 Poc=P.GetPoc();
 (*Poc)++;
 return *this;
}

PinList::PinLst ** PinList::GetPL()
{
 return PL;
}

int * PinList::GetPoc()
{
 return Poc;
}

void PinList::SetActPinNet(QString net)
{
 AP->Net=net;
}

void PinList::GetActPinNet(QString &net)
{
 net=AP->Net;
}


void PinList::GetPinR()
{
 AP=*PL;
}

bool PinList::GetPinNext(int * n,QString *net)
{
 if(AP){
  *n=AP->Num;
  *net=AP->Net;
  AP=AP->Next;
  return true;
 }
 return false;
}


bool PinList::GetPin(int * n,QString *net)
{
 AP=*PL;
 if(AP){
  *n=AP->Num;
  *net=AP->Net;
  return true;
 }
 return false;
}

bool PinList::GetNextPin(int * n,QString *net)
{
 if(AP) AP=AP->Next;
 if(AP){
  *n=AP->Num;
  *net=AP->Net;
  return true;
 }
 return false;
}

void PinList::Clean()
{
 PinLst *P;
 while(*PL){
  P=(*PL)->Next;
  delete *PL;
  *PL=P;
 }
}

void PinList::AddPin(int n)
{
 PinLst *P=*PL;
 while(P){
  if(P->Num==n) return;
  P=P->Next;
 }
// printf("AddPin : %d %x\n",n,(unsigned int)PL);
 P=new PinLst;
 P->Num=n;
 P->Next=*PL;
 *PL=P;
}

void PinList::SetNet(int n, QString net)
{
 PinLst *P=*PL;
 while(P){
  if(P->Num==n){
   P->Net=net;
  }
  P=P->Next;
 }
}

QString * PinList::GetNet(int n)
{
 PinLst *P=*PL;
 while(P){
  if(P->Num==n){
   return &(P->Net);
  }
  P=P->Next;
 }
 return NULL;
}


bool PinList::TextLoad(QTextStream * /*S*/)
{
 return false;
}

void PinList::TextSave(QTextStream * /*S*/, bool )
{
}
