/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "main.h"
#include "Library.h"
#include "PicPComp.h"
#include "PicPadS.h"
#include "PicPin.h"
#include "PicSComp.h"
#include "DbSch.h"
#include "DbPcb.h"
#include "Dlg.h"
#include "Table.h"
#include "Part.h"
#include "PartDlg.h"
#include "ImpExp.h"
#include "ImpPComp.h"
#include "ObjEdit.h"
#include "LibBrowser.h"
#include "Settings.h"
#include "Version.h"

#include <QFont>
//#include <qnamespace.h>
#include <QPrinter>
#include <QPrintDialog>
#include <QDateTime>
//Added by qt3to4:
#include <QTextStream>
#include <QResizeEvent>
#include <QMenu>

#include <stdio.h>

#include "Error.h"

Errors  gErr;
Library gLib;
unsigned int gFlag;
unsigned long long gID=0;

extern const char *sPic[];


My2Widget::My2Widget( QWidget *parent )
        : QWidget( parent )
{
    W=0;
/*
    Layer.Add(0,0,255,"TEST  ");
    Layer.Add(128,255,128,"TEST1 ");
    Layer.SetVis(Layer.GetDef());
    Layer.SetAct(Layer.GetDef());
    Layer.Add(255,0,0,"TEST2 ");
    Layer.SetVis(Layer.GetDef());
    Layer.Add(0,0,255,"TEST32");
*/
    DbP=NULL;
    DbPr=NULL;

    Db=NULL;

    setMinimumSize( 640, 480 );
//    setMaximumSize( 1024, 768 );
    wg= new Edit(Db,this);
    wg->show();

    lsw= new LySelWdg(&Layer,this);
    lsw->show();

    bb= new ButBarr(this);
    bb->show();

    ib=new InfoBarr(this);
    ib->show();

    wg->SetInfo(ib);

    connect( bb, SIGNAL(LActSel(int)), wg, SLOT(LActSel(int)) );
    connect( bb, SIGNAL(MActSel(int)), wg, SLOT(MActSel(int)) );
    connect( wg, SIGNAL(Escape()), bb, SLOT(Escape()) );

    connect( ib, SIGNAL(Press(QPoint,int)), wg, SLOT(Press(QPoint,int)) );
    connect( ib, SIGNAL(Change()), wg, SLOT(LyChange()) );

    connect( ib->GetCBAtrL(), SIGNAL(activated(const QString &)), &Layer,SLOT(SetAct(const QString &)) );

    connect( &Layer, SIGNAL(VisChange()), wg, SLOT(LyVisChange()) );
    connect( &Layer, SIGNAL(Change()), wg, SLOT(LyChange()) );

    wgP= new Edit(DbP,this);
     lswP= new LySelWdg(&LayerP,this);
    bbP= new ButBarr(this);
    ibP=new InfoBarr(this);
    ibP->SetMulF(10);
    wgP->SetInfo(ibP);

    connect( bbP, SIGNAL(LActSel(int)), wgP, SLOT(LActSel(int)) );
    connect( bbP, SIGNAL(MActSel(int)), wgP, SLOT(MActSel(int)) );
    connect( wgP, SIGNAL(Escape()), bbP, SLOT(Escape()) );

    connect( ibP, SIGNAL(Press(QPoint,int)), wgP, SLOT(Press(QPoint,int)) );
    connect( ibP, SIGNAL(Change()), wgP, SLOT(LyChange()) );

    connect( ibP->GetCBAtrL(), SIGNAL(activated(const QString &)), &LayerP,SLOT(SetAct(const QString &)) );

    connect( &LayerP, SIGNAL(VisChange()), wgP, SLOT(LyVisChange()) );
    connect( &LayerP, SIGNAL(Change()), wgP, SLOT(LyChange()) );

    connect( wg, SIGNAL(NetHL(QString)), wgP, SLOT(HLNet(QString)) );
    connect( wg, SIGNAL(CompHL(QString)), wgP, SLOT(HLComp(QString)) );
    connect( wg, SIGNAL(CompMove(QString)), wgP, SLOT(MoveComp(QString)) );
    connect( wgP, SIGNAL(NetHL(QString)), wg, SLOT(HLNet(QString)) );
    connect( wgP, SIGNAL(CompHL(QString)), wg, SLOT(HLComp(QString)) );


    wgPr= new Edit(DbPr,this);
     lswPr= new LySelWdg(&LayerPr,this);
    bbPr= new ButBarr(this);
    ibPr=new InfoBarr(this);
    wgPr->SetInfo(ibPr);

    connect( bbPr, SIGNAL(LActSel(int)), wgPr, SLOT(LActSel(int)) );
    connect( bbPr, SIGNAL(MActSel(int)), wgPr, SLOT(MActSel(int)) );
    connect( wgPr, SIGNAL(Escape()), bbPr, SLOT(Escape()) );

    connect( ibPr, SIGNAL(Press(QPoint,int)), wgPr, SLOT(Press(QPoint,int)) );
    connect( ibPr, SIGNAL(Change()), wgPr, SLOT(LyChange()) );

    connect( ibPr->GetCBAtrL(), SIGNAL(activated(const QString &)), &LayerPr,SLOT(SetAct(const QString &)) );

    connect( &LayerPr, SIGNAL(VisChange()), wgPr, SLOT(LyVisChange()) );
    connect( &LayerPr, SIGNAL(Change()), wgPr, SLOT(LyChange()) );



//    quit = new QPushButton( "Quit", this, "quit" );
    //quit->setGeometry( 10, 10, 75, 30 );
//    quit->setFont( QFont( "Times", 18, QFont::Bold ) );


//    connect( quit, SIGNAL(clicked()), qApp, SLOT(quit()) );
//    connect( quit, SIGNAL(clicked()), this, SLOT(SetMSpecial()) );

    mainMenu = new QMenuBar(this);
    mainMenu->setMinimumSize( 500, 20 );
//    mainMenu->setFont( QFont( "helvetica", 10, QFont::Bold ) );

    QMenu * fileMenu = mainMenu->addMenu( "File");
    MSpecial = mainMenu->addMenu( "Special");
    QMenu * WMenu = mainMenu->addMenu( "View");
    MPrj = mainMenu->addMenu( "Project");
    MSetting = mainMenu->addMenu( "Setting");
    QMenu * HelpMenu = mainMenu->addMenu( "Help");

    HelpMenu->addAction( "About", this, SLOT(About()));

//    QMenu * fileMenu = new QMenu;
//    QMenu * WMenu = new QMenu;
//    MSpecial = new QMenu();
//    MPrj = new QMenu();
//    MPart = new QMenu();
//    MSetting = new QMenu();
//    MSpecial->setCheckable(true);
//    fileMenu->setFont( QFont( "helvetica", 12, QFont::Bold ) );
//    MSpecial->setFont( QFont( "helvetica", 12, QFont::Bold ) );
//    fileMenu->insert( "New",  myView, SLOT(newFile()));
    fileMenu->addAction( "New Project", this, SLOT(NewP()));
    fileMenu->addAction( "Open Project", this, SLOT(LoadP()));
    fileMenu->addAction( "Save Project", this, SLOT(SaveP()));
    fileMenu->addAction( "Save Project As", this, SLOT(SaveAsP()));
    fileMenu->addSeparator();
    fileMenu->addAction( "New", this, SLOT(New()),Qt::CTRL+Qt::Key_N);
    fileMenu->addAction( "Open", this, SLOT(Load()),Qt::CTRL+Qt::Key_O);
    fileMenu->addAction( "Save", this, SLOT(Save()));
    fileMenu->addAction( "Save As", this, SLOT(SaveAs()));
    fileMenu->addSeparator();
    fileMenu->addAction( "Print", this, SLOT(Print()));
    fileMenu->addAction( "Import PCAD", this, SLOT(ImpPDF()));
    fileMenu->addAction( "Import PCAD Comp", this, SLOT(ImpPDFC()));
    fileMenu->addAction( "Import Orcad SDT", this, SLOT(ImpOrcSdt()));
    fileMenu->addAction( "Import Orcad Lib", this, SLOT(ImpOrcLib()));
    fileMenu->addAction( "Import PComp", this, SLOT(ImpPComps()));
    fileMenu->insertSeparator(NULL);
    fileMenu->addAction( "Export Orcad SDT", this, SLOT(ExpOrcSdt()));
    fileMenu->addAction( "Export Library", this, SLOT(SaveParts()));
    fileMenu->addAction( "Fabrication Outputs", this, SLOT(DoOutputs()));
    fileMenu->addSeparator();
    fileMenu->addAction( "Quit", qApp, SLOT(quit()));
    WMenu->addAction( "Project", this, SLOT(WiewPrj()));
    WMenu->addAction( "Schema", this, SLOT(WiewSch()));
    WMenu->addAction( "Board", this, SLOT(WiewPcb()));
    WMenu->addAction( "Sch+Board", this, SLOT(WiewSchPcb()));
    WMenu->addAction( "Sch Library", this, SLOT(WiewSchLib()));
    WMenu->addAction( "Pcb Library", this, SLOT(WiewPcbLib()));
    MSetting->addAction( "Outputs", this, SLOT(SetOutputs()));
    MSetting->addAction( "DRC", this, SLOT(SetDrc()));
    MSetting->addAction( "Sch Keys", this, SLOT(SetKeyMap()));
    MSetting->addAction( "Brd Keys", this, SLOT(SetKeyMapP()));
    MSetting->addAction( "Settings", this, SLOT(Settings()));

    connect( wg, SIGNAL(KeyPress(int)), &KM, SLOT(ProcKey(int)));
    connect( &KM, SIGNAL(SetAct(QString,int)), bb, SLOT(SetAct(QString,int)));
    connect( &KM, SIGNAL(SetLy(const QString &)), &Layer, SLOT(SetAct(const QString &)));
    connect( &KM, SIGNAL(SetNextLy(int)), &Layer, SLOT(SetActNext(int)));
    connect( &KM, SIGNAL(SetInfo(int,QString)), ib, SLOT(Set(int,QString)));

    KMP.SetKeyMapType(1);
    connect( wgP, SIGNAL(KeyPress(int)), &KMP, SLOT(ProcKey(int)));
    connect( &KMP, SIGNAL(SetAct(QString,int)), bbP, SLOT(SetAct(QString,int)));
    connect( &KMP, SIGNAL(SetLy(const QString &)), &LayerP, SLOT(SetAct(const QString &)));
    connect( &KMP, SIGNAL(SetNextLy(int)), &LayerP, SLOT(SetActNext(int)));
    connect( &KMP, SIGNAL(SetInfo(int,QString)), ibP, SLOT(Set(int,QString)));
    
     resize(1000,600);
    SetMSpecial();
    SetMPrj();

    connect(MPrj, SIGNAL(triggered(QAction *)), this, SLOT(LoadDb(QAction *)));

}

void My2Widget::resizeEvent ( QResizeEvent * /*e*/)
{
 Arrange();
}

void My2Widget::SetOutputs()
{
  OutDlg * Dl= new OutDlg(&Out);
  Dl->show();
}

void My2Widget::SetDrc()
{
  DrcDlg * Dl= new DrcDlg(&Drc);
  Dl->show();
}

void My2Widget::SetKeyMap()
{
  KeyMapDlg * Dl= new KeyMapDlg(&KM);
  Dl->show();
}

void My2Widget::SetKeyMapP()
{
  KeyMapDlg * Dl= new KeyMapDlg(&KMP);
  Dl->show();
}

void My2Widget::Settings()
{
  SetDlg * Dl= new SetDlg(NULL);
  if(Dl->exec()){
    gLib.SaveSetting();
    printf("Settings OK\n");
    wg->SettingsChanged();
    wgP->SettingsChanged();
  }  
  else printf("Settings Cancel\n");
}

void My2Widget::DoOutputs()
{
  QString s;
  if(Db->GetIden()==kDbSch) s.setNum(((DbSch *)Db)->GetVer());
  Out.DoOutputs(Db,DbP,fname,s);
}

void My2Widget::Arrange()
{
 int w;
 int h;


   w=width();
   h=height();
//   mainMenu->setGeometry( 0, 0, w, 24 );
//  quit->setGeometry( w-80, h-35, 75, 30 );

 if(W==kWSch){
  wg->setGeometry( 0, 50, w-60, h-100 );
  lsw->setGeometry( 0, 30, w, 20 );
  bb->setGeometry(w-60,50,60,h-100);
  ib->setGeometry(0,h-44,w,44);
  wgP->hide();
  lswP->hide();
  bbP->hide();
  ibP->hide();
  wgPr->hide();
  lswPr->hide();
  bbPr->hide();
  ibPr->hide();
  wg->show();
  lsw->show();
  bb->show();
  ib->show();
 }
 else if(W==kWPcb){
  wgP->setGeometry( 0, 50, w-60, h-100 );
  lswP->setGeometry( 0, 30, w, 20 );
  bbP->setGeometry(w-60,50,60,h-100);
  ibP->setGeometry(0,h-44,w,44);
  wg->hide();
  lsw->hide();
  bb->hide();
  ib->hide();
  wgPr->hide();
  lswPr->hide();
  bbPr->hide();
  ibPr->hide();
  wgP->show();
  lswP->show();
  bbP->show();
  ibP->show();
 }
 else if(W==kWSchPcb){
  wgP->setGeometry( w/2, 50, w/2-60, h-100 );
  lswP->setGeometry( w/2, 30, w/2, 20 );
  bbP->setGeometry(w-60,50,60,h-100);
  ibP->setGeometry(w/2,h-44,w/2,44);

  wg->setGeometry( 0, 50, (w/2)-60, h-100 );
  lsw->setGeometry( 0, 30, w/2-30, 20 );
  bb->setGeometry((w/2)-60,50,60,h-100);
  ib->setGeometry(0,h-44,w/2,44);

  wg->show();
  lsw->show();
  bb->show();
  ib->show();

  wgPr->hide();
  lswPr->hide();
  bbPr->hide();
  ibPr->hide();

  wgP->show();
  lswP->show();
  bbP->show();
  ibP->show();
 }
 else if(W==kWPrj){
  wgPr->setGeometry( 0, 50, w-60, h-100 );
  lswPr->setGeometry( 0, 30, w, 20 );
  bbPr->setGeometry(w-60,50,60,h-100);
  ibPr->setGeometry(0,h-44,w,44);
  wg->hide();
  lsw->hide();
  bb->hide();
  ib->hide();
  wgP->hide();
  lswP->hide();
  bbP->hide();
  ibP->hide();
  wgPr->show();
  lswPr->show();
  bbPr->show();
  ibPr->show();
 }
}

void My2Widget::SaveParts()
{
  QString dir;
  dir = QFileDialog::getExistingDirectory(this);
  if (dir.isEmpty()){
    return;
  }
  gLib.SaveParts(dir);
}

void My2Widget::Save()
{
 if(!Db && !DbP) return;
 if (fname.isEmpty()){
  fname = QFileDialog::getSaveFileName(this, tr("Save File"),0,tr("*.tdb"));
 }
 if (fname.isEmpty()){
  return;
 }
 setWindowTitle(fname);
 QFile F(fname+".bak");
 if(F.remove()) printf("Remove OK\n");
 F.setFileName(fname);
 F.open(QIODevice::ReadOnly);
 if(F.rename(fname+".bak")) printf("Rename OK\n");

 date=QDate::currentDate().toString().toUpper();
 QFileInfo FI(fname);
 bfname=FI.completeBaseName().toUpper();

 F.setFileName(fname);
 F.open(QIODevice::WriteOnly);
 QTextStream S;
 S.setDevice(&F);
 if(Db){
  if(Db->GetIden()==kDbSch){
   ((DbSch *)Db)->ClrNets();
   ver.setNum(((DbSch *)Db)->GetVer());
  }
  gLib.SaveSetting(&S);
  Out.TextSave(&S);
  Drc.TextSave(&S);
  KM.TextSave(&S);
  Layer.TextSave(&S);
  if(gLib.GetEmbedLib(-1)){
    gLib.SaveLib(&S,kPicPin);
    gLib.SaveLib(&S,kPicSComp);
  }
  S<<"{"<< sPic[Db->GetIden()] <<"\n";
  Db->TextSave(&S);
  Db->SetDate(&date,&bfname,&ver);
 }
 if(DbP){
  if(DbP->GetIden()==kDbPcb){
   ((DbPcb *)DbP)->CleanNets();
  }
  if(!Db)Out.TextSave(&S);
  KMP.TextSave(&S);
  LayerP.TextSave(&S,true);
  if(gLib.GetEmbedLib(-1)){
    gLib.SaveLib(&S,kPicPadS);
    gLib.SaveLib(&S,kPicPComp);
  }
  S<<"{"<< sPic[DbP->GetIden()] <<"\n";
  DbP->TextSave(&S);
  DbP->SetDate(&date,&bfname,&ver);
 }
 F.close();
}


void My2Widget::SaveP()
{
 if(!DbPr) return;
 if (pfname.isEmpty()){
  pfname = QFileDialog::getSaveFileName(this, tr("Save File"),0,tr("*.prj"));
 }
 if (pfname.isEmpty()){
  return;
 }
 setWindowTitle(pfname);
 QFile F(pfname);
 F.open(QIODevice::WriteOnly);
 QTextStream S;
 S.setDevice(&F);
 LayerPr.TextSave(&S);
 S<<"{"<< sPic[DbPr->GetIden()] <<"\n";
 DbPr->TextSave(&S);
 F.close();
}


void My2Widget::SaveAs()
{
 QString s;
 if(!Db && !DbP) return;
 s = QFileDialog::getSaveFileName(this, tr("Save As"),0,tr("*.tdb"));
 if (!s.isEmpty()){
  fname=s;
  Save();
 }
}

void My2Widget::SaveAsP()
{
 QString s;
 if(!DbPr) return;
 s = QFileDialog::getSaveFileName(this, tr("Save As"),0,tr("*.prj"));
 if (!s.isEmpty()){
  pfname=s;
  SaveP();
 }
}


void My2Widget::Print()
{
 QPrinter prt;
 

 prt.setResolution(72);
 prt.setOrientation(QPrinter::Landscape);
 prt.setColorMode(QPrinter::Color);
 prt.setOutputFileName(windowTitle()+".ps");
// prt.setOutputToFile(false);
 if((W==kWSch && Db) || (W==kWPcb && DbP)){
  QPrintDialog printDialog(&prt, this);
  if ( printDialog.exec() == QDialog::Accepted ){
   QPainter p;
   QRect r;
   float res;

//   int x;
   int width=595;
   int height=841;

   res=prt.resolution();
   printf("Resolution %d\n",prt.resolution());

   p.begin( &prt );

   r=p.viewport();
   printf("Wiewport x=%d y=%d w=%d h=%d\n",r.left(),r.top(),r.width(),r.height());

   width=r.width();
   height=r.height();


   int XPos;
   int XPos1;
   int YPos;
   int YPos1;

   float scale;
   unsigned int fl;

   if (W==kWSch && Db){
     Db->UpdORect();
    Db->GetORect(&r);
    fl=kDrawAll | kDrawMirrorTxt;
   }
   else{
     DbP->UpdORect();
     DbP->GetORect(&r);
     fl=kDrawAll;
     if(ibP && (ibP->IsOnFP())) fl|=kDrawFillPoly;
   }


   if ((float)width/r.width()<(float)height/r.height()){
    scale=(float)width/r.width();
   } else {
    scale=(float)height/r.height();
   }
//   scale=scale*0.9;
//   if(scale<0.03) scale=0.03;
   if(scale>1) scale=1;
   QPoint p1=r.center();
   XPos=-p1.x()+(int)((width/2)/scale);
   YPos=-p1.y()+(int)((height/2)/scale);
   
   printf("Scale %f\n",scale);

   if((scale>0.15) || (W!=kWSch)){
     if(W!=kWSch) scale=res/10000.0;
     p.scale(scale,scale);

     if (W==kWSch && Db) Db->DrawTo(&p,XPos,YPos,0,fl);
     else DbP->DrawTo(&p,XPos,YPos,0,fl);
   }
   else{
     scale=scale*1.4;
     p.scale(scale,scale);
//     p.rotate(90.0);

     printf("p1.x()=%d p1.y()=%d \n",p1.x(),p1.y());

     if(prt.orientation()==QPrinter::Landscape){
       prt.setOrientation(QPrinter::Portrait);
       XPos1=-p1.x();
       YPos1=-p1.y()+(int)((width/2)/scale);
       XPos=-p1.x()+(int)((height)/scale);
       YPos=-p1.y()+(int)((width/2)/scale);
     }
     else{
       prt.setOrientation(QPrinter::Landscape);
       XPos1=-p1.x()+(int)((height/2)/scale);
       YPos1=-p1.y();
       XPos=-p1.x()+(int)((height/2)/scale);
       YPos=-p1.y()+(int)((width)/scale);
     }
     

     if (W==kWSch && Db) Db->DrawTo(&p,XPos,YPos,0,fl);
     else DbP->DrawTo(&p,XPos,YPos,0,fl);
     prt.newPage();

     if (W==kWSch && Db) Db->DrawTo(&p,XPos1,YPos1,0,fl);
     else DbP->DrawTo(&p,XPos,YPos,0,fl);
     
     
   }  

   p.end();
  }
 }
}

void My2Widget::About()
{
  QString s;
  s.sprintf("peda v %d.%02d\n",VERSION/100,VERSION%100);
  gErr.Msg(s+"\nCopyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>\n\n"
      "This program is free software: you can redistribute it and/or modify "
    "it under the terms of the GNU General Public License as published by "
    "the Free Software Foundation, either version 3 of the License, or "
    "(at your option) any later version.\n\n"
    "This program is distributed in the hope that it will be useful, "
    "but WITHOUT ANY WARRANTY; without even the implied warranty of "
    "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the "
    "GNU General Public License for more details.\n\n"
    "Latest version of source code and examples are available on\nhttp://sourceforge.net/projects/peda/");
}

void My2Widget::New()
{
 QString s("../template/NEW.tdb");
 Load(s);
 fname="Untitled.tdb";
 setWindowTitle(fname);
}

void My2Widget::NewP()
{
 QString s("../template/NEW.prj");
 LoadP(s);
 pfname="../template/Untitled.prj";
 setWindowTitle(pfname);
}


void My2Widget::Load()
{
 QString s;
 s = QFileDialog::getOpenFileName(this, tr("Open File"),0,tr("*.tdb *.sco *.pco *.pin *.pad"));
 WiewSch();
 Load(s);
}

void My2Widget::LoadP()
{
 QString s;
 s = QFileDialog::getOpenFileName(this, tr("Open File"),0,tr("*.prj"));
 WiewPrj();
 LoadP(s);
}

void My2Widget::LoadDb(QAction * A)
{
 QString s;
 printf("LoadDb \n");
 s=A->text();
 printf("LoadDb %s\n",s.toLatin1().data());
 if(s!="Add"){
//  WiewSch();
  Load(s);
  if(DbPr && Db && Db->GetIden()==kDbSch){
   ((DbSch *)Db)->SetVer(DbPr->GetVer(s));
   ver.setNum(((DbSch *)Db)->GetVer());
   Db->SetDate(&date,&bfname,&ver);
   wg->UpdatePM();
   wg->update();
   if(DbP){
    DbP->SetDate(&date,&bfname,&ver);
    ((DbPcb *)DbP)->UpdateAtr();
    DbP->UpdORect();
    wgP->UpdatePM();
    wgP->update();
   }
   if(Db) WiewSch();
   else if(DbP) WiewPcb();
  }
 }
 else AddPrj();
}

void My2Widget::Load(QString name)
{
 QString s;
 if (name.isEmpty()){
  return;
 }
 fname=name;

 QDate Date;
 QFileInfo FI(fname);
 bfname=FI.completeBaseName().toUpper();
 Date=(FI.lastModified()).date();
 date=(Date.toString()).toUpper();


 setWindowTitle(fname);
 QFile F(fname);
 if(!F.open(QIODevice::ReadOnly)){
  gErr.Err("File not found "+fname);
  return;
 }
 QTextStream S;
 S.setDevice(&F);

 wg->SetDb(NULL);
 wgP->SetDb(NULL);
// PicGrp * D=NULL;
 if(Db) delete Db;
 if(DbP) delete DbP;
 Db=NULL;
 DbP=NULL;
 gLib.Clear(&Layer);
 gLib.Clear(&LayerP);
 Layer.DelDef(AllLy);
 LayerP.DelDef(AllLy);

 gErr.OpenLst();
 S >> s;
 while(!S.atEnd()){
  if (s.contains("OutSetting")) Out.TextLoad(&S);
  else if (s.contains("DrcSetting")) Drc.TextLoad(&S);
  else if (s.contains("SchKeyMapSetting")) KM.TextLoad(&S);
  else if (s.contains("PcbKeyMapSetting")) KMP.TextLoad(&S);
  else if (s.contains("Settings")) gLib.LoadSetting(&S);
  else if (s.contains("LayerP")){
//   printf("LayerP\n");
   LayerP.TextLoad(&S);
//   printf("LayerP Loaded\n");
  }
  else if (s.contains("Layer")){
//   printf("Layer\n");
   Layer.TextLoad(&S);
//   printf("Layer Loaded\n");
  }
  else if (s.contains("Data")){
   Db= new PicGrp(&Layer);
   Db->TextLoad(&S);
  }
  else if (s.contains(sPic[kPicGrp])){
   Db= new PicGrp(&Layer);
   Db->TextLoad(&S);
  }
  else if (s.contains(sPic[kPicPComp])){
   Db= new PicPComp(&Layer);
   Db->TextLoad(&S);
  }
  else if (s.contains(sPic[kPicSComp])){
   Db= new PicSComp(&Layer);
   Db->TextLoad(&S);
  }
  else if (s.contains(sPic[kDbSch])){
   Db= new DbSch(&Layer);
//   printf("DbSch\n");
   Db->TextLoad(&S);
//   printf("DbSch Loaded\n");
  }
  else if (s.contains(sPic[kDbPcb])){
   DbP= new DbPcb(&LayerP);
//   printf("DbPcb\n");
   DbP->TextLoad(&S);
//   printf("DbPcb Loaded\n");
  }
  else if (s.contains(sPic[kPicPadS])){
   Db= new PicPadS(&Layer);
   Db->TextLoad(&S);
  }
  else if (s.contains(sPic[kPicPin])){
   Db= new PicPin(&Layer);
   Db->TextLoad(&S);
  }
  else if (s.contains("LibPart")){
   gLib.LoadLib(&S,&Layer,&LayerP);
  }
  else{
    int i=1;
    do{
     S >> s;
     i+=s.count('{');
     i-=s.count('}');
    } while (i>0);
  }
  S >> s;
 }
 F.close();
 gErr.ShowLst();
 if(Db){
  Db->DeSelect();
  Db->SetLock(false);
  wg->SetDb(Db);
  bb->SetDbType(Db->GetIden());
  if(Db->GetIden()==kDbSch){
   ((DbSch *)Db)->Clean();
   ((DbSch *)Db)->UpdateAtr();
   ver.setNum(((DbSch *)Db)->GetVer());
  }
  Db->SetDate(&date,&bfname,&ver);
  if (!DbP){
   W=kWSch;
  }
 }
 if(DbP){
  if (!Db){
   W=kWPcb;
   Arrange();
  }
  DbP->DeSelect();
  DbP->SetLock(false);
  wgP->SetDb(DbP);
  bbP->SetDbType(DbP->GetIden());
  DbP->SetDate(&date,&bfname,&ver);
  if(DbP->GetIden()==kDbPcb){
   if(Db && Db->GetIden()==kDbSch){
     ToPcb();
   }
   ((DbPcb *)DbP)->UpdateAtr();
  }
 }
 Arrange();
 SetMSpecial();
}

void My2Widget::LoadP(QString name)
{
 QString s;
 if (name.isEmpty()){
  return;
 }
 pfname=name;
 setWindowTitle(pfname);
 QFile F(pfname);
 if(!F.open(QIODevice::ReadOnly)){
  gErr.Err("File not found "+fname);
  return;
 }
 QTextStream S;
 S.setDevice(&F);

 wgPr->SetDb(NULL);
// PicGrp * D=NULL;
 if(DbPr) delete DbPr;
 DbPr=NULL;
// gLib.Clear();
 gLib.Clear(&LayerPr);
 LayerPr.DelDef(AllLy);

 S >> s;
 while(!S.atEnd()){
  if (s.contains("Layer")){
//   printf("LayerP\n");
   LayerPr.TextLoad(&S);
//   printf("LayerP Loaded\n");
  }
  else if (s.contains(sPic[kDbPrj])){
   DbPr= new DbPrj(&LayerPr);
   DbPr->TextLoad(&S);
  }
  S >> s;
 }
 F.close();
 if(DbPr){
  DbPr->DeSelect();
  DbPr->SetLock(false);
  wgPr->SetDb(DbPr);
  bbPr->SetDbType(DbPr->GetIden());
 }
 W=0;
 Arrange();
 SetMPrj();
}



void My2Widget::SetMPrj()
{
 QString s;
 MPrj->clear();
 MPrj->addAction("Add");
 MPrj->insertSeparator(NULL);
 if(DbPr){
  DbPr->GetDbR();
  s=DbPr->GetDb();
  while(!s.isEmpty()){
   MPrj->addAction(s);
   s=DbPr->GetDb();
  }
 }
}

void My2Widget::AddPrj()
{
 QString s;
 if(DbPr && ((Db && Db->GetIden()==kDbSch) || (DbP && DbP->GetIden()==kDbPcb))){

  DbPr->GetDbR();
  s=DbPr->GetDb();
  while(!s.isEmpty()){
//   printf("%s %s\n",(const char *)s,(const char *)s);
   if(s==fname) return;
   s=DbPr->GetDb();
  }

  DbPr->AddDb(fname,0);
  if(Db && Db->GetIden()==kDbSch) DbPr->SetVer(fname,((DbSch *)Db)->GetVer());
  SetMPrj();
 }
}

void My2Widget::SetMSpecial()
{
 MSpecial->clear();

 MSpecial->addAction( "Tree", this, SLOT(TreeView()));

 MirrorID=MSpecial->addAction( "Mirror", this, SLOT(Mirror()));
 MirrorID->setCheckable(true); 
// if (Db && W==kWSch) MSpecial->setItemChecked(MirrorID,Db->GetMirror());
// if (DbP && W==kWPcb ) MSpecial->setItemChecked(MirrorID,DbP->GetMirror());
 if (Db && W==kWSch) MirrorID->setChecked(Db->GetMirror());
 if (DbP && W==kWPcb ) MirrorID->setChecked(DbP->GetMirror());

 MSpecial->addAction( "Clean", this, SLOT(Clean()));

 if(Db){
  if (Db->GetIden()==kDbSch){
    MSpecial->addAction( "Version", this, SLOT(SetVer()));
  }
  if (Db->GetIden()==kDbSch){
    MSpecial->addAction( "PCB Type", this, SLOT(SetSchType()));
  }
  if (Db->GetIden()==kDbSch){
    MSpecial->addAction( "Netlist", this, SLOT(Netlist()));
  }
  if (Db->GetIden()==kDbSch){
    MPart=MSpecial->addMenu( "Partlist");
//    connect(MPart, SIGNAL(activated(int)), this, SLOT(Partlist(int)));
    MPart->addAction( "By Ref", this, SLOT(Partlist0()));
    MPart->addAction( "By Val", this, SLOT(Partlist1()));
    MPart->addAction( "All By Ref", this, SLOT(Partlist2()));
    MPart->addAction( "All By Val", this, SLOT(Partlist3()));
    MPart->addAction( "All to csv", this, SLOT(Partlist4()));
  }
  if (Db->GetIden()==kDbSch){
    MSpecial->addAction( "Annotate", this, SLOT(Annotate()));
    MSpecial->addAction( "Add Ref.", this, SLOT(AddRef()));
  }
  if (Db->GetIden()==kDbSch){
    MSpecial->addAction( "ToPcb", this, SLOT(ToPcb()));
  }
  if (DbP && DbP->GetIden()==kDbPcb){
    MSpecial->addAction( "RtsNet", this, SLOT(RtsNet()));
    MSpecial->addAction( "DRC", this, SLOT(ProcDRC()));
    MSpecial->addAction( "Continuity check", this, SLOT(CheckCn()));
    MSpecial->addAction( "Clear polygon", this, SLOT(ClearPoly()));
    MSpecial->addAction( "UnClear polygon", this, SLOT(RmClearPoly()));
    MSpecial->addAction( "Rm unconnect poly.", this, SLOT(RmUnconnectPoly()));
  }
 }
}

void My2Widget::Clean()
{
 if(Db){
  Db->Clean();
  wg->UpdatePM();
  wg->update();
 }
 if(DbP){
  DbP->Clean();
  wgP->UpdatePM();
  wgP->update();
 }
}


void My2Widget::SetSchType()
{
 StrDlg DL(this);
 QString s("Std");
 QString s2("PCB Type :");
 if (DL.GetStr(&s,s2)){
  ((DbSch *)Db)->SetType(s);
  wg->UpdatePM();
  wg->update();
 }
}

void My2Widget::SetVer()
{
 if(Db->GetIden()==kDbSch){
  StrDlg DL(this);
  QString s;
  s.setNum(((DbSch *)Db)->GetVer());
  QString s2="Db Ver :";
  if (DL.GetStr(&s,s2)){
   ((DbSch *)Db)->SetVer(s.toInt());
   ver.setNum(((DbSch *)Db)->GetVer());
   Db->SetDate(&date,&bfname,&ver);
   wg->UpdatePM();
   wg->update();
   if(DbP){
    DbP->SetDate(&date,&bfname,&ver);
    ((DbPcb *)DbP)->UpdateAtr();
    DbP->UpdORect();
    wgP->UpdatePM();
    wgP->update();
   }
   if(DbPr){
    DbPr->SetVer(fname,s.toInt());
   }
  }
 }
}

void My2Widget::AddRef()
{
 if(Db->GetIden()==kDbSch){
  StrDlg DL(this);
  QString s;
  s.setNum(0);
  QString s2="Add to references :";
  if (DL.GetStr(&s,s2)){
   ((DbSch *)Db)->AddRef(s.toInt());
   wg->UpdatePM();
   wg->update();
  }
 }
}

void My2Widget::Netlist()
{
 if(((DbSch *)Db)->CheckRef()){
  ((DbSch *)Db)->Clean();
  ((DbSch *)Db)->UpdCGrp();
  ((DbSch *)Db)->Netlist();
 }
}


void My2Widget::Annotate()
{
 ((DbSch *)Db)->Annotate();
}

void My2Widget::Partlist0()
{
  Partlist(0);
}
void My2Widget::Partlist1()
{
  Partlist(1);
}
void My2Widget::Partlist2()
{
  Partlist(2);
}
void My2Widget::Partlist3()
{
  Partlist(3);
}
void My2Widget::Partlist4()
{
  Partlist(4);
}

void My2Widget::Partlist(int t)
{
 if(t<=1){
  Part * P=new Part;
  P->SetFName(fname);
  ((DbSch *)Db)->GetPart(P);
  P->SetType(t);
  P->Sort();
  P->List();
  PartDlg *D=new PartDlg(P,NULL);
  D->show();
  printf("Partlist : %lx\n",(unsigned long int)P);
 }
 else{
  if(DbPr) PartlistPr(t);
 }
}

void My2Widget::PartlistPr(int t)
{
 QString s;
 QString n;

 int i=1;
 DbSch * D=NULL;
 DbPcb * Pcb=NULL;
 QFile F;
 QTextStream S;
 Part * P=new Part;
 P->SetType(t);

 Layers * Lay=NULL;
 QString l;
 int x;
 int y;

 DbPr->GetDbR();
 n=DbPr->GetDb();
 while(!n.isEmpty()){
  F.setFileName(n);
  if(F.open(QIODevice::ReadOnly)){
   i=1;
  }
  else{
   printf("Partlist :: Error open %s\n",n.toLatin1().data());
  }
  S.setDevice(&F);

  if(D){
   delete D;
   D=NULL;
  }

  if(Pcb){
   delete Pcb;
   Pcb=NULL;
  }

  if(Lay){
   delete Lay;
   Lay=NULL;
  }

  S >> s;
  while(!S.atEnd() && i){
   if (i==1 && s.contains(sPic[kDbSch])){
    D= new DbSch(&LyTmp);
    D->TextLoad(&S);
    i=0;
   }
   else if (s.contains("LayerP")){
     printf("LayerP\n");
     Lay=new Layers();
     Lay->TextLoad(&S);
     printf("LayerP Loaded\n");
     i=0;
   }
   if (t==4 && s.contains(sPic[kDbPcb])){
    printf("DbPcb\n");
    if(!Lay) Lay=new Layers();
    Pcb= new DbPcb(Lay);
    Pcb->TextLoad(&S);
    i=0;
   }
   else if (s.contains("{")){
    i++;
   }
   else if (s.contains("}")){
    i--;
   }
   S >> s;
  }
  F.close();
  if(D){
   D->SetVer(DbPr->GetVer(n));
   printf("Partlist for %s\n",n.toLatin1().data());
   D->UpdCGrp();
   if(t==4) P->SetFName(pfname);
   else P->SetFName(n);
   D->GetPart(P);
  }
  else{
   printf("Error in %s\n",n.toLatin1().data());
  }
  if(Pcb && (t==4)){
    DbPr->GetParam(n,&x,&y,&l);
    if(Pcb->GetIden()==kDbPcb){
      printf("AddCenter %d,%d\n",x,y);
      Lay->SetAct((unsigned long int)0);
      Lay->SetVis("PINTOP");
      Lay->AddVis("PINBOT");
      Pcb->UpdateAtr();
      Pcb->UpdORect();
      P->AddCenter(Pcb,x,y);
    }
  }
  n=DbPr->GetDb();
 }
 printf("Partlist add all\n");
 if(D) delete D;
 if(Pcb) delete Pcb;
 if(Lay) delete Lay;
 if(t==4){
   QFile F(pfname.remove(".prj")+".csv");
   F.open(QIODevice::WriteOnly);
   QTextStream S;
   S.setDevice(&F);
   P->SetType(1);
   P->Sort();
 //  P->List();
   P->WriteCsv(S,0);
   S<<"\n\n";

   P->SetType(0);
   P->Sort();
 //  P->List();
   P->WriteCsv(S,0);
   S<<"\n\n";

//   P->SetType(4);
 //  P->Sort();
 //  P->List();
 //  P->WriteCsv(S,0);
   F.close();
 }
 else{
   printf("Partlist del D\n");
   P->Sort();
   printf("Partlist sort\n");
   PartDlg *Dl=new PartDlg(P,NULL);
   printf("Partlist dlg created\n");
   Dl->show();
   printf("Partlist end\n");
 }
}




void My2Widget::RtsNet()
{
 if (DbP){
  ((DbPcb *)DbP)->CleanNets();
  ((DbPcb *)DbP)->MkNets();
  DbP->UpdORect();
  wgP->UpdatePM();
  wgP->update();
 }
}


void My2Widget::Mirror()
{
 if(Db && W==kWSch){
  Db->SetMirror(1-Db->GetMirror());
//  MSpecial->setItemChecked(MirrorID,Db->GetMirror());
  MirrorID->setChecked(Db->GetMirror());
  wg->UpdatePM();
  wg->update();
 }
 if(DbP && W==kWPcb){
  DbP->SetMirror(1-DbP->GetMirror());
//  MSpecial->setItemChecked(MirrorID,DbP->GetMirror());
  MirrorID->setChecked(DbP->GetMirror());
  wgP->UpdatePM();
  wgP->update();
 }
}

void My2Widget::WiewPcb()
{
 gFlag=gFlag & 0xfffffffe;
 if(DbP) DbP->UpdORect();
 W=kWPcb;
 Arrange();
 SetMSpecial();
}

void My2Widget::WiewSch()
{
 gFlag=gFlag | 1;
 if(Db) Db->UpdORect();
 W=kWSch;
 Arrange();
 SetMSpecial();
}
void My2Widget::FitWiew()
{
  QRect r;
  if(W==kWSch){
    if(Db==NULL){
      if(DbP) WiewPcb();
      if(DbPr) WiewPrj();
    }
  }
  if(W==kWSch){
    if(Db){
      Db->GetORect(&r);
      wg->Zoom(r);
    }
  }
  if(W==kWPcb){
    if(Db){
      DbP->GetORect(&r);
      wgP->Zoom(r);
    }
  }
  if(W==kWPrj){
    if(Db){
      DbPr->GetORect(&r);
      wgPr->Zoom(r);
    }
  }
}

void My2Widget::WiewSchLib()
{
  LibBrowser *B=new LibBrowser(NULL);
  
  B->SetType(kPicSComp);
  connect( B, SIGNAL(SetCName(QString)),ib,SLOT(SetCName(QString)));
  connect( B, SIGNAL(ActSel(int)), wg, SLOT(LActSel(int)) );
  B->show();
}

void My2Widget::WiewPcbLib()
{
  LibBrowser *B=new LibBrowser(NULL);
  
  B->SetType(kPicPComp);
  connect( B, SIGNAL(SetCName(QString)),ibP,SLOT(SetCName(QString)));
  connect( B, SIGNAL(ActSel(int)), wgP, SLOT(LActSel(int)) );
  B->show();
}

void My2Widget::WiewSchPcb()
{
 gFlag=gFlag | 1;
 if(Db) Db->UpdORect();
 W=kWSchPcb;
 Arrange();
 SetMSpecial();
}

void My2Widget::WiewPrj()
{
 gFlag=gFlag | 1;
 if(DbPr) DbPr->UpdORect();
 W=kWPrj;
 Arrange();
 SetMSpecial();
}


void My2Widget::ToPcb()
{
 if(Db){
  if(Db->GetIden()==kDbSch){
   if(((DbSch *)Db)->CheckRef()){
    Netlist();
    if(!DbP)  DbP= new DbPcb(&LayerP);
    ((DbSch *)Db)->ToPcb((DbPcb *)DbP);
    DbP->DeSelect();
    ((DbPcb *)DbP)->DelInvalid();
    wgP->SetDb(DbP);
    ((DbPcb *)DbP)->CleanNets();
    ((DbPcb *)DbP)->MkNets();
    wgP->UpdatePM();
    wgP->update();
   }
  }
 }
}


void My2Widget::ImpPDF(QString name)
{
 ImpExp IE;
 if (name.isEmpty()) name = QFileDialog::getOpenFileName(this, tr("Open File"),0,tr("*.pdf"));

 QString s;
 if (name.isEmpty()){
  return;
 }

 QFile F(name);
 F.open(QIODevice::ReadOnly);
 QTextStream S;
 S.setDevice(&F);

 wgP->SetDb(NULL);
 if(DbP) delete DbP;
 gLib.Clear(&LayerP);
 LayerP.DelDef(AllLy);
 DbP= new DbPcb(&LayerP);

 if(IE.ImportPdf((DbPcb *)DbP,&S,1)){
  wgP->SetDb(DbP);
  DbP->UpdORect();
  ((DbPcb *)DbP)->UpdateAtr();
 }
 else{
  printf("Import Error\n");
  delete DbP;
  DbP=NULL;
 }

 F.close();
}

void My2Widget::ExpOrcSdt(QString name)
{
 OrcImpExp IE;

 if(!Db) return;
 if (name.isEmpty()) name = QFileDialog::getSaveFileName(this, tr("Save File"),0,tr("*.sch"));
 if (name.isEmpty()){
  return;
 }
 QFile F(name);
 F.open(QIODevice::WriteOnly);
 if(Db->GetIden()==kDbSch){
  ((DbSch *)Db)->ClrNets();
  if(IE.ExportSdt((DbSch *)Db,&F)){
   printf("Export OK\n");
  }
 }
}

void My2Widget::ImpOrcSdt(QString name)
{
 WiewSch();
 QString s("../template/Orc.tdb");
 Load(s);
 fname="../template/Untitled.tdb";
 setWindowTitle(fname);

 OrcImpExp IE;
 if (name.isEmpty()) name = QFileDialog::getOpenFileName(this, tr("Open File"),0,tr("*.sch"));

// QString s;
 if (name.isEmpty()){
  return;
 }

 QDate Date;
 QFileInfo FI(name);
 bfname=FI.completeBaseName().toUpper();
 Date=(FI.lastModified()).date();
 date=(Date.toString()).toUpper();

 QFile F(name);
 F.open(QIODevice::ReadOnly);

 wg->SetDb(NULL);
 if(Db) delete Db;
// gLib.Clear(&Layer);
// Layer.DelDef(AllLy);
 Db= new DbSch(&Layer);

 if(IE.ImportSdt((DbSch *)Db,&F,1)){
  wg->SetDb(Db);
  Layer.SetVis("WIRE");
  Layer.AddVis("POWER");
  Layer.AddVis("PrBody");
  Layer.AddVis("VAL");
  Layer.AddVis("REF");
  Layer.AddVis("PINNUM");
  Layer.AddVis("DESC");

  Layer.SetAct("WIRE");

  ver="0";
  ((DbSch *)Db)->SetDate(&date,&bfname,&ver);

  Db->Clean();
  Db->UpdORect();
  ((DbSch *)Db)->UpdateAtr();

  fname=name.remove(".sch")+".tdb";
  setWindowTitle(fname);
 }
 else{
  printf("Import Error\n");
  delete Db;
  Db=NULL;
 }

 F.close();
}

void My2Widget::ImpOrcLib(QString name)
{
 OrcImpExp IE;

 if (name.isEmpty()) name = QFileDialog::getOpenFileName(this, tr("Open File"),0,tr("*.tlb"));

 if (name.isEmpty()){
  return;
 }

 QFile F(name);
 F.open(QIODevice::ReadOnly);
 QTextStream S;
 S.setDevice(&F);

 if(IE.ImportLib(&S)){
  printf("Import OK\n");
 }
 else{
  printf("Import Error\n");
 }
 F.close();
}

void My2Widget::ImpPComps(QString name)
{
 ImpPComp IE;
 int i;
 
 if (name.isEmpty()) name = QFileDialog::getOpenFileName(this, tr("Open File"),0,tr("*.tlb"));

 if (name.isEmpty()){
  return;
 }

 QFile F(name);
 F.open(QIODevice::ReadOnly);
 QTextStream S;
 S.setDevice(&F);
 
 i=IE.Import(&S);
 if(i){
  printf("Import %d components OK\n",i);
 }
 else{
  printf("Import Error\n");
 }
 F.close();
}


void My2Widget::ImpPDFC()
{
 QString name;
 ImpExp IE;
 name = QFileDialog::getOpenFileName(this, tr("Open File"),0,tr("*.tdf"));

 QString s;
 if (name.isEmpty()){
  return;
 }

 QFile F(name);
 F.open(QIODevice::ReadOnly);
 QTextStream S;
 S.setDevice(&F);

 wg->SetDb(NULL);
 if(Db) delete Db;
 gLib.Clear(&Layer);
 Layer.DelDef(AllLy);
 Db= new PicPComp(&Layer);

 if(IE.ImportPdf((PicPComp *)Db,&S)){
//  Db->UpdORect();
  wg->SetDb(Db);
 }
 else{
  printf("Import Error\n");
  delete Db;
  Db=NULL;
 }

 F.close();
}

void My2Widget::ProcDRC()
{
 if(DbP && DbP->GetIden()==kDbPcb){
  ((DbPcb *)DbP)->CleanNets();
  ((DbPcb *)DbP)->MkNets();
  ((DbPcb *)DbP)->Drc(Drc);
  DbP->UpdORect();
  wgP->UpdatePM();
  wgP->update();
 }
}

void My2Widget::CheckCn()
{
 if(DbP && DbP->GetIden()==kDbPcb){
  ((DbPcb *)DbP)->CheckCn();
  DbP->UpdORect();
//  wgP->UpdatePM();
//  wgP->update();
 }
}

void My2Widget::ClearPoly()
{
 if(DbP){
   DbP->RmClearPoly();
   DbP->ClearPoly();
   DbP->Clean();
   wgP->UpdatePM();
   wgP->update();
 }
}

void My2Widget::RmClearPoly()
{
 if(DbP){
   DbP->RmClearPoly();
   DbP->Clean();
   wgP->UpdatePM();
   wgP->update();
 }
}

void My2Widget::RmUnconnectPoly()
{
  if(DbP && DbP->GetIden()==kDbPcb){
    ((DbPcb *)DbP)->CleanNets();
    ((DbPcb *)DbP)->MkNets();
    DbP->RmUnconnectPoly();
    wgP->UpdatePM();
    wgP->update();
  } 
}

void My2Widget::TreeView()
{
 PicGrp * D=NULL;
 if(W==kWSch && Db){
  D=Db;
 }
 if(W==kWPcb && DbP){
  D=DbP;
 }
 if(W==kWPrj && DbPr){
  D=DbPr;
 }
 if(D){
  TreeList *T=new TreeList(D,NULL);
  T->show();
  if(Db && W==kWSch){
   wg->UpdatePM();
   wg->update();
  }
  if(DbP && W==kWPcb){
   wgP->UpdatePM();
   wgP->update();
  }
  if(DbPr && W==kWPrj){
   wgPr->UpdatePM();
   wgPr->update();
  }
 }
}

int main( int argc, char **argv )
{
    QApplication::setColorSpec( QApplication::ManyColor );
    QApplication a(argc, argv);
//    a.setFont( QFont( "Courier", 8 ) );

    int r=1;

    QString s;
    QFile F;

    printf("peda v %d.%02d\n",VERSION/100,VERSION%100);
    printf("Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>\n");
    printf("This program comes with ABSOLUTELY NO WARRANTY\n");
    printf("This is free software, and you are welcome to redistribute it\n");
    printf("under certain conditions; for details see Help->About\n");

/*    F.setName(".pedarc-libs");
    if(!F.exists()) F.setName("/etc/.pedarc-libs");
    if(F.open(QIODevice::ReadOnly)){
     QTextStream S1;
     S1.setDevice(&F);
     S1>>s;
     while(!S1.atEnd()){
      gLib.AddDir((const char*)s);
      printf("gLib.AddDir %s\n",(const char*)s);
      S1>>s;
     }
     F.close();
    }
    else{
      gLib.AddDir("../pin/");
      gLib.AddDir("../vias/");
      gLib.AddDir("./");
    }
*/    
    gLib.LoadSetting();

//    gLib.AddDir("data/orcad/");
//    gLib.AddDir("data/pcad/");
//    gLib.AddDir("data/pco/");
//    gLib.AddDir("data/sco/");
//    gLib.AddDir("data/");

    gFlag=0;

    My2Widget wd;

    if(argc > 1){
     if(argv[1][0]=='-'){
      switch(argv[1][1]) {
       case 'l':
        if(argc < 3){
         printf("Error: missing filename\n");
        }
        else{
         wd.ImpOrcLib(argv[2]);
        }
        r=0;
        break;
       case 'e':
        if(argc < 3){
         printf("Error: missing filename\n");
        }
        else{
         wd.Load(argv[2]);
         s=argv[2];
         s.remove(".tdb");
         s=s+".sch";
         wd.ExpOrcSdt(s);
        }
        r=0;
        break;
       case 'c':
        if(argc < 3){
         printf("Error: missing filename\n");
        }
        else{
         wd.ImpOrcSdt(argv[2]);
         wd.Save();
        }
        r=0;
        break;
       case 's':
        if(argc < 3){
         printf("Error: missing filename\n");
         r=0;
        }
        else{
         wd.ImpOrcSdt(argv[2]);
        }
        break;
       case 'p':
        if(argc < 3){
         printf("Error: missing filename\n");
         r=0;
        }
        else{
         wd.ImpPDF(argv[2]);
        }
        break;
       case 'i':
        if(argc < 3){
         printf("Error: missing filename\n");
        }
        else{
         wd.ImpPComps(argv[2]);
        }
        r=0;
        break;
       case 'h':
       default:
        printf("Usage:\n peda [opt] [filename]\n");
        printf(" -l name  import orcad library\n");
        printf(" -s name  import orcad schematics\n");
        printf(" -p name  import pcad pdf\n");
        printf(" -c name  convert orcad schematics to peda tdb\n");
        printf(" -e name  export schematics to orcad\n");
        printf(" -i name  import pcb components\n");
        printf(" -h       help\n");
        r=0;
        break;
      }
     }
     else{
      wd.Load(argv[1]);
     }
    }

//    w.setGeometry( 10, 10, 200, 120 );
  if(r){
//    a.setMainWidget( &wd );

    wd.show();
    wd.WiewSch();
    wd.FitWiew();
    return a.exec();
  }
}
