#
# This source file is part of the EdgeDB open source project.
#
# Copyright 2008-present MagicStack Inc. and the EdgeDB authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

"""Declarations of supported range functions"""

COLUMNS = {
    'json_array_elements': ['value'],
    'json_array_elements_text': ['value'],
    'json_each': ['key', 'value'],
    'json_each_text': ['key', 'value'],
    'jsonb_array_elements': ['value'],
    'jsonb_array_elements_text': ['value'],
    'jsonb_each': ['key', 'value'],
    'jsonb_each_text': ['key', 'value'],
    'pg_available_extension_versions': [
        'name',
        'version',
        'superuser',
        'trusted',
        'relocatable',
        'schema',
        'requires',
        'comment',
    ],
    'pg_available_extensions': ['name', 'default_version', 'comment'],
    'pg_config': ['name', 'setting'],
    'pg_control_checkpoint': [
        'checkpoint_lsn',
        'redo_lsn',
        'redo_wal_file',
        'timeline_id',
        'prev_timeline_id',
        'full_page_writes',
        'next_xid',
        'next_oid',
        'next_multixact_id',
        'next_multi_offset',
        'oldest_xid',
        'oldest_commit_ts_xid',
        'checkpoint_time',
        'newest_commit_ts_xid',
        'oldest_multi_dbid',
        'oldest_multi_xid',
        'oldest_active_xid',
        'oldest_xid_dbid',
    ],
    'pg_control_init': [
        'max_data_alignment',
        'database_block_size',
        'blocks_per_segment',
        'wal_block_size',
        'bytes_per_wal_segment',
        'max_identifier_length',
        'max_index_columns',
        'max_toast_chunk_size',
        'large_object_chunk_size',
        'float8_pass_by_value',
        'data_page_checksum_version',
    ],
    'pg_control_recovery': [
        'min_recovery_end_lsn',
        'min_recovery_end_timeline',
        'backup_start_lsn',
        'backup_end_lsn',
        'end_of_backup_record_required',
    ],
    'pg_control_system': [
        'pg_control_version',
        'catalog_version_no',
        'system_identifier',
        'pg_control_last_modified',
    ],
    'pg_copy_logical_replication_slot': [
        'slot_name',
        'slot_name',
        'lsn',
        'slot_name',
        'lsn',
        'lsn',
    ],
    'pg_copy_physical_replication_slot': [
        'slot_name',
        'lsn',
        'slot_name',
        'lsn',
    ],
    'pg_create_logical_replication_slot': ['slot_name', 'lsn'],
    'pg_create_physical_replication_slot': ['slot_name', 'lsn'],
    'pg_cursor': [
        'name',
        'statement',
        'is_holdable',
        'is_binary',
        'is_scrollable',
        'creation_time',
    ],
    'pg_event_trigger_ddl_commands': [
        'classid',
        'objid',
        'objsubid',
        'command_tag',
        'object_type',
        'schema_name',
        'object_identity',
        'in_extension',
        'command',
    ],
    'pg_event_trigger_dropped_objects': [
        'classid',
        'objid',
        'objsubid',
        'original',
        'normal',
        'is_temporary',
        'object_type',
        'schema_name',
        'object_name',
        'object_identity',
        'address_names',
        'address_args',
    ],
    'pg_event_trigger_table_rewrite_oid': ['oid'],
    'pg_extension_update_paths': ['source', 'target', 'path'],
    'pg_get_backend_memory_contexts': [
        'name',
        'ident',
        'parent',
        'level',
        'total_bytes',
        'total_nblocks',
        'free_bytes',
        'free_chunks',
        'used_bytes',
    ],
    'pg_get_catalog_foreign_keys': [
        'fktable',
        'fkcols',
        'pktable',
        'pkcols',
        'is_array',
        'is_opt',
    ],
    'pg_get_keywords': ['word', 'catcode', 'barelabel', 'catdesc', 'baredesc'],
    'pg_get_multixact_members': ['xid', 'mode'],
    'pg_get_object_address': ['classid', 'objid', 'objsubid'],
    'pg_get_publication_tables': ['relid'],
    'pg_get_replication_slots': [
        'slot_name',
        'plugin',
        'slot_type',
        'datoid',
        'temporary',
        'active',
        'active_pid',
        'xmin',
        'catalog_xmin',
        'restart_lsn',
        'confirmed_flush_lsn',
        'wal_status',
        'safe_wal_size',
        'two_phase',
    ],
    'pg_get_shmem_allocations': ['name', 'off', 'size', 'allocated_size'],
    'pg_hba_file_rules': [
        'line_number',
        'type',
        'database',
        'user_name',
        'address',
        'netmask',
        'auth_method',
        'options',
        'error',
    ],
    'pg_identify_object': ['type', 'schema', 'name', 'identity'],
    'pg_identify_object_as_address': ['type', 'object_names', 'object_args'],
    'pg_last_committed_xact': ['xid', 'timestamp', 'roident'],
    'pg_lock_status': [
        'locktype',
        'database',
        'relation',
        'page',
        'tuple',
        'virtualxid',
        'transactionid',
        'classid',
        'objid',
        'objsubid',
        'virtualtransaction',
        'pid',
        'fastpath',
        'waitstart',
        'granted',
        'mode',
    ],
    'pg_logical_slot_get_binary_changes': ['lsn', 'xid', 'data'],
    'pg_logical_slot_get_changes': ['lsn', 'xid', 'data'],
    'pg_logical_slot_peek_binary_changes': ['lsn', 'xid', 'data'],
    'pg_logical_slot_peek_changes': ['lsn', 'xid', 'data'],
    'pg_ls_archive_statusdir': ['name', 'size', 'modification'],
    'pg_ls_logdir': ['name', 'size', 'modification'],
    'pg_ls_tmpdir': [
        'name',
        'size',
        'name',
        'modification',
        'size',
        'modification',
    ],
    'pg_ls_waldir': ['name', 'size', 'modification'],
    'pg_mcv_list_items': [
        'index',
        'values',
        'nulls',
        'frequency',
        'base_frequency',
    ],
    'pg_options_to_table': ['option_name', 'option_value'],
    'pg_partition_ancestors': ['relid'],
    'pg_partition_tree': ['relid', 'parentrelid', 'isleaf', 'level'],
    'pg_prepared_statement': [
        'name',
        'statement',
        'prepare_time',
        'parameter_types',
        'from_sql',
        'generic_plans',
        'custom_plans',
    ],
    'pg_prepared_xact': ['transaction', 'gid', 'prepared', 'ownerid', 'dbid'],
    'pg_replication_slot_advance': ['slot_name', 'end_lsn'],
    'pg_sequence_parameters': [
        'start_value',
        'minimum_value',
        'maximum_value',
        'increment',
        'cycle_option',
        'cache_size',
        'data_type',
    ],
    'pg_show_all_file_settings': [
        'sourcefile',
        'sourceline',
        'seqno',
        'name',
        'setting',
        'applied',
        'error',
    ],
    'pg_show_all_settings': [
        'name',
        'setting',
        'unit',
        'category',
        'short_desc',
        'extra_desc',
        'context',
        'vartype',
        'source',
        'min_val',
        'max_val',
        'enumvals',
        'boot_val',
        'reset_val',
        'sourcefile',
        'sourceline',
        'pending_restart',
    ],
    'pg_show_replication_origin_status': [
        'local_id',
        'external_id',
        'remote_lsn',
        'local_lsn',
    ],
    'pg_stat_file': [
        'size',
        'size',
        'access',
        'modification',
        'access',
        'modification',
        'change',
        'change',
        'creation',
        'isdir',
        'creation',
        'isdir',
    ],
    'pg_stat_get_activity': [
        'datid',
        'pid',
        'usesysid',
        'application_name',
        'state',
        'query',
        'wait_event_type',
        'wait_event',
        'xact_start',
        'query_start',
        'ssl',
        'backend_start',
        'state_change',
        'client_addr',
        'client_hostname',
        'client_port',
        'backend_xid',
        'backend_xmin',
        'query_id',
        'leader_pid',
        'gss_enc',
        'gss_princ',
        'gss_auth',
        'ssl_issuer_dn',
        'ssl_client_serial',
        'ssl_client_dn',
        'sslbits',
        'sslcipher',
        'sslversion',
        'backend_type',
    ],
    'pg_stat_get_archiver': [
        'archived_count',
        'last_archived_wal',
        'last_archived_time',
        'failed_count',
        'last_failed_wal',
        'last_failed_time',
        'stats_reset',
    ],
    'pg_stat_get_progress_info': [
        'pid',
        'datid',
        'relid',
        'param1',
        'param2',
        'param3',
        'param4',
        'param5',
        'param6',
        'param7',
        'param20',
        'param18',
        'param17',
        'param16',
        'param15',
        'param14',
        'param13',
        'param12',
        'param11',
        'param10',
        'param9',
        'param8',
        'param19',
    ],
    'pg_stat_get_replication_slot': [
        'slot_name',
        'spill_txns',
        'spill_count',
        'spill_bytes',
        'stream_txns',
        'stream_count',
        'stream_bytes',
        'total_txns',
        'total_bytes',
        'stats_reset',
    ],
    'pg_stat_get_slru': [
        'name',
        'blks_zeroed',
        'blks_hit',
        'blks_read',
        'blks_written',
        'blks_exists',
        'flushes',
        'truncates',
        'stats_reset',
    ],
    'pg_stat_get_subscription': [
        'subid',
        'relid',
        'pid',
        'received_lsn',
        'last_msg_send_time',
        'last_msg_receipt_time',
        'latest_end_lsn',
        'latest_end_time',
    ],
    'pg_stat_get_wal': [
        'wal_records',
        'wal_fpi',
        'wal_bytes',
        'wal_buffers_full',
        'wal_write',
        'wal_sync',
        'wal_write_time',
        'wal_sync_time',
        'stats_reset',
    ],
    'pg_stat_get_wal_receiver': [
        'pid',
        'status',
        'receive_start_lsn',
        'receive_start_tli',
        'written_lsn',
        'flushed_lsn',
        'received_tli',
        'last_msg_send_time',
        'last_msg_receipt_time',
        'latest_end_lsn',
        'latest_end_time',
        'slot_name',
        'sender_host',
        'sender_port',
        'conninfo',
    ],
    'pg_stat_get_wal_senders': [
        'pid',
        'state',
        'sent_lsn',
        'write_lsn',
        'flush_lsn',
        'replay_lsn',
        'write_lag',
        'flush_lag',
        'replay_lag',
        'sync_priority',
        'sync_state',
        'reply_time',
    ],
    'pg_stop_backup': ['lsn', 'labelfile', 'spcmapfile'],
    'pg_timezone_abbrevs': ['abbrev', 'utc_offset', 'is_ds'],
    'pg_timezone_names': ['name', 'abbrev', 'utc_offset', 'is_dst'],
    'pg_walfile_name_offset': ['file_name', 'file_offset'],
    'pg_xact_commit_timestamp_origin': ['timestamp', 'roident'],
}

# retrieved with
r'''
WITH
    procedures AS (
        SELECT *
        FROM pg_proc
        WHERE proname NOT ILIKE 'ts\_%'
          AND proname NOT ILIKE '\_%'
          AND proname != 'unnest'
          AND proname != 'aclexplode'
    ),
    pro_args AS (
        SELECT proname,
            UNNEST(proargnames) AS argname,
            UNNEST(proargmodes) AS argmode,
            GENERATE_SERIES(0, 10, 1) AS argn
        FROM procedures
    ),
    pro_outputs AS (
        SELECT *
        FROM pro_args
        WHERE argmode = 'o'
        ORDER BY proname, argn
    )
SELECT proname, ARRAY_AGG(argname)
FROM pro_outputs
GROUP BY proname;
'''
