#
# This source file is part of the EdgeDB open source project.
#
# Portions Copyright 2023-present MagicStack Inc. and the EdgeDB authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

for x in range_unpack(range(1, 1001)) union (
    insert Gist {
        p_str := "qwertyu" ++ str_pad_start(<str>x, 4, "0"),
    }
);

for x in range_unpack(range(1, 1001)) union (
    insert Gist2 {
        p_str := "qwertyu" ++ str_pad_start(<str>x, 4, "0"),
        p_str_2 := "iopasdf" ++ str_pad_start(<str>x, 4, "0"),
    }
);

# Dataset excerpt from pg_trgm tests in Postgres
for x in {
    "Tandobai Algad",
    "Daikalay",
    "Stubaital",
    "Neustift im Stubaital",
    "Anonyme Appartments Stubaital",
    "Barkaladja Pool",
    "Awabakal Nature Reserve",
    "Awabakal Field Studies Centre",
    "Barkala",
    "Bailallie",
    "Barkala Park",
    "Purba Kalaujan",
    "Nabakalas",
    "Barkal",
    "Baikanthapur",
    "Baikarjhuti",
    "Baika",
    "Baikari",
    "Purba Kalmegha",
    "Baskaltsi",
    "Bajkal",
    "Riacho do Sambaibal",
    "Sambaibal",
    "Barkalabava",
    "Kaikalahun Indian Reserve 25",
    "Tumba-Kalamba",
    "Kamba-Kalele",
    "Boyagbakala",
    "Bombakalo",
    "Batikalengbe",
    "Matamba-Kalenge",
    "Kambakala",
    "Abakalu",
    "Bonagbakala",
    "Bikala Madila",
    "Bikala",
    "Bumba-Kaloki",
    "Tumba-Kalunga",
    "Kabankala",
    "Mambakala",
    "Tumba-Kalumba",
    "Kabakala",
    "Bikalabwa",
    "Bomba-Kalende",
    "Mwalaba-Kalamba",
    "Matamba-Kalenga",
    "Bumba-Kalumba",
    "Bikalange",
    "Kabikala",
    "Mubikale",
    "Kanampumba-Kalawa",
    "Tshiabakale",
    "Bambakala",
    "Tsibakala",
    "Kimbakala",
    "Dabakalakoro",
    "Dabakala",
    "Mobaika",
    "Baimalou",
    "Xibaitaling",
    "Baikai",
    "Baikang",
    "Baitaling",
    "Baikan",
    "Baimaling Linchang",
    "Baimalong",
    "Baikanzui",
    "Baiyali",
    "Baimaling",
    "Baimalang Donggang",
    "Baikangshuoma",
    "Baitaliao",
    "Taikale",
    "Babainale",
    "Bailale",
    "Baibale",
    "Baiwale",
    "Baikangnei",
    "Baitali",
    "Xiabaikan",
    "Bailalong",
    "Baimaluo",
    "Baikacun",
    "Baisala",
    "Bailalin",
    "Baimala",
    "Baidalong",
    "Dabaika",
    "Caikalong",
    "Cuobaikacun",
    "Baikadangcun",
    "Baimalin",
    "Subaika",
    "Gabakkale",
    "Barkallou",
    "Embatkala",
    "Bodega Tabaibal",
    "Golba Kalo",
    "Haikala",
    "Kaikale",
    "Waikaloulevu",
    "Waikalou Creek",
    "Waikalou",
    "Ndelaikalou",
    "Ndelaikalokalo",
    "Bay of Backaland",
    "Bankali",
    "Ker Samba Kalla",
    "Demba Kali",
    "Baipal",
    "Kalibakalako",
    "Dalabakala",
    "Bikal",
    "Sembaikan",
    "Praikalogu",
    "Tanjung Ompaikalio",
    "Bonebabakal",
    "Tanjung Batikala",
    "Buku Baikole",
    "Pulau Baika",
    "Kebakkalang",
    "Ngambakalang",
    "Mota Sabakal",
    "Babakalo",
    "Buyu Rapanbakalai",
    "Kalimundubakalan",
    "Tanabakal",
    "Tanjung Aikaluin",
    "Desa Kebakalan",
    "Kebakalan",
    "Kalibakal",
    "Trobakal",
    "Alue Bakkala",
    "Moncong Baika",
    "Sampangbakalan",
    "Lebakkalapa Tonggoh",
    "Trembakal",
    "Desa Cemengbakalan",
    "Desa Tambakkalisogo",
    "Tambakkalisogo",
    "Laikalanda",
    "Tanjung Mbakalang",
    "Kali Purbakala",
    "Tukad Kubakal",
    "Praikalangga",
    "Banjar Kubakal",
    "Kombakalada",
    "Sori Rabakalo",
    "Kahambikalela",
    "Baikarara",
    "Baikapaka",
    "Teluk Haludubakal",
    "Yabakalewa",
    "Praikalumbang",
    "Waikalowo",
    "Praikalubu",
    "Loko Praikalubu",
    "Ramuk Ombakalada",
    "Praikalebung",
    "Praikaleka",
    "Andabakal",
    "Praikalau",
    "Praikalokat",
    "Praikalimbung",
    "Bambakalo",
    "Leubakkalian",
    "Pematang Baitalimbangan",
    "Lebakalil",
    "Gereba Kaler",
    "Muarabakal",
    "Umbulan Maharobakal",
    "Baidaloen",
    "Jatibakal",
    "Dola Peimambakal",
    "Salu Baidale",
    "Parbakalan",
    "Praikalembu",
    "Palindi Laikali",
    "Praikalu",
    "Sori Labakalate",
    "Sungaikalung",
    "Sungaikalong",
    "Payabakal",
    "Waikala",
    "Sungaikali",
    "Sungai Pebakalan",
    "Parit Membakal",
    "Baikat Abu Jaraban",
    "Maikalganj",
    "Maikala Range",
    "Baitalpur",
    "Baikanthpur",
    "Baihal",
    "Barkala Reserved Forest",
    "Babaipalli",
    "Kaikalapettai",
    "Kambainallur",
    "Bakkalale",
    "Kaikalui",
    "Baijalpur",
    "Nehalla Bankalah Reserved Forest",
    "Barkala Rao",
    "Barkali",
    "Baidal",
    "Barkaleh",
    "Darreh Pumba Kal",
    "Bahkalleh",
    "Wibakale",
    "Gaikali",
    "Gagaba Kalo",
    "Barkalare",
    "Bakkalmal",
    "Bugor Arba-Kalgan",
    "Kolodets Tabakkalgan",
    "Walangivattu Vaikal",
    "Vattevaikal Anicut",
    "Vaikali Tevar Kulam",
    "Vaikalitevan Kulam",
    "Vaikaladichchenai",
    "Uchchodaikallu",
    "Sellapattu Vaikal",
    "Savata Vaikal",
    "Puttadivali Vaikal",
    "Palukadu Vaikal",
    "Mulaikallu Kulam",
    "Koraikallimadu",
    "Koraikalapu Kulam",
    "Karaiyamullivaikal",
    "Karaivaikal Kulam",
    "Kanawali Vaikal",
    "Habakkala",
    "Chalam Vaikal Aru",
    "Ambakala Wewa",
    "Alaikallupoddakulam",
    "Alaikallupodda Alankulam",
    "Akamadi Vaikal",
    "Alaikalluppodda Kulam",
    "Vaikaliththevakulam",
    "Baikole",
    "Sidi Mohammed Bakkal",
    "Oulad el Bakkal",
    "Azib el Bakkali",
    "Tombakala",
    "Malaikaly",
    "Ambadikala",
    "Abankala",
    "Kombakala",
    "Bawkalut",
    "Bawkalut Chaung",
    "Baukala",
    "Cerro Bainaltzin",
    "Bukit Ubaibalih",
    "Kampong Sombakal",
    "Kampung Lebai Ali",
    "Batikal",
    "Maikali",
    "Abakaliki",
    "Tsaunin Maikalaji",
    "Baikaha",
    "Llano Limbaika",
    "Barkald",
    "Barkald stasjon",
    "Barkaleitet",
    "Barkaldfossen",
    "Barkaldvola",
    "Bakkalegskardet",
    "Baikajavri",
    "Barkalden",
    "Bakkalia",
    "Siljabaika",
    "Aikaluokta",
    "Blombakkali",
    "Bavkalasis",
    "Baikajohka",
    "Bakkalykkja",
    "Baiyaldi",
    "Naikala",
    "Baikanda",
    "Barkalne",
    "Raikal",
    "Baikatte",
    "Maikal",
    "Waikalabubu Bay",
    "Baikai Island",
    "Abikal",
    "Boikalakalawa Bay",
    "Maikal River",
    "Bankal",
    "Bankal School",
    "Kabankalan City Public Plaza",
    "Ranra Tabai Algad",
    "Bairkal Jabal",
    "Bairkal Dhora",
    "Bairkal",
    "Zaibai Algad",
    "Gulba Kalle",
    "Dabbarkal Sar",
    "Tabai Algad",
    "Haikalzai",
    "Wuchobai Algad",
    "Jabba Kalai",
    "Goth Soba Kaloi",
    "Baikar Tsarai",
    "Dudgaikal",
    "Baixale Kamar",
    "Zebai Algad",
    "Goth Haikal",
    "Haikal",
    "Jaba Kalle",
    "Salabaikasy",
    "Guba Kalita",
    "Guba Kalgalaksha",
    "Guba Kaldo",
    "Baskalino",
    "Sopka Barkaleptskaya",
    "Zabaykalovskiy",
    "Barkalova",
    "Barkalovka",
    "Gora Barkalova",
    "Gora Barkalyu",
    "Bikalamakhi",
    "Zabaykalka",
    "Kambaika",
    "Bikalikha",
    "Kordon Barkalo",
    "Ramada Makkah Shubaika",
    "Mount Tohebakala",
    "Tambakale Island",
    "Mbanitambaika Island",
    "Mbakalaka Island",
    "Kumbakale",
    "Kaikaloka",
    "Kelesaikal",
    "Nasb Gabakallah",
    "Jabal Barkal",
    "Jabal Abakallah",
    "Al Barkali",
    "Shabakal Abbass",
    "Mabaikuli",
    "Bambakalema",
    "Bambakalia",
    "Baiwala",
    "Babakalia",
    "Baikama",
    "Bankalol",
    "Kundebakali",
    "Yumbaikamadu",
    "Tabakali",
    "Daba Kalharereh",
    "Barkale",
    "Jabal Mobakali",
    "Korombaital",
    "Ambakali",
    "Ba Kaliin",
    "Tagobikala",
    "Fayzabadkala",
    "Aghbai Allazy",
    "Aghbai Alikagar",
    "Gora Fayzabadkala",
    "Daraikalot",
    "Aghbai Alakisirak",
    "Beikala",
    "Foho Berbakalau",
    "Mota Caicabaisala",
    "Sungai Utabailale",
    "Urochishche Batkali",
    "Khrebet Batkali",
    "Ras Barkallah",
    "Babakale",
    "Fabrikalar",
    "Laikala",
    "Waikalakaka",
    "Bakkala Cemetery",
    "Clifton T Barkalow Elementary School",
    "Barkalow Hollow",
    "Kailuapuhi Waikalua Homesteads",
    "Kawaikalia Gulch",
    "Waikalae",
    "Waikaloa Stream",
    "Waikalua-Loko Fish Pond",
    "Halekou Waikaluakai Homesteads",
    "East Waikalua",
    "Omar Haikal Islamic Academy",
    "Koshbakaly",
    "Bagkalen",
    "Gora Baikara",
    "Mfumbaika",
    "Mbakalungu",
    "Chumbaika",
    "Ntombankala School",
    "Khobai al Janhra",
    "Holiday Inn Dubai Al Barsha",
    "Novotel Dubai Al Barsha",
    "Doubletree Res.Dubai-Al Barsha",
    "Doubletree By Hilton Hotel and Apartments Dubai Al Barsha",
    "Doubletree By Hilton Dubai Al Barsha Hotel and Res",
    "Park Inn By Radisson Dubai Al Barsha",
    "Ramee Rose Hotel Dubai Al Barsha",
    "Aparthotel Adagio Premium Dubai Al Barsha",
    "Ataikala",
    "Selman Marrakech",
    "Riad Ain Marrakech",
    "Taj Palace Marrakech",
    "Delano Marrakech",
    "Pullman Marrakech Palmeraie Resort And Spa",
    "Lalla Calipau Marrakech",
    "Hotel Fashion Marrakech",
    "Four Seasons Resort Marrakech",
    "Adama Resort Marrakech",
    "Pullman Marrakech Palmeraie Re",
    "Ramada Resort Marrakech Douar Al Hana",
    "Hotel Zahia Marrakech",
    "Hotel Marrakech Le Tichka",
    "Le Chems Marrakech",
    "Beachcomber Royal Palm Marrakech",
    "Residence Marrakech",
    "Riad Hermes Marrakech",
    "Riad La Lune De Marrakech",
    "Hotel Marrakech Le Sangho Privilege",
    "Tempoo Hotel Marrakech",
    "Ag Hotel & Spa Marrakech",
    "Palm Appart Club Marrakech",
    "Hotel Ibis Moussafir Marrakech Palmeraie",
    "Ibis Marrakech Gare Voyageurs",
    "Marrakech Ryads Parc And Spa",
    "Terra Mia Marrakech Riad",
    "Residence Dar Lamia Marrakech",
    "Pullman Marrakech Palmeraie Rs",
    "Moussaf Marrakech Centre Gare",
    "Tempoo Hotel Marrakech Adults Only",
    "Sahara Palace Marrakech",
    "Moroccan House Marrakech",
    "El Andalouss And Spa Marrakech",
    "Suite Novotel Marrakech Rs",
    "Dar Catalina Marrakech Hotel Non Refundable Room",
    "Marrakech Hotel",
    "Oued Tammarrakech",
    "Tammarrakech",
    "Cercle de Marrakech-Banlieue",
    "Marrakech-Tensift-Al Haouz",
    "Koudia Marrakech",
    "Hotel Tichka Salam Marrakech",
    "L'Atlas Marrakech",
    "Royal Mirage Deluxe Marrakech",
    "Golden Tulip Farah Marrakech",
    "Ryad Mogador Marrakech",
    "Coralia Club Marrakech Palmariva",
    "La Sultana Marrakech",
    "Marrakech-Medina",
    "Marrakech",
    "Museum of Marrakech",
    "Douar Marrakechiyinc",
    "Ibis Marrakech Centre Gare",
    "Golden Tulip Rawabi Marrakech",
    "Murano Resort Marrakech",
    "Marrakech Garden Hotel",
    "Pullman Marrakech Palmerai Resort & Spa",
    "The Pearl Marrakech",
    "Palais Calipau Marrakech",
    "Hostal Equity Point Marrakech",
    "Sofitel Marrakech Lounge And Spa",
    "Pullman Marrakech Hotel And Spa",
    "Sofitel Marrakech Palais Imperial",
    "Hotel Ibis Moussafir Marrakech Centre Gare",
    "Red Hotel Marrakech",
    "Riad Zenith Marrakech",
    "Ksar Catalina Marrakech Hotel",
    "Blue Sea Hotel Marrakech Ryads Parc & Spa",
    "Bluebay Marrakech",
    "Pullman Marrakech Palmeraie Resort & Spa Hotel",
    "Riad Litzy Marrakech",
    "Sultana Hotel & Spa Marrakech",
    "Albatros Club Marrakech",
    "Hotel Sangho Club Marrakech",
    "Suite Novotel Marrakech Hotel",
    "Riad Utopia Suites & Spa Marrakech",
    "Riad Fatinat Marrakech",
    "Riad Dar El Aila Marrakech",
    "Es Saadi And Casino De Marrakech",
    "Dar Catalina Marrakech Hotel",
    "Grace Marrakech",
    "Marrakesh Apartments",
    "Marrakesh Country Club",
    "Koudiat Lmerrakechiyine",
    "Sidi Mohammed el Marrakchi",
    "Marrakesh",
    "Marrakchien",
    "Marrakchia",
    "Marrakesh Menara Airport",
    "Marrakesh Hua Hin Resort & Spa",
    "Marrakesh Hua Hin Resort And Spa",
    "Marrakesh Resort And Spa (Pool Suite)",
    "Marrakesh Huahin Resort & Spa",
    "Ibis Moussafir Marrakesh Centre Gare Hotel",
    "Maerak-chi",
    "Dar Hammou Ben Merrakchi",
    "Lalla el Marakchia",
    "Khrebet Marrakh",
    "Sungai Maru Kechil",
    "Marrache",
    "Goth Marracha",
    "Maramech Hill",
    "Maramech Woods Nature Preserve",
    "Oued Karakech",
    "Samarra School",
    "Jangal-e Marakeh Sar",
} union (
    (insert Gist {
        p_str := x
    })
    union
    (insert Gist2 {
        p_str := x,
        p_str_2 := x,
    })
);
