#include "configuration.h"
#if !MESHTASTIC_EXCLUDE_INPUTBROKER
#include "buzz/BuzzerFeedbackThread.h"
#include "input/ExpressLRSFiveWay.h"
#include "input/InputBroker.h"
#include "input/RotaryEncoderImpl.h"
#include "input/RotaryEncoderInterruptImpl1.h"
#include "input/SerialKeyboardImpl.h"
#include "input/UpDownInterruptImpl1.h"
#include "input/i2cButton.h"
#include "modules/SystemCommandsModule.h"
#if HAS_TRACKBALL
#include "input/TrackballInterruptImpl1.h"
#endif

#if !MESHTASTIC_EXCLUDE_I2C
#include "input/cardKbI2cImpl.h"
#endif
#include "input/kbMatrixImpl.h"
#endif
#if !MESHTASTIC_EXCLUDE_PKI
#include "KeyVerificationModule.h"
#endif
#if !MESHTASTIC_EXCLUDE_ADMIN
#include "modules/AdminModule.h"
#endif
#if !MESHTASTIC_EXCLUDE_ATAK
#include "modules/AtakPluginModule.h"
#endif
#if !MESHTASTIC_EXCLUDE_CANNEDMESSAGES
#include "modules/CannedMessageModule.h"
#endif
#if !MESHTASTIC_EXCLUDE_DETECTIONSENSOR
#include "modules/DetectionSensorModule.h"
#endif
#if !MESHTASTIC_EXCLUDE_NEIGHBORINFO
#include "modules/NeighborInfoModule.h"
#endif
#if !MESHTASTIC_EXCLUDE_NODEINFO
#include "modules/NodeInfoModule.h"
#endif
#if !MESHTASTIC_EXCLUDE_GPS
#include "modules/PositionModule.h"
#endif
#if !MESHTASTIC_EXCLUDE_REMOTEHARDWARE
#include "modules/RemoteHardwareModule.h"
#endif
#if !MESHTASTIC_EXCLUDE_POWERSTRESS
#include "modules/PowerStressModule.h"
#endif
#include "modules/RoutingModule.h"
#include "modules/TextMessageModule.h"
#if !MESHTASTIC_EXCLUDE_TRACEROUTE
#include "modules/TraceRouteModule.h"
#endif
#if !MESHTASTIC_EXCLUDE_WAYPOINT
#include "modules/WaypointModule.h"
#endif
#if ARCH_PORTDUINO
#include "input/LinuxInputImpl.h"
#include "input/SeesawRotary.h"
#include "modules/Telemetry/HostMetrics.h"
#if !MESHTASTIC_EXCLUDE_STOREFORWARD
#include "modules/StoreForwardModule.h"
#endif
#endif
#if HAS_TELEMETRY
#include "modules/Telemetry/DeviceTelemetry.h"
#endif
#if HAS_SENSOR && !MESHTASTIC_EXCLUDE_ENVIRONMENTAL_SENSOR
#include "main.h"
#include "modules/Telemetry/AirQualityTelemetry.h"
#include "modules/Telemetry/EnvironmentTelemetry.h"
#include "modules/Telemetry/HealthTelemetry.h"
#include "modules/Telemetry/Sensor/TelemetrySensor.h"
#endif
#if HAS_TELEMETRY && !MESHTASTIC_EXCLUDE_POWER_TELEMETRY
#include "modules/Telemetry/PowerTelemetry.h"
#endif
#if !MESHTASTIC_EXCLUDE_GENERIC_THREAD_MODULE
#include "modules/GenericThreadModule.h"
#endif

#ifdef ARCH_ESP32
#if defined(USE_SX1280) && !MESHTASTIC_EXCLUDE_AUDIO
#include "modules/esp32/AudioModule.h"
#endif
#if !MESHTASTIC_EXCLUDE_PAXCOUNTER
#include "modules/esp32/PaxcounterModule.h"
#endif
#if !MESHTASTIC_EXCLUDE_STOREFORWARD
#include "modules/StoreForwardModule.h"
#endif
#endif

#if !MESHTASTIC_EXCLUDE_EXTERNALNOTIFICATION
#include "modules/ExternalNotificationModule.h"
#endif
#if !MESHTASTIC_EXCLUDE_RANGETEST && !MESHTASTIC_EXCLUDE_GPS
#include "modules/RangeTestModule.h"
#endif
#if !defined(CONFIG_IDF_TARGET_ESP32S2) && !MESHTASTIC_EXCLUDE_SERIAL
#include "modules/SerialModule.h"
#endif

#if !MESHTASTIC_EXCLUDE_DROPZONE
#include "modules/DropzoneModule.h"
#endif

/**
 * Create module instances here.  If you are adding a new module, you must 'new' it here (or somewhere else)
 */
void setupModules()
{
    if (config.device.role != meshtastic_Config_DeviceConfig_Role_REPEATER) {
#if (HAS_BUTTON || ARCH_PORTDUINO) && !MESHTASTIC_EXCLUDE_INPUTBROKER
        if (config.display.displaymode != meshtastic_Config_DisplayConfig_DisplayMode_COLOR) {
            inputBroker = new InputBroker();
            systemCommandsModule = new SystemCommandsModule();
            buzzerFeedbackThread = new BuzzerFeedbackThread();
        }
#endif
#if !MESHTASTIC_EXCLUDE_ADMIN
        adminModule = new AdminModule();
#endif
#if !MESHTASTIC_EXCLUDE_NODEINFO
        nodeInfoModule = new NodeInfoModule();
#endif
#if !MESHTASTIC_EXCLUDE_GPS
        positionModule = new PositionModule();
#endif
#if !MESHTASTIC_EXCLUDE_WAYPOINT
        waypointModule = new WaypointModule();
#endif
#if !MESHTASTIC_EXCLUDE_TEXTMESSAGE
        textMessageModule = new TextMessageModule();
#endif
#if !MESHTASTIC_EXCLUDE_TRACEROUTE
        traceRouteModule = new TraceRouteModule();
#endif
#if !MESHTASTIC_EXCLUDE_NEIGHBORINFO
        if (moduleConfig.has_neighbor_info && moduleConfig.neighbor_info.enabled) {
            neighborInfoModule = new NeighborInfoModule();
        }
#endif
#if !MESHTASTIC_EXCLUDE_DETECTIONSENSOR
        if (moduleConfig.has_detection_sensor && moduleConfig.detection_sensor.enabled) {
            detectionSensorModule = new DetectionSensorModule();
        }
#endif
#if !MESHTASTIC_EXCLUDE_ATAK
        if (IS_ONE_OF(config.device.role, meshtastic_Config_DeviceConfig_Role_TAK,
                      meshtastic_Config_DeviceConfig_Role_TAK_TRACKER)) {
            atakPluginModule = new AtakPluginModule();
        }
#endif
#if !MESHTASTIC_EXCLUDE_PKI
        keyVerificationModule = new KeyVerificationModule();
#endif
#if !MESHTASTIC_EXCLUDE_DROPZONE
        dropzoneModule = new DropzoneModule();
#endif
#if !MESHTASTIC_EXCLUDE_GENERIC_THREAD_MODULE
        new GenericThreadModule();
#endif
        // Note: if the rest of meshtastic doesn't need to explicitly use your module, you do not need to assign the instance
        // to a global variable.

#if !MESHTASTIC_EXCLUDE_REMOTEHARDWARE
        new RemoteHardwareModule();
#endif
#if !MESHTASTIC_EXCLUDE_POWERSTRESS
        new PowerStressModule();
#endif
        // Example: Put your module here
        // new ReplyModule();
#if (HAS_BUTTON || ARCH_PORTDUINO) && !MESHTASTIC_EXCLUDE_INPUTBROKER
        if (config.display.displaymode != meshtastic_Config_DisplayConfig_DisplayMode_COLOR) {
            rotaryEncoderInterruptImpl1 = new RotaryEncoderInterruptImpl1();
            if (!rotaryEncoderInterruptImpl1->init()) {
                delete rotaryEncoderInterruptImpl1;
                rotaryEncoderInterruptImpl1 = nullptr;
            }
#ifdef T_LORA_PAGER
            // use a special FSM based rotary encoder version for T-LoRa Pager
            rotaryEncoderImpl = new RotaryEncoderImpl();
            if (!rotaryEncoderImpl->init()) {
                delete rotaryEncoderImpl;
                rotaryEncoderImpl = nullptr;
            }
#else
            upDownInterruptImpl1 = new UpDownInterruptImpl1();
            if (!upDownInterruptImpl1->init()) {
                delete upDownInterruptImpl1;
                upDownInterruptImpl1 = nullptr;
            }
#endif
            cardKbI2cImpl = new CardKbI2cImpl();
            cardKbI2cImpl->init();
#if defined(M5STACK_UNITC6L)
            i2cButton = new i2cButtonThread("i2cButtonThread");
#endif
#ifdef INPUTBROKER_MATRIX_TYPE
            kbMatrixImpl = new KbMatrixImpl();
            kbMatrixImpl->init();
#endif // INPUTBROKER_MATRIX_TYPE
#ifdef INPUTBROKER_SERIAL_TYPE
            aSerialKeyboardImpl = new SerialKeyboardImpl();
            aSerialKeyboardImpl->init();
#endif // INPUTBROKER_MATRIX_TYPE
        }
#endif // HAS_BUTTON
#if ARCH_PORTDUINO
        if (config.display.displaymode != meshtastic_Config_DisplayConfig_DisplayMode_COLOR) {
            seesawRotary = new SeesawRotary("SeesawRotary");
            if (!seesawRotary->init()) {
                delete seesawRotary;
                seesawRotary = nullptr;
            }
            aLinuxInputImpl = new LinuxInputImpl();
            aLinuxInputImpl->init();
        }
#endif
#if !MESHTASTIC_EXCLUDE_INPUTBROKER && HAS_TRACKBALL
        if (config.display.displaymode != meshtastic_Config_DisplayConfig_DisplayMode_COLOR) {
            trackballInterruptImpl1 = new TrackballInterruptImpl1();
            trackballInterruptImpl1->init(TB_DOWN, TB_UP, TB_LEFT, TB_RIGHT, TB_PRESS);
        }
#endif
#ifdef INPUTBROKER_EXPRESSLRSFIVEWAY_TYPE
        expressLRSFiveWayInput = new ExpressLRSFiveWay();
#endif
#if HAS_SCREEN && !MESHTASTIC_EXCLUDE_CANNEDMESSAGES
        if (config.display.displaymode != meshtastic_Config_DisplayConfig_DisplayMode_COLOR) {
            cannedMessageModule = new CannedMessageModule();
        }
#endif
#if ARCH_PORTDUINO
        new HostMetricsModule();
#endif
#if HAS_TELEMETRY
        new DeviceTelemetryModule();
#endif
#if HAS_TELEMETRY && HAS_SENSOR && !MESHTASTIC_EXCLUDE_ENVIRONMENTAL_SENSOR
        if (moduleConfig.has_telemetry &&
            (moduleConfig.telemetry.environment_measurement_enabled || moduleConfig.telemetry.environment_screen_enabled)) {
            new EnvironmentTelemetryModule();
        }
#if __has_include("Adafruit_PM25AQI.h")
        if (moduleConfig.has_telemetry && moduleConfig.telemetry.air_quality_enabled &&
            nodeTelemetrySensorsMap[meshtastic_TelemetrySensorType_PMSA003I].first > 0) {
            new AirQualityTelemetryModule();
        }
#endif
#if !MESHTASTIC_EXCLUDE_HEALTH_TELEMETRY
        if (nodeTelemetrySensorsMap[meshtastic_TelemetrySensorType_MAX30102].first > 0 ||
            nodeTelemetrySensorsMap[meshtastic_TelemetrySensorType_MLX90614].first > 0) {
            new HealthTelemetryModule();
        }
#endif
#endif
#if HAS_TELEMETRY && !MESHTASTIC_EXCLUDE_POWER_TELEMETRY && !MESHTASTIC_EXCLUDE_ENVIRONMENTAL_SENSOR
        if (moduleConfig.has_telemetry &&
            (moduleConfig.telemetry.power_measurement_enabled || moduleConfig.telemetry.power_screen_enabled)) {
            new PowerTelemetryModule();
        }
#endif
#if (defined(ARCH_ESP32) || defined(ARCH_NRF52) || defined(ARCH_RP2040) || defined(ARCH_STM32WL)) &&                             \
    !defined(CONFIG_IDF_TARGET_ESP32S2) && !defined(CONFIG_IDF_TARGET_ESP32C3)
#if !MESHTASTIC_EXCLUDE_SERIAL
        if (moduleConfig.has_serial && moduleConfig.serial.enabled &&
            config.display.displaymode != meshtastic_Config_DisplayConfig_DisplayMode_COLOR) {
            new SerialModule();
        }
#endif
#endif
#ifdef ARCH_ESP32
        // Only run on an esp32 based device.
#if defined(USE_SX1280) && !MESHTASTIC_EXCLUDE_AUDIO
        audioModule = new AudioModule();
#endif
#if !MESHTASTIC_EXCLUDE_PAXCOUNTER
        if (moduleConfig.has_paxcounter && moduleConfig.paxcounter.enabled) {
            paxcounterModule = new PaxcounterModule();
        }
#endif
#endif
#if defined(ARCH_ESP32) || defined(ARCH_PORTDUINO)
#if !MESHTASTIC_EXCLUDE_STOREFORWARD
        if (moduleConfig.has_store_forward && moduleConfig.store_forward.enabled) {
            storeForwardModule = new StoreForwardModule();
        }
#endif
#endif
#if !MESHTASTIC_EXCLUDE_EXTERNALNOTIFICATION
        externalNotificationModule = new ExternalNotificationModule();
#endif
#if !MESHTASTIC_EXCLUDE_RANGETEST && !MESHTASTIC_EXCLUDE_GPS
        if (moduleConfig.has_range_test && moduleConfig.range_test.enabled)
            new RangeTestModule();
#endif
    } else {
#if !MESHTASTIC_EXCLUDE_ADMIN
        adminModule = new AdminModule();
#endif
#if HAS_TELEMETRY
        new DeviceTelemetryModule();
#endif
#if !MESHTASTIC_EXCLUDE_TRACEROUTE
        traceRouteModule = new TraceRouteModule();
#endif
    }
    // NOTE! This module must be added LAST because it likes to check for replies from other modules and avoid sending extra
    // acks
    routingModule = new RoutingModule();
}
