#
# spec file for package kernel-firmware
#
# Copyright (c) 2020 SUSE LLC
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via https://bugs.opensuse.org/
#


%global flavor @BUILD_FLAVOR@%{nil}

%if 0%{?suse_version} < 1550
%define _firmwaredir /lib/firmware
%endif

%define __ksyms_path ^%{_firmwaredir}
%define version_unconverted 20201218

Name:           kernel-firmware
Version:        20201218
Release:        0
Summary:        Linux kernel firmware files
License:        SUSE-Firmware AND GPL-2.0-only AND GPL-2.0-or-later AND MIT
Group:          System/Kernel
URL:            https://git.kernel.org/cgit/linux/kernel/git/firmware/linux-firmware.git/
# Created with umask 022; cd /_tmp
# After git clone https://git.kernel.org/pub/scm/linux/kernel/git/firmware/linux-firmware.git
# cd linux-firmware
# git archive --format=tar --prefix=kernel-firmware-$version/ -v master ./ | xz -9 -M 4G --check=crc32 -T 4 > /tmp/kernel-firmware-$version.tar.xz
#
Source0:        kernel-firmware-%{version}.tar.xz
Source1:        extrawhence
Source2:        ast_dp501_fw.bin
Source8:        ql2600_fw.bin
Source9:        ql2700_fw.bin
Source10:       ql8300_fw.bin
Source99:       %{name}-rpmlintrc
# install / build infrastructure
Source1001:     install-split.sh
Source1002:     list-license.sh
Source1003:     get_supplements.sh
Source1004:     topics.list
Source1005:     licenses.list
Source1006:     aliases.list
Source1007:     topicdefs
Source1008:     topicprovs
Source1009:     kernel-firmware.spec.in
Source1010:     makespec.sh
Source1011:     fwtopics.py
Source1012:     check-topic.py
Source1013:     update-aliases.py
Source1014:     README.build
BuildRequires:  fdupes
BuildRequires:  suse-module-tools
Requires(post): /usr/bin/mkdir /usr/bin/touch
Requires(postun): /usr/bin/mkdir /usr/bin/touch
BuildArch:      noarch
Provides:       ath3k-firmware
Obsoletes:      ath3k-firmware
Provides:       bcm43xx-firmware:/lib/firmware/brcm/brcmfmac43430-sdio.bin
Provides:       cxgb3-firmware
Obsoletes:      cxgb3-firmware
Provides:       iwl1000-ucode
Obsoletes:      iwl1000-ucode
Provides:       iwl3945-ucode
Obsoletes:      iwl3945-ucode
Provides:       iwl4965-ucode
Obsoletes:      iwl4965-ucode
Provides:       iwl5000-ucode
Obsoletes:      iwl5000-ucode
Provides:       iwl5150-ucode
Obsoletes:      iwl5150-ucode
Provides:       iwl100-ucode
Obsoletes:      iwl100-ucode
Provides:       iwl6000-ucode
Obsoletes:      iwl6000-ucode
Provides:       iwl6050-ucode
Obsoletes:      iwl6050-ucode
Provides:       iwl6000g2-ucode
Obsoletes:      iwl6000g2-ucode
Provides:       ralink-firmware
Obsoletes:      ralink-firmware
Provides:       qlogic-firmware
Obsoletes:      qlogic-firmware
Provides:       compat-wireless-firmware = 4.4
Obsoletes:      compat-wireless-firmware < 4.4

# Force bzip2 instead of lzma compression (bsc#1176981)
%define _binary_payload w9.bzdio

%description
This package contains the raw uncompressed firmware files for Linux kernel
drivers.  This package is provided only for compatibility with older kernels
that do not support the compressed format.

%package -n ucode-amd
Summary:        Microcode updates for AMD CPUs
Group:          System/Kernel
Requires(post): /usr/bin/mkdir /usr/bin/touch
Requires(postun): /usr/bin/mkdir /usr/bin/touch
# new style (after 3.12 kernel somewhen)
Supplements:    modalias(cpu:type%%3Ax86*ven0002*)
# old style (before 3.16 kernel)
Supplements:    modalias(x86cpu:vendor%%3A0002%%3Afamily%%3A*%%3Amodel%%3A*%%3Afeature%%3A*)

%description -n ucode-amd
This package contains the microcode files used by AMD CPUs.

%package all
Summary:        Compatibility metapackage for kernel firmware files
Group:          System/Kernel
Requires(post): /usr/bin/mkdir /usr/bin/touch
Requires(postun): /usr/bin/mkdir /usr/bin/touch
Requires(post): dracut >= 049
Provides:       kernel-firmware = %{version}
Obsoletes:      kernel-firmware <= %{version}
Conflicts:      kernel < 5.3
Provides:       compat-wireless-firmware = 4.4
Obsoletes:      compat-wireless-firmware < 4.4
Requires:       %{name}-amdgpu = %{version}
Requires:       %{name}-ath10k = %{version}
Requires:       %{name}-ath11k = %{version}
Requires:       %{name}-atheros = %{version}
Requires:       %{name}-bluetooth = %{version}
Requires:       %{name}-bnx2 = %{version}
Requires:       %{name}-brcm = %{version}
Requires:       %{name}-chelsio = %{version}
Requires:       %{name}-dpaa2 = %{version}
Requires:       %{name}-i915 = %{version}
Requires:       %{name}-intel = %{version}
Requires:       %{name}-iwlwifi = %{version}
Requires:       %{name}-liquidio = %{version}
Requires:       %{name}-marvell = %{version}
Requires:       %{name}-media = %{version}
Requires:       %{name}-mediatek = %{version}
Requires:       %{name}-mellanox = %{version}
Requires:       %{name}-mwifiex = %{version}
Requires:       %{name}-network = %{version}
Requires:       %{name}-nfp = %{version}
Requires:       %{name}-nvidia = %{version}
Requires:       %{name}-platform = %{version}
Requires:       %{name}-prestera = %{version}
Requires:       %{name}-qlogic = %{version}
Requires:       %{name}-radeon = %{version}
Requires:       %{name}-realtek = %{version}
Requires:       %{name}-serial = %{version}
Requires:       %{name}-sound = %{version}
Requires:       %{name}-ti = %{version}
Requires:       %{name}-ueagle = %{version}
Requires:       %{name}-usb-network = %{version}

%description all
This package is a catch-all compatibility metapackage for providing
all files that have been provided by kernel-firmware package.

%package amdgpu
Summary:        Kernel firmware files for AMDGPU graphics driver
Group:          System/Kernel
Requires(post): /usr/bin/mkdir /usr/bin/touch
Requires(postun): /usr/bin/mkdir /usr/bin/touch
Requires(post): dracut >= 049
Conflicts:      kernel < 5.3
Supplements:    modalias(pci:v00001002d00001304sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00001305sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00001306sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00001307sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00001309sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000130Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000130Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000130Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000130Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000130Esv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000130Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00001310sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00001311sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00001312sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00001313sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00001315sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00001316sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00001317sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00001318sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000131Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000131Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000131Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000015D8sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000015DDsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00001636sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006600sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006601sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006602sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006603sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006604sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006605sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006606sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006607sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006608sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006610sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006611sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006613sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006617sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006620sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006621sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006623sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006631sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006640sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006641sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006646sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006647sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006649sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006650sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006651sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006658sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000665Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000665Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000665Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006660sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006663sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006664sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006665sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006667sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000666Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000066A0sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000066A1sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000066A2sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000066A3sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000066A4sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000066A7sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000066AFsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006780sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006784sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006788sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000678Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006790sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006791sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006792sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006798sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006799sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000679Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000679Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000679Esv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000679Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067A0sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067A1sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067A2sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067A8sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067A9sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067AAsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067B0sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067B1sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067B8sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067B9sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067BAsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067BEsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067C0sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067C1sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067C2sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067C4sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067C7sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067C8sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067C9sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067CAsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067CCsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067CFsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067D0sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067DFsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067E0sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067E1sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067E3sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067E7sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067E8sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067E9sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067EBsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067EFsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067FFsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006800sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006801sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006802sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006806sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006808sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006809sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006810sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006811sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006816sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006817sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006818sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006819sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006820sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006821sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006822sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006823sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006824sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006825sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006826sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006827sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006828sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006829sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000682Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000682Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000682Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000682Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000682Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006830sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006831sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006835sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006837sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006838sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006839sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000683Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000683Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000683Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006860sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006861sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006862sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006863sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006864sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006867sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006868sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006869sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000686Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000686Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000686Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000686Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000686Esv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000686Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000687Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006900sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006901sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006902sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006903sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006907sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006920sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006921sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006928sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006929sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000692Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000692Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006930sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006938sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006939sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000694Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000694Esv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000694Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006980sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006981sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006985sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006986sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006987sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006995sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006997sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000699Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000069A0sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000069A1sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000069A2sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000069A3sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000069AFsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006FDFsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007300sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000730Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007310sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007312sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007318sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007319sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000731Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000731Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000731Esv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000731Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007340sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007341sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007347sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000734Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007360sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007362sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007388sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000738Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000738Esv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007390sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000073A0sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000073A2sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000073A3sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000073ABsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000073AEsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000073BFsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009830sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009831sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009832sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009833sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009834sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009835sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009836sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009837sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009838sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009839sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000983Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000983Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000983Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000983Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000983Esv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000983Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009850sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009851sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009852sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009853sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009854sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009855sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009856sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009857sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009858sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009859sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000985Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000985Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000985Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000985Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000985Esv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000985Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009870sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009874sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009875sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009876sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009877sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000098E4sv*sd*bc*sc*i*)

%description amdgpu
This package contains compressed kernel firmware files for
AMDGPU graphics driver.

%package atheros
Summary:        Kernel firmware files for Atheros wireless drivers
Group:          System/Kernel
Requires(post): /usr/bin/mkdir /usr/bin/touch
Requires(postun): /usr/bin/mkdir /usr/bin/touch
Requires(post): dracut >= 049
Conflicts:      kernel < 5.3
Provides:       ath3k-firmware
Obsoletes:      ath3k-firmware
Supplements:    modalias(ar9170usb)
Supplements:    modalias(arusb_lnx)
Supplements:    modalias(pci:v000017CBd00001201sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001AE9d00000302sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001AE9d00000310sv*sd*bc*sc*i*)
Supplements:    modalias(sdio:c*v0271d0300*)
Supplements:    modalias(sdio:c*v0271d0301*)
Supplements:    modalias(sdio:c*v0271d0400*)
Supplements:    modalias(sdio:c*v0271d0401*)
Supplements:    modalias(sdio:c*v0271d0402*)
Supplements:    modalias(sdio:c*v0271d0418*)
Supplements:    modalias(sdio:c*v0271d0419*)
Supplements:    modalias(usb:v03F0p311Dd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0409p0249d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0409p02B4d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v040Dp3801d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0411p017Fd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0411p0197d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0471p209Ed*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0489pE027d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0489pE02Cd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0489pE036d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0489pE03Cd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0489pE03Dd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0489pE04Dd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0489pE04Ed*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0489pE056d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0489pE057d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0489pE05Fd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0489pE076d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0489pE078d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0489pE095d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v04BBp093Fd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v04C5p1330d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v04CAp3004d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v04CAp3005d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v04CAp3006d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v04CAp3007d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v04CAp3008d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v04CAp300Bd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v04CAp300Dd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v04CAp300Fd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v04CAp3010d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v04CAp3014d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v04CAp3018d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v04CAp4605d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v04DAp3904d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v04F2pAFF1d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v057Cp8401d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v057Cp8402d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v057Cp8403d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0586p3417d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07B8p9271d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07D1p3A07d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07D1p3A08d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07D1p3A09d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07D1p3A0Fd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07D1p3A10d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07D1p3C10d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v083Ap4506d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v083Ap4507d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v083ApA704d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v083ApF522d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0846p4250d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0846p4251d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0846p4300d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0846p4301d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0846p5F00d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0846p5F01d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0846p9001d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0846p9010d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0846p9018d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0846p9030d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0846p9040d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0930p0215d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0930p0219d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0930p021Cd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0930p0220d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0930p0227d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0930p0A08d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0ACEp1221d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0B05p17D0d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CDEp0012d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CDEp0013d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CDEp0023d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CDEp0026d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CDEp0027d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CF3p0001d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CF3p0002d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CF3p0003d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CF3p0004d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CF3p0005d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CF3p0006d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CF3p0036d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CF3p1001d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CF3p1002d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CF3p1006d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CF3p1010d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CF3p1011d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CF3p20FFd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CF3p3000d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CF3p3002d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CF3p3004d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CF3p3008d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CF3p311Dd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CF3p311Ed*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CF3p311Fd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CF3p3121d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CF3p7010d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CF3p7015d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CF3p817Ad*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CF3p817Bd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CF3p9170d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CF3p9271d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CF3p9374d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CF3p9375d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CF3pB002d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CF3pB003d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CF3pE003d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CF3pE004d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CF3pE005d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CF3pE006d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CF3pE019d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0D8Ep7801d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0D8Ep7802d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0D8Ep7803d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0D8Ep7811d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0D8Ep7812d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v129Bp160Bd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v129Bp160Cd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1385p4250d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1385p4251d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1385p5F00d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1385p5F01d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1385p5F02d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1385p5F03d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D3p3304d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D3p3327d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D3p3328d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D3p3346d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D3p3348d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D3p3349d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D3p3350d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D3p3362d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D3p3375d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D3p3393d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D3p3395d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D3p3402d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D3p3408d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D3p3423d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D3p3432d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D3p3472d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D3p3474d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D3p3487d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D3p3490d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1435p0326d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1435p0804d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1435p0826d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1435p0827d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1435p0828d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1435p0829d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v157Ep3006d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v157Ep3007d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v157Ep3205d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v157Ep3206d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1668p1200d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v168Cp0001d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v168Cp0002d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1690p0710d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1690p0711d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1690p0712d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1690p0713d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v16ABp7801d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v16ABp7802d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v16ABp7811d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v16ABp7812d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1B75p9170d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1EDAp2315d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2001p3A00d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2001p3A01d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2001p3A02d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2001p3A03d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2001p3A04d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2001p3A05d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2019p5304d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:vCACEp0300d*dc*dsc*dp*ic*isc*ip*in*)

%description atheros
This package contains compressed kernel firmware files for
Atheros wireless drivers.

%package ath10k
Summary:        Kernel firmware files for Atheros QCA988x WiFi drivers
Group:          System/Kernel
Requires(post): /usr/bin/mkdir /usr/bin/touch
Requires(postun): /usr/bin/mkdir /usr/bin/touch
Requires(post): dracut >= 049
Conflicts:      kernel < 5.3
Supplements:    modalias(of:N*T*Cqcom,ipq4019-wifi)
Supplements:    modalias(of:N*T*Cqcom,ipq4019-wifiC*)
Supplements:    modalias(pci:v00000777d000011ACsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v0000168Cd0000003Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v0000168Cd0000003Esv*sd*bc*sc*i*)
Supplements:    modalias(pci:v0000168Cd00000040sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v0000168Cd00000041sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v0000168Cd00000042sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v0000168Cd00000046sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v0000168Cd00000050sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v0000168Cd00000056sv*sd*bc*sc*i*)
Supplements:    modalias(sdio:c*v0271d050A*)
Supplements:    modalias(sdio:c*v0271d0701*)
Supplements:    modalias(usb:v13B1p0042d*dc*dsc*dp*ic*isc*ip*in*)

%description ath10k
This package contains compressed kernel firmware files for
Atheros QCA988x WiFi drivers.

%package ath11k
Summary:        Kernel firmware files for Atheros Qualcomm WiFi drivers
Group:          System/Kernel
Requires(post): /usr/bin/mkdir /usr/bin/touch
Requires(postun): /usr/bin/mkdir /usr/bin/touch
Requires(post): dracut >= 049
Conflicts:      kernel < 5.3
Supplements:    modalias(pci:v000017CBd00001101sv*sd*bc*sc*i*)

%description ath11k
This package contains compressed kernel firmware files for
Atheros Qualcomm WiFi drivers.

%package bluetooth
Summary:        Kernel firmware files for various Bluetooth drivers
Group:          System/Kernel
Requires(post): /usr/bin/mkdir /usr/bin/touch
Requires(postun): /usr/bin/mkdir /usr/bin/touch
Requires(post): dracut >= 049
Conflicts:      kernel < 5.3
Supplements:    modalias(of:N*T*Cusb1286,204e)
Supplements:    modalias(of:N*T*Cusb1286,204eC*)
Supplements:    modalias(of:N*T*Cusb4ca,301a)
Supplements:    modalias(of:N*T*Cusb4ca,301aC*)
Supplements:    modalias(of:N*T*Cusbcf3,e300)
Supplements:    modalias(of:N*T*Cusbcf3,e300C*)
Supplements:    modalias(usb:v044Ep3001d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v044Ep3002d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0489p*d*dc*dsc*dp*icFFisc01ip01in*)
Supplements:    modalias(usb:v04BFp030Ad*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v04CAp*d*dc*dsc*dp*icFFisc01ip01in*)
Supplements:    modalias(usb:v050Dp*d*dc*dsc*dp*icFFisc01ip01in*)
Supplements:    modalias(usb:v057Cp3800d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v05ACp8213d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v05ACp8215d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v05ACp8218d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v05ACp821Ad*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v05ACp821Bd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v05ACp821Fd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v05ACp8281d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v05ACp*d*dc*dsc*dp*icFFisc01ip01in*)
Supplements:    modalias(usb:v0930p*d*dc*dsc*dp*icFFisc01ip01in*)
Supplements:    modalias(usb:v0A5Cp21E1d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0A5Cp*d*dc*dsc*dp*icFFisc01ip01in*)
Supplements:    modalias(usb:v0B05p*d*dc*dsc*dp*icFFisc01ip01in*)
Supplements:    modalias(usb:v0BB4p*d*dc*dsc*dp*icFFisc01ip01in*)
Supplements:    modalias(usb:v0BDBp1002d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0C10p0000d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0E8Dp763Fd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v105Bp*d*dc*dsc*dp*icFFisc01ip01in*)
Supplements:    modalias(usb:v13D3p*d*dc*dsc*dp*icFFisc01ip01in*)
Supplements:    modalias(usb:v19FFp0239d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v413Cp8197d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v413Cp*d*dc*dsc*dp*icFFisc01ip01in*)
Supplements:    modalias(usb:v8087p0A5Ad*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v*p*d*dc*dsc*dp*icE0isc01ip01in*)
Supplements:    modalias(usb:v*p*d*dcE0dsc01dp01ic*isc*ip*in*)
Supplements:    modalias(usb:v*p*d*dcE0dsc01dp04ic*isc*ip*in*)

%description bluetooth
This package contains compressed kernel firmware files for
various Bluetooth drivers.

%package bnx2
Summary:        Kernel firmware files for Broadcom network drivers
Group:          System/Kernel
Requires(post): /usr/bin/mkdir /usr/bin/touch
Requires(postun): /usr/bin/mkdir /usr/bin/touch
Requires(post): dracut >= 049
Conflicts:      kernel < 5.3
Supplements:    modalias(pci:v00001077d000016A1sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001077d000016A4sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001077d000016ADsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d00001639sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d0000163Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d0000163Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d0000163Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d0000163Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d0000163Esv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d0000163Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d0000164Asv0000103Csd00003101bc*sc*i*)
Supplements:    modalias(pci:v000014E4d0000164Asv0000103Csd00003106bc*sc*i*)
Supplements:    modalias(pci:v000014E4d0000164Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d0000164Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d0000164Esv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d0000164Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d00001650sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d00001662sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d00001663sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d0000166Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d0000168Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d0000168Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d0000168Esv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d000016A1sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d000016A2sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d000016A4sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d000016A5sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d000016A9sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d000016AAsv0000103Csd00003102bc*sc*i*)
Supplements:    modalias(pci:v000014E4d000016AAsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d000016ABsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d000016ACsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d000016ADsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d000016AEsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d000016AFsv*sd*bc*sc*i*)

%description bnx2
This package contains compressed kernel firmware files for
Broadcom network drivers.

%package brcm
Summary:        Kernel firmware files for Broadcom wireless drivers
Group:          System/Kernel
Requires(post): /usr/bin/mkdir /usr/bin/touch
Requires(postun): /usr/bin/mkdir /usr/bin/touch
Requires(post): dracut >= 049
Conflicts:      kernel < 5.3
Provides:       bcm43xx-firmware:/lib/firmware/brcm/brcmfmac43430-sdio.bin
Supplements:    modalias(bcma:m04BFid0812rev11cl*)
Supplements:    modalias(bcma:m04BFid0812rev17cl*)
Supplements:    modalias(bcma:m04BFid0812rev18cl*)
Supplements:    modalias(pci:v000014E4d00004354sv*sd*bc02sc80i*)
Supplements:    modalias(pci:v000014E4d00004355sv000014E4sd00004355bc02sc80i*)
Supplements:    modalias(pci:v000014E4d00004365sv000014E4sd00004365bc02sc80i*)
Supplements:    modalias(pci:v000014E4d000043A3sv*sd*bc02sc80i*)
Supplements:    modalias(pci:v000014E4d000043BAsv*sd*bc02sc80i*)
Supplements:    modalias(pci:v000014E4d000043BBsv*sd*bc02sc80i*)
Supplements:    modalias(pci:v000014E4d000043BCsv*sd*bc02sc80i*)
Supplements:    modalias(pci:v000014E4d000043C3sv*sd*bc02sc80i*)
Supplements:    modalias(pci:v000014E4d000043C4sv*sd*bc02sc80i*)
Supplements:    modalias(pci:v000014E4d000043C5sv*sd*bc02sc80i*)
Supplements:    modalias(pci:v000014E4d000043CAsv*sd*bc02sc80i*)
Supplements:    modalias(pci:v000014E4d000043CBsv*sd*bc02sc80i*)
Supplements:    modalias(pci:v000014E4d000043CCsv*sd*bc02sc80i*)
Supplements:    modalias(pci:v000014E4d000043D3sv*sd*bc02sc80i*)
Supplements:    modalias(pci:v000014E4d000043D9sv*sd*bc02sc80i*)
Supplements:    modalias(pci:v000014E4d000043E9sv*sd*bc02sc80i*)
Supplements:    modalias(pci:v000014E4d000043ECsv*sd*bc02sc80i*)
Supplements:    modalias(pci:v000014E4d000043EFsv*sd*bc02sc80i*)
Supplements:    modalias(pci:v000014E4d0000440Dsv*sd*bc02sc80i*)
Supplements:    modalias(pci:v000014E4d00004464sv*sd*bc02sc80i*)
Supplements:    modalias(pci:v000014E4d0000AA52sv*sd*bc02sc80i*)
Supplements:    modalias(sdio:c*v02D0d4324*)
Supplements:    modalias(sdio:c*v02D0d4329*)
Supplements:    modalias(sdio:c*v02D0d4330*)
Supplements:    modalias(sdio:c*v02D0d4334*)
Supplements:    modalias(sdio:c*v02D0d4335*)
Supplements:    modalias(sdio:c*v02D0d4339*)
Supplements:    modalias(sdio:c*v02D0d4345*)
Supplements:    modalias(sdio:c*v02D0d4354*)
Supplements:    modalias(sdio:c*v02D0d4355*)
Supplements:    modalias(sdio:c*v02D0d4356*)
Supplements:    modalias(sdio:c*v02D0d4359*)
Supplements:    modalias(sdio:c*v02D0d4373*)
Supplements:    modalias(sdio:c*v02D0dA804*)
Supplements:    modalias(sdio:c*v02D0dA887*)
Supplements:    modalias(sdio:c*v02D0dA94C*)
Supplements:    modalias(sdio:c*v02D0dA94D*)
Supplements:    modalias(sdio:c*v02D0dA962*)
Supplements:    modalias(sdio:c*v02D0dA9A4*)
Supplements:    modalias(sdio:c*v02D0dA9A6*)
Supplements:    modalias(sdio:c*v02D0dA9BF*)
Supplements:    modalias(usb:v043Ep3101d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v04B4p0BDCd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v04B4pBD29d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0A5Cp0BDCd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0A5CpBD17d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0A5CpBD1Ed*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0A5CpBD1Fd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0A5CpBD27d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13B1p0039d*dc*dsc*dp*ic*isc*ip*in*)

%description brcm
This package contains compressed kernel firmware files for
Broadcom wireless drivers.

%package chelsio
Summary:        Kernel firmware files for Chelsio network drivers
Group:          System/Kernel
Requires(post): /usr/bin/mkdir /usr/bin/touch
Requires(postun): /usr/bin/mkdir /usr/bin/touch
Requires(post): dracut >= 049
Conflicts:      kernel < 5.3
Provides:       cxgb3-firmware
Obsoletes:      cxgb3-firmware
Supplements:    modalias(pci:v00001425d00000020sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00000021sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00000022sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00000023sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00000024sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00000025sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00000026sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00000030sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00000031sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00000032sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00000035sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00000036sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00000037sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004000sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004001sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004002sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004003sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004004sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004005sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004006sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004007sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004008sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004009sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000400Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000400Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000400Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000400Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000400Esv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004080sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004081sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004082sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004083sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004084sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004085sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004086sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004087sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004088sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004400sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004401sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004402sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004403sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004404sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004405sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004406sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004407sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004408sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004409sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000440Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000440Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000440Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000440Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000440Esv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004480sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004481sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004482sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004483sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004484sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004485sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004486sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004487sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004488sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004600sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004601sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004602sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004603sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004604sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004605sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004606sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004607sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004608sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004609sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000460Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000460Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000460Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000460Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000460Esv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004680sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004681sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004682sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004683sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004684sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004685sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004686sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004687sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00004688sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005000sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005001sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005002sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005003sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005004sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005005sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005006sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005007sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005008sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005009sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000500Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000500Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000500Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000500Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000500Esv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005010sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005011sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005012sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005013sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005014sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005015sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005016sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005017sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005018sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005019sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000501Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000501Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005080sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005081sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005082sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005083sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005084sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005085sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005086sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005087sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005088sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005089sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005090sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005091sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005092sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005093sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005094sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005095sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005096sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005097sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005098sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005099sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000509Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000509Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000509Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000509Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000509Esv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000509Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d000050A0sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d000050A1sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d000050A2sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d000050A3sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d000050A4sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d000050A5sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d000050A6sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d000050A7sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d000050A8sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d000050A9sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d000050AAsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d000050ABsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d000050ACsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d000050ADsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d000050AEsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d000050AFsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d000050B0sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005400sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005401sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005402sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005403sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005404sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005405sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005406sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005407sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005408sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005409sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000540Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000540Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000540Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000540Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000540Esv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005410sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005411sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005412sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005413sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005414sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005415sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005416sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005417sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005418sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005419sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000541Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000541Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005480sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005481sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005482sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005483sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005484sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005485sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005486sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005487sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005488sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005489sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005490sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005491sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005492sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005493sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005494sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005495sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005496sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005497sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005498sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005499sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000549Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000549Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000549Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000549Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000549Esv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000549Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d000054A0sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d000054A1sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d000054A2sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d000054A3sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d000054A4sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d000054A5sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d000054A6sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d000054A7sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d000054A8sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d000054A9sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d000054AAsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d000054ABsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d000054ACsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d000054ADsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d000054AEsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d000054AFsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d000054B0sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005600sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005601sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005602sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005603sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005604sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005605sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005606sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005607sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005608sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005609sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000560Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000560Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000560Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000560Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000560Esv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005610sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005611sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005612sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005613sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005614sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005615sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005616sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005617sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005618sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005619sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000561Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000561Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005680sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005681sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005682sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005683sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005684sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005685sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005686sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005687sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005688sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005689sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005690sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005691sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005692sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005693sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005694sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005695sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005696sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005697sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005698sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00005699sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000569Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000569Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000569Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000569Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000569Esv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000569Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d000056A0sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d000056A1sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d000056A2sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d000056A3sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d000056A4sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d000056A5sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d000056A6sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d000056A7sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d000056A8sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d000056A9sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d000056AAsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d000056ABsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d000056ACsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d000056ADsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d000056AEsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d000056AFsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d000056B0sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006001sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006002sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006003sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006004sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006005sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006006sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006007sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006008sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006009sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000600Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006011sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006014sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006015sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006080sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006081sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006082sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006083sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006084sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006085sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006086sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006087sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006088sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006089sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000608Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000608Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006401sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006402sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006403sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006404sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006405sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006406sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006407sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006408sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006409sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000640Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006411sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006414sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006415sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006480sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006481sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006482sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006483sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006484sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006485sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006486sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006487sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006488sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006489sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000648Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000648Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006601sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006602sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006603sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006604sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006605sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006606sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006607sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006608sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006609sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000660Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006611sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006614sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006615sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006680sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006681sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006682sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006683sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006684sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006685sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006686sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006687sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006688sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d00006689sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000668Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001425d0000668Bsv*sd*bc*sc*i*)

%description chelsio
This package contains compressed kernel firmware files for
Chelsio network drivers.

%package dpaa2
Summary:        Kernel firmware files for NXP Management Complex bus driver
Group:          System/Kernel
Requires(post): /usr/bin/mkdir /usr/bin/touch
Requires(postun): /usr/bin/mkdir /usr/bin/touch
Requires(post): dracut >= 049
Conflicts:      kernel < 5.3

%description dpaa2
This package contains compressed kernel firmware files for
NXP Management Complex bus driver.

%package i915
Summary:        Kernel firmware files for Intel i915 graphics driver
Group:          System/Kernel
Requires(post): /usr/bin/mkdir /usr/bin/touch
Requires(postun): /usr/bin/mkdir /usr/bin/touch
Requires(post): dracut >= 049
Conflicts:      kernel < 5.3
Supplements:    modalias(pci:v00008086d00000042sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000046sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000102sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000106sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d0000010Asv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000112sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000116sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000122sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000126sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000152sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000155sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000156sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000157sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d0000015Asv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000162sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000166sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d0000016Asv0000152Dsd00008990bc03sc*i*)
Supplements:    modalias(pci:v00008086d0000016Asv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000402sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000406sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d0000040Asv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d0000040Bsv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d0000040Esv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000412sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000416sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d0000041Asv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d0000041Bsv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d0000041Esv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000422sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000426sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d0000042Asv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d0000042Bsv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d0000042Esv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000A02sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000A06sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000A0Asv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000A0Bsv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000A0Esv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000A12sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000A16sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000A1Asv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000A1Bsv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000A1Esv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000A22sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000A26sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000A2Asv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000A2Bsv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000A2Esv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000A84sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000C02sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000C06sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000C0Asv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000C0Bsv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000C0Esv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000C12sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000C16sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000C1Asv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000C1Bsv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000C1Esv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000C22sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000C26sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000C2Asv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000C2Bsv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000C2Esv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000D02sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000D06sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000D0Asv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000D0Bsv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000D0Esv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000D12sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000D16sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000D1Asv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000D1Bsv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000D1Esv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000D22sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000D26sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000D2Asv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000D2Bsv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000D2Esv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000F30sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000F31sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000F32sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00000F33sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00001602sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00001606sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d0000160Asv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d0000160Bsv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d0000160Dsv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d0000160Esv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00001612sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00001616sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d0000161Asv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d0000161Bsv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d0000161Dsv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d0000161Esv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00001622sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00001626sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d0000162Asv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d0000162Bsv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d0000162Dsv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d0000162Esv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00001632sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00001636sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d0000163Asv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d0000163Bsv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d0000163Dsv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d0000163Esv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00001902sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00001906sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d0000190Asv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d0000190Bsv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d0000190Esv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00001912sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00001916sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d0000191Asv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d0000191Bsv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d0000191Dsv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d0000191Esv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00001921sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00001923sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00001926sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00001927sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d0000192Asv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d0000192Bsv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d0000192Dsv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00001932sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d0000193Asv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d0000193Bsv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d0000193Dsv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00001A84sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00001A85sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d000022B0sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d000022B1sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d000022B2sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d000022B3sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00002562sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00002572sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00002582sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d0000258Asv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00002592sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00002772sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d000027A2sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d000027AEsv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00002972sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00002982sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00002992sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d000029A2sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d000029B2sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d000029C2sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d000029D2sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00002A02sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00002A12sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00002A42sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00002E02sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00002E12sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00002E22sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00002E32sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00002E42sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00002E92sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00003184sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00003185sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00003577sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00003582sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d0000358Esv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00003E90sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00003E91sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00003E92sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00003E93sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00003E94sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00003E96sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00003E98sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00003E99sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00003E9Asv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00003E9Bsv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00003E9Csv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00003EA0sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00003EA1sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00003EA2sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00003EA3sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00003EA4sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00003EA5sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00003EA6sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00003EA7sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00003EA8sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00003EA9sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00004500sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00004541sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00004551sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00004555sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00004557sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00004571sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00004C80sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00004C8Asv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00004C8Bsv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00004C8Csv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00004C90sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00004C9Asv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00004E51sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00004E55sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00004E57sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00004E61sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00004E71sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00005902sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00005906sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00005908sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d0000590Asv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d0000590Bsv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d0000590Esv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00005912sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00005913sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00005915sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00005916sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00005917sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d0000591Asv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d0000591Bsv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d0000591Csv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d0000591Dsv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d0000591Esv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00005921sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00005923sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00005926sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00005927sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d0000593Bsv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00005A40sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00005A41sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00005A42sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00005A44sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00005A49sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00005A4Asv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00005A4Csv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00005A50sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00005A51sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00005A52sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00005A54sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00005A59sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00005A5Asv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00005A5Csv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00005A84sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00005A85sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d000087C0sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d000087CAsv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00008A50sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00008A51sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00008A52sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00008A53sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00008A54sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00008A56sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00008A57sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00008A58sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00008A59sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00008A5Asv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00008A5Bsv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00008A5Csv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00008A5Dsv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00008A70sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00008A71sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00009A40sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00009A49sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00009A59sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00009A60sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00009A68sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00009A70sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00009A78sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00009AC0sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00009AC9sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00009AD9sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00009AF8sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00009B21sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00009B41sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00009BA0sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00009BA2sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00009BA4sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00009BA5sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00009BA8sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00009BAAsv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00009BABsv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00009BACsv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00009BC0sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00009BC2sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00009BC4sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00009BC5sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00009BC6sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00009BC8sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00009BCAsv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00009BCBsv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00009BCCsv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00009BE6sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d00009BF6sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d0000A001sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00008086d0000A011sv*sd*bc03sc*i*)

%description i915
This package contains compressed kernel firmware files for
Intel i915 graphics driver.

%package intel
Summary:        Kernel firmware files for Intel-platform device drivers
Group:          System/Kernel
Requires(post): /usr/bin/mkdir /usr/bin/touch
Requires(postun): /usr/bin/mkdir /usr/bin/touch
Requires(post): dracut >= 049
Conflicts:      kernel < 5.3
Supplements:    modalias(pci:v00008086d00000435sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d00001919sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d000019E2sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d00001D60sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d00001D61sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d00001D62sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d00001D63sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d00001D64sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d00001D65sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d00001D66sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d00001D67sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d00001D68sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d00001D69sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d00001D6Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d00001D6Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024F0sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024F1sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d000037C8sv*sd*bc*sc*i*)
Supplements:    modalias(usb:v8086p0180d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v8086p0181d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v8086p0182d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v8086p0186d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v8086p0187d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v8086p0188d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v8086p1403d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v8086p1405d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v8086p1406d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v8087p07D6d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v8087p07D7d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v8087p07D9d*dc*dsc*dp*ic*isc*ip*in*)

%description intel
This package contains compressed kernel firmware files for
Intel-platform device drivers.

%package iwlwifi
Summary:        Kernel firmware files for Intel wireless drivers
Group:          System/Kernel
Requires(post): /usr/bin/mkdir /usr/bin/touch
Requires(postun): /usr/bin/mkdir /usr/bin/touch
Requires(post): dracut >= 049
Conflicts:      kernel < 5.3
Provides:       iwl1000-ucode
Obsoletes:      iwl1000-ucode
Provides:       iwl3945-ucode
Obsoletes:      iwl3945-ucode
Provides:       iwl4965-ucode
Obsoletes:      iwl4965-ucode
Provides:       iwl5000-ucode
Obsoletes:      iwl5000-ucode
Provides:       iwl5150-ucode
Obsoletes:      iwl5150-ucode
Provides:       iwl100-ucode
Obsoletes:      iwl100-ucode
Provides:       iwl6000-ucode
Obsoletes:      iwl6000-ucode
Provides:       iwl6050-ucode
Obsoletes:      iwl6050-ucode
Provides:       iwl6000g2-ucode
Obsoletes:      iwl6000g2-ucode
Supplements:    modalias(iwl4965)
Supplements:    modalias(pci:v00008086d00000082sv*sd00001301bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000082sv*sd00001304bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000082sv*sd00001305bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000082sv*sd00001306bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000082sv*sd00001307bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000082sv*sd00001308bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000082sv*sd00001321bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000082sv*sd00001326bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000082sv*sd00001328bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000082sv*sd00004820bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000082sv*sd0000C020bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000083sv*sd00001205bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000083sv*sd00001206bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000083sv*sd00001225bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000083sv*sd00001226bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000083sv*sd00001305bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000083sv*sd00001306bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000083sv*sd00001325bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000083sv*sd00001326bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000084sv*sd00001215bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000084sv*sd00001216bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000084sv*sd00001315bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000084sv*sd00001316bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000085sv*sd00001311bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000085sv*sd00001316bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000085sv*sd00001318bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000085sv*sd0000C220bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000085sv*sd0000C228bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000087sv*sd00001301bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000087sv*sd00001306bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000087sv*sd00001321bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000087sv*sd00001326bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000089sv*sd00001311bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000089sv*sd00001316bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000008Asv*sd00005305bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000008Asv*sd00005307bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000008Asv*sd00005325bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000008Asv*sd00005327bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000008Bsv*sd00005315bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000008Bsv*sd00005317bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000090sv*sd00005211bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000090sv*sd00005215bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000090sv*sd00005216bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000091sv*sd00005201bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000091sv*sd00005205bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000091sv*sd00005206bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000091sv*sd00005207bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000091sv*sd00005221bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000091sv*sd00005225bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000091sv*sd00005226bc*sc*i*)
Supplements:    modalias(pci:v00008086d000002F0sv*sd00000030bc*sc*i*)
Supplements:    modalias(pci:v00008086d000002F0sv*sd00000034bc*sc*i*)
Supplements:    modalias(pci:v00008086d000002F0sv*sd00000038bc*sc*i*)
Supplements:    modalias(pci:v00008086d000002F0sv*sd0000003Cbc*sc*i*)
Supplements:    modalias(pci:v00008086d000002F0sv*sd00000040bc*sc*i*)
Supplements:    modalias(pci:v00008086d000002F0sv*sd00000044bc*sc*i*)
Supplements:    modalias(pci:v00008086d000002F0sv*sd00000060bc*sc*i*)
Supplements:    modalias(pci:v00008086d000002F0sv*sd00000064bc*sc*i*)
Supplements:    modalias(pci:v00008086d000002F0sv*sd00000070bc*sc*i*)
Supplements:    modalias(pci:v00008086d000002F0sv*sd00000074bc*sc*i*)
Supplements:    modalias(pci:v00008086d000002F0sv*sd00000078bc*sc*i*)
Supplements:    modalias(pci:v00008086d000002F0sv*sd0000007Cbc*sc*i*)
Supplements:    modalias(pci:v00008086d000002F0sv*sd000000A0bc*sc*i*)
Supplements:    modalias(pci:v00008086d000002F0sv*sd000000A4bc*sc*i*)
Supplements:    modalias(pci:v00008086d000002F0sv*sd00000230bc*sc*i*)
Supplements:    modalias(pci:v00008086d000002F0sv*sd00000234bc*sc*i*)
Supplements:    modalias(pci:v00008086d000002F0sv*sd00000238bc*sc*i*)
Supplements:    modalias(pci:v00008086d000002F0sv*sd0000023Cbc*sc*i*)
Supplements:    modalias(pci:v00008086d000002F0sv*sd00000244bc*sc*i*)
Supplements:    modalias(pci:v00008086d000002F0sv*sd00000260bc*sc*i*)
Supplements:    modalias(pci:v00008086d000002F0sv*sd00000264bc*sc*i*)
Supplements:    modalias(pci:v00008086d000002F0sv*sd000002A0bc*sc*i*)
Supplements:    modalias(pci:v00008086d000002F0sv*sd000002A4bc*sc*i*)
Supplements:    modalias(pci:v00008086d000002F0sv*sd00000310bc*sc*i*)
Supplements:    modalias(pci:v00008086d000002F0sv*sd00001030bc*sc*i*)
Supplements:    modalias(pci:v00008086d000002F0sv*sd00001551bc*sc*i*)
Supplements:    modalias(pci:v00008086d000002F0sv*sd00001552bc*sc*i*)
Supplements:    modalias(pci:v00008086d000002F0sv*sd00001651bc*sc*i*)
Supplements:    modalias(pci:v00008086d000002F0sv*sd00001652bc*sc*i*)
Supplements:    modalias(pci:v00008086d000002F0sv*sd00002030bc*sc*i*)
Supplements:    modalias(pci:v00008086d000002F0sv*sd00002034bc*sc*i*)
Supplements:    modalias(pci:v00008086d000002F0sv*sd00002074bc*sc*i*)
Supplements:    modalias(pci:v00008086d000002F0sv*sd00004030bc*sc*i*)
Supplements:    modalias(pci:v00008086d000002F0sv*sd00004034bc*sc*i*)
Supplements:    modalias(pci:v00008086d000002F0sv*sd00004070bc*sc*i*)
Supplements:    modalias(pci:v00008086d000002F0sv*sd000040A4bc*sc*i*)
Supplements:    modalias(pci:v00008086d000002F0sv*sd00004234bc*sc*i*)
Supplements:    modalias(pci:v00008086d000002F0sv*sd00004244bc*sc*i*)
Supplements:    modalias(pci:v00008086d000002F0sv*sd000042A4bc*sc*i*)
Supplements:    modalias(pci:v00008086d000002F0sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d000006F0sv*sd00000030bc*sc*i*)
Supplements:    modalias(pci:v00008086d000006F0sv*sd00000034bc*sc*i*)
Supplements:    modalias(pci:v00008086d000006F0sv*sd00000038bc*sc*i*)
Supplements:    modalias(pci:v00008086d000006F0sv*sd0000003Cbc*sc*i*)
Supplements:    modalias(pci:v00008086d000006F0sv*sd00000040bc*sc*i*)
Supplements:    modalias(pci:v00008086d000006F0sv*sd00000044bc*sc*i*)
Supplements:    modalias(pci:v00008086d000006F0sv*sd00000060bc*sc*i*)
Supplements:    modalias(pci:v00008086d000006F0sv*sd00000064bc*sc*i*)
Supplements:    modalias(pci:v00008086d000006F0sv*sd00000070bc*sc*i*)
Supplements:    modalias(pci:v00008086d000006F0sv*sd00000074bc*sc*i*)
Supplements:    modalias(pci:v00008086d000006F0sv*sd00000078bc*sc*i*)
Supplements:    modalias(pci:v00008086d000006F0sv*sd0000007Cbc*sc*i*)
Supplements:    modalias(pci:v00008086d000006F0sv*sd000000A0bc*sc*i*)
Supplements:    modalias(pci:v00008086d000006F0sv*sd000000A4bc*sc*i*)
Supplements:    modalias(pci:v00008086d000006F0sv*sd00000230bc*sc*i*)
Supplements:    modalias(pci:v00008086d000006F0sv*sd00000234bc*sc*i*)
Supplements:    modalias(pci:v00008086d000006F0sv*sd00000238bc*sc*i*)
Supplements:    modalias(pci:v00008086d000006F0sv*sd0000023Cbc*sc*i*)
Supplements:    modalias(pci:v00008086d000006F0sv*sd00000244bc*sc*i*)
Supplements:    modalias(pci:v00008086d000006F0sv*sd00000260bc*sc*i*)
Supplements:    modalias(pci:v00008086d000006F0sv*sd00000264bc*sc*i*)
Supplements:    modalias(pci:v00008086d000006F0sv*sd000002A0bc*sc*i*)
Supplements:    modalias(pci:v00008086d000006F0sv*sd000002A4bc*sc*i*)
Supplements:    modalias(pci:v00008086d000006F0sv*sd00000310bc*sc*i*)
Supplements:    modalias(pci:v00008086d000006F0sv*sd00001551bc*sc*i*)
Supplements:    modalias(pci:v00008086d000006F0sv*sd00001552bc*sc*i*)
Supplements:    modalias(pci:v00008086d000006F0sv*sd00001651bc*sc*i*)
Supplements:    modalias(pci:v00008086d000006F0sv*sd00001652bc*sc*i*)
Supplements:    modalias(pci:v00008086d000006F0sv*sd00002030bc*sc*i*)
Supplements:    modalias(pci:v00008086d000006F0sv*sd00002034bc*sc*i*)
Supplements:    modalias(pci:v00008086d000006F0sv*sd00002074bc*sc*i*)
Supplements:    modalias(pci:v00008086d000006F0sv*sd00004030bc*sc*i*)
Supplements:    modalias(pci:v00008086d000006F0sv*sd00004034bc*sc*i*)
Supplements:    modalias(pci:v00008086d000006F0sv*sd00004070bc*sc*i*)
Supplements:    modalias(pci:v00008086d000006F0sv*sd000040A4bc*sc*i*)
Supplements:    modalias(pci:v00008086d000006F0sv*sd00004234bc*sc*i*)
Supplements:    modalias(pci:v00008086d000006F0sv*sd00004244bc*sc*i*)
Supplements:    modalias(pci:v00008086d000006F0sv*sd000042A4bc*sc*i*)
Supplements:    modalias(pci:v00008086d000006F0sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000885sv*sd00001305bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000885sv*sd00001307bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000885sv*sd00001325bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000885sv*sd00001327bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000886sv*sd00001315bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000886sv*sd00001317bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000887sv*sd00004062bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000887sv*sd00004462bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000888sv*sd00004262bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000088Esv*sd00004060bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000088Esv*sd0000406Abc*sc*i*)
Supplements:    modalias(pci:v00008086d0000088Esv*sd00004460bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000088Esv*sd0000446Abc*sc*i*)
Supplements:    modalias(pci:v00008086d0000088Esv*sd00004860bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000088Fsv*sd00004260bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000088Fsv*sd0000426Abc*sc*i*)
Supplements:    modalias(pci:v00008086d0000088Fsv*sd00005260bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000890sv*sd00004022bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000890sv*sd00004422bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000890sv*sd00004822bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000891sv*sd00004222bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000892sv*sd00000062bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000892sv*sd00000462bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000893sv*sd00000262bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000894sv*sd00000022bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000894sv*sd00000422bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000894sv*sd00000822bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000895sv*sd00000222bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000896sv*sd00005005bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000896sv*sd00005007bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000896sv*sd00005025bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000896sv*sd00005027bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000897sv*sd00005015bc*sc*i*)
Supplements:    modalias(pci:v00008086d00000897sv*sd00005017bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008AEsv*sd00001005bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008AEsv*sd00001007bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008AEsv*sd00001025bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008AEsv*sd00001027bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008AFsv*sd00001015bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008AFsv*sd00001017bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B1sv*sd00004020bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B1sv*sd0000402Abc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B1sv*sd00004060bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B1sv*sd00004062bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B1sv*sd0000406Abc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B1sv*sd00004070bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B1sv*sd00004072bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B1sv*sd00004160bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B1sv*sd00004162bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B1sv*sd00004170bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B1sv*sd00004420bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B1sv*sd00004460bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B1sv*sd00004462bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B1sv*sd0000446Abc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B1sv*sd00004470bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B1sv*sd00004472bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B1sv*sd00004560bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B1sv*sd00004570bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B1sv*sd0000486Ebc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B1sv*sd00004870bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B1sv*sd00004A6Cbc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B1sv*sd00004A6Ebc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B1sv*sd00004A70bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B1sv*sd00004C60bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B1sv*sd00004C70bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B1sv*sd00005070bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B1sv*sd00005072bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B1sv*sd00005170bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B1sv*sd00005770bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B1sv*sd0000C020bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B1sv*sd0000C02Abc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B1sv*sd0000C060bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B1sv*sd0000C062bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B1sv*sd0000C06Abc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B1sv*sd0000C070bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B1sv*sd0000C072bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B1sv*sd0000C160bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B1sv*sd0000C162bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B1sv*sd0000C170bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B1sv*sd0000C360bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B1sv*sd0000C420bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B1sv*sd0000C460bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B1sv*sd0000C462bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B1sv*sd0000C470bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B1sv*sd0000C472bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B1sv*sd0000C560bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B1sv*sd0000C570bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B1sv*sd0000C760bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B1sv*sd0000C770bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B1sv*sd0000CC60bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B1sv*sd0000CC70bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B2sv*sd00004220bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B2sv*sd00004260bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B2sv*sd00004262bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B2sv*sd0000426Abc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B2sv*sd00004270bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B2sv*sd00004272bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B2sv*sd00004360bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B2sv*sd00004370bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B2sv*sd0000C220bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B2sv*sd0000C260bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B2sv*sd0000C262bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B2sv*sd0000C26Abc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B2sv*sd0000C270bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B2sv*sd0000C272bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B2sv*sd0000C370bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B3sv*sd00000060bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B3sv*sd00000062bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B3sv*sd00000070bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B3sv*sd00000072bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B3sv*sd00000170bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B3sv*sd00000172bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B3sv*sd00000470bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B3sv*sd00000472bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B3sv*sd00001070bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B3sv*sd00001170bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B3sv*sd00008060bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B3sv*sd00008062bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B3sv*sd00008070bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B3sv*sd00008072bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B3sv*sd00008170bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B3sv*sd00008172bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B3sv*sd00008470bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B3sv*sd00008570bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B4sv*sd00000270bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B4sv*sd00000272bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B4sv*sd00000370bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B4sv*sd00008270bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B4sv*sd00008272bc*sc*i*)
Supplements:    modalias(pci:v00008086d000008B4sv*sd00008370bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000095Asv*sd00001010bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000095Asv*sd00005000bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000095Asv*sd00005002bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000095Asv*sd0000500Abc*sc*i*)
Supplements:    modalias(pci:v00008086d0000095Asv*sd00005010bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000095Asv*sd00005012bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000095Asv*sd00005020bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000095Asv*sd0000502Abc*sc*i*)
Supplements:    modalias(pci:v00008086d0000095Asv*sd00005090bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000095Asv*sd00005100bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000095Asv*sd00005102bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000095Asv*sd00005110bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000095Asv*sd00005190bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000095Asv*sd00005400bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000095Asv*sd00005410bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000095Asv*sd00005412bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000095Asv*sd00005420bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000095Asv*sd00005490bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000095Asv*sd00005510bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000095Asv*sd00005590bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000095Asv*sd00005C10bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000095Asv*sd00005F10bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000095Asv*sd00009000bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000095Asv*sd0000900Abc*sc*i*)
Supplements:    modalias(pci:v00008086d0000095Asv*sd00009010bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000095Asv*sd00009012bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000095Asv*sd00009110bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000095Asv*sd00009112bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000095Asv*sd00009400bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000095Asv*sd00009410bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000095Asv*sd00009510bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000095Asv*sd00009E10bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000095Bsv*sd00005200bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000095Bsv*sd00005202bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000095Bsv*sd0000520Abc*sc*i*)
Supplements:    modalias(pci:v00008086d0000095Bsv*sd00005210bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000095Bsv*sd00005212bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000095Bsv*sd00005290bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000095Bsv*sd00005302bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000095Bsv*sd00005310bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000095Bsv*sd00009200bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000095Bsv*sd00009210bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000095Bsv*sd00009310bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024F3sv*sd00000000bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024F3sv*sd00000004bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024F3sv*sd00000010bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024F3sv*sd00000012bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024F3sv*sd00000044bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024F3sv*sd00000050bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024F3sv*sd00000110bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024F3sv*sd00000130bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024F3sv*sd00000132bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024F3sv*sd00000150bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024F3sv*sd000001F0bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024F3sv*sd00000250bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024F3sv*sd00000810bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024F3sv*sd00000850bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024F3sv*sd00000910bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024F3sv*sd00000930bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024F3sv*sd00000950bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024F3sv*sd00001010bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024F3sv*sd00001012bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024F3sv*sd00001050bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024F3sv*sd000010B0bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024F3sv*sd00001110bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024F3sv*sd00001130bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024F3sv*sd00001132bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024F3sv*sd00001150bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024F3sv*sd00004010bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024F3sv*sd00008010bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024F3sv*sd00008050bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024F3sv*sd00008110bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024F3sv*sd00008130bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024F3sv*sd00008132bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024F3sv*sd00008150bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024F3sv*sd00009010bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024F3sv*sd00009050bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024F3sv*sd00009110bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024F3sv*sd00009130bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024F3sv*sd00009132bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024F3sv*sd00009150bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024F3sv*sd0000B0B0bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024F3sv*sd0000C010bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024F3sv*sd0000C050bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024F3sv*sd0000C110bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024F3sv*sd0000D010bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024F3sv*sd0000D050bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024F3sv*sd0000D0B0bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024F4sv*sd00000030bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024F4sv*sd00001030bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024F4sv*sd00008030bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024F4sv*sd00009030bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024F4sv*sd0000C030bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024F4sv*sd0000D030bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024F5sv*sd00000010bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024F6sv*sd00000030bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024FBsv*sd00000000bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024FBsv*sd00002010bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024FBsv*sd00002050bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024FBsv*sd00002110bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024FBsv*sd00002150bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024FDsv*sd00000010bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024FDsv*sd00000012bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024FDsv*sd00000014bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024FDsv*sd00000050bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024FDsv*sd00000110bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024FDsv*sd00000130bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024FDsv*sd00000150bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024FDsv*sd00000810bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024FDsv*sd00000850bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024FDsv*sd00000910bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024FDsv*sd00000930bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024FDsv*sd00000950bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024FDsv*sd00001010bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024FDsv*sd00001012bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024FDsv*sd00001014bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024FDsv*sd000010D0bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024FDsv*sd00001110bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024FDsv*sd00001130bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024FDsv*sd00003E01bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024FDsv*sd00003E02bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024FDsv*sd00008010bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024FDsv*sd00008050bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024FDsv*sd00008110bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024FDsv*sd00008130bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024FDsv*sd00009010bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024FDsv*sd00009074bc*sc*i*)
Supplements:    modalias(pci:v00008086d000024FDsv*sd00009110bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002526sv*sd00000010bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002526sv*sd00000014bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002526sv*sd00000018bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002526sv*sd0000001Cbc*sc*i*)
Supplements:    modalias(pci:v00008086d00002526sv*sd00000030bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002526sv*sd00000034bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002526sv*sd00000038bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002526sv*sd0000003Cbc*sc*i*)
Supplements:    modalias(pci:v00008086d00002526sv*sd00000060bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002526sv*sd00000064bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002526sv*sd000000A0bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002526sv*sd000000A4bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002526sv*sd00000210bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002526sv*sd00000214bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002526sv*sd00000230bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002526sv*sd00000234bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002526sv*sd00000238bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002526sv*sd0000023Cbc*sc*i*)
Supplements:    modalias(pci:v00008086d00002526sv*sd00000260bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002526sv*sd00000264bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002526sv*sd000002A0bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002526sv*sd000002A4bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002526sv*sd00001010bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002526sv*sd00001030bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002526sv*sd00001210bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002526sv*sd00001410bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002526sv*sd00001420bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002526sv*sd00001550bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002526sv*sd00001551bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002526sv*sd00001552bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002526sv*sd00001610bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002526sv*sd00002030bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002526sv*sd00002034bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002526sv*sd00004010bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002526sv*sd00004018bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002526sv*sd0000401Cbc*sc*i*)
Supplements:    modalias(pci:v00008086d00002526sv*sd00004030bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002526sv*sd00004034bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002526sv*sd000040A4bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002526sv*sd00004234bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002526sv*sd000042A4bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002526sv*sd00006010bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002526sv*sd00006014bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002526sv*sd00008010bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002526sv*sd00008014bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002526sv*sd0000A014bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002526sv*sd0000E010bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002526sv*sd0000E014bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002526sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000271Bsv*sd00000010bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000271Bsv*sd00000014bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000271Bsv*sd00000210bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000271Bsv*sd00000214bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000271Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000271Csv*sd00000214bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000271Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002720sv*sd00000000bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002720sv*sd00000030bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002720sv*sd00000034bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002720sv*sd00000038bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002720sv*sd0000003Cbc*sc*i*)
Supplements:    modalias(pci:v00008086d00002720sv*sd00000040bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002720sv*sd00000044bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002720sv*sd00000060bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002720sv*sd00000064bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002720sv*sd00000070bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002720sv*sd00000074bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002720sv*sd00000078bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002720sv*sd0000007Cbc*sc*i*)
Supplements:    modalias(pci:v00008086d00002720sv*sd00000090bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002720sv*sd000000A0bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002720sv*sd000000A4bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002720sv*sd00000230bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002720sv*sd00000234bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002720sv*sd00000238bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002720sv*sd0000023Cbc*sc*i*)
Supplements:    modalias(pci:v00008086d00002720sv*sd00000244bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002720sv*sd00000260bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002720sv*sd00000264bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002720sv*sd000002A0bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002720sv*sd000002A4bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002720sv*sd00000310bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002720sv*sd00000A10bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002720sv*sd00001010bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002720sv*sd00001030bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002720sv*sd00001080bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002720sv*sd00001210bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002720sv*sd00001551bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002720sv*sd00001552bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002720sv*sd00001651bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002720sv*sd00001652bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002720sv*sd00002030bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002720sv*sd00002034bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002720sv*sd00002074bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002720sv*sd00004030bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002720sv*sd00004034bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002720sv*sd00004070bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002720sv*sd000040A4bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002720sv*sd00004234bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002720sv*sd00004244bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002720sv*sd000042A4bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002720sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002723sv*sd00000080bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002723sv*sd00000084bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002723sv*sd00000088bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002723sv*sd0000008Cbc*sc*i*)
Supplements:    modalias(pci:v00008086d00002723sv*sd00001653bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002723sv*sd00001654bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002723sv*sd00002080bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002723sv*sd00004080bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002723sv*sd00004088bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002723sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002725sv*sd00000020bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002725sv*sd00000024bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002725sv*sd00000090bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002725sv*sd000000B0bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002725sv*sd00000310bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002725sv*sd00000510bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002725sv*sd00000A10bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002725sv*sd00004020bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002725sv*sd00006020bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002725sv*sd00006024bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002725sv*sd0000E020bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002725sv*sd0000E024bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002726sv*sd00000070bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002726sv*sd00000074bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002726sv*sd00000078bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002726sv*sd0000007Cbc*sc*i*)
Supplements:    modalias(pci:v00008086d00002726sv*sd00000090bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002726sv*sd00000098bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002726sv*sd000000B0bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002726sv*sd00000510bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002726sv*sd00002074bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002726sv*sd00004070bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002729sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d000030DCsv*sd00000030bc*sc*i*)
Supplements:    modalias(pci:v00008086d000030DCsv*sd00000034bc*sc*i*)
Supplements:    modalias(pci:v00008086d000030DCsv*sd00000038bc*sc*i*)
Supplements:    modalias(pci:v00008086d000030DCsv*sd0000003Cbc*sc*i*)
Supplements:    modalias(pci:v00008086d000030DCsv*sd00000060bc*sc*i*)
Supplements:    modalias(pci:v00008086d000030DCsv*sd00000064bc*sc*i*)
Supplements:    modalias(pci:v00008086d000030DCsv*sd000000A0bc*sc*i*)
Supplements:    modalias(pci:v00008086d000030DCsv*sd000000A4bc*sc*i*)
Supplements:    modalias(pci:v00008086d000030DCsv*sd00000230bc*sc*i*)
Supplements:    modalias(pci:v00008086d000030DCsv*sd00000234bc*sc*i*)
Supplements:    modalias(pci:v00008086d000030DCsv*sd00000238bc*sc*i*)
Supplements:    modalias(pci:v00008086d000030DCsv*sd0000023Cbc*sc*i*)
Supplements:    modalias(pci:v00008086d000030DCsv*sd00000260bc*sc*i*)
Supplements:    modalias(pci:v00008086d000030DCsv*sd00000264bc*sc*i*)
Supplements:    modalias(pci:v00008086d000030DCsv*sd000002A0bc*sc*i*)
Supplements:    modalias(pci:v00008086d000030DCsv*sd000002A4bc*sc*i*)
Supplements:    modalias(pci:v00008086d000030DCsv*sd00001010bc*sc*i*)
Supplements:    modalias(pci:v00008086d000030DCsv*sd00001030bc*sc*i*)
Supplements:    modalias(pci:v00008086d000030DCsv*sd00001210bc*sc*i*)
Supplements:    modalias(pci:v00008086d000030DCsv*sd00001551bc*sc*i*)
Supplements:    modalias(pci:v00008086d000030DCsv*sd00001552bc*sc*i*)
Supplements:    modalias(pci:v00008086d000030DCsv*sd00002030bc*sc*i*)
Supplements:    modalias(pci:v00008086d000030DCsv*sd00002034bc*sc*i*)
Supplements:    modalias(pci:v00008086d000030DCsv*sd00004030bc*sc*i*)
Supplements:    modalias(pci:v00008086d000030DCsv*sd00004034bc*sc*i*)
Supplements:    modalias(pci:v00008086d000030DCsv*sd000040A4bc*sc*i*)
Supplements:    modalias(pci:v00008086d000030DCsv*sd00004234bc*sc*i*)
Supplements:    modalias(pci:v00008086d000030DCsv*sd000042A4bc*sc*i*)
Supplements:    modalias(pci:v00008086d000030DCsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d00003165sv*sd00004010bc*sc*i*)
Supplements:    modalias(pci:v00008086d00003165sv*sd00004012bc*sc*i*)
Supplements:    modalias(pci:v00008086d00003165sv*sd00004110bc*sc*i*)
Supplements:    modalias(pci:v00008086d00003165sv*sd00004410bc*sc*i*)
Supplements:    modalias(pci:v00008086d00003165sv*sd00004510bc*sc*i*)
Supplements:    modalias(pci:v00008086d00003165sv*sd00008010bc*sc*i*)
Supplements:    modalias(pci:v00008086d00003165sv*sd00008110bc*sc*i*)
Supplements:    modalias(pci:v00008086d00003166sv*sd00004210bc*sc*i*)
Supplements:    modalias(pci:v00008086d00003166sv*sd00004212bc*sc*i*)
Supplements:    modalias(pci:v00008086d00003166sv*sd00004310bc*sc*i*)
Supplements:    modalias(pci:v00008086d000031DCsv*sd00000030bc*sc*i*)
Supplements:    modalias(pci:v00008086d000031DCsv*sd00000034bc*sc*i*)
Supplements:    modalias(pci:v00008086d000031DCsv*sd00000038bc*sc*i*)
Supplements:    modalias(pci:v00008086d000031DCsv*sd0000003Cbc*sc*i*)
Supplements:    modalias(pci:v00008086d000031DCsv*sd00000060bc*sc*i*)
Supplements:    modalias(pci:v00008086d000031DCsv*sd00000064bc*sc*i*)
Supplements:    modalias(pci:v00008086d000031DCsv*sd000000A0bc*sc*i*)
Supplements:    modalias(pci:v00008086d000031DCsv*sd000000A4bc*sc*i*)
Supplements:    modalias(pci:v00008086d000031DCsv*sd00000230bc*sc*i*)
Supplements:    modalias(pci:v00008086d000031DCsv*sd00000234bc*sc*i*)
Supplements:    modalias(pci:v00008086d000031DCsv*sd00000238bc*sc*i*)
Supplements:    modalias(pci:v00008086d000031DCsv*sd0000023Cbc*sc*i*)
Supplements:    modalias(pci:v00008086d000031DCsv*sd00000260bc*sc*i*)
Supplements:    modalias(pci:v00008086d000031DCsv*sd00000264bc*sc*i*)
Supplements:    modalias(pci:v00008086d000031DCsv*sd000002A0bc*sc*i*)
Supplements:    modalias(pci:v00008086d000031DCsv*sd000002A4bc*sc*i*)
Supplements:    modalias(pci:v00008086d000031DCsv*sd00001010bc*sc*i*)
Supplements:    modalias(pci:v00008086d000031DCsv*sd00001030bc*sc*i*)
Supplements:    modalias(pci:v00008086d000031DCsv*sd00001210bc*sc*i*)
Supplements:    modalias(pci:v00008086d000031DCsv*sd00001551bc*sc*i*)
Supplements:    modalias(pci:v00008086d000031DCsv*sd00001552bc*sc*i*)
Supplements:    modalias(pci:v00008086d000031DCsv*sd00002030bc*sc*i*)
Supplements:    modalias(pci:v00008086d000031DCsv*sd00002034bc*sc*i*)
Supplements:    modalias(pci:v00008086d000031DCsv*sd00004030bc*sc*i*)
Supplements:    modalias(pci:v00008086d000031DCsv*sd00004034bc*sc*i*)
Supplements:    modalias(pci:v00008086d000031DCsv*sd000040A4bc*sc*i*)
Supplements:    modalias(pci:v00008086d000031DCsv*sd00004234bc*sc*i*)
Supplements:    modalias(pci:v00008086d000031DCsv*sd000042A4bc*sc*i*)
Supplements:    modalias(pci:v00008086d000031DCsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d000034F0sv*sd00000030bc*sc*i*)
Supplements:    modalias(pci:v00008086d000034F0sv*sd00000034bc*sc*i*)
Supplements:    modalias(pci:v00008086d000034F0sv*sd00000038bc*sc*i*)
Supplements:    modalias(pci:v00008086d000034F0sv*sd0000003Cbc*sc*i*)
Supplements:    modalias(pci:v00008086d000034F0sv*sd00000040bc*sc*i*)
Supplements:    modalias(pci:v00008086d000034F0sv*sd00000044bc*sc*i*)
Supplements:    modalias(pci:v00008086d000034F0sv*sd00000060bc*sc*i*)
Supplements:    modalias(pci:v00008086d000034F0sv*sd00000064bc*sc*i*)
Supplements:    modalias(pci:v00008086d000034F0sv*sd00000070bc*sc*i*)
Supplements:    modalias(pci:v00008086d000034F0sv*sd00000074bc*sc*i*)
Supplements:    modalias(pci:v00008086d000034F0sv*sd00000078bc*sc*i*)
Supplements:    modalias(pci:v00008086d000034F0sv*sd0000007Cbc*sc*i*)
Supplements:    modalias(pci:v00008086d000034F0sv*sd000000A0bc*sc*i*)
Supplements:    modalias(pci:v00008086d000034F0sv*sd000000A4bc*sc*i*)
Supplements:    modalias(pci:v00008086d000034F0sv*sd00000230bc*sc*i*)
Supplements:    modalias(pci:v00008086d000034F0sv*sd00000234bc*sc*i*)
Supplements:    modalias(pci:v00008086d000034F0sv*sd00000238bc*sc*i*)
Supplements:    modalias(pci:v00008086d000034F0sv*sd0000023Cbc*sc*i*)
Supplements:    modalias(pci:v00008086d000034F0sv*sd00000244bc*sc*i*)
Supplements:    modalias(pci:v00008086d000034F0sv*sd00000260bc*sc*i*)
Supplements:    modalias(pci:v00008086d000034F0sv*sd00000264bc*sc*i*)
Supplements:    modalias(pci:v00008086d000034F0sv*sd000002A0bc*sc*i*)
Supplements:    modalias(pci:v00008086d000034F0sv*sd000002A4bc*sc*i*)
Supplements:    modalias(pci:v00008086d000034F0sv*sd00000310bc*sc*i*)
Supplements:    modalias(pci:v00008086d000034F0sv*sd00001551bc*sc*i*)
Supplements:    modalias(pci:v00008086d000034F0sv*sd00001552bc*sc*i*)
Supplements:    modalias(pci:v00008086d000034F0sv*sd00001651bc*sc*i*)
Supplements:    modalias(pci:v00008086d000034F0sv*sd00001652bc*sc*i*)
Supplements:    modalias(pci:v00008086d000034F0sv*sd00002030bc*sc*i*)
Supplements:    modalias(pci:v00008086d000034F0sv*sd00002034bc*sc*i*)
Supplements:    modalias(pci:v00008086d000034F0sv*sd00002074bc*sc*i*)
Supplements:    modalias(pci:v00008086d000034F0sv*sd00004030bc*sc*i*)
Supplements:    modalias(pci:v00008086d000034F0sv*sd00004034bc*sc*i*)
Supplements:    modalias(pci:v00008086d000034F0sv*sd00004070bc*sc*i*)
Supplements:    modalias(pci:v00008086d000034F0sv*sd000040A4bc*sc*i*)
Supplements:    modalias(pci:v00008086d000034F0sv*sd00004234bc*sc*i*)
Supplements:    modalias(pci:v00008086d000034F0sv*sd00004244bc*sc*i*)
Supplements:    modalias(pci:v00008086d000034F0sv*sd000042A4bc*sc*i*)
Supplements:    modalias(pci:v00008086d000034F0sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d00003DF0sv*sd00000030bc*sc*i*)
Supplements:    modalias(pci:v00008086d00003DF0sv*sd00000034bc*sc*i*)
Supplements:    modalias(pci:v00008086d00003DF0sv*sd00000038bc*sc*i*)
Supplements:    modalias(pci:v00008086d00003DF0sv*sd0000003Cbc*sc*i*)
Supplements:    modalias(pci:v00008086d00003DF0sv*sd00000060bc*sc*i*)
Supplements:    modalias(pci:v00008086d00003DF0sv*sd00000064bc*sc*i*)
Supplements:    modalias(pci:v00008086d00003DF0sv*sd000000A0bc*sc*i*)
Supplements:    modalias(pci:v00008086d00003DF0sv*sd000000A4bc*sc*i*)
Supplements:    modalias(pci:v00008086d00003DF0sv*sd00000230bc*sc*i*)
Supplements:    modalias(pci:v00008086d00003DF0sv*sd00000234bc*sc*i*)
Supplements:    modalias(pci:v00008086d00003DF0sv*sd00000238bc*sc*i*)
Supplements:    modalias(pci:v00008086d00003DF0sv*sd0000023Cbc*sc*i*)
Supplements:    modalias(pci:v00008086d00003DF0sv*sd00000260bc*sc*i*)
Supplements:    modalias(pci:v00008086d00003DF0sv*sd00000264bc*sc*i*)
Supplements:    modalias(pci:v00008086d00003DF0sv*sd000002A0bc*sc*i*)
Supplements:    modalias(pci:v00008086d00003DF0sv*sd000002A4bc*sc*i*)
Supplements:    modalias(pci:v00008086d00003DF0sv*sd00001010bc*sc*i*)
Supplements:    modalias(pci:v00008086d00003DF0sv*sd00001030bc*sc*i*)
Supplements:    modalias(pci:v00008086d00003DF0sv*sd00001210bc*sc*i*)
Supplements:    modalias(pci:v00008086d00003DF0sv*sd00001551bc*sc*i*)
Supplements:    modalias(pci:v00008086d00003DF0sv*sd00001552bc*sc*i*)
Supplements:    modalias(pci:v00008086d00003DF0sv*sd00002030bc*sc*i*)
Supplements:    modalias(pci:v00008086d00003DF0sv*sd00002034bc*sc*i*)
Supplements:    modalias(pci:v00008086d00003DF0sv*sd00004030bc*sc*i*)
Supplements:    modalias(pci:v00008086d00003DF0sv*sd00004034bc*sc*i*)
Supplements:    modalias(pci:v00008086d00003DF0sv*sd000040A4bc*sc*i*)
Supplements:    modalias(pci:v00008086d00003DF0sv*sd00004234bc*sc*i*)
Supplements:    modalias(pci:v00008086d00003DF0sv*sd000042A4bc*sc*i*)
Supplements:    modalias(pci:v00008086d00003DF0sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d00004222sv*sd00001005bc*sc*i*)
Supplements:    modalias(pci:v00008086d00004222sv*sd00001034bc*sc*i*)
Supplements:    modalias(pci:v00008086d00004222sv*sd00001044bc*sc*i*)
Supplements:    modalias(pci:v00008086d00004222sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d00004227sv*sd00001014bc*sc*i*)
Supplements:    modalias(pci:v00008086d00004227sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d00004229sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000422Bsv*sd00001101bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000422Bsv*sd00001108bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000422Bsv*sd00001121bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000422Bsv*sd00001128bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000422Csv*sd00001301bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000422Csv*sd00001306bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000422Csv*sd00001307bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000422Csv*sd00001321bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000422Csv*sd00001326bc*sc*i*)
Supplements:    modalias(pci:v00008086d00004230sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d00004232sv*sd00001201bc*sc*i*)
Supplements:    modalias(pci:v00008086d00004232sv*sd00001204bc*sc*i*)
Supplements:    modalias(pci:v00008086d00004232sv*sd00001205bc*sc*i*)
Supplements:    modalias(pci:v00008086d00004232sv*sd00001206bc*sc*i*)
Supplements:    modalias(pci:v00008086d00004232sv*sd00001221bc*sc*i*)
Supplements:    modalias(pci:v00008086d00004232sv*sd00001224bc*sc*i*)
Supplements:    modalias(pci:v00008086d00004232sv*sd00001225bc*sc*i*)
Supplements:    modalias(pci:v00008086d00004232sv*sd00001226bc*sc*i*)
Supplements:    modalias(pci:v00008086d00004232sv*sd00001301bc*sc*i*)
Supplements:    modalias(pci:v00008086d00004232sv*sd00001304bc*sc*i*)
Supplements:    modalias(pci:v00008086d00004232sv*sd00001305bc*sc*i*)
Supplements:    modalias(pci:v00008086d00004232sv*sd00001306bc*sc*i*)
Supplements:    modalias(pci:v00008086d00004232sv*sd00001321bc*sc*i*)
Supplements:    modalias(pci:v00008086d00004232sv*sd00001324bc*sc*i*)
Supplements:    modalias(pci:v00008086d00004232sv*sd00001325bc*sc*i*)
Supplements:    modalias(pci:v00008086d00004232sv*sd00001326bc*sc*i*)
Supplements:    modalias(pci:v00008086d00004235sv*sd00001001bc*sc*i*)
Supplements:    modalias(pci:v00008086d00004235sv*sd00001004bc*sc*i*)
Supplements:    modalias(pci:v00008086d00004235sv*sd00001021bc*sc*i*)
Supplements:    modalias(pci:v00008086d00004235sv*sd00001024bc*sc*i*)
Supplements:    modalias(pci:v00008086d00004235sv*sd00001101bc*sc*i*)
Supplements:    modalias(pci:v00008086d00004235sv*sd00001104bc*sc*i*)
Supplements:    modalias(pci:v00008086d00004235sv*sd00001121bc*sc*i*)
Supplements:    modalias(pci:v00008086d00004235sv*sd00001124bc*sc*i*)
Supplements:    modalias(pci:v00008086d00004236sv*sd00001011bc*sc*i*)
Supplements:    modalias(pci:v00008086d00004236sv*sd00001014bc*sc*i*)
Supplements:    modalias(pci:v00008086d00004236sv*sd00001111bc*sc*i*)
Supplements:    modalias(pci:v00008086d00004236sv*sd00001114bc*sc*i*)
Supplements:    modalias(pci:v00008086d00004237sv*sd00001211bc*sc*i*)
Supplements:    modalias(pci:v00008086d00004237sv*sd00001214bc*sc*i*)
Supplements:    modalias(pci:v00008086d00004237sv*sd00001215bc*sc*i*)
Supplements:    modalias(pci:v00008086d00004237sv*sd00001216bc*sc*i*)
Supplements:    modalias(pci:v00008086d00004237sv*sd00001311bc*sc*i*)
Supplements:    modalias(pci:v00008086d00004237sv*sd00001314bc*sc*i*)
Supplements:    modalias(pci:v00008086d00004237sv*sd00001315bc*sc*i*)
Supplements:    modalias(pci:v00008086d00004237sv*sd00001316bc*sc*i*)
Supplements:    modalias(pci:v00008086d00004238sv*sd00001111bc*sc*i*)
Supplements:    modalias(pci:v00008086d00004238sv*sd00001118bc*sc*i*)
Supplements:    modalias(pci:v00008086d00004239sv*sd00001311bc*sc*i*)
Supplements:    modalias(pci:v00008086d00004239sv*sd00001316bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000423Asv*sd00001001bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000423Asv*sd00001021bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000423Bsv*sd00001011bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000423Csv*sd00001201bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000423Csv*sd00001206bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000423Csv*sd00001221bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000423Csv*sd00001301bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000423Csv*sd00001306bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000423Csv*sd00001321bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000423Csv*sd00001326bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000423Dsv*sd00001211bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000423Dsv*sd00001216bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000423Dsv*sd00001311bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000423Dsv*sd00001316bc*sc*i*)
Supplements:    modalias(pci:v00008086d000043F0sv*sd00000030bc*sc*i*)
Supplements:    modalias(pci:v00008086d000043F0sv*sd00000034bc*sc*i*)
Supplements:    modalias(pci:v00008086d000043F0sv*sd00000038bc*sc*i*)
Supplements:    modalias(pci:v00008086d000043F0sv*sd0000003Cbc*sc*i*)
Supplements:    modalias(pci:v00008086d000043F0sv*sd00000040bc*sc*i*)
Supplements:    modalias(pci:v00008086d000043F0sv*sd00000044bc*sc*i*)
Supplements:    modalias(pci:v00008086d000043F0sv*sd00000060bc*sc*i*)
Supplements:    modalias(pci:v00008086d000043F0sv*sd00000064bc*sc*i*)
Supplements:    modalias(pci:v00008086d000043F0sv*sd00000070bc*sc*i*)
Supplements:    modalias(pci:v00008086d000043F0sv*sd00000074bc*sc*i*)
Supplements:    modalias(pci:v00008086d000043F0sv*sd00000078bc*sc*i*)
Supplements:    modalias(pci:v00008086d000043F0sv*sd0000007Cbc*sc*i*)
Supplements:    modalias(pci:v00008086d000043F0sv*sd000000A0bc*sc*i*)
Supplements:    modalias(pci:v00008086d000043F0sv*sd000000A4bc*sc*i*)
Supplements:    modalias(pci:v00008086d000043F0sv*sd00000230bc*sc*i*)
Supplements:    modalias(pci:v00008086d000043F0sv*sd00000234bc*sc*i*)
Supplements:    modalias(pci:v00008086d000043F0sv*sd00000238bc*sc*i*)
Supplements:    modalias(pci:v00008086d000043F0sv*sd0000023Cbc*sc*i*)
Supplements:    modalias(pci:v00008086d000043F0sv*sd00000244bc*sc*i*)
Supplements:    modalias(pci:v00008086d000043F0sv*sd00000260bc*sc*i*)
Supplements:    modalias(pci:v00008086d000043F0sv*sd00000264bc*sc*i*)
Supplements:    modalias(pci:v00008086d000043F0sv*sd000002A0bc*sc*i*)
Supplements:    modalias(pci:v00008086d000043F0sv*sd000002A4bc*sc*i*)
Supplements:    modalias(pci:v00008086d000043F0sv*sd00001010bc*sc*i*)
Supplements:    modalias(pci:v00008086d000043F0sv*sd00001030bc*sc*i*)
Supplements:    modalias(pci:v00008086d000043F0sv*sd00001210bc*sc*i*)
Supplements:    modalias(pci:v00008086d000043F0sv*sd00001551bc*sc*i*)
Supplements:    modalias(pci:v00008086d000043F0sv*sd00001552bc*sc*i*)
Supplements:    modalias(pci:v00008086d000043F0sv*sd00001651bc*sc*i*)
Supplements:    modalias(pci:v00008086d000043F0sv*sd00001652bc*sc*i*)
Supplements:    modalias(pci:v00008086d000043F0sv*sd00002030bc*sc*i*)
Supplements:    modalias(pci:v00008086d000043F0sv*sd00002034bc*sc*i*)
Supplements:    modalias(pci:v00008086d000043F0sv*sd00002074bc*sc*i*)
Supplements:    modalias(pci:v00008086d000043F0sv*sd00004030bc*sc*i*)
Supplements:    modalias(pci:v00008086d000043F0sv*sd00004034bc*sc*i*)
Supplements:    modalias(pci:v00008086d000043F0sv*sd00004070bc*sc*i*)
Supplements:    modalias(pci:v00008086d000043F0sv*sd000040A4bc*sc*i*)
Supplements:    modalias(pci:v00008086d000043F0sv*sd00004234bc*sc*i*)
Supplements:    modalias(pci:v00008086d000043F0sv*sd00004244bc*sc*i*)
Supplements:    modalias(pci:v00008086d000043F0sv*sd000042A4bc*sc*i*)
Supplements:    modalias(pci:v00008086d000043F0sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d00004DF0sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d00007A70sv*sd00000090bc*sc*i*)
Supplements:    modalias(pci:v00008086d00007A70sv*sd00000098bc*sc*i*)
Supplements:    modalias(pci:v00008086d00007A70sv*sd000000B0bc*sc*i*)
Supplements:    modalias(pci:v00008086d00007A70sv*sd00000310bc*sc*i*)
Supplements:    modalias(pci:v00008086d00007A70sv*sd00000510bc*sc*i*)
Supplements:    modalias(pci:v00008086d00007A70sv*sd00000A10bc*sc*i*)
Supplements:    modalias(pci:v00008086d00007AF0sv*sd00000090bc*sc*i*)
Supplements:    modalias(pci:v00008086d00007AF0sv*sd00000098bc*sc*i*)
Supplements:    modalias(pci:v00008086d00007AF0sv*sd000000B0bc*sc*i*)
Supplements:    modalias(pci:v00008086d00007AF0sv*sd00000310bc*sc*i*)
Supplements:    modalias(pci:v00008086d00007AF0sv*sd00000510bc*sc*i*)
Supplements:    modalias(pci:v00008086d00007AF0sv*sd00000A10bc*sc*i*)
Supplements:    modalias(pci:v00008086d00007E80sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d00009DF0sv*sd00000000bc*sc*i*)
Supplements:    modalias(pci:v00008086d00009DF0sv*sd00000010bc*sc*i*)
Supplements:    modalias(pci:v00008086d00009DF0sv*sd00000030bc*sc*i*)
Supplements:    modalias(pci:v00008086d00009DF0sv*sd00000034bc*sc*i*)
Supplements:    modalias(pci:v00008086d00009DF0sv*sd00000038bc*sc*i*)
Supplements:    modalias(pci:v00008086d00009DF0sv*sd0000003Cbc*sc*i*)
Supplements:    modalias(pci:v00008086d00009DF0sv*sd00000060bc*sc*i*)
Supplements:    modalias(pci:v00008086d00009DF0sv*sd00000064bc*sc*i*)
Supplements:    modalias(pci:v00008086d00009DF0sv*sd000000A0bc*sc*i*)
Supplements:    modalias(pci:v00008086d00009DF0sv*sd000000A4bc*sc*i*)
Supplements:    modalias(pci:v00008086d00009DF0sv*sd00000210bc*sc*i*)
Supplements:    modalias(pci:v00008086d00009DF0sv*sd00000230bc*sc*i*)
Supplements:    modalias(pci:v00008086d00009DF0sv*sd00000234bc*sc*i*)
Supplements:    modalias(pci:v00008086d00009DF0sv*sd00000238bc*sc*i*)
Supplements:    modalias(pci:v00008086d00009DF0sv*sd0000023Cbc*sc*i*)
Supplements:    modalias(pci:v00008086d00009DF0sv*sd00000260bc*sc*i*)
Supplements:    modalias(pci:v00008086d00009DF0sv*sd00000264bc*sc*i*)
Supplements:    modalias(pci:v00008086d00009DF0sv*sd000002A0bc*sc*i*)
Supplements:    modalias(pci:v00008086d00009DF0sv*sd000002A4bc*sc*i*)
Supplements:    modalias(pci:v00008086d00009DF0sv*sd00000310bc*sc*i*)
Supplements:    modalias(pci:v00008086d00009DF0sv*sd00000410bc*sc*i*)
Supplements:    modalias(pci:v00008086d00009DF0sv*sd00000510bc*sc*i*)
Supplements:    modalias(pci:v00008086d00009DF0sv*sd00000610bc*sc*i*)
Supplements:    modalias(pci:v00008086d00009DF0sv*sd00000710bc*sc*i*)
Supplements:    modalias(pci:v00008086d00009DF0sv*sd00000A10bc*sc*i*)
Supplements:    modalias(pci:v00008086d00009DF0sv*sd00001010bc*sc*i*)
Supplements:    modalias(pci:v00008086d00009DF0sv*sd00001030bc*sc*i*)
Supplements:    modalias(pci:v00008086d00009DF0sv*sd00001210bc*sc*i*)
Supplements:    modalias(pci:v00008086d00009DF0sv*sd00001551bc*sc*i*)
Supplements:    modalias(pci:v00008086d00009DF0sv*sd00001552bc*sc*i*)
Supplements:    modalias(pci:v00008086d00009DF0sv*sd00002010bc*sc*i*)
Supplements:    modalias(pci:v00008086d00009DF0sv*sd00002030bc*sc*i*)
Supplements:    modalias(pci:v00008086d00009DF0sv*sd00002034bc*sc*i*)
Supplements:    modalias(pci:v00008086d00009DF0sv*sd00002A10bc*sc*i*)
Supplements:    modalias(pci:v00008086d00009DF0sv*sd00004030bc*sc*i*)
Supplements:    modalias(pci:v00008086d00009DF0sv*sd00004034bc*sc*i*)
Supplements:    modalias(pci:v00008086d00009DF0sv*sd000040A4bc*sc*i*)
Supplements:    modalias(pci:v00008086d00009DF0sv*sd00004234bc*sc*i*)
Supplements:    modalias(pci:v00008086d00009DF0sv*sd000042A4bc*sc*i*)
Supplements:    modalias(pci:v00008086d00009DF0sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A0F0sv*sd00000000bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A0F0sv*sd00000030bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A0F0sv*sd00000034bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A0F0sv*sd00000038bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A0F0sv*sd0000003Cbc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A0F0sv*sd00000040bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A0F0sv*sd00000044bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A0F0sv*sd00000060bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A0F0sv*sd00000064bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A0F0sv*sd00000070bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A0F0sv*sd00000074bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A0F0sv*sd00000078bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A0F0sv*sd0000007Cbc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A0F0sv*sd000000A0bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A0F0sv*sd000000A4bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A0F0sv*sd000000B0bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A0F0sv*sd00000230bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A0F0sv*sd00000234bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A0F0sv*sd00000238bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A0F0sv*sd0000023Cbc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A0F0sv*sd00000244bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A0F0sv*sd00000260bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A0F0sv*sd00000264bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A0F0sv*sd000002A0bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A0F0sv*sd000002A4bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A0F0sv*sd00000A10bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A0F0sv*sd00001010bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A0F0sv*sd00001030bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A0F0sv*sd00001210bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A0F0sv*sd00001551bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A0F0sv*sd00001552bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A0F0sv*sd00001651bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A0F0sv*sd00001652bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A0F0sv*sd00002030bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A0F0sv*sd00002034bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A0F0sv*sd00002074bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A0F0sv*sd00004030bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A0F0sv*sd00004034bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A0F0sv*sd00004070bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A0F0sv*sd000040A4bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A0F0sv*sd00004234bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A0F0sv*sd00004244bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A0F0sv*sd000042A4bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A0F0sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A370sv*sd00000030bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A370sv*sd00000034bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A370sv*sd00000038bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A370sv*sd0000003Cbc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A370sv*sd00000060bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A370sv*sd00000064bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A370sv*sd000000A0bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A370sv*sd000000A4bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A370sv*sd00000230bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A370sv*sd00000234bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A370sv*sd00000238bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A370sv*sd0000023Cbc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A370sv*sd00000260bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A370sv*sd00000264bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A370sv*sd000002A0bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A370sv*sd000002A4bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A370sv*sd00001010bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A370sv*sd00001030bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A370sv*sd00001210bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A370sv*sd00001551bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A370sv*sd00001552bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A370sv*sd00002030bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A370sv*sd00002034bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A370sv*sd00004030bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A370sv*sd00004034bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A370sv*sd000040A4bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A370sv*sd00004234bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A370sv*sd000042A4bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A370sv*sd*bc*sc*i*)

%description iwlwifi
This package contains compressed kernel firmware files for
Intel wireless drivers.

%package liquidio
Summary:        Kernel firmware files for Cavium LiquidIO driver
Group:          System/Kernel
Requires(post): /usr/bin/mkdir /usr/bin/touch
Requires(postun): /usr/bin/mkdir /usr/bin/touch
Requires(post): dracut >= 049
Conflicts:      kernel < 5.3
Supplements:    modalias(pci:v0000177Dd00000091sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v0000177Dd00000092sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v0000177Dd00009702sv*sd*bc*sc*i*)

%description liquidio
This package contains compressed kernel firmware files for
Cavium LiquidIO driver.

%package marvell
Summary:        Kernel firmware files for Marvell network drivers
Group:          System/Kernel
Requires(post): /usr/bin/mkdir /usr/bin/touch
Requires(postun): /usr/bin/mkdir /usr/bin/touch
Requires(post): dracut >= 049
Conflicts:      kernel < 5.3
Supplements:    modalias(pci:v000011ABd00002A0Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000011ABd00002A0Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000011ABd00002A24sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000011ABd00002A2Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000011ABd00002A30sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000011ABd00002A40sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000011ABd00002A41sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000011ABd00002A42sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000011ABd00002A43sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000011ABd00002B36sv*sd*bc*sc*i*)
Supplements:    modalias(pcmcia:m02DBc6064f*fn*pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m02DBc8103f*fn*pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m02DFc8103f*fn*pfn*pa*pb*pc*pd*)
Supplements:    modalias(sdio:c*v02DFd9103*)
Supplements:    modalias(sdio:c*v02DFd9104*)
Supplements:    modalias(sdio:c*v02DFd9105*)
Supplements:    modalias(sdio:c*v02DFd911A*)
Supplements:    modalias(sdio:c*v02DFd911B*)
Supplements:    modalias(sdio:c*v02DFd912A*)
Supplements:    modalias(sdio:c*v02DFd912E*)
Supplements:    modalias(sdio:c*v02DFd9136*)
Supplements:    modalias(sdio:c*v02DFd9142*)
Supplements:    modalias(sdio:c*v02DFd9146*)
Supplements:    modalias(sdio:c*v02DFd914A*)
Supplements:    modalias(usb:v05A3p8388d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1286p2001d*dc*dsc*dp*ic*isc*ip*in*)

%description marvell
This package contains compressed kernel firmware files for
Marvell network drivers.

%package media
Summary:        Kernel firmware files for various Video4Linux drivers
Group:          System/Kernel
Requires(post): /usr/bin/mkdir /usr/bin/touch
Requires(postun): /usr/bin/mkdir /usr/bin/touch
Requires(post): dracut >= 049
Conflicts:      kernel < 5.3
Supplements:    modalias(i2c:cx25840)
Supplements:    modalias(of:N*T*Camlogic,g12a-vdec)
Supplements:    modalias(of:N*T*Camlogic,g12a-vdecC*)
Supplements:    modalias(of:N*T*Camlogic,gxbb-vdec)
Supplements:    modalias(of:N*T*Camlogic,gxbb-vdecC*)
Supplements:    modalias(of:N*T*Camlogic,gxl-vdec)
Supplements:    modalias(of:N*T*Camlogic,gxl-vdecC*)
Supplements:    modalias(of:N*T*Camlogic,gxm-vdec)
Supplements:    modalias(of:N*T*Camlogic,gxm-vdecC*)
Supplements:    modalias(of:N*T*Camlogic,sm1-vdec)
Supplements:    modalias(of:N*T*Camlogic,sm1-vdecC*)
Supplements:    modalias(of:N*T*Cmediatek,mt8173-vpu)
Supplements:    modalias(of:N*T*Cmediatek,mt8173-vpuC*)
Supplements:    modalias(of:N*T*Csamsung,exynos5433-mfc)
Supplements:    modalias(of:N*T*Csamsung,exynos5433-mfcC*)
Supplements:    modalias(of:N*T*Csamsung,mfc-v10)
Supplements:    modalias(of:N*T*Csamsung,mfc-v10C*)
Supplements:    modalias(of:N*T*Csamsung,mfc-v5)
Supplements:    modalias(of:N*T*Csamsung,mfc-v5C*)
Supplements:    modalias(of:N*T*Csamsung,mfc-v6)
Supplements:    modalias(of:N*T*Csamsung,mfc-v6C*)
Supplements:    modalias(of:N*T*Csamsung,mfc-v7)
Supplements:    modalias(of:N*T*Csamsung,mfc-v7C*)
Supplements:    modalias(of:N*T*Csamsung,mfc-v8)
Supplements:    modalias(of:N*T*Csamsung,mfc-v8C*)
Supplements:    modalias(of:N*T*Cti,dra7-vpe)
Supplements:    modalias(of:N*T*Cti,dra7-vpeC*)
Supplements:    modalias(pci:v00001131d00007146sv0000110Asd00000000bc*sc*i*)
Supplements:    modalias(pci:v00001131d00007146sv000013C2sd00000000bc*sc*i*)
Supplements:    modalias(pci:v00001131d00007146sv000013C2sd00000001bc*sc*i*)
Supplements:    modalias(pci:v00001131d00007146sv000013C2sd00000002bc*sc*i*)
Supplements:    modalias(pci:v00001131d00007146sv000013C2sd00000003bc*sc*i*)
Supplements:    modalias(pci:v00001131d00007146sv000013C2sd00000004bc*sc*i*)
Supplements:    modalias(pci:v00001131d00007146sv000013C2sd00000006bc*sc*i*)
Supplements:    modalias(pci:v00001131d00007146sv000013C2sd00000008bc*sc*i*)
Supplements:    modalias(pci:v00001131d00007146sv000013C2sd0000000Abc*sc*i*)
Supplements:    modalias(pci:v00001131d00007146sv000013C2sd0000000Ebc*sc*i*)
Supplements:    modalias(pci:v00001131d00007146sv000013C2sd00001002bc*sc*i*)
Supplements:    modalias(pci:v000014F1d00005B7Asv*sd*bc*sc*i*)
Supplements:    modalias(usb:v0413p60F6d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0413p6A05d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0413p6F00d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0413p6F01d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v045Ep02D5d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v048Dp9005d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v048Dp9006d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v048Dp9135d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v048Dp9306d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v04C1p009Dd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0553p0100d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0553p0140d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0553p0151d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v05D8p810Fd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0602p1001d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07CAp0335d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07CAp0337d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07CAp0825d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07CAp1835d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07CAp1867d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07CAp1871d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07CAp2835d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07CAp3835d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07CAp4835d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07CApA110d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07CApA807d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07CApA835d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07CApA867d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07CApB568d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07CApB808d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07CApB835d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0B05p171Fd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0B05p1736d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0B05p173Fd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0B05p1779d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0B48p1003d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0B48p1004d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0B48p1005d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CCDp0058d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CCDp005Ad*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CCDp0060d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CCDp0062d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CCDp0078d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CCDp0081d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CCDp0093d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CCDp0099d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CCDp00AAd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CCDp00ABd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CCDp10A0d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CCDp10A1d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CCDp10AEd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CCDp10B2d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0FD9p0011d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0FD9p0020d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0FD9p0021d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0FD9p003Fd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1044p7001d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1044p7002d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v10B8p1BB2d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v10B8p1BB4d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v10B8p1E14d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v10B8p1E6Ed*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v10B8p1E78d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v10B8p1E80d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v10B8p1EBCd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v10B8p1EBEd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v10B8p1EF0d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v10B8p1F90d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v10B8p1F98d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v10B8p1F9Cd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v10B8p1FA0d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v10B8p1FA8d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v10B8p1FAAd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v10B8p2383d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v10B8p2384d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1164p0871d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1164p1E8Cd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1164p1EDCd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1164p1EFCd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1164p1F08d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1164p2EDCd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1415p0003d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v147Fp2758d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v14F7p0004d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1554p5010d[0-2]*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1554p5010d3[0-9A-E]*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1554p5010d3F00dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1584p6003d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v15A4p1000d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v15A4p1001d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v15A4p1002d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v15A4p1003d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v15A4p9035d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1660p1921d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v185Bp1E78d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v185Bp1E80d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1B80pE409d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1B80pE410d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1B80pE411d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1D19p0100d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1E59p0002d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1F4DpA115d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2013p0245d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2013p0248d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2013p025Ad*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2013p025Cd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2013p025Dd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2013p0262d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2013p1FAAd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2040p5200d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2040p7050d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2040p7060d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2040p7070d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2040p7080d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2040p8400d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2040p9580d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2040p9941d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2040p9950d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2040pB200d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2040pB210d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2040pF900d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2304p0228d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2304p0229d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2304p022Cd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2304p022Ed*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2304p0236d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2304p0237d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2304p023Ad*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2304p023Bd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2304p023Dd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2304p023Ed*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2304p0243d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2304p0245d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2304p0248d*dc*dsc*dp*ic*isc*ip*in*)

%description media
This package contains compressed kernel firmware files for
various Video4Linux drivers.

%package mediatek
Summary:        Kernel firmware files for Mediatek network drivers
Group:          System/Kernel
Requires(post): /usr/bin/mkdir /usr/bin/touch
Requires(postun): /usr/bin/mkdir /usr/bin/touch
Requires(post): dracut >= 049
Conflicts:      kernel < 5.3
Provides:       ralink-firmware
Obsoletes:      ralink-firmware
Supplements:    modalias(of:N*T*Cmediatek,mt7622-bluetooth)
Supplements:    modalias(of:N*T*Cmediatek,mt7622-bluetoothC*)
Supplements:    modalias(of:N*T*Cmediatek,mt7663u-bluetooth)
Supplements:    modalias(of:N*T*Cmediatek,mt7663u-bluetoothC*)
Supplements:    modalias(of:N*T*Cmediatek,mt7668u-bluetooth)
Supplements:    modalias(of:N*T*Cmediatek,mt7668u-bluetoothC*)
Supplements:    modalias(of:N*T*Cmediatek,mt8183-scp)
Supplements:    modalias(of:N*T*Cmediatek,mt8183-scpC*)
Supplements:    modalias(of:N*T*Cmediatek,mt8192-scp)
Supplements:    modalias(of:N*T*Cmediatek,mt8192-scpC*)
Supplements:    modalias(pci:v000014C3d00007602sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014C3d00007610sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014C3d00007611sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014C3d00007612sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014C3d00007615sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014C3d00007630sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014C3d00007650sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014C3d00007662sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014C3d00007663sv*sd*bc*sc*i*)
Supplements:    modalias(sdio:c*v037Ad7663*)
Supplements:    modalias(sdio:c*v037Ad7668*)
Supplements:    modalias(usb:v045Ep02E6d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v045Ep02FEd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v04BBp0951d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v057Cp8502d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v057Cp8503d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0586p3425d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07B8p7610d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0846p9053d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0B05p17D1d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0B05p17D3d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0B05p17DBd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0B05p17EBd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0B05p180Bd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0B05p1833d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p0075d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p0079d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0E8Dp760Ad*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0E8Dp760Bd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0E8Dp7610d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0E8Dp7612d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0E8Dp7630d*dc*dsc*dp*icFFisc02ipFFin*)
Supplements:    modalias(usb:v0E8Dp7632d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0E8Dp7650d*dc*dsc*dp*icFFisc02ipFFin*)
Supplements:    modalias(usb:v13B1p003Ed*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D3p3431d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D3p3434d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v148Fp7601d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v148Fp760Ad*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v148Fp760Bd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v148Fp760Cd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v148Fp760Dd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v148Fp7610d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v148Fp761Ad*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2001p3D02d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2001p3D04d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2019pAB31d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v20F4p806Bd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2357p0105d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2357p0123d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2717p4106d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v293Cp5702d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2955p0001d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2955p1001d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2A5Fp1000d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2C4Ep0103d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v7392p7710d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v7392pA711d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v7392pB711d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v7392pC711d*dc*dsc*dp*ic*isc*ip*in*)

%description mediatek
This package contains compressed kernel firmware files for
Mediatek network drivers.

%package mellanox
Summary:        Kernel firmware files for Mellanox Spectrum switch driver
Group:          System/Kernel
Requires(post): /usr/bin/mkdir /usr/bin/touch
Requires(postun): /usr/bin/mkdir /usr/bin/touch
Requires(post): dracut >= 049
Conflicts:      kernel < 5.3
Supplements:    modalias(pci:v000015B3d0000CB84sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000015B3d0000CF6Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000015B3d0000CF70sv*sd*bc*sc*i*)

%description mellanox
This package contains compressed kernel firmware files for
Mellanox Spectrum switch driver.

%package mwifiex
Summary:        Kernel firmware files for Marvell WiFi fullmac drivers
Group:          System/Kernel
Requires(post): /usr/bin/mkdir /usr/bin/touch
Requires(postun): /usr/bin/mkdir /usr/bin/touch
Requires(post): dracut >= 049
Conflicts:      kernel < 5.3
Supplements:    modalias(pci:v000011ABd00002B30sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000011ABd00002B38sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000011ABd00002B42sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001B4Bd00002B42sv*sd*bc*sc*i*)
Supplements:    modalias(sdio:c*v02DFd9105*)
Supplements:    modalias(sdio:c*v02DFd9116*)
Supplements:    modalias(sdio:c*v02DFd9119*)
Supplements:    modalias(sdio:c*v02DFd911A*)
Supplements:    modalias(sdio:c*v02DFd911B*)
Supplements:    modalias(sdio:c*v02DFd9129*)
Supplements:    modalias(sdio:c*v02DFd912A*)
Supplements:    modalias(sdio:c*v02DFd912D*)
Supplements:    modalias(sdio:c*v02DFd912E*)
Supplements:    modalias(sdio:c*v02DFd9135*)
Supplements:    modalias(sdio:c*v02DFd9136*)
Supplements:    modalias(sdio:c*v02DFd9139*)
Supplements:    modalias(sdio:c*v02DFd9141*)
Supplements:    modalias(sdio:c*v02DFd9142*)
Supplements:    modalias(sdio:c*v02DFd9145*)
Supplements:    modalias(sdio:c*v02DFd9146*)
Supplements:    modalias(sdio:c*v02DFd9149*)
Supplements:    modalias(sdio:c*v02DFd914A*)
Supplements:    modalias(usb:v1286p2041d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1286p2042d*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v1286p2043d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1286p2044d*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v1286p2049d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1286p204Ad*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v1286p204Ed*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v1286p2052d*dc*dsc*dp*ic*isc*ip*in*)

%description mwifiex
This package contains compressed kernel firmware files for
Marvell WiFi fullmac drivers.

%package network
Summary:        Kernel firmware files for various network drivers
Group:          System/Kernel
Requires(post): /usr/bin/mkdir /usr/bin/touch
Requires(postun): /usr/bin/mkdir /usr/bin/touch
Requires(post): dracut >= 049
Conflicts:      kernel < 5.3
Supplements:    modalias(pci:v00001011d0000001Asv*sd*bc02sc00i*)
Supplements:    modalias(pci:v0000106Bd00001645sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001077d00008020sv*sd*bc02sc00i00*)
Supplements:    modalias(pci:v00001077d00008030sv*sd*bc02sc00i00*)
Supplements:    modalias(pci:v00001077d00008040sv*sd*bc02sc00i00*)
Supplements:    modalias(pci:v00001077d00008430sv*sd*bc02sc00i00*)
Supplements:    modalias(pci:v00001077d00008440sv*sd*bc02sc00i00*)
Supplements:    modalias(pci:v00001077d00008830sv*sd*bc02sc00i00*)
Supplements:    modalias(pci:v00001077d00008C30sv*sd*bc02sc00i00*)
Supplements:    modalias(pci:v000010A9d00000009sv*sd*bc02sc00i*)
Supplements:    modalias(pci:v000010B6d00001001sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000010B6d00001002sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000010B7d00000001sv*sd*bc02sc00i*)
Supplements:    modalias(pci:v000010B7d00009900sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000010B7d00009902sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000010B7d00009903sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000010B7d00009904sv*sd00001000bc*sc*i*)
Supplements:    modalias(pci:v000010B7d00009904sv*sd00001102bc*sc*i*)
Supplements:    modalias(pci:v000010B7d00009904sv*sd00002000bc*sc*i*)
Supplements:    modalias(pci:v000010B7d00009905sv*sd00001101bc*sc*i*)
Supplements:    modalias(pci:v000010B7d00009905sv*sd00001102bc*sc*i*)
Supplements:    modalias(pci:v000010B7d00009905sv*sd00002101bc*sc*i*)
Supplements:    modalias(pci:v000010B7d00009905sv*sd00002102bc*sc*i*)
Supplements:    modalias(pci:v000010B7d00009908sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000010B7d00009909sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000010B7d0000990Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000010CFd000011A2sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001148d00004400sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001148d00004500sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000012AEd00000001sv*sd*bc02sc00i*)
Supplements:    modalias(pci:v000012AEd00000002sv*sd*bc02sc00i*)
Supplements:    modalias(pci:v000012AEd000000FAsv*sd*bc02sc00i*)
Supplements:    modalias(pci:v00001385d0000620Asv*sd*bc02sc00i*)
Supplements:    modalias(pci:v00001385d0000630Asv*sd*bc02sc00i*)
Supplements:    modalias(pci:v000014C1d00000008sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014C1d00000009sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d00001600sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d00001601sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d00001641sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d00001642sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d00001643sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d00001644sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d00001645sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d00001646sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d00001647sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d00001648sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d00001649sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d0000164Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d00001653sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d00001654sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d00001655sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d00001656sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d00001657sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d00001659sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d0000165Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d0000165Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d0000165Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d0000165Esv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d0000165Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d00001665sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d00001668sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d00001669sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d0000166Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d0000166Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d0000166Esv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d00001672sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d00001673sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d00001674sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d00001676sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d00001677sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d00001678sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d00001679sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d0000167Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d0000167Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d0000167Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d0000167Esv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d0000167Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d00001680sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d00001681sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d00001682sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d00001683sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d00001684sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d00001686sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d00001687sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d00001688sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d00001689sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d00001690sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d00001691sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d00001692sv00001025sd00000601bc*sc*i*)
Supplements:    modalias(pci:v000014E4d00001692sv00001025sd00000612bc*sc*i*)
Supplements:    modalias(pci:v000014E4d00001692sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d00001693sv000017AAsd00003056bc*sc*i*)
Supplements:    modalias(pci:v000014E4d00001693sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d00001694sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d00001696sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d00001698sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d00001699sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d0000169Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d0000169Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d0000169Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d0000169Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d000016A0sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d000016A6sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d000016A7sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d000016A8sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d000016B0sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d000016B1sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d000016B2sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d000016B3sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d000016B4sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d000016B5sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d000016B6sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d000016B7sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d000016C6sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d000016C7sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d000016DDsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d000016F3sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d000016F7sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d000016FDsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d000016FEsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d0000170Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d0000170Esv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d00001712sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000014E4d00001713sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v0000173Bd000003E8sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v0000173Bd000003E9sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v0000173Bd000003EAsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v0000173Bd000003EBsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000017D5d00005733sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000017D5d00005833sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001814d00000301sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001814d00000302sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001814d00000401sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001FC9d00003009sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001FC9d00003010sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001FC9d00003014sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00004040d00000001sv*sd*bc02sc00i00*)
Supplements:    modalias(pci:v00004040d00000002sv*sd*bc02sc00i00*)
Supplements:    modalias(pci:v00004040d00000003sv*sd*bc02sc00i00*)
Supplements:    modalias(pci:v00004040d00000004sv*sd*bc02sc00i00*)
Supplements:    modalias(pci:v00004040d00000005sv*sd*bc02sc00i00*)
Supplements:    modalias(pci:v00004040d00000024sv*sd*bc02sc00i00*)
Supplements:    modalias(pci:v00004040d00000025sv*sd*bc02sc00i00*)
Supplements:    modalias(pci:v00004040d00000100sv*sd*bc02sc00i00*)
Supplements:    modalias(pci:v00008086d00001029sv*sd*bc02sc00i*)
Supplements:    modalias(pci:v00008086d00001030sv*sd*bc02sc00i*)
Supplements:    modalias(pci:v00008086d00001031sv*sd*bc02sc00i*)
Supplements:    modalias(pci:v00008086d00001032sv*sd*bc02sc00i*)
Supplements:    modalias(pci:v00008086d00001033sv*sd*bc02sc00i*)
Supplements:    modalias(pci:v00008086d00001034sv*sd*bc02sc00i*)
Supplements:    modalias(pci:v00008086d00001038sv*sd*bc02sc00i*)
Supplements:    modalias(pci:v00008086d00001039sv*sd*bc02sc00i*)
Supplements:    modalias(pci:v00008086d0000103Asv*sd*bc02sc00i*)
Supplements:    modalias(pci:v00008086d0000103Bsv*sd*bc02sc00i*)
Supplements:    modalias(pci:v00008086d0000103Csv*sd*bc02sc00i*)
Supplements:    modalias(pci:v00008086d0000103Dsv*sd*bc02sc00i*)
Supplements:    modalias(pci:v00008086d0000103Esv*sd*bc02sc00i*)
Supplements:    modalias(pci:v00008086d00001050sv*sd*bc02sc00i*)
Supplements:    modalias(pci:v00008086d00001051sv*sd*bc02sc00i*)
Supplements:    modalias(pci:v00008086d00001052sv*sd*bc02sc00i*)
Supplements:    modalias(pci:v00008086d00001053sv*sd*bc02sc00i*)
Supplements:    modalias(pci:v00008086d00001054sv*sd*bc02sc00i*)
Supplements:    modalias(pci:v00008086d00001055sv*sd*bc02sc00i*)
Supplements:    modalias(pci:v00008086d00001056sv*sd*bc02sc00i*)
Supplements:    modalias(pci:v00008086d00001057sv*sd*bc02sc00i*)
Supplements:    modalias(pci:v00008086d00001059sv*sd*bc02sc00i*)
Supplements:    modalias(pci:v00008086d00001064sv*sd*bc02sc00i*)
Supplements:    modalias(pci:v00008086d00001065sv*sd*bc02sc00i*)
Supplements:    modalias(pci:v00008086d00001066sv*sd*bc02sc00i*)
Supplements:    modalias(pci:v00008086d00001067sv*sd*bc02sc00i*)
Supplements:    modalias(pci:v00008086d00001068sv*sd*bc02sc00i*)
Supplements:    modalias(pci:v00008086d00001069sv*sd*bc02sc00i*)
Supplements:    modalias(pci:v00008086d0000106Asv*sd*bc02sc00i*)
Supplements:    modalias(pci:v00008086d0000106Bsv*sd*bc02sc00i*)
Supplements:    modalias(pci:v00008086d00001091sv*sd*bc02sc00i*)
Supplements:    modalias(pci:v00008086d00001092sv*sd*bc02sc00i*)
Supplements:    modalias(pci:v00008086d00001093sv*sd*bc02sc00i*)
Supplements:    modalias(pci:v00008086d00001094sv*sd*bc02sc00i*)
Supplements:    modalias(pci:v00008086d00001095sv*sd*bc02sc00i*)
Supplements:    modalias(pci:v00008086d000010FEsv*sd*bc02sc00i*)
Supplements:    modalias(pci:v00008086d00001209sv*sd*bc02sc00i*)
Supplements:    modalias(pci:v00008086d00001229sv*sd*bc02sc00i*)
Supplements:    modalias(pci:v00008086d0000124Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000124Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000124Esv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000124Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000151Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d00001591sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d00001592sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d00001593sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000159Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000188Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000188Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000188Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000188Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000188Esv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d00001890sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d00001891sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d00001892sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d00001893sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d00001894sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d00001897sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d00001898sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d00001899sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000189Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d00002449sv*sd*bc02sc00i*)
Supplements:    modalias(pci:v00008086d00002459sv*sd*bc02sc00i*)
Supplements:    modalias(pci:v00008086d0000245Dsv*sd*bc02sc00i*)
Supplements:    modalias(pci:v00008086d000027DCsv*sd*bc02sc00i*)
Supplements:    modalias(pci:v00009004d00006915sv*sd*bc*sc*i*)

%description network
This package contains compressed kernel firmware files for
various network drivers.

%package nfp
Summary:        Kernel firmware files for Netronome Flow Processor driver
Group:          System/Kernel
Requires(post): /usr/bin/mkdir /usr/bin/touch
Requires(postun): /usr/bin/mkdir /usr/bin/touch
Requires(post): dracut >= 049
Conflicts:      kernel < 5.3
Supplements:    modalias(pci:v000019EEd00004000sv000019EEsd*bc*sc*i*)
Supplements:    modalias(pci:v000019EEd00005000sv000019EEsd*bc*sc*i*)
Supplements:    modalias(pci:v000019EEd00006000sv000019EEsd*bc*sc*i*)
Supplements:    modalias(pci:v000019EEd00006003sv000019EEsd*bc*sc*i*)

%description nfp
This package contains compressed kernel firmware files for
Netronome Flow Processor driver.

%package nvidia
Summary:        Kernel firmware files for Nvidia Tegra and graphics drivers
Group:          System/Kernel
Requires(post): /usr/bin/mkdir /usr/bin/touch
Requires(postun): /usr/bin/mkdir /usr/bin/touch
Requires(post): dracut >= 049
Conflicts:      kernel < 5.3
Supplements:    modalias(of:N*T*Cnvidia,gk20a)
Supplements:    modalias(of:N*T*Cnvidia,gk20aC*)
Supplements:    modalias(of:N*T*Cnvidia,gm20b)
Supplements:    modalias(of:N*T*Cnvidia,gm20bC*)
Supplements:    modalias(of:N*T*Cnvidia,gp10b)
Supplements:    modalias(of:N*T*Cnvidia,gp10bC*)
Supplements:    modalias(of:N*T*Cnvidia,tegra114-dc)
Supplements:    modalias(of:N*T*Cnvidia,tegra114-dcC*)
Supplements:    modalias(of:N*T*Cnvidia,tegra114-dsi)
Supplements:    modalias(of:N*T*Cnvidia,tegra114-dsiC*)
Supplements:    modalias(of:N*T*Cnvidia,tegra114-gr3d)
Supplements:    modalias(of:N*T*Cnvidia,tegra114-gr3dC*)
Supplements:    modalias(of:N*T*Cnvidia,tegra114-hdmi)
Supplements:    modalias(of:N*T*Cnvidia,tegra114-hdmiC*)
Supplements:    modalias(of:N*T*Cnvidia,tegra124-dc)
Supplements:    modalias(of:N*T*Cnvidia,tegra124-dcC*)
Supplements:    modalias(of:N*T*Cnvidia,tegra124-dpaux)
Supplements:    modalias(of:N*T*Cnvidia,tegra124-dpauxC*)
Supplements:    modalias(of:N*T*Cnvidia,tegra124-dsi)
Supplements:    modalias(of:N*T*Cnvidia,tegra124-dsiC*)
Supplements:    modalias(of:N*T*Cnvidia,tegra124-hdmi)
Supplements:    modalias(of:N*T*Cnvidia,tegra124-hdmiC*)
Supplements:    modalias(of:N*T*Cnvidia,tegra124-sor)
Supplements:    modalias(of:N*T*Cnvidia,tegra124-sorC*)
Supplements:    modalias(of:N*T*Cnvidia,tegra124-vic)
Supplements:    modalias(of:N*T*Cnvidia,tegra124-vicC*)
Supplements:    modalias(of:N*T*Cnvidia,tegra124-xusb)
Supplements:    modalias(of:N*T*Cnvidia,tegra124-xusbC*)
Supplements:    modalias(of:N*T*Cnvidia,tegra132-dsi)
Supplements:    modalias(of:N*T*Cnvidia,tegra132-dsiC*)
Supplements:    modalias(of:N*T*Cnvidia,tegra132-sor)
Supplements:    modalias(of:N*T*Cnvidia,tegra132-sorC*)
Supplements:    modalias(of:N*T*Cnvidia,tegra186-dc)
Supplements:    modalias(of:N*T*Cnvidia,tegra186-dcC*)
Supplements:    modalias(of:N*T*Cnvidia,tegra186-display)
Supplements:    modalias(of:N*T*Cnvidia,tegra186-displayC*)
Supplements:    modalias(of:N*T*Cnvidia,tegra186-dpaux)
Supplements:    modalias(of:N*T*Cnvidia,tegra186-dpauxC*)
Supplements:    modalias(of:N*T*Cnvidia,tegra186-sor)
Supplements:    modalias(of:N*T*Cnvidia,tegra186-sor1)
Supplements:    modalias(of:N*T*Cnvidia,tegra186-sor1C*)
Supplements:    modalias(of:N*T*Cnvidia,tegra186-sorC*)
Supplements:    modalias(of:N*T*Cnvidia,tegra186-vic)
Supplements:    modalias(of:N*T*Cnvidia,tegra186-vicC*)
Supplements:    modalias(of:N*T*Cnvidia,tegra186-xusb)
Supplements:    modalias(of:N*T*Cnvidia,tegra186-xusbC*)
Supplements:    modalias(of:N*T*Cnvidia,tegra194-dc)
Supplements:    modalias(of:N*T*Cnvidia,tegra194-dcC*)
Supplements:    modalias(of:N*T*Cnvidia,tegra194-display)
Supplements:    modalias(of:N*T*Cnvidia,tegra194-displayC*)
Supplements:    modalias(of:N*T*Cnvidia,tegra194-dpaux)
Supplements:    modalias(of:N*T*Cnvidia,tegra194-dpauxC*)
Supplements:    modalias(of:N*T*Cnvidia,tegra194-sor)
Supplements:    modalias(of:N*T*Cnvidia,tegra194-sorC*)
Supplements:    modalias(of:N*T*Cnvidia,tegra194-vic)
Supplements:    modalias(of:N*T*Cnvidia,tegra194-vicC*)
Supplements:    modalias(of:N*T*Cnvidia,tegra194-xusb)
Supplements:    modalias(of:N*T*Cnvidia,tegra194-xusbC*)
Supplements:    modalias(of:N*T*Cnvidia,tegra20-dc)
Supplements:    modalias(of:N*T*Cnvidia,tegra20-dcC*)
Supplements:    modalias(of:N*T*Cnvidia,tegra20-gr2d)
Supplements:    modalias(of:N*T*Cnvidia,tegra20-gr2dC*)
Supplements:    modalias(of:N*T*Cnvidia,tegra20-gr3d)
Supplements:    modalias(of:N*T*Cnvidia,tegra20-gr3dC*)
Supplements:    modalias(of:N*T*Cnvidia,tegra20-hdmi)
Supplements:    modalias(of:N*T*Cnvidia,tegra20-hdmiC*)
Supplements:    modalias(of:N*T*Cnvidia,tegra210-dc)
Supplements:    modalias(of:N*T*Cnvidia,tegra210-dcC*)
Supplements:    modalias(of:N*T*Cnvidia,tegra210-dpaux)
Supplements:    modalias(of:N*T*Cnvidia,tegra210-dpauxC*)
Supplements:    modalias(of:N*T*Cnvidia,tegra210-dsi)
Supplements:    modalias(of:N*T*Cnvidia,tegra210-dsiC*)
Supplements:    modalias(of:N*T*Cnvidia,tegra210-sor)
Supplements:    modalias(of:N*T*Cnvidia,tegra210-sor1)
Supplements:    modalias(of:N*T*Cnvidia,tegra210-sor1C*)
Supplements:    modalias(of:N*T*Cnvidia,tegra210-sorC*)
Supplements:    modalias(of:N*T*Cnvidia,tegra210-vic)
Supplements:    modalias(of:N*T*Cnvidia,tegra210-vicC*)
Supplements:    modalias(of:N*T*Cnvidia,tegra210-xusb)
Supplements:    modalias(of:N*T*Cnvidia,tegra210-xusbC*)
Supplements:    modalias(of:N*T*Cnvidia,tegra30-dc)
Supplements:    modalias(of:N*T*Cnvidia,tegra30-dcC*)
Supplements:    modalias(of:N*T*Cnvidia,tegra30-gr2d)
Supplements:    modalias(of:N*T*Cnvidia,tegra30-gr2dC*)
Supplements:    modalias(of:N*T*Cnvidia,tegra30-gr3d)
Supplements:    modalias(of:N*T*Cnvidia,tegra30-gr3dC*)
Supplements:    modalias(of:N*T*Cnvidia,tegra30-hdmi)
Supplements:    modalias(of:N*T*Cnvidia,tegra30-hdmiC*)
Supplements:    modalias(pci:v000010DEd*sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v000012D2d*sv*sd*bc03sc*i*)

%description nvidia
This package contains compressed kernel firmware files for
Nvidia Tegra and graphics drivers.

%package platform
Summary:        Kernel firmware files for various platform drivers
Group:          System/Kernel
Requires(post): /usr/bin/mkdir /usr/bin/touch
Requires(postun): /usr/bin/mkdir /usr/bin/touch
Requires(post): dracut >= 049
Conflicts:      kernel < 5.3
Supplements:    modalias(acpi*:AMDI0C00:*)
Supplements:    modalias(eisa:sABP7401*)
Supplements:    modalias(eisa:sABP7501*)
Supplements:    modalias(of:N*T*Camd,ccp-seattle-v1a)
Supplements:    modalias(of:N*T*Camd,ccp-seattle-v1aC*)
Supplements:    modalias(of:N*T*Cfsl,imx25-sdma)
Supplements:    modalias(of:N*T*Cfsl,imx25-sdmaC*)
Supplements:    modalias(of:N*T*Cfsl,imx31-sdma)
Supplements:    modalias(of:N*T*Cfsl,imx31-sdmaC*)
Supplements:    modalias(of:N*T*Cfsl,imx35-sdma)
Supplements:    modalias(of:N*T*Cfsl,imx35-sdmaC*)
Supplements:    modalias(of:N*T*Cfsl,imx51-sdma)
Supplements:    modalias(of:N*T*Cfsl,imx51-sdmaC*)
Supplements:    modalias(of:N*T*Cfsl,imx53-sdma)
Supplements:    modalias(of:N*T*Cfsl,imx53-sdmaC*)
Supplements:    modalias(of:N*T*Cfsl,imx6q-sdma)
Supplements:    modalias(of:N*T*Cfsl,imx6q-sdmaC*)
Supplements:    modalias(of:N*T*Cfsl,imx7d-sdma)
Supplements:    modalias(of:N*T*Cfsl,imx7d-sdmaC*)
Supplements:    modalias(of:N*T*Cfsl,imx8mq-sdma)
Supplements:    modalias(of:N*T*Cfsl,imx8mq-sdmaC*)
Supplements:    modalias(of:N*T*Cqcom,mdp4)
Supplements:    modalias(of:N*T*Cqcom,mdp4C*)
Supplements:    modalias(of:N*T*Cqcom,mdp5)
Supplements:    modalias(of:N*T*Cqcom,mdp5C*)
Supplements:    modalias(of:N*T*Cqcom,mdss)
Supplements:    modalias(of:N*T*Cqcom,mdssC*)
Supplements:    modalias(of:N*T*Cqcom,mdss_mdp)
Supplements:    modalias(of:N*T*Cqcom,mdss_mdpC*)
Supplements:    modalias(of:N*T*Cqcom,msm8916-mss-pil)
Supplements:    modalias(of:N*T*Cqcom,msm8916-mss-pilC*)
Supplements:    modalias(of:N*T*Cqcom,msm8974-adsp-pil)
Supplements:    modalias(of:N*T*Cqcom,msm8974-adsp-pilC*)
Supplements:    modalias(of:N*T*Cqcom,msm8974-mss-pil)
Supplements:    modalias(of:N*T*Cqcom,msm8974-mss-pilC*)
Supplements:    modalias(of:N*T*Cqcom,msm8996-adsp-pil)
Supplements:    modalias(of:N*T*Cqcom,msm8996-adsp-pilC*)
Supplements:    modalias(of:N*T*Cqcom,msm8996-mss-pil)
Supplements:    modalias(of:N*T*Cqcom,msm8996-mss-pilC*)
Supplements:    modalias(of:N*T*Cqcom,msm8996-slpi-pil)
Supplements:    modalias(of:N*T*Cqcom,msm8996-slpi-pilC*)
Supplements:    modalias(of:N*T*Cqcom,msm8998-adsp-pas)
Supplements:    modalias(of:N*T*Cqcom,msm8998-adsp-pasC*)
Supplements:    modalias(of:N*T*Cqcom,msm8998-mss-pil)
Supplements:    modalias(of:N*T*Cqcom,msm8998-mss-pilC*)
Supplements:    modalias(of:N*T*Cqcom,msm8998-slpi-pas)
Supplements:    modalias(of:N*T*Cqcom,msm8998-slpi-pasC*)
Supplements:    modalias(of:N*T*Cqcom,q6v5-pil)
Supplements:    modalias(of:N*T*Cqcom,q6v5-pilC*)
Supplements:    modalias(of:N*T*Cqcom,qcs404-adsp-pas)
Supplements:    modalias(of:N*T*Cqcom,qcs404-adsp-pasC*)
Supplements:    modalias(of:N*T*Cqcom,qcs404-cdsp-pas)
Supplements:    modalias(of:N*T*Cqcom,qcs404-cdsp-pasC*)
Supplements:    modalias(of:N*T*Cqcom,qcs404-wcss-pas)
Supplements:    modalias(of:N*T*Cqcom,qcs404-wcss-pasC*)
Supplements:    modalias(of:N*T*Cqcom,sc7180-dpu)
Supplements:    modalias(of:N*T*Cqcom,sc7180-dpuC*)
Supplements:    modalias(of:N*T*Cqcom,sc7180-mdss)
Supplements:    modalias(of:N*T*Cqcom,sc7180-mdssC*)
Supplements:    modalias(of:N*T*Cqcom,sc7180-mpss-pas)
Supplements:    modalias(of:N*T*Cqcom,sc7180-mpss-pasC*)
Supplements:    modalias(of:N*T*Cqcom,sc7180-mss-pil)
Supplements:    modalias(of:N*T*Cqcom,sc7180-mss-pilC*)
Supplements:    modalias(of:N*T*Cqcom,sdm845-adsp-pas)
Supplements:    modalias(of:N*T*Cqcom,sdm845-adsp-pasC*)
Supplements:    modalias(of:N*T*Cqcom,sdm845-cdsp-pas)
Supplements:    modalias(of:N*T*Cqcom,sdm845-cdsp-pasC*)
Supplements:    modalias(of:N*T*Cqcom,sdm845-dpu)
Supplements:    modalias(of:N*T*Cqcom,sdm845-dpuC*)
Supplements:    modalias(of:N*T*Cqcom,sdm845-mdss)
Supplements:    modalias(of:N*T*Cqcom,sdm845-mdssC*)
Supplements:    modalias(of:N*T*Cqcom,sdm845-mss-pil)
Supplements:    modalias(of:N*T*Cqcom,sdm845-mss-pilC*)
Supplements:    modalias(of:N*T*Cqcom,sm8150-adsp-pas)
Supplements:    modalias(of:N*T*Cqcom,sm8150-adsp-pasC*)
Supplements:    modalias(of:N*T*Cqcom,sm8150-cdsp-pas)
Supplements:    modalias(of:N*T*Cqcom,sm8150-cdsp-pasC*)
Supplements:    modalias(of:N*T*Cqcom,sm8150-mpss-pas)
Supplements:    modalias(of:N*T*Cqcom,sm8150-mpss-pasC*)
Supplements:    modalias(of:N*T*Cqcom,sm8150-slpi-pas)
Supplements:    modalias(of:N*T*Cqcom,sm8150-slpi-pasC*)
Supplements:    modalias(of:N*T*Cqcom,sm8250-adsp-pas)
Supplements:    modalias(of:N*T*Cqcom,sm8250-adsp-pasC*)
Supplements:    modalias(of:N*T*Cqcom,sm8250-cdsp-pas)
Supplements:    modalias(of:N*T*Cqcom,sm8250-cdsp-pasC*)
Supplements:    modalias(of:N*T*Cqcom,sm8250-slpi-pas)
Supplements:    modalias(of:N*T*Cqcom,sm8250-slpi-pasC*)
Supplements:    modalias(pci:v0000100Bd00000035sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001022d00001456sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001022d00001468sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001022d00001486sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001022d00001537sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001022d000015DFsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v0000108Ed0000ABBAsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000010CDd00001100sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000010CDd00001200sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000010CDd00001300sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000010CDd00002300sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000010CDd00002500sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000010CDd00002700sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000010EEd00009038sv000016AEsd0000C522bc*sc*i*)
Supplements:    modalias(pci:v0000177Dd00000012sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001A03d00002000sv*sd*bc03sc*i*)
Supplements:    modalias(pci:v00001A03d00002010sv*sd*bc03sc*i*)
Supplements:    modalias(pcmcia:m0013c0000f*fn*pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0032c0A05f*fn*pfn01pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0032c0B05f*fn*pfn01pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0032c0E01f*fn*pfn01pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0032c1101f*fn*pfn01pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0057c0021f*fn*pfn00pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0057c0021f*fn*pfn01pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0057c1004f*fn*pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0089c0301f*fn*pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0089c110Af*fn*pfn01pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m00A4c0276f*fn*pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0101c0035f*fn01pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0101c0039f*fn*pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0101c003Df*fn01pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0101c0556f*fn01pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0101c0562f*fn01pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0104c0006f*fn*pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0104c000Af*fn*pfn00pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0104c000Af*fn*pfn01pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0104c000Df*fn*pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0104c0070f*fn00pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0104c0070f*fn01pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0104c0075f*fn*pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0104c0145f*fn*pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0105c0101f*fn*pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0105c0D0Af*fn*pfn01pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0105c0E0Af*fn*pfn01pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0105c100Af*fn*pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0105c3E0Af*fn*pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0105c410Af*fn*pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0105cEA15f*fn*pfn00pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0105cEA15f*fn*pfn01pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0107c0002f*fn*pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0109c0501f*fn*pfn00pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0109c0501f*fn*pfn01pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m010Bc0D50f*fn*pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m010Bc0D51f*fn*pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m010Bc0D52f*fn*pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m010Bc0D53f*fn*pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m010BcD180f*fn*pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0115c3330f*fn*pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0124c0100f*fn*pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0134c5600f*fn*pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0137c000Ef*fn*pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0137c001Bf*fn*pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0137c0025f*fn*pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0137c0045f*fn*pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0137c0052f*fn*pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0138c110Af*fn*pfn01pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m013FcA555f*fn*pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0140c000Af*fn*pfn00pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0140c000Af*fn*pfn01pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0143c3341f*fn*pfn00pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0143c3341f*fn*pfn01pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0143cC0ABf*fn*pfn00pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0143cC0ABf*fn*pfn01pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0149c0230f*fn*pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0149c4530f*fn*pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0149cC1ABf*fn*pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m016Cc0006f*fn*pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m016Cc0020f*fn00pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m016Cc0020f*fn01pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m016Cc0023f*fn*pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m016Cc0081f*fn*pfn01pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0175c0000f*fn00pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0175c0000f*fn01pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0186c0110f*fn*pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0192cA555f*fn*pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m01BFc8041f*fn*pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0200c0001f*fn*pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0213c2452f*fn*pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m021Bc0101f*fn*pfn00pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m021Bc0101f*fn*pfn01pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m026Fc0300f*fn*pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m026Fc0307f*fn*pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m026Fc030Af*fn*pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0274c1103f*fn*pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0274c1121f*fn*pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m0279c950Bf*fn*pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m08A1cC0ABf*fn*pfn00pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m08A1cC0ABf*fn*pfn01pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:mC001c0009f*fn*pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m*c*f02fn*pfn*pa*pb*pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn00pfn*pa11C2DA09pb7289DC5DpcAAD95E1Fpd*)
Supplements:    modalias(pcmcia:m*c*f*fn00pfn*pa3BEB8CF2pb16DC1BA7pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn00pfn*pa3BEB8CF2pb19816C41pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn00pfn*pa3BEB8CF2pb1CCE7AC4pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn00pfn*pa3BEB8CF2pb64112029pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn00pfn*pa3BEB8CF2pbDB9E58BCpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn00pfn*pa8FDF8F89pbDD5ED9E8pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn00pfn*paB569A6E5pb4BDF15C3pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn00pfn*paB569A6E5pb5BD4FF2Cpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn00pfn*paB569A6E5pbAE911C15pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn00pfn*pa*pb1ED59302pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn00pfn*pa*pb*pc*pd58FC6056*)
Supplements:    modalias(pcmcia:m*c*f*fn01pfn*pa11C2DA09pb7289DC5DpcAAD95E1Fpd*)
Supplements:    modalias(pcmcia:m*c*f*fn01pfn*pa3BEB8CF2pb16DC1BA7pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn01pfn*pa3BEB8CF2pb19816C41pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn01pfn*pa3BEB8CF2pb1CCE7AC4pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn01pfn*pa3BEB8CF2pb64112029pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn01pfn*pa8FDF8F89pbDD5ED9E8pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn01pfn*paB569A6E5pb4BDF15C3pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn01pfn*paB569A6E5pb5BD4FF2Cpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn01pfn*paB569A6E5pbAE911C15pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn01pfn*paF03E4E77pb*pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn01pfn*pa*pb1ED59302pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn01pfn*pa*pb*pc*pd58FC6056*)
Supplements:    modalias(pcmcia:m*c*f*fn02pfn*pa3BEB8CF2pb1CCE7AC4pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn03pfn*pa3BEB8CF2pb1CCE7AC4pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn00pa0733CC81pbB3765033pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn00pa0C2F80CDpb656947B9pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn00pa0C2F80CDpbDC9BA5EDpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn00pa1A424A1CpbB23897FFpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn00pa281F1C5Dpb570F348Epc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn00pa281F1C5Dpb6FDCACEEpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn00pa2A151FACpb48B932AEpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn00pa578BA6E7pbB0AC62C4pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn00paB2CED065pb3CED0555pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn00paB4585A1Apb53F922F8pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn00paBA9EB7E2pb077C174Epc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn00paDCFE12D3pbC67C648Fpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn00paDCFE12D3pbCD8906CCpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn00paDD9989BEpb662C394Cpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn00paF510DB04pb0143B773pc46A52D63pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn00paF510DB04pb04CD2988pc46A52D63pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn00paF510DB04pb52D21E1EpcBD6C43EFpd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn00paF510DB04pb52D21E1Epc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn00paF510DB04pb856D66C8pcBD6C43EFpd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn00paF5F025C2pb338E8155pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn00paF5F025C2pb4AE85D35pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn00paF7CB0B07pb66881874pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn00paF7CB0B07pb7A821B58pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn01pa0733CC81pbB3765033pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn01pa0C2F80CDpb656947B9pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn01pa0C2F80CDpbDC9BA5EDpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn01pa18DF0BA0pb831B1064pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn01pa1A424A1CpbB23897FFpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn01pa1EAE9475pbD9A93BEDpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn01pa281F1C5Dpb570F348Epc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn01pa281F1C5Dpb6FDCACEEpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn01pa2A151FACpb48B932AEpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn01pa2E3EE845pbECA401BFpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn01pa2E3EE845pb*pc0EA978EApd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn01pa2E3EE845pb*pc76DF1D29pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn01pa2E3EE845pb*pc80609023pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn01pa2E3EE845pb*pcA650C32Apd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn01pa2E3EE845pb*pcF1403719pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn01pa578BA6E7pbB0AC62C4pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn01paB2CED065pb3CED0555pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn01paB4585A1Apb53F922F8pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn01paBA9EB7E2pb077C174Epc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn01paDCFE12D3pbC67C648Fpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn01paDCFE12D3pbCD8906CCpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn01paDD9989BEpb662C394Cpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn01paF510DB04pb0143B773pc46A52D63pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn01paF510DB04pb04CD2988pc46A52D63pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn01paF510DB04pb52D21E1EpcBD6C43EFpd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn01paF510DB04pb52D21E1Epc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn01paF510DB04pb856D66C8pcBD6C43EFpd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn01paF5F025C2pb338E8155pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn01paF5F025C2pb4AE85D35pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn01paF7CB0B07pb66881874pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn01paF7CB0B07pb7A821B58pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa00B2E941pb43AC239Bpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa00B2E941pb4B0D829Epc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa01C43AE1pb00B2E941pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa06A8514Fpb*pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa0733CC81pb32EE8C78pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa0733CC81pb3A3B28E9pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa0733CC81pb453C3F9Dpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa0733CC81pb66C5A389pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa0733CC81pb7A3E5C3Apc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa09928730pb00B2E941pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa0A21501Apb6589340Apc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa0A21501ApbA51564A2pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa0C2F80CDpb194B650Apc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa0C2F80CDpbB3466314pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa0C629325pbB4E7DBAFpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa0E2CDD5EpbC9314B38pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa110D26D9pb9FD2F0A2pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa1128E633pbCE2A89B3pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa18DF0BA0pbBC912D76pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa19CA78AFpb69FB7490pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa19CA78AFpb71D98E83pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa19CA78AFpbB6BC0235pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa19CA78AFpbF964F42Bpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa1A424A1Cpb0F0073F9pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa1A424A1Cpb50DCD0ECpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa1A424A1CpbD9A1D05Bpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa1A424A1CpbF28C8398pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa1B7827B2pb79FBA4F7pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa1B7827B2pb931AFAABpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa1B7827B2pbCDA71D1Cpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa1B7827B2pbFEC71E40pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa1D55D7ECpbE4C64D34pc3FF7175Bpd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa1EAE9475pb0ED386FApc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa20841B68pbAF8A3578pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa21CAB552pbF6F90722pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa23C78A9Dpb00B2E941pcCEF397FBpd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa281F1C5Dpb00B2E941pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa281F1C5Dpb3FF7175Bpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa281F1C5Dpb42D5D7E1pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa281F1C5Dpb45F1F3B4pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa281F1C5Dpb4D8817C8pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa281F1C5Dpb4DE2F6C8pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa281F1C5Dpb5E9D92C0pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa281F1C5Dpb6E41773Bpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa281F1C5Dpb929C486Cpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa281F1C5DpbBF17199Bpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa281F1C5DpbD4CD2F20pc7D3D83A8pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa281F1C5DpbD4CD2F20pcB87ADD82pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa281F1C5DpbDCEA68BCpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa281F1C5DpbE707F641pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa281F1C5DpbEC5DBCA7pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa281F1C5DpbFE871EEBpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa2A151FACpbC1B7E327pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa2A151FACpbF00555CBpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa2AD62F3Cpb9FD2F0A2pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa2D8CE292pb*pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa2E3EE845pb*pc22A49F89pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa2E6DA59Bpb0478E472pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa313ADBC8pb08D9F190pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa313C7BE3pb0AFB54A2pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa32607776pbD9E73B13pc0E87332Epd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa33234748pb3C95B953pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa34F3F1C8pb10B59F8Cpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa352FFF7Fpb00B2E941pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa36634A66pb62241D96pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa36634A66pbC6D05997pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa36E1191Fpb60C229B9pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa36E1191FpbA6617EC8pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa3A7ADE0Fpb41C64504pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa3BD2D898pb92ABC92Fpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa3BEB8CF2pb171E7190pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa3BEB8CF2pb18430676pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa3BEB8CF2pb20DA4262pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa3BEB8CF2pb6A709903pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa3BEB8CF2pb6F933767pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa3BEB8CF2pbD77255FApc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa3BEB8CF2pbEA5DD57Dpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa3D294BE4pbEB9AAB6Cpc3FF7175Bpd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa44445376pb8DED41D4pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa44EBF863pb93AE4D79pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa466B05F0pb33C8DB2Apc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa466B05F0pb8B74BC4Fpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa481E0094pb41A6916Cpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa481E0094pbA2EB0CF3pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa4B91CEC7pbE70220D6pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa4EF00B21pb844BE9E9pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa506BCCAEpbCB3685F1pc*pdBD6C43EF*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa5070A7F9pb82F96E96pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa5070A7F9pb86741224pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa5261440Fpb47D5CA83pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa5261440Fpb485E85D9pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa5261440Fpb6705FCAApc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa5261440Fpb73EC0D88pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa5261440Fpb8797663Bpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa5261440FpbC49BD73Dpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa5261440FpbFA9D85BDpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa53C864C6pb929C486Cpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa53C864C6pbEDD059F6pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa547E66DCpb6B260753pc3FF7175Bpd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa547E66DCpb6FC5459Bpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa552AB682pbEEB1BA6Apc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa55632FD5pbDC65F2B1pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa56C538D2pb11B0FFC0pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa578BA6E7pb0A9888C1pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa578BA6E7pb939FEDBDpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa58D93FC4pb244734E9pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa5CD66D9Dpb84697CE0pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa5F73BE51pb0B3E2383pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa5F73BE51pb4CD7C09Epc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa60CB09A6pb60CB09A6pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa63F2E0BDpbB9E175D3pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa63F2E0BDpbFCE33442pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa648D55C1pbBDE526C7pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa668388B3pb3F9BDF2Fpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa6701DA11pb6701DA11pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa67459937pb*pc916D02BApd8FBE92AE*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa67F236ABpb*pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa69616CB3pbE600E76Epc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa697403D8pbA6D3B233pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa697403D8pbE160B995pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa6A26D1CFpbC16CE9C5pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa6A26D1CFpbC4F84EFBpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa6A26D1CFpbDC65F2B1pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa6EE5A3D8pb30EAD12BpcB00F05A0pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa725B842Dpb2DB1F8E9pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa725B842DpbF1EFEE84pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa738A0019pb281F1C5Dpc5E9D92C0pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa7500E246pb00B2E941pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa75B8AD5Apb*pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa76942813pb8B96CE65pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa76E171BDpb6EB1C947pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa77008979pb9D8D445Dpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa77008979pbFD184814pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa78D64BC0pbCA0CA4B8pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa78F308DCpbDCEA68BCpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa7BCB459ApbA5C81FA5pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa7DD33481pb10B41826pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa816CC815pb412729FBpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa820A67B6pb31ED1A5Fpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa842047EEpbC2EFCF03pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa8787BEC7pb*pcF6E4A31Epd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa8850B4DEpb*pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa88FCDEDApb0E714BEEpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa88FCDEDApb6D772737pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa88FCDEDApb81090922pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa88FCDEDApbC1E2521Cpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa8DD86181pbF2B52517pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa932B7189pb699E4436pc6F6652E0pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa932B7189pb*pc5E9D92C0pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa93693494pb93693494pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa93B15570pb461C5247pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa93B15570pb75EC3EFBpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa93B15570pb82F96E96pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa94FAF360pb*pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa9533672Epb281F1C5Dpc3FF7175Bpd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa96767301pb71FBBC61pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa96913A85pb27AB5437pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa96913A85pb8FBE92AEpc0877B627pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa96913A85pbCEC8F102pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa9791A90Epb9FD2F0A2pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa9999AB35pb00B2E941pc4B0D829Epd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa99BCAFE9pbAA25BCABpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa9AA79DC3pb60E5BC0Epc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa9D7CD6F5pb5CB8BF41pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa9FE55D3Dpb85601198pc3FF7175Bpd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paA2CD8E6Dpb42DA662Apc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paA3A3062Cpb5A00CE95pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paA3A3062Cpb8CBD7C76pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paA89B87D3pb1EB88E64pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paAD180345pb9D58D392pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paAEDAEC74pbAD050EF1pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paAF8144C9pb868F6616pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paB18DC3B4pbCC51A956pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paB38BCC2Epb4DE88352pcEACA6C8Dpd7E57C22E*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paB4585A1Apb7271409Cpc*pdBD6C43EF*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paB496E65EpbF31602A6pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paB4BE14E3pb43AC239Bpc0877B627pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paB4BE14E3pb4B0D829Epc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paB569A6E5pbFEE5297Bpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paB572D360pbD2385B7Apc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paBB7FBDD7pb28E299F8pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paBB7FBDD7pbCD91CC68pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paBBEFB52FpbD2897A97pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paBC477DDEpbFBA775A7pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paBDC3B102pb929C486Cpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paC4420B35pb031A380Dpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paC4420B35pb92ABC92Fpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paC4F8B18Bpb4A0EEB2Dpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paC4F8B18BpbFB21D265pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paC53AC515pb81E39388pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paC70A4760pb2ADE483Epc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paC70A4760pb5DD978A8pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paCDD0644Apb00B2E941pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paCF434FBApb00B2E941pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paD0B78F51pb7E2D49EDpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paD4FDCBD8pbC49BD73Dpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paD830297FpbD265C307pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paD85F6206pb42A2C018pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paD85F6206pb698F93DBpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paD85F6206pb761B11E0pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paDC6F88FDpb4A7E2AE0pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paDC6F88FDpb4BCBD7FDpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paDCFE12D3pbCD8906CCpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paDFC6B5B2pb5542BFFFpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paDFC6B5B2pbCB112A11pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paE3736C88pb00B2E941pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paE3E66E22pbB96150DFpc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paE59365C8pb6A2161D1pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paE625F451pbCECD6DFApc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paEBF91155pb30074C80pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paEBF91155pb7F5A4F50pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paEE138382pbD4CE9B02pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paEE5AF0ADpb7C2ADD04pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paF510DB04pb*pcBB2CCE4Apd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paF510DB04pb*pc*pdBD6C43EF*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paF5F025C2pb3A30E110pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paF7CB0B07pb6701DA11pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paF866B0B0pb6F6652E0pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paF866B0B0pb*pcF6E4A31Epd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paF8A097E3pb97880447pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paFA2E424Dpb3953D9B9pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*paFA2E424DpbE9190D8Apc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa*pbA996D078pc*pd*)
Supplements:    modalias(pcmcia:m*c*f*fn*pfn*pa*pbAD20B156pc*pd*)
Supplements:    modalias(platform:imx25-sdma)
Supplements:    modalias(platform:imx31-sdma)
Supplements:    modalias(platform:imx35-sdma)
Supplements:    modalias(platform:imx51-sdma)
Supplements:    modalias(platform:imx53-sdma)
Supplements:    modalias(platform:imx6q-sdma)
Supplements:    modalias(platform:imx7d-sdma)
Supplements:    modalias(platform:imx8mq-sdma)
Supplements:    modalias(usb:v093BpA002d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v093BpA004d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CF2p6250d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0EB1p6666d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0EB1p6668d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D8p0001d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D8p0002d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D8p0010d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D8p0011d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D8p0020d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D8p0021d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D8p0022d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1943p2255d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1943p2257d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1943pA250d*dc*dsc*dp*ic*isc*ip*in*)

%description platform
This package contains compressed kernel firmware files for
various platform drivers.

%package prestera
Summary:        Kernel firmware files for Marvell Prestera ASIC driver
Group:          System/Kernel
Requires(post): /usr/bin/mkdir /usr/bin/touch
Requires(postun): /usr/bin/mkdir /usr/bin/touch
Requires(post): dracut >= 049
Conflicts:      kernel < 5.3

%description prestera
This package contains compressed kernel firmware files for
Marvell Prestera ASIC driver.

%package qlogic
Summary:        Kernel firmware files for QLogic network drivers
Group:          System/Kernel
Requires(post): /usr/bin/mkdir /usr/bin/touch
Requires(postun): /usr/bin/mkdir /usr/bin/touch
Requires(post): dracut >= 049
Conflicts:      kernel < 5.3
Provides:       qlogic-firmware
Obsoletes:      qlogic-firmware
Supplements:    modalias(fs-ipathfs)
Supplements:    modalias(pci:v00001077d00001016sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001077d00001020sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001077d00001080sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001077d00001216sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001077d00001240sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001077d00001280sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001077d00002031sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001077d00002061sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001077d00002071sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001077d00002081sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001077d00002089sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001077d00002100sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001077d00002200sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001077d00002261sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001077d00002271sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001077d00002281sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001077d00002289sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001077d00002300sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001077d00002312sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001077d00002322sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001077d00002422sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001077d00002432sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001077d00002532sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001077d00005422sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001077d00005432sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001077d00006312sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001077d00006322sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001077d00007220sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001077d00007322sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001077d00008001sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001077d00008021sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001077d00008031sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001077d00008044sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001077d00008432sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001077d0000F001sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001657d00000013sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001657d00000014sv*sd*bc02sc00i*)
Supplements:    modalias(pci:v00001657d00000014sv*sd*bc0Csc04i00*)
Supplements:    modalias(pci:v00001657d00000017sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001657d00000021sv*sd*bc0Csc04i00*)
Supplements:    modalias(pci:v00001657d00000022sv*sd*bc02sc00i*)
Supplements:    modalias(pci:v00001657d00000022sv*sd*bc0Csc04i00*)
Supplements:    modalias(pci:v00001657d00000023sv*sd*bc0Csc04i00*)
Supplements:    modalias(pci:v00001FC1d00000010sv*sd*bc*sc*i*)

%description qlogic
This package contains compressed kernel firmware files for
QLogic network drivers.

%package radeon
Summary:        Kernel firmware files for Radeon graphics driver
Group:          System/Kernel
Requires(post): /usr/bin/mkdir /usr/bin/touch
Requires(postun): /usr/bin/mkdir /usr/bin/touch
Requires(post): dracut >= 049
Conflicts:      kernel < 5.3
Supplements:    modalias(pci:v00001002d00001304sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00001305sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00001306sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00001307sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00001309sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000130Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000130Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000130Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000130Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000130Esv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000130Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00001310sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00001311sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00001312sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00001313sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00001315sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00001316sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00001317sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00001318sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000131Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000131Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000131Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000015D8sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000015DDsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00001636sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00003150sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00003151sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00003152sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00003154sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00003155sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00003E50sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00003E54sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004136sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004137sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004144sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004145sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004146sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004147sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004148sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004149sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000414Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000414Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004150sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004151sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004152sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004153sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004154sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004155sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004156sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004237sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004242sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004336sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004337sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004437sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004966sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004967sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004A48sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004A49sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004A4Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004A4Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004A4Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004A4Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004A4Esv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004A4Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004A50sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004A54sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004B48sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004B49sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004B4Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004B4Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004B4Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004C57sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004C58sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004C59sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004C5Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004C64sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004C66sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004C67sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004E44sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004E45sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004E46sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004E47sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004E48sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004E49sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004E4Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004E4Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004E50sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004E51sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004E52sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004E53sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004E54sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00004E56sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005144sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005145sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005146sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005147sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005148sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000514Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000514Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005157sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005158sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005159sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000515Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000515Esv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005460sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005462sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005464sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005548sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005549sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000554Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000554Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000554Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000554Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000554Esv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000554Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005550sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005551sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005552sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005554sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000564Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000564Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000564Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005652sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005653sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005657sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005834sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005835sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005954sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005955sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005960sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005961sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005962sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005964sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005965sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005969sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005974sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005975sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005A41sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005A42sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005A61sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005A62sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005B60sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005B62sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005B63sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005B64sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005B65sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005C61sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005C63sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005D48sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005D49sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005D4Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005D4Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005D4Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005D4Esv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005D4Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005D50sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005D52sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005D57sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005E48sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005E4Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005E4Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005E4Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005E4Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00005E4Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006600sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006601sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006602sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006603sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006604sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006605sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006606sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006607sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006608sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006610sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006611sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006613sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006617sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006620sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006621sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006623sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006631sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006640sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006641sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006646sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006647sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006649sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006650sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006651sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006658sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000665Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000665Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000665Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006660sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006663sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006664sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006665sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006667sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000666Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000066A0sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000066A1sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000066A2sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000066A3sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000066A4sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000066A7sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000066AFsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006700sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006701sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006702sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006703sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006704sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006705sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006706sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006707sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006708sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006709sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006718sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006719sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000671Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000671Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000671Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006720sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006721sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006722sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006723sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006724sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006725sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006726sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006727sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006728sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006729sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006738sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006739sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000673Esv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006740sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006741sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006742sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006743sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006744sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006745sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006746sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006747sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006748sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006749sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000674Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006750sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006751sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006758sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006759sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000675Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000675Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000675Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006760sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006761sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006762sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006763sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006764sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006765sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006766sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006767sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006768sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006770sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006771sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006772sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006778sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006779sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000677Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006780sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006784sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006788sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000678Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006790sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006791sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006792sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006798sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006799sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000679Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000679Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000679Esv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000679Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067A0sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067A1sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067A2sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067A8sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067A9sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067AAsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067B0sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067B1sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067B8sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067B9sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067BAsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067BEsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067C0sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067C1sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067C2sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067C4sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067C7sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067C8sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067C9sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067CAsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067CCsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067CFsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067D0sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067DFsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067E0sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067E1sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067E3sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067E7sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067E8sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067E9sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067EBsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067EFsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000067FFsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006800sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006801sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006802sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006806sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006808sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006809sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006810sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006811sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006816sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006817sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006818sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006819sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006820sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006821sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006822sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006823sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006824sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006825sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006826sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006827sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006828sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006829sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000682Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000682Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000682Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000682Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000682Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006830sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006831sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006835sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006837sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006838sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006839sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000683Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000683Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000683Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006840sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006841sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006842sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006843sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006849sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000684Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006850sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006858sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006859sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006860sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006861sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006862sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006863sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006864sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006867sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006868sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006869sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000686Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000686Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000686Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000686Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000686Esv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000686Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000687Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006880sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006888sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006889sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000688Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000688Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000688Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006898sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006899sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000689Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000689Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000689Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000689Esv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000068A0sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000068A1sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000068A8sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000068A9sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000068B0sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000068B8sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000068B9sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000068BAsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000068BEsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000068BFsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000068C0sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000068C1sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000068C7sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000068C8sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000068C9sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000068D8sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000068D9sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000068DAsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000068DEsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000068E0sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000068E1sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000068E4sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000068E5sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000068E8sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000068E9sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000068F1sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000068F2sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000068F8sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000068F9sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000068FAsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000068FEsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006900sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006901sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006902sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006903sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006907sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006920sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006921sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006928sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006929sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000692Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000692Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006930sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006938sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006939sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000694Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000694Esv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000694Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006980sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006981sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006985sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006986sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006987sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006995sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006997sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000699Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000069A0sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000069A1sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000069A2sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000069A3sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000069AFsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00006FDFsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007100sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007101sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007102sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007103sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007104sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007105sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007106sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007108sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007109sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000710Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000710Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000710Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000710Esv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000710Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007140sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007141sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007142sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007143sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007144sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007145sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007146sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007147sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007149sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000714Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000714Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000714Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000714Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000714Esv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000714Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007151sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007152sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007153sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000715Esv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000715Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007180sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007181sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007183sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007186sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007187sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007188sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000718Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000718Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000718Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000718Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000718Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007193sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007196sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000719Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000719Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000071C0sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000071C1sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000071C2sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000071C3sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000071C4sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000071C5sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000071C6sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000071C7sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000071CDsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000071CEsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000071D2sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000071D4sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000071D5sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000071D6sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000071DAsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000071DEsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007200sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007210sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007211sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007240sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007243sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007244sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007245sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007246sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007247sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007248sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007249sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000724Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000724Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000724Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000724Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000724Esv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000724Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007280sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007281sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007283sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007284sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007287sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007288sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007289sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000728Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000728Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007290sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007291sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007293sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007297sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007300sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000730Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007310sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007312sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007318sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007319sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000731Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000731Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000731Esv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000731Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007340sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007341sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007347sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000734Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007360sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007362sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007388sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000738Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000738Esv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007390sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000073A0sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000073A2sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000073A3sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000073ABsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000073AEsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000073BFsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007834sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007835sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000791Esv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000791Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000793Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007941sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00007942sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000796Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000796Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000796Esv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000796Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009400sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009401sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009402sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009403sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009405sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000940Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000940Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000940Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009440sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009441sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009442sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009443sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009444sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009446sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000944Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000944Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000944Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000944Esv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009450sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009452sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009456sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000945Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000945Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000945Esv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009460sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009462sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000946Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000946Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000947Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000947Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009480sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009487sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009488sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009489sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000948Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000948Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009490sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009491sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009495sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009498sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000949Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000949Esv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000949Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000094A0sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000094A1sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000094A3sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000094B1sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000094B3sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000094B4sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000094B5sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000094B9sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000094C0sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000094C1sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000094C3sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000094C4sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000094C5sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000094C6sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000094C7sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000094C8sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000094C9sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000094CBsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000094CCsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000094CDsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009500sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009501sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009504sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009505sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009506sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009507sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009508sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009509sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000950Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009511sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009515sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009517sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009519sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009540sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009541sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009542sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000954Esv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000954Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009552sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009553sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009555sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009557sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000955Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009580sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009581sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009583sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009586sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009587sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009588sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009589sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000958Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000958Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000958Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000958Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000958Esv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000958Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009590sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009591sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009593sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009595sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009596sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009597sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009598sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009599sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000959Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000095C0sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000095C2sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000095C4sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000095C5sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000095C6sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000095C7sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000095C9sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000095CCsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000095CDsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000095CEsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000095CFsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009610sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009611sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009612sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009613sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009614sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009615sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009616sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009640sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009641sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009642sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009643sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009644sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009645sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009647sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009648sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009649sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000964Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000964Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000964Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000964Esv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000964Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009710sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009711sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009712sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009713sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009714sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009715sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009802sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009803sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009804sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009805sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009806sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009807sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009808sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009809sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000980Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009830sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009831sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009832sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009833sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009834sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009835sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009836sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009837sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009838sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009839sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000983Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000983Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000983Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000983Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000983Esv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000983Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009850sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009851sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009852sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009853sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009854sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009855sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009856sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009857sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009858sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009859sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000985Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000985Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000985Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000985Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000985Esv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000985Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009870sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009874sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009875sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009876sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009877sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000098E4sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009900sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009901sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009903sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009904sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009905sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009906sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009907sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009908sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009909sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000990Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000990Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000990Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000990Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000990Esv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000990Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009910sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009913sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009917sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009918sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009919sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009990sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009991sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009992sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009993sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009994sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009995sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009996sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009997sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009998sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d00009999sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000999Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000999Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000999Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d0000999Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000099A0sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000099A2sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001002d000099A4sv*sd*bc*sc*i*)

%description radeon
This package contains compressed kernel firmware files for
Radeon graphics driver.

%package realtek
Summary:        Kernel firmware files for Realtek wireless drivers
Group:          System/Kernel
Requires(post): /usr/bin/mkdir /usr/bin/touch
Requires(postun): /usr/bin/mkdir /usr/bin/touch
Requires(post): dracut >= 049
Conflicts:      kernel < 5.3
Supplements:    modalias(pci:v00000001d00008168sv*sd00002410bc*sc*i*)
Supplements:    modalias(pci:v000007AAd00000044sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000007AAd00000047sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000010ECd0000002Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000010ECd00002502sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000010ECd00002600sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000010ECd00003000sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000010ECd00008125sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000010ECd00008129sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000010ECd00008136sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000010ECd00008161sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000010ECd00008167sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000010ECd00008168sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000010ECd00008169sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000010ECd00008171sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000010ECd00008172sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000010ECd00008173sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000010ECd00008174sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000010ECd00008176sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000010ECd00008177sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000010ECd00008178sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000010ECd00008179sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000010ECd0000818Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000010ECd00008191sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000010ECd00008192sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000010ECd00008193sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000010ECd00008812sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000010ECd00008821sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000010ECd0000B723sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000010FFd00008168sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001186d00004300sv00001186sd00004B10bc*sc*i*)
Supplements:    modalias(pci:v00001186d00004300sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001186d00004302sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001259d0000C107sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001432d00007708sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001432d00007711sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001432d00007722sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001432d00007727sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001432d00007728sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001432d00007738sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001432d00007748sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001432d00007758sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001432d00007768sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001462d0000891Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000016ECd00000116sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001737d00001032sv*sd00000024bc*sc*i*)
Supplements:    modalias(pci:v00001814d00000601sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001814d00000681sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001814d00000701sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001814d00000781sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001814d00003060sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001814d00003062sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001814d00003090sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001814d00003091sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001814d00003092sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001814d00003290sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001814d00003390sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001814d00003562sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001814d00003592sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001814d00003593sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001814d0000359Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001814d00005360sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001814d00005362sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001814d00005390sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001814d00005392sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001814d0000539Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001814d0000539Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001814d0000539Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001A3Bd00001059sv*sd*bc*sc*i*)
Supplements:    modalias(usb:v0409p02B6d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0411p00E8d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0411p012Ed*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0411p0148d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0411p0150d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0411p0158d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0411p015Dd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0411p016Fd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0411p01A2d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0411p01A8d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0411p01EEd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0411p01FDd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0411p0241d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0411p0253d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v043Ep7A12d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v043Ep7A13d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v043Ep7A22d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v043Ep7A32d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v043Ep7A42d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v045Ep07ABd*dc*dsc*dp*ic02isc06ip00in*)
Supplements:    modalias(usb:v045Ep07ABd*dc*dsc*dp*icFFisc*ip*in*)
Supplements:    modalias(usb:v045Ep07C6d*dc*dsc*dp*ic02isc06ip00in*)
Supplements:    modalias(usb:v045Ep07C6d*dc*dsc*dp*icFFisc*ip*in*)
Supplements:    modalias(usb:v045Ep0927d*dc*dsc*dp*ic02isc06ip00in*)
Supplements:    modalias(usb:v045Ep0927d*dc*dsc*dp*icFFisc*ip*in*)
Supplements:    modalias(usb:v0471p200Fd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0471p20DDd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0471p2104d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0471p2126d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0471p2180d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0471p2181d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0471p2182d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v04BBp0944d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v04BBp0945d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v04BBp0947d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v04BBp0948d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v04BBp094Bd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v04BBp094Cd*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v04BBp094Ed*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v04BBp0950d*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v04DAp1800d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v04DAp1801d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v04DAp23F6d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v04E8p2018d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v04E8pA101d*dc*dsc*dp*ic02isc06ip00in*)
Supplements:    modalias(usb:v04E8pA101d*dc*dsc*dp*icFFisc*ip*in*)
Supplements:    modalias(usb:v04F2pAFF2d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v04F2pAFF5d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v04F2pAFF6d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v04F2pAFF7d*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v04F2pAFF7d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v04F2pAFF8d*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v04F2pAFF8d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v04F2pAFF9d*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v04F2pAFF9d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v04F2pAFFAd*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v04F2pAFFAd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v04F2pAFFBd*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v04F2pAFFBd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v04F2pAFFCd*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v04F2pAFFCd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v050Dp1003d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v050Dp1004d*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v050Dp1004d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v050Dp1102d*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v050Dp1102d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v050Dp1103d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v050Dp11F1d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v050Dp11F2d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v050Dp2102d*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v050Dp2102d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v050Dp2103d*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v050Dp2103d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v050Dp8053d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v050Dp805Cd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v050Dp815Cd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v050Dp815Fd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v050Dp825Ad*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v050Dp825Bd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v050Dp845Ad*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v050Dp935Ad*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v050Dp935Bd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v050Dp945Ad*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v050Dp945Bd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v056Ep4008d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v057Cp8501d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0586p3416d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0586p3418d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0586p341Ad*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0586p341Ed*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0586p341Fd*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v0586p341Fd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0586p3421d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0586p343Ed*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v05A6p0101d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v06F8pE031d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v06F8pE032d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v06F8pE033d*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v06F8pE033d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v06F8pE034d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v06F8pE035d*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v06F8pE036d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0789p0162d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0789p0163d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0789p0164d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0789p0166d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0789p0167d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0789p0168d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0789p0169d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0789p016Bd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0789p016Dd*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v0789p0170d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07AAp002Fd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07AAp003Cd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07AAp003Fd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07AAp0041d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07AAp0042d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07AAp0047d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07AAp0051d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07AAp0056d*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v07AAp0056d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07B8p2770d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07B8p2870d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07B8p3070d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07B8p3071d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07B8p3072d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07B8p3073d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07B8p3074d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07B8p8178d*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v07B8p8178d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07B8p8179d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07B8p8188d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07B8p8189d*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v07B8p8189d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07D1p3300d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07D1p3302d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07D1p3303d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07D1p3306d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07D1p3C09d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07D1p3C0Ad*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07D1p3C0Bd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07D1p3C0Dd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07D1p3C0Ed*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07D1p3C0Fd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07D1p3C11d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07D1p3C13d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07D1p3C15d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07D1p3C16d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07D1p3C17d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07FAp7712d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v083Ap6618d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v083Ap7511d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v083Ap7512d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v083Ap7522d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v083Ap8522d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v083ApA512d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v083ApA618d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v083ApA701d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v083ApA702d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v083ApA703d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v083ApB511d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v083ApB512d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v083ApB522d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v083ApC512d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v083ApC522d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v083ApD522d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v083ApF511d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0846p9012d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0846p9013d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0846p9019d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0846p9021d*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v0846p9021d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0846p9041d*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v0846p9041d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0846p9043d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0846pF001d*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v0846pF001d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v08B9p1197d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0930p0A07d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0955p09FFd*dc*dsc*dp*ic02isc06ip00in*)
Supplements:    modalias(usb:v0955p09FFd*dc*dsc*dp*icFFisc*ip*in*)
Supplements:    modalias(usb:v0B05p166Ad*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0B05p1731d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0B05p1732d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0B05p1742d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0B05p1760d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0B05p1761d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0B05p1784d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0B05p1786d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0B05p1790d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0B05p1791d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0B05p179Dd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0B05p17A7d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0B05p17ABd*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v0B05p17ABd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0B05p17ADd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0B05p17BAd*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v0B05p17BAd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0B05p17BCd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0B05p17E8d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0B05p18F0d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0BDAp0179d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0BDAp018Ad*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v0BDAp018Ad*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0BDAp0724d*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v0BDAp1724d*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v0BDAp1E1Ed*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v0BDAp2E2Ed*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v0BDAp317Fd*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v0BDAp317Fd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0BDAp5077d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0BDAp5088d*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v0BDAp5088d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0BDAp8050d*dc*dsc*dp*ic02isc06ip00in*)
Supplements:    modalias(usb:v0BDAp8050d*dc*dsc*dp*icFFisc*ip*in*)
Supplements:    modalias(usb:v0BDAp8152d*dc*dsc*dp*ic02isc06ip00in*)
Supplements:    modalias(usb:v0BDAp8152d*dc*dsc*dp*icFFisc*ip*in*)
Supplements:    modalias(usb:v0BDAp8153d*dc*dsc*dp*ic02isc06ip00in*)
Supplements:    modalias(usb:v0BDAp8153d*dc*dsc*dp*icFFisc*ip*in*)
Supplements:    modalias(usb:v0BDAp8170d*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v0BDAp8170d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0BDAp8171d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0BDAp8172d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0BDAp8173d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0BDAp8174d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0BDAp8176d*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v0BDAp8176d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0BDAp8177d*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v0BDAp8177d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0BDAp8178d*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v0BDAp8178d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0BDAp8179d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0BDAp817Ad*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v0BDAp817Ad*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0BDAp817Bd*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v0BDAp817Bd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0BDAp817Cd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0BDAp817Dd*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v0BDAp817Dd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0BDAp817Ed*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v0BDAp817Ed*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0BDAp817Fd*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v0BDAp817Fd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0BDAp8186d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0BDAp818Ad*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v0BDAp818Ad*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0BDAp818Bd*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v0BDAp818Cd*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v0BDAp8191d*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v0BDAp8191d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0BDAp8192d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0BDAp819Ad*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0BDAp8712d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0BDAp8713d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0BDAp8724d*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v0BDAp8754d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0BDApB720d*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v0BDApC512d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0BDApFFEFd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CDEp0022d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CDEp0025d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DB0p3820d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DB0p3821d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DB0p3822d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DB0p3870d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DB0p3871d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DB0p6899d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DB0p821Ad*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DB0p822Ad*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DB0p822Bd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DB0p822Cd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DB0p870Ad*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DB0p871Ad*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DB0p871Bd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DB0p871Cd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DB0p899Ad*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p0017d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p002Bd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p002Cd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p002Dd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p0039d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p003Bd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p003Cd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p003Dd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p003Ed*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p003Fd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p0040d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p0041d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p0042d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p0045d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p0047d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p0048d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p0049d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p004Ad*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p004Bd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p004Cd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p004Dd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p0050d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p0051d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p0052d*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v0DF6p0052d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p0053d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p0057d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p0058d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p0059d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p005Bd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p005Cd*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v0DF6p005Cd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p005Dd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p005Fd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p0060d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p0061d*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v0DF6p0061d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p0062d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p0063d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p0064d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p0065d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p0066d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p0067d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p0068d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p0069d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p006Ad*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p006Cd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p006Ed*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p006Fd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p0070d*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v0DF6p0070d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p0076d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p0077d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p0078d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0E0Bp9031d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0E0Bp9041d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0E66p0001d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0E66p0003d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0E66p0009d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0E66p000Bd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0E66p0013d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0E66p0015d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0E66p0016d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0E66p0017d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0E66p0018d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0E66p0019d*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v0E66p0019d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0E66p0020d*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v0E66p0020d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0E66p0021d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0EB0p9061d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0EB0p9071d*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v0EB0p9071d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0FE9pB307d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v100Dp9031d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v100Dp9032d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v103Cp1629d*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v103Cp1629d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1044p800Bd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1044p800Cd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1044p800Dd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1058p0631d*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v129Bp1828d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13B1p002Fd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13B1p0031d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13B1p003Bd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13B1p0041d*dc*dsc*dp*ic02isc06ip00in*)
Supplements:    modalias(usb:v13B1p0041d*dc*dsc*dp*icFFisc*ip*in*)
Supplements:    modalias(usb:v13D3p3247d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D3p3262d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D3p3273d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D3p3284d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D3p3305d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D3p3306d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D3p3307d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D3p3309d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D3p3310d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D3p3311d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D3p3321d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D3p3322d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D3p3323d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D3p3325d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D3p3329d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D3p3333d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D3p3334d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D3p3335d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D3p3336d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D3p3339d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D3p3340d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D3p3341d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D3p3342d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D3p3357d*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v13D3p3357d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D3p3358d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D3p3359d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D3p3365d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D3p3399d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D3p3400d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D3p3401d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1482p3C09d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v148Fp2070d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v148Fp2770d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v148Fp2870d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v148Fp3070d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v148Fp3071d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v148Fp3072d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v148Fp3370d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v148Fp3572d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v148Fp3573d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v148Fp5370d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v148Fp5372d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v148Fp5572d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v148Fp8070d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v148FpF101d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v148FpF301d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v14B2p3300d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v14B2p3301d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v14B2p3302d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v14B2p3C06d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v14B2p3C07d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v14B2p3C08d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v14B2p3C09d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v14B2p3C11d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v14B2p3C12d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v14B2p3C23d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v14B2p3C25d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v14B2p3C27d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v14B2p3C28d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v14B2p3C2Cd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v157Ep300Ed*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v157Ep3013d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v15A9p0006d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v15A9p0010d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v15A9p0012d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v15C5p0008d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v167Bp4001d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1690p0740d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1690p0744d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1690p0752d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1690p0761d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1690p0764d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1737p0070d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1737p0071d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1737p0077d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1737p0078d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1737p0079d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1740p0600d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1740p0602d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1740p0605d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1740p0615d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1740p9603d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1740p9605d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1740p9701d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1740p9702d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1740p9703d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1740p9705d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1740p9706d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1740p9707d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1740p9708d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1740p9709d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1740p9801d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1761p0B05d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v177Fp0153d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v177Fp0154d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v177Fp0163d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v177Fp0164d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v177Fp0165d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v177Fp0254d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v177Fp0302d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v177Fp0313d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v177Fp0323d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v177Fp0324d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v17EFp304Fd*dc*dsc*dp*ic02isc06ip00in*)
Supplements:    modalias(usb:v17EFp304Fd*dc*dsc*dp*icFFisc*ip*in*)
Supplements:    modalias(usb:v17EFp3062d*dc*dsc*dp*ic02isc06ip00in*)
Supplements:    modalias(usb:v17EFp3062d*dc*dsc*dp*icFFisc*ip*in*)
Supplements:    modalias(usb:v17EFp3069d*dc*dsc*dp*ic02isc06ip00in*)
Supplements:    modalias(usb:v17EFp3069d*dc*dsc*dp*icFFisc*ip*in*)
Supplements:    modalias(usb:v17EFp3082d*dc*dsc*dp*ic02isc06ip00in*)
Supplements:    modalias(usb:v17EFp3082d*dc*dsc*dp*icFFisc*ip*in*)
Supplements:    modalias(usb:v17EFp7205d*dc*dsc*dp*ic02isc06ip00in*)
Supplements:    modalias(usb:v17EFp7205d*dc*dsc*dp*icFFisc*ip*in*)
Supplements:    modalias(usb:v17EFp720Cd*dc*dsc*dp*ic02isc06ip00in*)
Supplements:    modalias(usb:v17EFp720Cd*dc*dsc*dp*icFFisc*ip*in*)
Supplements:    modalias(usb:v17EFp7214d*dc*dsc*dp*ic02isc06ip00in*)
Supplements:    modalias(usb:v17EFp7214d*dc*dsc*dp*icFFisc*ip*in*)
Supplements:    modalias(usb:v17EFpA387d*dc*dsc*dp*ic02isc06ip00in*)
Supplements:    modalias(usb:v17EFpA387d*dc*dsc*dp*icFFisc*ip*in*)
Supplements:    modalias(usb:v18C5p0008d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v18C5p0012d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v18E8p6259d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1A32p0304d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1B75p3070d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1B75p3071d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1B75p3072d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1B75p7733d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1B75pA200d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1D4Dp0002d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1D4Dp000Cd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1D4Dp000Ed*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1D4Dp0010d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1D4Dp0011d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1EDAp2012d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1EDAp2210d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1EDAp2310d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2001p3306d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2001p3307d*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v2001p3307d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2001p3308d*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v2001p3308d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2001p3309d*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v2001p3309d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2001p330Ad*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v2001p330Ad*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2001p330Bd*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v2001p330Dd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2001p330Fd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2001p3310d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2001p3311d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2001p3317d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2001p3319d*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v2001p331Bd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2001p3C15d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2001p3C17d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2001p3C19d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2001p3C1Ad*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2001p3C1Bd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2001p3C1Cd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2001p3C1Dd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2001p3C1Ed*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2001p3C1Fd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2001p3C20d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2001p3C21d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2001p3C22d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2001p3C23d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2001p3C25d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2019p1201d*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v2019p1201d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2019p4901d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2019p4902d*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v2019p4902d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2019p5201d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2019pAB24d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2019pAB25d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2019pAB28d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2019pAB29d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2019pAB2Ad*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v2019pAB2Ad*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2019pAB2Bd*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v2019pAB2Bd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2019pAB2Ed*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v2019pAB2Ed*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2019pAB33d*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v2019pED06d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2019pED14d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2019pED16d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2019pED17d*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v2019pED17d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2019pED18d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2019pED19d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v203Dp1480d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v203Dp14A1d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v203Dp14A9d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v20B8p8888d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v20F4p624Dd*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v20F4p624Dd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v20F4p646Bd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v20F4p648Bd*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v20F4p648Bd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v20F4p724Ad*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2357p0100d*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v2357p0100d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2357p0107d*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v2357p0108d*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v2357p0109d*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v2357p010Cd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2357p0111d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2357p0601d*dc*dsc*dp*ic02isc06ip00in*)
Supplements:    modalias(usb:v2357p0601d*dc*dsc*dp*icFFisc*ip*in*)
Supplements:    modalias(usb:v25D4p4CA1d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v25D4p4CABd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2C4Ep0102d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v4855p0090d*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v4855p0090d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v4855p0091d*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v4855p0091d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v4856p0091d*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v4856p0091d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v5A57p0280d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v5A57p0282d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v5A57p0283d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v5A57p0284d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v5A57p5257d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v7392p4085d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v7392p7611d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v7392p7612d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v7392p7622d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v7392p7711d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v7392p7717d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v7392p7718d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v7392p7722d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v7392p7733d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v7392p7811d*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v7392p7811d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v7392p7822d*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v7392p7822d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v7392pA611d*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:v8516p2070d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v8516p2770d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v8516p2870d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v8516p3070d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v8516p3071d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v8516p3072d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v8516p3572d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v9846p9041d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:vCDABp8010d*dc*dsc*dp*icFFiscFFipFFin*)
Supplements:    modalias(usb:vF201p5370d*dc*dsc*dp*ic*isc*ip*in*)

%description realtek
This package contains compressed kernel firmware files for
Realtek wireless drivers.

%package serial
Summary:        Kernel firmware files for various serial drivers
Group:          System/Kernel
Requires(post): /usr/bin/mkdir /usr/bin/touch
Requires(postun): /usr/bin/mkdir /usr/bin/touch
Requires(post): dracut >= 049
Conflicts:      kernel < 5.3
Supplements:    modalias(pci:v000011FEd00000040sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000011FEd00000041sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000011FEd00000042sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000011FEd00000043sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000011FEd00000044sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000011FEd00000045sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000011FEd00000046sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000011FEd00000047sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000011FEd0000004Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000011FEd0000004Bsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000011FEd0000004Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000011FEd0000004Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000011FEd0000004Esv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000011FEd0000004Fsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000011FEd00000050sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000011FEd00000051sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000011FEd00000052sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000011FEd00000060sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000011FEd00000061sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000011FEd00000062sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000011FEd00000063sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000011FEd00000064sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000011FEd00000065sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000011FEd00000066sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000011FEd00000067sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000011FEd00000068sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000011FEd00000072sv*sd*bc*sc*i*)
Supplements:    modalias(usb:v0404p0202d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0404p0203d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0404p0310d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0404p0311d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0404p0312d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0451p3410d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0451p5052d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0451p5053d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0451p505Ad*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0451p505Fd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0451p5152d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0451pF430d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v04B3p4543d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v04B3p454Bd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v04B3p454Cd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v05D9pA225d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v05D9pA758d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v05D9pA794d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v06CDp0101d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v06CDp0102d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v06CDp0103d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v06CDp0104d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v06CDp0105d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v06CDp0106d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v06CDp0107d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v06CDp0108d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v06CDp0109d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v06CDp010Ad*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v06CDp010Bd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v06CDp010Cd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v06CDp010Fd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v06CDp0110d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v06CDp0112d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v06CDp0113d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v06CDp0114d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v06CDp0115d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v06CDp0118d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v06CDp0119d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v06CDp011Ad*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v06CDp011Bd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v06CDp011Cd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v06CDp0121d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v06CDp012Ad*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v06CDp0131d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v06CDp0135d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v06E0p0319d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v06E0pF108d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v06E0pF109d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v06E0pF110d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v06E0pF111d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v06E0pF112d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v06E0pF114d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v06E0pF115d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0710p0001d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0710p8001d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v085Ap8025d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v085Ap8027d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v10ACp0102d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v110Ap1110d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v110Ap1130d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v110Ap1131d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v110Ap1150d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v110Ap1151d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v110Ap1250d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v110Ap1251d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v110Ap1410d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v110Ap1450d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v110Ap1451d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v110Ap1613d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v110Ap1618d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v110Ap1653d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v110Ap1658d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1608p0001d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1608p0002d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1608p0003d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1608p0004d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1608p0005d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1608p0006d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1608p0007d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1608p0008d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1608p000Cd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1608p000Dd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1608p000Ed*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1608p000Fd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1608p0010d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1608p0011d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1608p0012d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1608p0013d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1608p0014d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1608p0018d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1608p0019d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1608p001Ad*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1608p0201d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1608p0205d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1608p0206d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1608p0207d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1608p020Cd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1608p020Dd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1608p0212d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1608p0215d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1608p0217d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1608p021Ad*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1608p021Bd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1608p021Cd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1608p021Dd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1608p021Ed*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1608p0240d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1608p0241d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1608p0242d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1608p0243d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1608p0244d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1608p0247d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1608p0301d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1608p0302d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1608p0303d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1608p0304d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1608p0305d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1608p0306d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1608p0307d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1608p0308d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1608p0309d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1608p030Ad*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1608p030Bd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1608p030Cd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1608p030Ed*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1608p1403d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1645p8093d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1A61p3410d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1A61p3420d*dc*dsc*dp*ic*isc*ip*in*)

%description serial
This package contains compressed kernel firmware files for
various serial drivers.

%package sound
Summary:        Kernel firmware files for various sound drivers
Group:          System/Kernel
Requires(post): /usr/bin/mkdir /usr/bin/touch
Requires(postun): /usr/bin/mkdir /usr/bin/touch
Requires(post): dracut >= 049
Conflicts:      kernel < 5.3
Supplements:    modalias(acpi*:80860F28:*)
Supplements:    modalias(acpi*:808622A8:*)
Supplements:    modalias(acpi*:CSC0000:*)
Supplements:    modalias(acpi*:CSC0004:*)
Supplements:    modalias(acpi*:CSC0010:*)
Supplements:    modalias(acpi*:INT33C8:*)
Supplements:    modalias(acpi*:INT3438:*)
Supplements:    modalias(acpi*:PNPB006:*)
Supplements:    modalias(pci:v00001073d00000004sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001073d0000000Asv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001073d0000000Csv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001073d0000000Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001073d00000010sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00001073d00000012sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v000010B5d0000906Dsv*sd*bc*sc*i*)
Supplements:    modalias(pci:v0000125Dd00001988sv*sd*bc04sc01i*)
Supplements:    modalias(pci:v0000125Dd00001989sv*sd*bc04sc01i*)
Supplements:    modalias(pci:v0000125Dd00001990sv*sd*bc04sc01i*)
Supplements:    modalias(pci:v0000125Dd00001992sv*sd*bc04sc01i*)
Supplements:    modalias(pci:v0000125Dd00001998sv*sd*bc04sc01i*)
Supplements:    modalias(pci:v0000125Dd00001999sv*sd*bc04sc01i*)
Supplements:    modalias(pci:v0000125Dd0000199Asv*sd*bc04sc01i*)
Supplements:    modalias(pci:v0000125Dd0000199Bsv*sd*bc04sc01i*)
Supplements:    modalias(pci:v00008086d000002C8sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d000006C8sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d00003198sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d00005A98sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d00009D70sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d00009D71sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d00009DC8sv*sd*bc*sc*i*)
Supplements:    modalias(pci:v00008086d0000A348sv*sd*bc*sc*i*)
Supplements:    modalias(pnp:dCSC0000*)
Supplements:    modalias(pnp:dCSC0004*)
Supplements:    modalias(pnp:dCSC0010*)
Supplements:    modalias(pnp:dPnPb006*)
Supplements:    modalias(sst)
Supplements:    modalias(usb:v086Ap0100d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v086Ap0102d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v086Ap0110d*dc*dsc*dp*ic*isc*ip*in*)

%description sound
This package contains compressed kernel firmware files for
various sound drivers.

%package ti
Summary:        Kernel firmware files for Texas Instruments wireless drivers
Group:          System/Kernel
Requires(post): /usr/bin/mkdir /usr/bin/touch
Requires(postun): /usr/bin/mkdir /usr/bin/touch
Requires(post): dracut >= 049
Conflicts:      kernel < 5.3
Supplements:    modalias(platform:wl12xx)
Supplements:    modalias(platform:wl18xx)

%description ti
This package contains compressed kernel firmware files for
Texas Instruments wireless drivers.

%package ueagle
Summary:        Kernel firmware files for Eagle IV USB ADSL modem driver
Group:          System/Kernel
Requires(post): /usr/bin/mkdir /usr/bin/touch
Requires(postun): /usr/bin/mkdir /usr/bin/touch
Requires(post): dracut >= 049
Conflicts:      kernel < 5.3
Supplements:    modalias(usb:v05CCp3350d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v05CCp3351d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v05CCp3352d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v05CCp3353d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v05CCp3362d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v05CCp3363d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0BAFp00F1d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0BAFp00F2d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0BAFp00F5d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0BAFp00F6d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0BAFp00F7d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0BAFp00F8d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0BAFp00F9d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0BAFp00FAd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1039p2100d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1039p2101d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1039p2110d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1039p2111d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1039p2120d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1039p2121d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1039p2130d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1039p2131d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1110p9000d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1110p9001d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1110p900Fd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1110p9010d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1110p9021d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1110p9022d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1110p9023d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1110p9024d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1110p9031d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1110p9032d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1110p9041d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1110p9042d*dc*dsc*dp*ic*isc*ip*in*)

%description ueagle
This package contains compressed kernel firmware files for
Eagle IV USB ADSL modem driver.

%package usb-network
Summary:        Kernel firmware files for various USB WiFi / Ethernet drivers
Group:          System/Kernel
Requires(post): /usr/bin/mkdir /usr/bin/touch
Requires(postun): /usr/bin/mkdir /usr/bin/touch
Requires(post): dracut >= 049
Conflicts:      kernel < 5.3
Supplements:    modalias(sdio:c*v041Bd9116*)
Supplements:    modalias(sdio:c*v041Bd9330*)
Supplements:    modalias(usb:v03E8p0008d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0411p00D8d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0411p00D9d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0411p00E6d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0411p00F4d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0411p0116d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0411p0119d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0411p0137d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0471p200Ad*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v04BBp0901d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v04BBp093Dd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v04E8p4471d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0506p03E8d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0506p11F8d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v050Dp7050d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v050Dp705Ad*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v050Dp905Bd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v050Dp905Cd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0557p2002d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0557p4000d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0565p0002d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0565p0003d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0565p0005d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0586p3415d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v05E9p0008d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v05E9p0009d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v066Bp2202d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v06E1p0008d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v06E1p0009d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v06F8pE002d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v06F8pE010d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v06F8pE020d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0707p0100d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0769p31F3d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07AAp0001d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07AAp002Ed*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07B8p4000d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07B8pB21Bd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07B8pB21Cd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07B8pB21Dd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07B8pB21Ed*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07B8pB21Fd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07C9pB010d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07D1p3C03d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07D1p3C04d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07D1p3C06d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v07D1p3C07d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0812p3101d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0846p1001d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0846p1002d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v085Ap0008d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v085Ap0009d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v087Dp5704d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v08DDp0120d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0951p0008d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v095Ap3003d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0B05p1723d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0B05p1724d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0CDEp001Cd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DB0p4600d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DB0p6874d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DB0p6877d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DB0pA861d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DB0pA874d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p0024d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p0027d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p002Fd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p90ACd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0DF6p9712d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v0EB0p9021d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1044p8008d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1044p800Ad*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v10BDp1427d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1342p0204d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1371p9022d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1371p9032d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13B1p0020d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13B1p0023d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13B1p0028d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v13D2p0400d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1472p0009d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1485p0001d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1485p0002d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v148Fp2573d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v148Fp2671d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v148Fp9021d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v14B2p3C10d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v14B2p3C22d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v15A9p0004d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v160Ap3184d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1618p9113d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1618p9116d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1631pC019d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1645p0005d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1645p0008d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1645p8005d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1668p0323d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1690p0722d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1740p3701d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1740p7100d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v178Dp02BEd*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v18C5p0002d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v18E8p6196d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v18E8p6229d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v18E8p6238d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v1B75p7318d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2001p4000d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2019pAB01d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v2019pAB50d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v6933p5001d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v7167p3840d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v7392p7318d*dc*dsc*dp*ic*isc*ip*in*)
Supplements:    modalias(usb:v7392p7618d*dc*dsc*dp*ic*isc*ip*in*)

%description usb-network
This package contains compressed kernel firmware files for
various USB WiFi / Ethernet drivers.


%prep
%setup -q
# additional firmwares
cat %{SOURCE1} >> WHENCE
cp %{SOURCE2} %{SOURCE8} %{SOURCE9} %{SOURCE10} .

%build
# nothing to do

%install
mkdir -p %{buildroot}%{_firmwaredir}
%if "%flavor" != "compressed"
sh ./copy-firmware.sh %{buildroot}%{_firmwaredir}
%else
sh %{_sourcedir}/install-split.sh -v %{_sourcedir}/topics.list %{buildroot} %{_firmwaredir} < WHENCE
sh %{_sourcedir}/list-license.sh < %{_sourcedir}/licenses.list
%endif
%fdupes -s %{buildroot}

%if "%flavor" != "compressed"
%post
%{?regenerate_initrd_post}
%postun
%{?regenerate_initrd_post}
%posttrans
%{?regenerate_initrd_posttrans}
%post -n ucode-amd
%{?regenerate_initrd_post}
%postun -n ucode-amd
%{?regenerate_initrd_post}
%posttrans -n ucode-amd
%{?regenerate_initrd_posttrans}
%else
%post all
%{?regenerate_initrd_post}
%postun all
%{?regenerate_initrd_post}
%posttrans all
%{?regenerate_initrd_posttrans}
%post amdgpu
%{?regenerate_initrd_post}
%postun amdgpu
%{?regenerate_initrd_post}
%posttrans amdgpu
%{?regenerate_initrd_posttrans}
%post atheros
%{?regenerate_initrd_post}
%postun atheros
%{?regenerate_initrd_post}
%posttrans atheros
%{?regenerate_initrd_posttrans}
%post ath10k
%{?regenerate_initrd_post}
%postun ath10k
%{?regenerate_initrd_post}
%posttrans ath10k
%{?regenerate_initrd_posttrans}
%post ath11k
%{?regenerate_initrd_post}
%postun ath11k
%{?regenerate_initrd_post}
%posttrans ath11k
%{?regenerate_initrd_posttrans}
%post bluetooth
%{?regenerate_initrd_post}
%postun bluetooth
%{?regenerate_initrd_post}
%posttrans bluetooth
%{?regenerate_initrd_posttrans}
%post bnx2
%{?regenerate_initrd_post}
%postun bnx2
%{?regenerate_initrd_post}
%posttrans bnx2
%{?regenerate_initrd_posttrans}
%post brcm
%{?regenerate_initrd_post}
%postun brcm
%{?regenerate_initrd_post}
%posttrans brcm
%{?regenerate_initrd_posttrans}
%post chelsio
%{?regenerate_initrd_post}
%postun chelsio
%{?regenerate_initrd_post}
%posttrans chelsio
%{?regenerate_initrd_posttrans}
%post dpaa2
%{?regenerate_initrd_post}
%postun dpaa2
%{?regenerate_initrd_post}
%posttrans dpaa2
%{?regenerate_initrd_posttrans}
%post i915
%{?regenerate_initrd_post}
%postun i915
%{?regenerate_initrd_post}
%posttrans i915
%{?regenerate_initrd_posttrans}
%post intel
%{?regenerate_initrd_post}
%postun intel
%{?regenerate_initrd_post}
%posttrans intel
%{?regenerate_initrd_posttrans}
%post iwlwifi
%{?regenerate_initrd_post}
%postun iwlwifi
%{?regenerate_initrd_post}
%posttrans iwlwifi
%{?regenerate_initrd_posttrans}
%post liquidio
%{?regenerate_initrd_post}
%postun liquidio
%{?regenerate_initrd_post}
%posttrans liquidio
%{?regenerate_initrd_posttrans}
%post marvell
%{?regenerate_initrd_post}
%postun marvell
%{?regenerate_initrd_post}
%posttrans marvell
%{?regenerate_initrd_posttrans}
%post media
%{?regenerate_initrd_post}
%postun media
%{?regenerate_initrd_post}
%posttrans media
%{?regenerate_initrd_posttrans}
%post mediatek
%{?regenerate_initrd_post}
%postun mediatek
%{?regenerate_initrd_post}
%posttrans mediatek
%{?regenerate_initrd_posttrans}
%post mellanox
%{?regenerate_initrd_post}
%postun mellanox
%{?regenerate_initrd_post}
%posttrans mellanox
%{?regenerate_initrd_posttrans}
%post mwifiex
%{?regenerate_initrd_post}
%postun mwifiex
%{?regenerate_initrd_post}
%posttrans mwifiex
%{?regenerate_initrd_posttrans}
%post network
%{?regenerate_initrd_post}
%postun network
%{?regenerate_initrd_post}
%posttrans network
%{?regenerate_initrd_posttrans}
%post nfp
%{?regenerate_initrd_post}
%postun nfp
%{?regenerate_initrd_post}
%posttrans nfp
%{?regenerate_initrd_posttrans}
%post nvidia
%{?regenerate_initrd_post}
%postun nvidia
%{?regenerate_initrd_post}
%posttrans nvidia
%{?regenerate_initrd_posttrans}
%post platform
%{?regenerate_initrd_post}
%postun platform
%{?regenerate_initrd_post}
%posttrans platform
%{?regenerate_initrd_posttrans}
%post prestera
%{?regenerate_initrd_post}
%postun prestera
%{?regenerate_initrd_post}
%posttrans prestera
%{?regenerate_initrd_posttrans}
%post qlogic
%{?regenerate_initrd_post}
%postun qlogic
%{?regenerate_initrd_post}
%posttrans qlogic
%{?regenerate_initrd_posttrans}
%post radeon
%{?regenerate_initrd_post}
%postun radeon
%{?regenerate_initrd_post}
%posttrans radeon
%{?regenerate_initrd_posttrans}
%post realtek
%{?regenerate_initrd_post}
%postun realtek
%{?regenerate_initrd_post}
%posttrans realtek
%{?regenerate_initrd_posttrans}
%post serial
%{?regenerate_initrd_post}
%postun serial
%{?regenerate_initrd_post}
%posttrans serial
%{?regenerate_initrd_posttrans}
%post sound
%{?regenerate_initrd_post}
%postun sound
%{?regenerate_initrd_post}
%posttrans sound
%{?regenerate_initrd_posttrans}
%post ti
%{?regenerate_initrd_post}
%postun ti
%{?regenerate_initrd_post}
%posttrans ti
%{?regenerate_initrd_posttrans}
%post ueagle
%{?regenerate_initrd_post}
%postun ueagle
%{?regenerate_initrd_post}
%posttrans ueagle
%{?regenerate_initrd_posttrans}
%post usb-network
%{?regenerate_initrd_post}
%postun usb-network
%{?regenerate_initrd_post}
%posttrans usb-network
%{?regenerate_initrd_posttrans}
%endif

%if "%flavor" != "compressed"
%files
%doc WHENCE README
%license GPL-2 GPL-3 LICEN[CS]E.*
%{_firmwaredir}
%exclude %{_firmwaredir}/amd-ucode
%exclude %{_firmwaredir}/amd-ucode/*

%files -n ucode-amd
%license LICENSE.amd-ucode
%dir %{_firmwaredir}
%{_firmwaredir}/amd-ucode
%endif

%if "%flavor" == "compressed"
%files all
%doc WHENCE README

%files -f files-amdgpu amdgpu
%files -f files-atheros atheros
%files -f files-ath10k ath10k
%files -f files-ath11k ath11k
%files -f files-bluetooth bluetooth
%files -f files-bnx2 bnx2
%files -f files-brcm brcm
%files -f files-chelsio chelsio
%files -f files-dpaa2 dpaa2
%files -f files-i915 i915
%files -f files-intel intel
%files -f files-iwlwifi iwlwifi
%files -f files-liquidio liquidio
%files -f files-marvell marvell
%files -f files-media media
%files -f files-mediatek mediatek
%files -f files-mellanox mellanox
%files -f files-mwifiex mwifiex
%files -f files-network network
%files -f files-nfp nfp
%files -f files-nvidia nvidia
%files -f files-platform platform
%files -f files-prestera prestera
%files -f files-qlogic qlogic
%files -f files-radeon radeon
%files -f files-realtek realtek
%files -f files-serial serial
%files -f files-sound sound
%files -f files-ti ti
%files -f files-ueagle ueagle
%files -f files-usb-network usb-network
%endif

%changelog
